# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1


@dataclass
class Overhead(DictMixin):
    """Overhead structure represents the resource overhead associated with running a
      pod.

      **parameters**

      * **podFixed** ``Optional[dict]`` - PodFixed represents the fixed resource overhead associated with running a pod.
    """
    podFixed: 'Optional[dict]' = None


@dataclass
class RuntimeClass(DictMixin):
    """RuntimeClass defines a class of container runtime supported in the cluster.
      The RuntimeClass is used to determine which container runtime is used to run
      all containers in a pod. RuntimeClasses are (currently) manually defined by a
      user or cluster provisioner, and referenced in the PodSpec. The Kubelet is
      responsible for resolving the RuntimeClassName reference before running the
      pod.  For more details, see
      https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class

      **parameters**

      * **spec** ``RuntimeClassSpec`` - Specification of the RuntimeClass More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: 'RuntimeClassSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class RuntimeClassList(DictMixin):
    """RuntimeClassList is a list of RuntimeClass objects.

      **parameters**

      * **items** ``List[RuntimeClass]`` - Items is a list of schema objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[RuntimeClass]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class RuntimeClassSpec(DictMixin):
    """RuntimeClassSpec is a specification of a RuntimeClass. It contains parameters
      that are required to describe the RuntimeClass to the Container Runtime
      Interface (CRI) implementation, as well as any other components that need to
      understand how the pod will be run. The RuntimeClassSpec is immutable.

      **parameters**

      * **runtimeHandler** ``str`` - RuntimeHandler specifies the underlying runtime and configuration that the CRI
        implementation will use to handle pods of this class. The possible values are
        specific to the node & CRI configuration.  It is assumed that all handlers are
        available on every node, and handlers of the same name are equivalent on every
        node. For example, a handler called "runc" might specify that the runc OCI
        runtime (using native Linux containers) will be used to run the containers in
        a pod. The RuntimeHandler must be lowercase, conform to the DNS Label (RFC
        1123) requirements, and is immutable.
      * **overhead** ``Optional[Overhead]`` - Overhead represents the resource overhead associated with running a pod for a
        given RuntimeClass. For more details, see
        https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md This
        field is beta-level as of Kubernetes v1.18, and is only honored by servers
        that enable the PodOverhead feature.
      * **scheduling** ``Optional[Scheduling]`` - Scheduling holds the scheduling constraints to ensure that pods running with
        this RuntimeClass are scheduled to nodes that support it. If scheduling is
        nil, this RuntimeClass is assumed to be supported by all nodes.
    """
    runtimeHandler: 'str'
    overhead: 'Optional[Overhead]' = None
    scheduling: 'Optional[Scheduling]' = None


@dataclass
class Scheduling(DictMixin):
    """Scheduling specifies the scheduling constraints for nodes supporting a
      RuntimeClass.

      **parameters**

      * **nodeSelector** ``Optional[dict]`` - nodeSelector lists labels that must be present on nodes that support this
        RuntimeClass. Pods using this RuntimeClass can only be scheduled to a node
        matched by this selector. The RuntimeClass nodeSelector is merged with a pod's
        existing nodeSelector. Any conflicts will cause the pod to be rejected in
        admission.
      * **tolerations** ``Optional[List[core_v1.Toleration]]`` - tolerations are appended (excluding duplicates) to pods running with this
        RuntimeClass during admission, effectively unioning the set of nodes tolerated
        by the pod and the RuntimeClass.
    """
    nodeSelector: 'Optional[dict]' = None
    tolerations: 'Optional[List[core_v1.Toleration]]' = None


