# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class FlowDistinguisherMethod(DictMixin):
    """FlowDistinguisherMethod specifies the method of a flow distinguisher.

      **parameters**

      * **type** ``str`` - `type` is the type of flow distinguisher method The supported types are
        "ByUser" and "ByNamespace". Required.
    """
    type: 'str'


@dataclass
class FlowSchema(DictMixin):
    """FlowSchema defines the schema of a group of flows. Note that a flow is made up
      of a set of inbound API requests with similar attributes and is identified by
      a pair of strings: the name of the FlowSchema and a "flow distinguisher".

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - `metadata` is the standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[FlowSchemaSpec]`` - `spec` is the specification of the desired behavior of a FlowSchema. More
        info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[FlowSchemaStatus]`` - `status` is the current status of a FlowSchema. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[FlowSchemaSpec]' = None
    status: 'Optional[FlowSchemaStatus]' = None


@dataclass
class FlowSchemaCondition(DictMixin):
    """FlowSchemaCondition describes conditions for a FlowSchema.

      **parameters**

      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - `lastTransitionTime` is the last time the condition transitioned from one
        status to another.
      * **message** ``Optional[str]`` - `message` is a human-readable message indicating details about last
        transition.
      * **reason** ``Optional[str]`` - `reason` is a unique, one-word, CamelCase reason for the condition's last
        transition.
      * **status** ``Optional[str]`` - `status` is the status of the condition. Can be True, False, Unknown.
        Required.
      * **type** ``Optional[str]`` - `type` is the type of the condition. Required.
    """
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None
    status: 'Optional[str]' = None
    type: 'Optional[str]' = None


@dataclass
class FlowSchemaList(DictMixin):
    """FlowSchemaList is a list of FlowSchema objects.

      **parameters**

      * **items** ``List[FlowSchema]`` - `items` is a list of FlowSchemas.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - `metadata` is the standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[FlowSchema]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class FlowSchemaSpec(DictMixin):
    """FlowSchemaSpec describes how the FlowSchema's specification looks like.

      **parameters**

      * **priorityLevelConfiguration** ``PriorityLevelConfigurationReference`` - `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in
        the cluster. If the reference cannot be resolved, the FlowSchema will be
        ignored and marked as invalid in its status. Required.
      * **distinguisherMethod** ``Optional[FlowDistinguisherMethod]`` - `distinguisherMethod` defines how to compute the flow distinguisher for
        requests that match this schema. `nil` specifies that the distinguisher is
        disabled and thus will always be the empty string.
      * **matchingPrecedence** ``Optional[int]`` - `matchingPrecedence` is used to choose among the FlowSchemas that match a
        given request. The chosen FlowSchema is among those with the numerically
        lowest (which we take to be logically highest) MatchingPrecedence.  Each
        MatchingPrecedence value must be ranged in [1,10000]. Note that if the
        precedence is not specified, it will be set to 1000 as default.
      * **rules** ``Optional[List[PolicyRulesWithSubjects]]`` - `rules` describes which requests will match this flow schema. This FlowSchema
        matches a request if and only if at least one member of rules matches the
        request. if it is an empty slice, there will be no requests matching the
        FlowSchema.
    """
    priorityLevelConfiguration: 'PriorityLevelConfigurationReference'
    distinguisherMethod: 'Optional[FlowDistinguisherMethod]' = None
    matchingPrecedence: 'Optional[int]' = None
    rules: 'Optional[List[PolicyRulesWithSubjects]]' = None


@dataclass
class FlowSchemaStatus(DictMixin):
    """FlowSchemaStatus represents the current state of a FlowSchema.

      **parameters**

      * **conditions** ``Optional[List[FlowSchemaCondition]]`` - `conditions` is a list of the current states of FlowSchema.
    """
    conditions: 'Optional[List[FlowSchemaCondition]]' = None


@dataclass
class GroupSubject(DictMixin):
    """GroupSubject holds detailed information for group-kind subject.

      **parameters**

      * **name** ``str`` - name is the user group that matches, or "*" to match all user groups. See
        https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go
        for some well-known group names. Required.
    """
    name: 'str'


@dataclass
class LimitResponse(DictMixin):
    """LimitResponse defines how to handle requests that can not be executed right
      now.

      **parameters**

      * **type** ``str`` - `type` is "Queue" or "Reject". "Queue" means that requests that can not be
        executed upon arrival are held in a queue until they can be executed or a
        queuing limit is reached. "Reject" means that requests that can not be
        executed upon arrival are rejected. Required.
      * **queuing** ``Optional[QueuingConfiguration]`` - `queuing` holds the configuration parameters for queuing. This field may be
        non-empty only if `type` is `"Queue"`.
    """
    type: 'str'
    queuing: 'Optional[QueuingConfiguration]' = None


@dataclass
class LimitedPriorityLevelConfiguration(DictMixin):
    """LimitedPriorityLevelConfiguration specifies how to handle requests that are
      subject to limits. It addresses two issues:
       * How are requests for this priority level limited?
       * What should be done with requests that exceed the limit?

      **parameters**

      * **assuredConcurrencyShares** ``Optional[int]`` - `assuredConcurrencyShares` (ACS) configures the execution limit, which is a
        limit on the number of requests of this priority level that may be exeucting
        at a given time.  ACS must be a positive number. The server's concurrency
        limit (SCL) is divided among the concurrency-controlled priority levels in
        proportion to their assured concurrency shares. This produces the assured
        concurrency value (ACV) --- the number of requests that may be executing at a
        time --- for each such priority level:
                    ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )
        bigger numbers of ACS mean more reserved concurrent requests (at the expense
        of every other PL). This field has a default value of 30.
      * **limitResponse** ``Optional[LimitResponse]`` - `limitResponse` indicates what to do with requests that can not be executed
        right now
    """
    assuredConcurrencyShares: 'Optional[int]' = None
    limitResponse: 'Optional[LimitResponse]' = None


@dataclass
class NonResourcePolicyRule(DictMixin):
    """NonResourcePolicyRule is a predicate that matches non-resource requests
      according to their verb and the target non-resource URL. A
      NonResourcePolicyRule matches a request if and only if both (a) at least one
      member of verbs matches the request and (b) at least one member of
      nonResourceURLs matches the request.

      **parameters**

      * **nonResourceURLs** ``List[str]`` - `nonResourceURLs` is a set of url prefixes that a user should have access to
        and may not be empty. For example:
          - "/healthz" is legal
          - "/hea*" is illegal
          - "/hea" is legal but matches nothing
          - "/hea/*" also matches nothing
          - "/healthz/*" matches all per-component health checks.
        "*" matches all non-resource urls. if it is present, it must be the only
        entry. Required.
      * **verbs** ``List[str]`` - `verbs` is a list of matching verbs and may not be empty. "*" matches all
        verbs. If it is present, it must be the only entry. Required.
    """
    nonResourceURLs: 'List[str]'
    verbs: 'List[str]'


@dataclass
class PolicyRulesWithSubjects(DictMixin):
    """PolicyRulesWithSubjects prescribes a test that applies to a request to an
      apiserver. The test considers the subject making the request, the verb being
      requested, and the resource to be acted upon. This PolicyRulesWithSubjects
      matches a request if and only if both (a) at least one member of subjects
      matches the request and (b) at least one member of resourceRules or
      nonResourceRules matches the request.

      **parameters**

      * **subjects** ``List[Subject]`` - subjects is the list of normal user, serviceaccount, or group that this rule
        cares about. There must be at least one member in this slice. A slice that
        includes both the system:authenticated and system:unauthenticated user groups
        matches every request. Required.
      * **nonResourceRules** ``Optional[List[NonResourcePolicyRule]]`` - `nonResourceRules` is a list of NonResourcePolicyRules that identify matching
        requests according to their verb and the target non-resource URL.
      * **resourceRules** ``Optional[List[ResourcePolicyRule]]`` - `resourceRules` is a slice of ResourcePolicyRules that identify matching
        requests according to their verb and the target resource. At least one of
        `resourceRules` and `nonResourceRules` has to be non-empty.
    """
    subjects: 'List[Subject]'
    nonResourceRules: 'Optional[List[NonResourcePolicyRule]]' = None
    resourceRules: 'Optional[List[ResourcePolicyRule]]' = None


@dataclass
class PriorityLevelConfiguration(DictMixin):
    """PriorityLevelConfiguration represents the configuration of a priority level.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - `metadata` is the standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PriorityLevelConfigurationSpec]`` - `spec` is the specification of the desired behavior of a "request-priority".
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[PriorityLevelConfigurationStatus]`` - `status` is the current status of a "request-priority". More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PriorityLevelConfigurationSpec]' = None
    status: 'Optional[PriorityLevelConfigurationStatus]' = None


@dataclass
class PriorityLevelConfigurationCondition(DictMixin):
    """PriorityLevelConfigurationCondition defines the condition of priority level.

      **parameters**

      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - `lastTransitionTime` is the last time the condition transitioned from one
        status to another.
      * **message** ``Optional[str]`` - `message` is a human-readable message indicating details about last
        transition.
      * **reason** ``Optional[str]`` - `reason` is a unique, one-word, CamelCase reason for the condition's last
        transition.
      * **status** ``Optional[str]`` - `status` is the status of the condition. Can be True, False, Unknown.
        Required.
      * **type** ``Optional[str]`` - `type` is the type of the condition. Required.
    """
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None
    status: 'Optional[str]' = None
    type: 'Optional[str]' = None


@dataclass
class PriorityLevelConfigurationList(DictMixin):
    """PriorityLevelConfigurationList is a list of PriorityLevelConfiguration
      objects.

      **parameters**

      * **items** ``List[PriorityLevelConfiguration]`` - `items` is a list of request-priorities.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - `metadata` is the standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PriorityLevelConfiguration]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PriorityLevelConfigurationReference(DictMixin):
    """PriorityLevelConfigurationReference contains information that points to the
      "request-priority" being used.

      **parameters**

      * **name** ``str`` - `name` is the name of the priority level configuration being referenced
        Required.
    """
    name: 'str'


@dataclass
class PriorityLevelConfigurationSpec(DictMixin):
    """PriorityLevelConfigurationSpec specifies the configuration of a priority
      level.

      **parameters**

      * **type** ``str`` - `type` indicates whether this priority level is subject to limitation on
        request execution.  A value of `"Exempt"` means that requests of this priority
        level are not subject to a limit (and thus are never queued) and do not
        detract from the capacity made available to other priority levels.  A value of
        `"Limited"` means that (a) requests of this priority level _are_ subject to
        limits and (b) some of the server's limited capacity is made available
        exclusively to this priority level. Required.
      * **limited** ``Optional[LimitedPriorityLevelConfiguration]`` - `limited` specifies how requests are handled for a Limited priority level.
        This field must be non-empty if and only if `type` is `"Limited"`.
    """
    type: 'str'
    limited: 'Optional[LimitedPriorityLevelConfiguration]' = None


@dataclass
class PriorityLevelConfigurationStatus(DictMixin):
    """PriorityLevelConfigurationStatus represents the current state of a
      "request-priority".

      **parameters**

      * **conditions** ``Optional[List[PriorityLevelConfigurationCondition]]`` - `conditions` is the current state of "request-priority".
    """
    conditions: 'Optional[List[PriorityLevelConfigurationCondition]]' = None


@dataclass
class QueuingConfiguration(DictMixin):
    """QueuingConfiguration holds the configuration parameters for queuing

      **parameters**

      * **handSize** ``Optional[int]`` - `handSize` is a small positive number that configures the shuffle sharding of
        requests into queues.  When enqueuing a request at this priority level the
        request's flow identifier (a string pair) is hashed and the hash value is used
        to shuffle the list of queues and deal a hand of the size specified here.  The
        request is put into one of the shortest queues in that hand. `handSize` must
        be no larger than `queues`, and should be significantly smaller (so that a few
        heavy flows do not saturate most of the queues).  See the user-facing
        documentation for more extensive guidance on setting this field.  This field
        has a default value of 8.
      * **queueLengthLimit** ``Optional[int]`` - `queueLengthLimit` is the maximum number of requests allowed to be waiting in
        a given queue of this priority level at a time; excess requests are rejected.
        This value must be positive.  If not specified, it will be defaulted to 50.
      * **queues** ``Optional[int]`` - `queues` is the number of queues for this priority level. The queues exist
        independently at each apiserver. The value must be positive.  Setting it to 1
        effectively precludes shufflesharding and thus makes the distinguisher method
        of associated flow schemas irrelevant.  This field has a default value of 64.
    """
    handSize: 'Optional[int]' = None
    queueLengthLimit: 'Optional[int]' = None
    queues: 'Optional[int]' = None


@dataclass
class ResourcePolicyRule(DictMixin):
    """ResourcePolicyRule is a predicate that matches some resource requests, testing
      the request's verb and the target resource. A ResourcePolicyRule matches a
      resource request if and only if: (a) at least one member of verbs matches the
      request, (b) at least one member of apiGroups matches the request, (c) at
      least one member of resources matches the request, and (d) least one member of
      namespaces matches the request.

      **parameters**

      * **apiGroups** ``List[str]`` - `apiGroups` is a list of matching API groups and may not be empty. "*" matches
        all API groups and, if present, must be the only entry. Required.
      * **resources** ``List[str]`` - `resources` is a list of matching resources (i.e., lowercase and plural) with,
        if desired, subresource.  For example, [ "services", "nodes/status" ].  This
        list may not be empty. "*" matches all resources and, if present, must be the
        only entry. Required.
      * **verbs** ``List[str]`` - `verbs` is a list of matching verbs and may not be empty. "*" matches all
        verbs and, if present, must be the only entry. Required.
      * **clusterScope** ``Optional[bool]`` - `clusterScope` indicates whether to match requests that do not specify a
        namespace (which happens either because the resource is not namespaced or the
        request targets all namespaces). If this field is omitted or false then the
        `namespaces` field must contain a non-empty list.
      * **namespaces** ``Optional[List[str]]`` - `namespaces` is a list of target namespaces that restricts matches.  A request
        that specifies a target namespace matches only if either (a) this list
        contains that target namespace or (b) this list contains "*".  Note that "*"
        matches any specified namespace but does not match a request that _does not
        specify_ a namespace (see the `clusterScope` field for that). This list may be
        empty, but only if `clusterScope` is true.
    """
    apiGroups: 'List[str]'
    resources: 'List[str]'
    verbs: 'List[str]'
    clusterScope: 'Optional[bool]' = None
    namespaces: 'Optional[List[str]]' = None


@dataclass
class ServiceAccountSubject(DictMixin):
    """ServiceAccountSubject holds detailed information for service-account-kind
      subject.

      **parameters**

      * **name** ``str`` - `name` is the name of matching ServiceAccount objects, or "*" to match
        regardless of name. Required.
      * **namespace** ``str`` - `namespace` is the namespace of matching ServiceAccount objects. Required.
    """
    name: 'str'
    namespace: 'str'


@dataclass
class Subject(DictMixin):
    """Subject matches the originator of a request, as identified by the request
      authentication system. There are three ways of matching an originator; by
      user, group, or service account.

      **parameters**

      * **kind** ``str`` - `kind` indicates which one of the other fields is non-empty. Required
      * **group** ``Optional[GroupSubject]`` - `group` matches based on user group name.
      * **serviceAccount** ``Optional[ServiceAccountSubject]`` - `serviceAccount` matches ServiceAccounts.
      * **user** ``Optional[UserSubject]`` - `user` matches based on username.
    """
    kind: 'str'
    group: 'Optional[GroupSubject]' = None
    serviceAccount: 'Optional[ServiceAccountSubject]' = None
    user: 'Optional[UserSubject]' = None


@dataclass
class UserSubject(DictMixin):
    """UserSubject holds detailed information for user-kind subject.

      **parameters**

      * **name** ``str`` - `name` is the username that matches, or "*" to match all usernames. Required.
    """
    name: 'str'


