# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1


@dataclass
class Event(DictMixin):
    """Event is a report of an event somewhere in the cluster. It generally denotes
      some state change in the system. Events have a limited retention time and
      triggers and messages may evolve with time.  Event consumers should not rely
      on the timing of an event with a given Reason reflecting a consistent
      underlying trigger, or the continued existence of events with that Reason.
      Events should be treated as informative, best-effort, supplemental data.

      **parameters**

      * **eventTime** ``meta_v1.MicroTime`` - eventTime is the time when this Event was first observed. It is required.
      * **action** ``Optional[str]`` - action is what action was taken/failed regarding to the regarding object. It
        is machine-readable. This field can have at most 128 characters.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **deprecatedCount** ``Optional[int]`` - deprecatedCount is the deprecated field assuring backward compatibility with
        core.v1 Event type.
      * **deprecatedFirstTimestamp** ``Optional[meta_v1.Time]`` - deprecatedFirstTimestamp is the deprecated field assuring backward
        compatibility with core.v1 Event type.
      * **deprecatedLastTimestamp** ``Optional[meta_v1.Time]`` - deprecatedLastTimestamp is the deprecated field assuring backward
        compatibility with core.v1 Event type.
      * **deprecatedSource** ``Optional[core_v1.EventSource]`` - deprecatedSource is the deprecated field assuring backward compatibility with
        core.v1 Event type.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **note** ``Optional[str]`` - note is a human-readable description of the status of this operation. Maximal
        length of the note is 1kB, but libraries should be prepared to handle values
        up to 64kB.
      * **reason** ``Optional[str]`` - reason is why the action was taken. It is human-readable. This field can have
        at most 128 characters.
      * **regarding** ``Optional[core_v1.ObjectReference]`` - regarding contains the object this Event is about. In most cases it's an
        Object reporting controller implements, e.g. ReplicaSetController implements
        ReplicaSets and this event is emitted because it acts on some changes in a
        ReplicaSet object.
      * **related** ``Optional[core_v1.ObjectReference]`` - related is the optional secondary object for more complex actions. E.g. when
        regarding object triggers a creation or deletion of related object.
      * **reportingController** ``Optional[str]`` - reportingController is the name of the controller that emitted this Event,
        e.g. `kubernetes.io/kubelet`. This field cannot be empty for new Events.
      * **reportingInstance** ``Optional[str]`` - reportingInstance is the ID of the controller instance, e.g. `kubelet-xyzf`.
        This field cannot be empty for new Events and it can have at most 128
        characters.
      * **series** ``Optional[EventSeries]`` - series is data about the Event series this event represents or nil if it's a
        singleton Event.
      * **type** ``Optional[str]`` - type is the type of this event (Normal, Warning), new types could be added in
        the future. It is machine-readable.
    """
    eventTime: 'meta_v1.MicroTime'
    action: 'Optional[str]' = None
    apiVersion: 'Optional[str]' = None
    deprecatedCount: 'Optional[int]' = None
    deprecatedFirstTimestamp: 'Optional[meta_v1.Time]' = None
    deprecatedLastTimestamp: 'Optional[meta_v1.Time]' = None
    deprecatedSource: 'Optional[core_v1.EventSource]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    note: 'Optional[str]' = None
    reason: 'Optional[str]' = None
    regarding: 'Optional[core_v1.ObjectReference]' = None
    related: 'Optional[core_v1.ObjectReference]' = None
    reportingController: 'Optional[str]' = None
    reportingInstance: 'Optional[str]' = None
    series: 'Optional[EventSeries]' = None
    type: 'Optional[str]' = None


@dataclass
class EventList(DictMixin):
    """EventList is a list of Event objects.

      **parameters**

      * **items** ``List[Event]`` - items is a list of schema objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[Event]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class EventSeries(DictMixin):
    """EventSeries contain information on series of events, i.e. thing that was/is
      happening continuously for some time.

      **parameters**

      * **count** ``int`` - count is the number of occurrences in this series up to the last heartbeat
        time.
      * **lastObservedTime** ``meta_v1.MicroTime`` - lastObservedTime is the time when last Event from the series was seen before
        last heartbeat.
    """
    count: 'int'
    lastObservedTime: 'meta_v1.MicroTime'


