# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1


@dataclass
class Endpoint(DictMixin):
    """Endpoint represents a single logical "backend" implementing a service.

      **parameters**

      * **addresses** ``List[str]`` - addresses of this endpoint. The contents of this field are interpreted
        according to the corresponding EndpointSlice addressType field. Consumers must
        handle different types of addresses in the context of their own capabilities.
        This must contain at least one address but no more than 100.
      * **conditions** ``Optional[EndpointConditions]`` - conditions contains information about the current status of the endpoint.
      * **deprecatedTopology** ``Optional[dict]`` - deprecatedTopology contains topology information part of the v1beta1 API. This
        field is deprecated, and will be removed when the v1beta1 API is removed (no
        sooner than kubernetes v1.24).  While this field can hold values, it is not
        writable through the v1 API, and any attempts to write to it will be silently
        ignored. Topology information can be found in the zone and nodeName fields
        instead.
      * **hints** ``Optional[EndpointHints]`` - hints contains information associated with how an endpoint should be consumed.
      * **hostname** ``Optional[str]`` - hostname of this endpoint. This field may be used by consumers of endpoints to
        distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints
        which use the same hostname should be considered fungible (e.g. multiple A
        values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
      * **nodeName** ``Optional[str]`` - nodeName represents the name of the Node hosting this endpoint. This can be
        used to determine endpoints local to a Node. This field can be enabled with
        the EndpointSliceNodeName feature gate.
      * **targetRef** ``Optional[core_v1.ObjectReference]`` - targetRef is a reference to a Kubernetes object that represents this endpoint.
      * **zone** ``Optional[str]`` - zone is the name of the Zone this endpoint exists in.
    """
    addresses: 'List[str]'
    conditions: 'Optional[EndpointConditions]' = None
    deprecatedTopology: 'Optional[dict]' = None
    hints: 'Optional[EndpointHints]' = None
    hostname: 'Optional[str]' = None
    nodeName: 'Optional[str]' = None
    targetRef: 'Optional[core_v1.ObjectReference]' = None
    zone: 'Optional[str]' = None


@dataclass
class EndpointConditions(DictMixin):
    """EndpointConditions represents the current condition of an endpoint.

      **parameters**

      * **ready** ``Optional[bool]`` - ready indicates that this endpoint is prepared to receive traffic, according
        to whatever system is managing the endpoint. A nil value indicates an unknown
        state. In most cases consumers should interpret this unknown state as ready.
        For compatibility reasons, ready should never be "true" for terminating
        endpoints.
      * **serving** ``Optional[bool]`` - serving is identical to ready except that it is set regardless of the
        terminating state of endpoints. This condition should be set to true for a
        ready endpoint that is terminating. If nil, consumers should defer to the
        ready condition. This field can be enabled with the
        EndpointSliceTerminatingCondition feature gate.
      * **terminating** ``Optional[bool]`` - terminating indicates that this endpoint is terminating. A nil value indicates
        an unknown state. Consumers should interpret this unknown state to mean that
        the endpoint is not terminating. This field can be enabled with the
        EndpointSliceTerminatingCondition feature gate.
    """
    ready: 'Optional[bool]' = None
    serving: 'Optional[bool]' = None
    terminating: 'Optional[bool]' = None


@dataclass
class EndpointHints(DictMixin):
    """EndpointHints provides hints describing how an endpoint should be consumed.

      **parameters**

      * **forZones** ``Optional[List[ForZone]]`` - forZones indicates the zone(s) this endpoint should be consumed by to enable
        topology aware routing.
    """
    forZones: 'Optional[List[ForZone]]' = None


@dataclass
class EndpointPort(DictMixin):
    """EndpointPort represents a Port used by an EndpointSlice

      **parameters**

      * **appProtocol** ``Optional[str]`` - The application protocol for this port. This field follows standard Kubernetes
        label syntax. Un-prefixed names are reserved for IANA standard service names
        (as per RFC-6335 and http://www.iana.org/assignments/service-names).
        Non-standard protocols should use prefixed names such as
        mycompany.com/my-custom-protocol.
      * **name** ``Optional[str]`` - The name of this port. All ports in an EndpointSlice must have a unique name.
        If the EndpointSlice is dervied from a Kubernetes service, this corresponds to
        the Service.ports[].name. Name must either be an empty string or pass
        DNS_LABEL validation: * must be no more than 63 characters long. * must
        consist of lower case alphanumeric characters or '-'. * must start and end
        with an alphanumeric character. Default is empty string.
      * **port** ``Optional[int]`` - The port number of the endpoint. If this is not specified, ports are not
        restricted and must be interpreted in the context of the specific consumer.
      * **protocol** ``Optional[str]`` - The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
    """
    appProtocol: 'Optional[str]' = None
    name: 'Optional[str]' = None
    port: 'Optional[int]' = None
    protocol: 'Optional[str]' = None


@dataclass
class EndpointSlice(DictMixin):
    """EndpointSlice represents a subset of the endpoints that implement a service.
      For a given service there may be multiple EndpointSlice objects, selected by
      labels, which must be joined to produce the full set of endpoints.

      **parameters**

      * **addressType** ``str`` - addressType specifies the type of address carried by this EndpointSlice. All
        addresses in this slice must be the same type. This field is immutable after
        creation. The following address types are currently supported: * IPv4:
        Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN:
        Represents a Fully Qualified Domain Name.
      * **endpoints** ``List[Endpoint]`` - endpoints is a list of unique endpoints in this slice. Each slice may include
        a maximum of 1000 endpoints.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata.
      * **ports** ``Optional[List[EndpointPort]]`` - ports specifies the list of network ports exposed by each endpoint in this
        slice. Each port must have a unique name. When ports is empty, it indicates
        that there are no defined ports. When a port is defined with a nil port value,
        it indicates "all ports". Each slice may include a maximum of 100 ports.
    """
    addressType: 'str'
    endpoints: 'List[Endpoint]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    ports: 'Optional[List[EndpointPort]]' = None


@dataclass
class EndpointSliceList(DictMixin):
    """EndpointSliceList represents a list of endpoint slices

      **parameters**

      * **items** ``List[EndpointSlice]`` - List of endpoint slices
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata.
    """
    items: 'List[EndpointSlice]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ForZone(DictMixin):
    """ForZone provides information about which zones should consume this endpoint.

      **parameters**

      * **name** ``str`` - name represents the name of the zone.
    """
    name: 'str'


