# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import resource
from . import util_intstr


@dataclass
class AWSElasticBlockStoreVolumeSource(DictMixin):
    """Represents a Persistent Disk resource in AWS.
      
      An AWS EBS disk must exist before mounting to a container. The disk must also
      be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as
      read/write once. AWS EBS volumes support ownership management and SELinux
      relabeling.

      **parameters**

      * **volumeID** ``str`` - Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More
        info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **fsType** ``Optional[str]`` - Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **partition** ``Optional[int]`` - The partition in the volume that you want to mount. If omitted, the default is
        to mount by volume name. Examples: For volume /dev/sda1, you specify the
        partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you
        can leave the property empty).
      * **readOnly** ``Optional[bool]`` - Specify "true" to force and set the ReadOnly property in VolumeMounts to
        "true". If omitted, the default is "false". More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    """
    volumeID: 'str'
    fsType: 'Optional[str]' = None
    partition: 'Optional[int]' = None
    readOnly: 'Optional[bool]' = None


@dataclass
class Affinity(DictMixin):
    """Affinity is a group of affinity scheduling rules.

      **parameters**

      * **nodeAffinity** ``Optional[NodeAffinity]`` - Describes node affinity scheduling rules for the pod.
      * **podAffinity** ``Optional[PodAffinity]`` - Describes pod affinity scheduling rules (e.g. co-locate this pod in the same
        node, zone, etc. as some other pod(s)).
      * **podAntiAffinity** ``Optional[PodAntiAffinity]`` - Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in
        the same node, zone, etc. as some other pod(s)).
    """
    nodeAffinity: 'Optional[NodeAffinity]' = None
    podAffinity: 'Optional[PodAffinity]' = None
    podAntiAffinity: 'Optional[PodAntiAffinity]' = None


@dataclass
class AttachedVolume(DictMixin):
    """AttachedVolume describes a volume attached to a node

      **parameters**

      * **devicePath** ``str`` - DevicePath represents the device path where the volume should be available
      * **name** ``str`` - Name of the attached volume
    """
    devicePath: 'str'
    name: 'str'


@dataclass
class AzureDiskVolumeSource(DictMixin):
    """AzureDisk represents an Azure Data Disk mount on the host and bind mount to
      the pod.

      **parameters**

      * **diskName** ``str`` - The Name of the data disk in the blob storage
      * **diskURI** ``str`` - The URI the data disk in the blob storage
      * **cachingMode** ``Optional[str]`` - Host Caching mode: None, Read Only, Read Write.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **kind** ``Optional[str]`` - Expected values Shared: multiple blob disks per storage account  Dedicated:
        single blob disk per storage account  Managed: azure managed data disk (only
        in managed availability set). defaults to shared
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
    """
    diskName: 'str'
    diskURI: 'str'
    cachingMode: 'Optional[str]' = None
    fsType: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None


@dataclass
class AzureFilePersistentVolumeSource(DictMixin):
    """AzureFile represents an Azure File Service mount on the host and bind mount to
      the pod.

      **parameters**

      * **secretName** ``str`` - the name of secret that contains Azure Storage Account Name and Key
      * **shareName** ``str`` - Share Name
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **secretNamespace** ``Optional[str]`` - the namespace of the secret that contains Azure Storage Account Name and Key
        default is the same as the Pod
    """
    secretName: 'str'
    shareName: 'str'
    readOnly: 'Optional[bool]' = None
    secretNamespace: 'Optional[str]' = None


@dataclass
class AzureFileVolumeSource(DictMixin):
    """AzureFile represents an Azure File Service mount on the host and bind mount to
      the pod.

      **parameters**

      * **secretName** ``str`` - the name of secret that contains Azure Storage Account Name and Key
      * **shareName** ``str`` - Share Name
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
    """
    secretName: 'str'
    shareName: 'str'
    readOnly: 'Optional[bool]' = None


@dataclass
class Binding(DictMixin):
    """Binding ties one object to another; for example, a pod is bound to a node by a
      scheduler. Deprecated in 1.7, please use the bindings subresource of pods
      instead.

      **parameters**

      * **target** ``ObjectReference`` - The target object that you want to bind to the standard object.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    target: 'ObjectReference'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class CSIPersistentVolumeSource(DictMixin):
    """Represents storage that is managed by an external CSI volume driver (Beta
      feature)

      **parameters**

      * **driver** ``str`` - Driver is the name of the driver to use for this volume. Required.
      * **volumeHandle** ``str`` - VolumeHandle is the unique volume name returned by the CSI volume plugin’s
        CreateVolume to refer to the volume on all subsequent calls. Required.
      * **controllerExpandSecretRef** ``Optional[SecretReference]`` - ControllerExpandSecretRef is a reference to the secret object containing
        sensitive information to pass to the CSI driver to complete the CSI
        ControllerExpandVolume call. This is an alpha field and requires enabling
        ExpandCSIVolumes feature gate. This field is optional, and may be empty if no
        secret is required. If the secret object contains more than one secret, all
        secrets are passed.
      * **controllerPublishSecretRef** ``Optional[SecretReference]`` - ControllerPublishSecretRef is a reference to the secret object containing
        sensitive information to pass to the CSI driver to complete the CSI
        ControllerPublishVolume and ControllerUnpublishVolume calls. This field is
        optional, and may be empty if no secret is required. If the secret object
        contains more than one secret, all secrets are passed.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs".
      * **nodePublishSecretRef** ``Optional[SecretReference]`` - NodePublishSecretRef is a reference to the secret object containing sensitive
        information to pass to the CSI driver to complete the CSI NodePublishVolume
        and NodeUnpublishVolume calls. This field is optional, and may be empty if no
        secret is required. If the secret object contains more than one secret, all
        secrets are passed.
      * **nodeStageSecretRef** ``Optional[SecretReference]`` - NodeStageSecretRef is a reference to the secret object containing sensitive
        information to pass to the CSI driver to complete the CSI NodeStageVolume and
        NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may
        be empty if no secret is required. If the secret object contains more than one
        secret, all secrets are passed.
      * **readOnly** ``Optional[bool]`` - Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to
        false (read/write).
      * **volumeAttributes** ``Optional[dict]`` - Attributes of the volume to publish.
    """
    driver: 'str'
    volumeHandle: 'str'
    controllerExpandSecretRef: 'Optional[SecretReference]' = None
    controllerPublishSecretRef: 'Optional[SecretReference]' = None
    fsType: 'Optional[str]' = None
    nodePublishSecretRef: 'Optional[SecretReference]' = None
    nodeStageSecretRef: 'Optional[SecretReference]' = None
    readOnly: 'Optional[bool]' = None
    volumeAttributes: 'Optional[dict]' = None


@dataclass
class CSIVolumeSource(DictMixin):
    """Represents a source location of a volume to mount, managed by an external CSI
      driver

      **parameters**

      * **driver** ``str`` - Driver is the name of the CSI driver that handles this volume. Consult with
        your admin for the correct name as registered in the cluster.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the
        empty value is passed to the associated CSI driver which will determine the
        default filesystem to apply.
      * **nodePublishSecretRef** ``Optional[LocalObjectReference]`` - NodePublishSecretRef is a reference to the secret object containing sensitive
        information to pass to the CSI driver to complete the CSI NodePublishVolume
        and NodeUnpublishVolume calls. This field is optional, and  may be empty if no
        secret is required. If the secret object contains more than one secret, all
        secret references are passed.
      * **readOnly** ``Optional[bool]`` - Specifies a read-only configuration for the volume. Defaults to false
        (read/write).
      * **volumeAttributes** ``Optional[dict]`` - VolumeAttributes stores driver-specific properties that are passed to the CSI
        driver. Consult your driver's documentation for supported values.
    """
    driver: 'str'
    fsType: 'Optional[str]' = None
    nodePublishSecretRef: 'Optional[LocalObjectReference]' = None
    readOnly: 'Optional[bool]' = None
    volumeAttributes: 'Optional[dict]' = None


@dataclass
class Capabilities(DictMixin):
    """Adds and removes POSIX capabilities from running containers.

      **parameters**

      * **add** ``Optional[List[str]]`` - Added capabilities
      * **drop** ``Optional[List[str]]`` - Removed capabilities
    """
    add: 'Optional[List[str]]' = None
    drop: 'Optional[List[str]]' = None


@dataclass
class CephFSPersistentVolumeSource(DictMixin):
    """Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **monitors** ``List[str]`` - Required: Monitors is a collection of Ceph monitors More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **path** ``Optional[str]`` - Optional: Used as the mounted root, rather than the full Ceph tree, default is
        /
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretFile** ``Optional[str]`` - Optional: SecretFile is the path to key ring for User, default is
        /etc/ceph/user.secret More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretRef** ``Optional[SecretReference]`` - Optional: SecretRef is reference to the authentication secret for User,
        default is empty. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **user** ``Optional[str]`` - Optional: User is the rados user name, default is admin More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    monitors: 'List[str]'
    path: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretFile: 'Optional[str]' = None
    secretRef: 'Optional[SecretReference]' = None
    user: 'Optional[str]' = None


@dataclass
class CephFSVolumeSource(DictMixin):
    """Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **monitors** ``List[str]`` - Required: Monitors is a collection of Ceph monitors More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **path** ``Optional[str]`` - Optional: Used as the mounted root, rather than the full Ceph tree, default is
        /
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretFile** ``Optional[str]`` - Optional: SecretFile is the path to key ring for User, default is
        /etc/ceph/user.secret More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretRef** ``Optional[LocalObjectReference]`` - Optional: SecretRef is reference to the authentication secret for User,
        default is empty. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **user** ``Optional[str]`` - Optional: User is the rados user name, default is admin More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    monitors: 'List[str]'
    path: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretFile: 'Optional[str]' = None
    secretRef: 'Optional[LocalObjectReference]' = None
    user: 'Optional[str]' = None


@dataclass
class CinderPersistentVolumeSource(DictMixin):
    """Represents a cinder volume resource in Openstack. A Cinder volume must exist
      before mounting to a container. The volume must also be in the same region as
      the kubelet. Cinder volumes support ownership management and SELinux
      relabeling.

      **parameters**

      * **volumeID** ``str`` - volume id used to identify the volume in cinder. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be
        "ext4" if unspecified. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **secretRef** ``Optional[SecretReference]`` - Optional: points to a secret object containing parameters used to connect to
        OpenStack.
    """
    volumeID: 'str'
    fsType: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[SecretReference]' = None


@dataclass
class CinderVolumeSource(DictMixin):
    """Represents a cinder volume resource in Openstack. A Cinder volume must exist
      before mounting to a container. The volume must also be in the same region as
      the kubelet. Cinder volumes support ownership management and SELinux
      relabeling.

      **parameters**

      * **volumeID** ``str`` - volume id used to identify the volume in cinder. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be
        "ext4" if unspecified. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **secretRef** ``Optional[LocalObjectReference]`` - Optional: points to a secret object containing parameters used to connect to
        OpenStack.
    """
    volumeID: 'str'
    fsType: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[LocalObjectReference]' = None


@dataclass
class ClientIPConfig(DictMixin):
    """ClientIPConfig represents the configurations of Client IP based session
      affinity.

      **parameters**

      * **timeoutSeconds** ``Optional[int]`` - timeoutSeconds specifies the seconds of ClientIP type session sticky time. The
        value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP".
        Default value is 10800(for 3 hours).
    """
    timeoutSeconds: 'Optional[int]' = None


@dataclass
class ComponentCondition(DictMixin):
    """Information about the condition of a component.

      **parameters**

      * **status** ``str`` - Status of the condition for a component. Valid values for "Healthy": "True",
        "False", or "Unknown".
      * **type** ``str`` - Type of condition for a component. Valid value: "Healthy"
      * **error** ``Optional[str]`` - Condition error code for a component. For example, a health check error code.
      * **message** ``Optional[str]`` - Message about the condition for a component. For example, information about a
        health check.
    """
    status: 'str'
    type: 'str'
    error: 'Optional[str]' = None
    message: 'Optional[str]' = None


@dataclass
class ComponentStatus(DictMixin):
    """ComponentStatus (and ComponentStatusList) holds the cluster validation info.
      Deprecated: This API is deprecated in v1.19+

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **conditions** ``Optional[List[ComponentCondition]]`` - List of component conditions observed
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    apiVersion: 'Optional[str]' = None
    conditions: 'Optional[List[ComponentCondition]]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class ComponentStatusList(DictMixin):
    """Status of all the conditions for the component as a list of ComponentStatus
      objects. Deprecated: This API is deprecated in v1.19+

      **parameters**

      * **items** ``List[ComponentStatus]`` - List of ComponentStatus objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ComponentStatus]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ConfigMap(DictMixin):
    """ConfigMap holds configuration data for pods to consume.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **binaryData** ``Optional[dict]`` - BinaryData contains the binary data. Each key must consist of alphanumeric
        characters, '-', '_' or '.'. BinaryData can contain byte sequences that are
        not in the UTF-8 range. The keys stored in BinaryData must not overlap with
        the ones in the Data field, this is enforced during validation process. Using
        this field will require 1.10+ apiserver and kubelet.
      * **data** ``Optional[dict]`` - Data contains the configuration data. Each key must consist of alphanumeric
        characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the
        BinaryData field. The keys stored in Data must not overlap with the keys in
        the BinaryData field, this is enforced during validation process.
      * **immutable** ``Optional[bool]`` - Immutable, if set to true, ensures that data stored in the ConfigMap cannot be
        updated (only object metadata can be modified). If not set to true, the field
        can be modified at any time. Defaulted to nil.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    apiVersion: 'Optional[str]' = None
    binaryData: 'Optional[dict]' = None
    data: 'Optional[dict]' = None
    immutable: 'Optional[bool]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class ConfigMapEnvSource(DictMixin):
    """ConfigMapEnvSource selects a ConfigMap to populate the environment variables
      with.
      
      The contents of the target ConfigMap's Data field will represent the key-value
      pairs as environment variables.

      **parameters**

      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the ConfigMap must be defined
    """
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class ConfigMapKeySelector(DictMixin):
    """Selects a key from a ConfigMap.

      **parameters**

      * **key** ``str`` - The key to select.
      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the ConfigMap or its key must be defined
    """
    key: 'str'
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class ConfigMapList(DictMixin):
    """ConfigMapList is a resource containing a list of ConfigMap objects.

      **parameters**

      * **items** ``List[ConfigMap]`` - Items is the list of ConfigMaps.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[ConfigMap]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ConfigMapNodeConfigSource(DictMixin):
    """ConfigMapNodeConfigSource contains the information to reference a ConfigMap as
      a config source for the Node. This API is deprecated since 1.22:
      https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration

      **parameters**

      * **kubeletConfigKey** ``str`` - KubeletConfigKey declares which key of the referenced ConfigMap corresponds to
        the KubeletConfiguration structure This field is required in all cases.
      * **name** ``str`` - Name is the metadata.name of the referenced ConfigMap. This field is required
        in all cases.
      * **namespace** ``str`` - Namespace is the metadata.namespace of the referenced ConfigMap. This field is
        required in all cases.
      * **resourceVersion** ``Optional[str]`` - ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap.
        This field is forbidden in Node.Spec, and required in Node.Status.
      * **uid** ``Optional[str]`` - UID is the metadata.UID of the referenced ConfigMap. This field is forbidden
        in Node.Spec, and required in Node.Status.
    """
    kubeletConfigKey: 'str'
    name: 'str'
    namespace: 'str'
    resourceVersion: 'Optional[str]' = None
    uid: 'Optional[str]' = None


@dataclass
class ConfigMapProjection(DictMixin):
    """Adapts a ConfigMap into a projected volume.
      
      The contents of the target ConfigMap's Data field will be presented in a
      projected volume as files using the keys in the Data field as the file names,
      unless the items element is populated with specific mappings of keys to paths.
      Note that this is identical to a configmap volume source without the default
      mode.

      **parameters**

      * **items** ``Optional[List[KeyToPath]]`` - If unspecified, each key-value pair in the Data field of the referenced
        ConfigMap will be projected into the volume as a file whose name is the key
        and content is the value. If specified, the listed keys will be projected into
        the specified paths, and unlisted keys will not be present. If a key is
        specified which is not present in the ConfigMap, the volume setup will error
        unless it is marked optional. Paths must be relative and may not contain the
        '..' path or start with '..'.
      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the ConfigMap or its keys must be defined
    """
    items: 'Optional[List[KeyToPath]]' = None
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class ConfigMapVolumeSource(DictMixin):
    """Adapts a ConfigMap into a volume.
      
      The contents of the target ConfigMap's Data field will be presented in a
      volume as files using the keys in the Data field as the file names, unless the
      items element is populated with specific mappings of keys to paths. ConfigMap
      volumes support ownership management and SELinux relabeling.

      **parameters**

      * **defaultMode** ``Optional[int]`` - Optional: mode bits used to set permissions on created files by default. Must
        be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
        YAML accepts both octal and decimal values, JSON requires decimal values for
        mode bits. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.
      * **items** ``Optional[List[KeyToPath]]`` - If unspecified, each key-value pair in the Data field of the referenced
        ConfigMap will be projected into the volume as a file whose name is the key
        and content is the value. If specified, the listed keys will be projected into
        the specified paths, and unlisted keys will not be present. If a key is
        specified which is not present in the ConfigMap, the volume setup will error
        unless it is marked optional. Paths must be relative and may not contain the
        '..' path or start with '..'.
      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the ConfigMap or its keys must be defined
    """
    defaultMode: 'Optional[int]' = None
    items: 'Optional[List[KeyToPath]]' = None
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class Container(DictMixin):
    """A single application container that you want to run within a pod.

      **parameters**

      * **name** ``str`` - Name of the container specified as a DNS_LABEL. Each container in a pod must
        have a unique name (DNS_LABEL). Cannot be updated.
      * **args** ``Optional[List[str]]`` - Arguments to the entrypoint. The docker image's CMD is used if this is not
        provided. Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. Double $$ are reduced to a single $, which allows
        for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the
        string literal "$(VAR_NAME)". Escaped references will never be expanded,
        regardless of whether the variable exists or not. Cannot be updated. More
        info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **command** ``Optional[List[str]]`` - Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT
        is used if this is not provided. Variable references $(VAR_NAME) are expanded
        using the container's environment. If a variable cannot be resolved, the
        reference in the input string will be unchanged. Double $$ are reduced to a
        single $, which allows for escaping the $(VAR_NAME) syntax: i.e.
        "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped
        references will never be expanded, regardless of whether the variable exists
        or not. Cannot be updated. More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **env** ``Optional[List[EnvVar]]`` - List of environment variables to set in the container. Cannot be updated.
      * **envFrom** ``Optional[List[EnvFromSource]]`` - List of sources to populate environment variables in the container. The keys
        defined within a source must be a C_IDENTIFIER. All invalid keys will be
        reported as an event when the container is starting. When a key exists in
        multiple sources, the value associated with the last source will take
        precedence. Values defined by an Env with a duplicate key will take
        precedence. Cannot be updated.
      * **image** ``Optional[str]`` - Docker image name. More info:
        https://kubernetes.io/docs/concepts/containers/images This field is optional
        to allow higher level config management to default or override container
        images in workload controllers like Deployments and StatefulSets.
      * **imagePullPolicy** ``Optional[str]`` - Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if
        :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More
        info: https://kubernetes.io/docs/concepts/containers/images#updating-images
      * **lifecycle** ``Optional[Lifecycle]`` - Actions that the management system should take in response to container
        lifecycle events. Cannot be updated.
      * **livenessProbe** ``Optional[Probe]`` - Periodic probe of container liveness. Container will be restarted if the probe
        fails. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **ports** ``Optional[List[ContainerPort]]`` - List of ports to expose from the container. Exposing a port here gives the
        system additional information about the network connections a container uses,
        but is primarily informational. Not specifying a port here DOES NOT prevent
        that port from being exposed. Any port which is listening on the default
        "0.0.0.0" address inside a container will be accessible from the network.
        Cannot be updated.
      * **readinessProbe** ``Optional[Probe]`` - Periodic probe of container service readiness. Container will be removed from
        service endpoints if the probe fails. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **resources** ``Optional[ResourceRequirements]`` - Compute Resources required by this container. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
      * **securityContext** ``Optional[SecurityContext]`` - SecurityContext defines the security options the container should be run with.
        If set, the fields of SecurityContext override the equivalent fields of
        PodSecurityContext. More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
      * **startupProbe** ``Optional[Probe]`` - StartupProbe indicates that the Pod has successfully initialized. If
        specified, no other probes are executed until this completes successfully. If
        this probe fails, the Pod will be restarted, just as if the livenessProbe
        failed. This can be used to provide different probe parameters at the
        beginning of a Pod's lifecycle, when it might take a long time to load data or
        warm a cache, than during steady-state operation. This cannot be updated. More
        info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **stdin** ``Optional[bool]`` - Whether this container should allocate a buffer for stdin in the container
        runtime. If this is not set, reads from stdin in the container will always
        result in EOF. Default is false.
      * **stdinOnce** ``Optional[bool]`` - Whether the container runtime should close the stdin channel after it has been
        opened by a single attach. When stdin is true the stdin stream will remain
        open across multiple attach sessions. If stdinOnce is set to true, stdin is
        opened on container start, is empty until the first client attaches to stdin,
        and then remains open and accepts data until the client disconnects, at which
        time stdin is closed and remains closed until the container is restarted. If
        this flag is false, a container processes that reads from stdin will never
        receive an EOF. Default is false
      * **terminationMessagePath** ``Optional[str]`` - Optional: Path at which the file to which the container's termination message
        will be written is mounted into the container's filesystem. Message written is
        intended to be brief final status, such as an assertion failure message. Will
        be truncated by the node if greater than 4096 bytes. The total message length
        across all containers will be limited to 12kb. Defaults to
        /dev/termination-log. Cannot be updated.
      * **terminationMessagePolicy** ``Optional[str]`` - Indicate how the termination message should be populated. File will use the
        contents of terminationMessagePath to populate the container status message on
        both success and failure. FallbackToLogsOnError will use the last chunk of
        container log output if the termination message file is empty and the
        container exited with an error. The log output is limited to 2048 bytes or 80
        lines, whichever is smaller. Defaults to File. Cannot be updated.
      * **tty** ``Optional[bool]`` - Whether this container should allocate a TTY for itself, also requires 'stdin'
        to be true. Default is false.
      * **volumeDevices** ``Optional[List[VolumeDevice]]`` - volumeDevices is the list of block devices to be used by the container.
      * **volumeMounts** ``Optional[List[VolumeMount]]`` - Pod volumes to mount into the container's filesystem. Cannot be updated.
      * **workingDir** ``Optional[str]`` - Container's working directory. If not specified, the container runtime's
        default will be used, which might be configured in the container image. Cannot
        be updated.
    """
    name: 'str'
    args: 'Optional[List[str]]' = None
    command: 'Optional[List[str]]' = None
    env: 'Optional[List[EnvVar]]' = None
    envFrom: 'Optional[List[EnvFromSource]]' = None
    image: 'Optional[str]' = None
    imagePullPolicy: 'Optional[str]' = None
    lifecycle: 'Optional[Lifecycle]' = None
    livenessProbe: 'Optional[Probe]' = None
    ports: 'Optional[List[ContainerPort]]' = None
    readinessProbe: 'Optional[Probe]' = None
    resources: 'Optional[ResourceRequirements]' = None
    securityContext: 'Optional[SecurityContext]' = None
    startupProbe: 'Optional[Probe]' = None
    stdin: 'Optional[bool]' = None
    stdinOnce: 'Optional[bool]' = None
    terminationMessagePath: 'Optional[str]' = None
    terminationMessagePolicy: 'Optional[str]' = None
    tty: 'Optional[bool]' = None
    volumeDevices: 'Optional[List[VolumeDevice]]' = None
    volumeMounts: 'Optional[List[VolumeMount]]' = None
    workingDir: 'Optional[str]' = None


@dataclass
class ContainerImage(DictMixin):
    """Describe a container image

      **parameters**

      * **names** ``Optional[List[str]]`` - Names by which this image is known. e.g. ["k8s.gcr.io/hyperkube:v1.0.7",
        "dockerhub.io/google_containers/hyperkube:v1.0.7"]
      * **sizeBytes** ``Optional[int]`` - The size of the image in bytes.
    """
    names: 'Optional[List[str]]' = None
    sizeBytes: 'Optional[int]' = None


@dataclass
class ContainerPort(DictMixin):
    """ContainerPort represents a network port in a single container.

      **parameters**

      * **containerPort** ``int`` - Number of port to expose on the pod's IP address. This must be a valid port
        number, 0 < x < 65536.
      * **hostIP** ``Optional[str]`` - What host IP to bind the external port to.
      * **hostPort** ``Optional[int]`` - Number of port to expose on the host. If specified, this must be a valid port
        number, 0 < x < 65536. If HostNetwork is specified, this must match
        ContainerPort. Most containers do not need this.
      * **name** ``Optional[str]`` - If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
        named port in a pod must have a unique name. Name for the port that can be
        referred to by services.
      * **protocol** ``Optional[str]`` - Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
    """
    containerPort: 'int'
    hostIP: 'Optional[str]' = None
    hostPort: 'Optional[int]' = None
    name: 'Optional[str]' = None
    protocol: 'Optional[str]' = None


@dataclass
class ContainerState(DictMixin):
    """ContainerState holds a possible state of container. Only one of its members
      may be specified. If none of them is specified, the default one is
      ContainerStateWaiting.

      **parameters**

      * **running** ``Optional[ContainerStateRunning]`` - Details about a running container
      * **terminated** ``Optional[ContainerStateTerminated]`` - Details about a terminated container
      * **waiting** ``Optional[ContainerStateWaiting]`` - Details about a waiting container
    """
    running: 'Optional[ContainerStateRunning]' = None
    terminated: 'Optional[ContainerStateTerminated]' = None
    waiting: 'Optional[ContainerStateWaiting]' = None


@dataclass
class ContainerStateRunning(DictMixin):
    """ContainerStateRunning is a running state of a container.

      **parameters**

      * **startedAt** ``Optional[meta_v1.Time]`` - Time at which the container was last (re-)started
    """
    startedAt: 'Optional[meta_v1.Time]' = None


@dataclass
class ContainerStateTerminated(DictMixin):
    """ContainerStateTerminated is a terminated state of a container.

      **parameters**

      * **exitCode** ``int`` - Exit status from the last termination of the container
      * **containerID** ``Optional[str]`` - Container's ID in the format 'docker://<container_id>'
      * **finishedAt** ``Optional[meta_v1.Time]`` - Time at which the container last terminated
      * **message** ``Optional[str]`` - Message regarding the last termination of the container
      * **reason** ``Optional[str]`` - (brief) reason from the last termination of the container
      * **signal** ``Optional[int]`` - Signal from the last termination of the container
      * **startedAt** ``Optional[meta_v1.Time]`` - Time at which previous execution of the container started
    """
    exitCode: 'int'
    containerID: 'Optional[str]' = None
    finishedAt: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None
    signal: 'Optional[int]' = None
    startedAt: 'Optional[meta_v1.Time]' = None


@dataclass
class ContainerStateWaiting(DictMixin):
    """ContainerStateWaiting is a waiting state of a container.

      **parameters**

      * **message** ``Optional[str]`` - Message regarding why the container is not yet running.
      * **reason** ``Optional[str]`` - (brief) reason the container is not yet running.
    """
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class ContainerStatus(DictMixin):
    """ContainerStatus contains details for the current status of this container.

      **parameters**

      * **image** ``str`` - The image the container is running. More info:
        https://kubernetes.io/docs/concepts/containers/images
      * **imageID** ``str`` - ImageID of the container's image.
      * **name** ``str`` - This must be a DNS_LABEL. Each container in a pod must have a unique name.
        Cannot be updated.
      * **ready** ``bool`` - Specifies whether the container has passed its readiness probe.
      * **restartCount** ``int`` - The number of times the container has been restarted, currently based on the
        number of dead containers that have not yet been removed. Note that this is
        calculated from dead containers. But those containers are subject to garbage
        collection. This value will get capped at 5 by GC.
      * **containerID** ``Optional[str]`` - Container's ID in the format 'docker://<container_id>'.
      * **lastState** ``Optional[ContainerState]`` - Details about the container's last termination condition.
      * **started** ``Optional[bool]`` - Specifies whether the container has passed its startup probe. Initialized as
        false, becomes true after startupProbe is considered successful. Resets to
        false when the container is restarted, or if kubelet loses state temporarily.
        Is always true when no startupProbe is defined.
      * **state** ``Optional[ContainerState]`` - Details about the container's current condition.
    """
    image: 'str'
    imageID: 'str'
    name: 'str'
    ready: 'bool'
    restartCount: 'int'
    containerID: 'Optional[str]' = None
    lastState: 'Optional[ContainerState]' = None
    started: 'Optional[bool]' = None
    state: 'Optional[ContainerState]' = None


@dataclass
class DaemonEndpoint(DictMixin):
    """DaemonEndpoint contains information about a single Daemon endpoint.

      **parameters**

      * **Port** ``int`` - Port number of the given endpoint.
    """
    Port: 'int'


@dataclass
class DownwardAPIProjection(DictMixin):
    """Represents downward API info for projecting into a projected volume. Note that
      this is identical to a downwardAPI volume source without the default mode.

      **parameters**

      * **items** ``Optional[List[DownwardAPIVolumeFile]]`` - Items is a list of DownwardAPIVolume file
    """
    items: 'Optional[List[DownwardAPIVolumeFile]]' = None


@dataclass
class DownwardAPIVolumeFile(DictMixin):
    """DownwardAPIVolumeFile represents information to create the file containing the
      pod field

      **parameters**

      * **path** ``str`` - Required: Path is  the relative path name of the file to be created. Must not
        be absolute or contain the '..' path. Must be utf-8 encoded. The first item of
        the relative path must not start with '..'
      * **fieldRef** ``Optional[ObjectFieldSelector]`` - Required: Selects a field of the pod: only annotations, labels, name and
        namespace are supported.
      * **mode** ``Optional[int]`` - Optional: mode bits used to set permissions on this file, must be an octal
        value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts
        both octal and decimal values, JSON requires decimal values for mode bits. If
        not specified, the volume defaultMode will be used. This might be in conflict
        with other options that affect the file mode, like fsGroup, and the result can
        be other mode bits set.
      * **resourceFieldRef** ``Optional[ResourceFieldSelector]`` - Selects a resource of the container: only resources limits and requests
        (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently
        supported.
    """
    path: 'str'
    fieldRef: 'Optional[ObjectFieldSelector]' = None
    mode: 'Optional[int]' = None
    resourceFieldRef: 'Optional[ResourceFieldSelector]' = None


@dataclass
class DownwardAPIVolumeSource(DictMixin):
    """DownwardAPIVolumeSource represents a volume containing downward API info.
      Downward API volumes support ownership management and SELinux relabeling.

      **parameters**

      * **defaultMode** ``Optional[int]`` - Optional: mode bits to use on created files by default. Must be a Optional:
        mode bits used to set permissions on created files by default. Must be an
        octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML
        accepts both octal and decimal values, JSON requires decimal values for mode
        bits. Defaults to 0644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
      * **items** ``Optional[List[DownwardAPIVolumeFile]]`` - Items is a list of downward API volume file
    """
    defaultMode: 'Optional[int]' = None
    items: 'Optional[List[DownwardAPIVolumeFile]]' = None


@dataclass
class EmptyDirVolumeSource(DictMixin):
    """Represents an empty directory for a pod. Empty directory volumes support
      ownership management and SELinux relabeling.

      **parameters**

      * **medium** ``Optional[str]`` - What type of storage medium should back this directory. The default is ""
        which means to use the node's default medium. Must be an empty string
        (default) or Memory. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#emptydir
      * **sizeLimit** ``Optional[resource.Quantity]`` - Total amount of local storage required for this EmptyDir volume. The size
        limit is also applicable for memory medium. The maximum usage on memory medium
        EmptyDir would be the minimum value between the SizeLimit specified here and
        the sum of memory limits of all containers in a pod. The default is nil which
        means that the limit is undefined. More info:
        http://kubernetes.io/docs/user-guide/volumes#emptydir
    """
    medium: 'Optional[str]' = None
    sizeLimit: 'Optional[resource.Quantity]' = None


@dataclass
class EndpointAddress(DictMixin):
    """EndpointAddress is a tuple that describes single IP address.

      **parameters**

      * **ip** ``str`` - The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local
        (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also
        accepted but not fully supported on all platforms. Also, certain kubernetes
        components, like kube-proxy, are not IPv6 ready.
      * **hostname** ``Optional[str]`` - The Hostname of this endpoint
      * **nodeName** ``Optional[str]`` - Optional: Node hosting this endpoint. This can be used to determine endpoints
        local to a node.
      * **targetRef** ``Optional[ObjectReference]`` - Reference to object providing the endpoint.
    """
    ip: 'str'
    hostname: 'Optional[str]' = None
    nodeName: 'Optional[str]' = None
    targetRef: 'Optional[ObjectReference]' = None


@dataclass
class EndpointPort(DictMixin):
    """EndpointPort is a tuple that describes a single port.

      **parameters**

      * **port** ``int`` - The port number of the endpoint.
      * **appProtocol** ``Optional[str]`` - The application protocol for this port. This field follows standard Kubernetes
        label syntax. Un-prefixed names are reserved for IANA standard service names
        (as per RFC-6335 and http://www.iana.org/assignments/service-names).
        Non-standard protocols should use prefixed names such as
        mycompany.com/my-custom-protocol.
      * **name** ``Optional[str]`` - The name of this port.  This must match the 'name' field in the corresponding
        ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
      * **protocol** ``Optional[str]`` - The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
    """
    port: 'int'
    appProtocol: 'Optional[str]' = None
    name: 'Optional[str]' = None
    protocol: 'Optional[str]' = None


@dataclass
class EndpointSubset(DictMixin):
    """EndpointSubset is a group of addresses with a common set of ports. The
      expanded set of endpoints is the Cartesian product of Addresses x Ports. For
      example, given:
        {
          Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
          Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        }
      The resulting set of endpoints can be viewed as:
          a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
          b: [ 10.10.1.1:309, 10.10.2.2:309 ]

      **parameters**

      * **addresses** ``Optional[List[EndpointAddress]]`` - IP addresses which offer the related ports that are marked as ready. These
        endpoints should be considered safe for load balancers and clients to utilize.
      * **notReadyAddresses** ``Optional[List[EndpointAddress]]`` - IP addresses which offer the related ports but are not currently marked as
        ready because they have not yet finished starting, have recently failed a
        readiness check, or have recently failed a liveness check.
      * **ports** ``Optional[List[EndpointPort]]`` - Port numbers available on the related IP addresses.
    """
    addresses: 'Optional[List[EndpointAddress]]' = None
    notReadyAddresses: 'Optional[List[EndpointAddress]]' = None
    ports: 'Optional[List[EndpointPort]]' = None


@dataclass
class Endpoints(DictMixin):
    """Endpoints is a collection of endpoints that implement the actual service.
      Example:
        Name: "mysvc",
        Subsets: [
          {
            Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
            Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
          },
          {
            Addresses: [{"ip": "10.10.3.3"}],
            Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
          },
       ]

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **subsets** ``Optional[List[EndpointSubset]]`` - The set of all endpoints is the union of all subsets. Addresses are placed
        into subsets according to the IPs they share. A single address with multiple
        ports, some of which are ready and some of which are not (because they come
        from different containers) will result in the address being displayed in
        different subsets for the different ports. No address will appear in both
        Addresses and NotReadyAddresses in the same subset. Sets of addresses and
        ports that comprise a service.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    subsets: 'Optional[List[EndpointSubset]]' = None


@dataclass
class EndpointsList(DictMixin):
    """EndpointsList is a list of endpoints.

      **parameters**

      * **items** ``List[Endpoints]`` - List of endpoints.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Endpoints]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class EnvFromSource(DictMixin):
    """EnvFromSource represents the source of a set of ConfigMaps

      **parameters**

      * **configMapRef** ``Optional[ConfigMapEnvSource]`` - The ConfigMap to select from
      * **prefix** ``Optional[str]`` - An optional identifier to prepend to each key in the ConfigMap. Must be a
        C_IDENTIFIER.
      * **secretRef** ``Optional[SecretEnvSource]`` - The Secret to select from
    """
    configMapRef: 'Optional[ConfigMapEnvSource]' = None
    prefix: 'Optional[str]' = None
    secretRef: 'Optional[SecretEnvSource]' = None


@dataclass
class EnvVar(DictMixin):
    """EnvVar represents an environment variable present in a Container.

      **parameters**

      * **name** ``str`` - Name of the environment variable. Must be a C_IDENTIFIER.
      * **value** ``Optional[str]`` - Variable references $(VAR_NAME) are expanded using the previously defined
        environment variables in the container and any service environment variables.
        If a variable cannot be resolved, the reference in the input string will be
        unchanged. Double $$ are reduced to a single $, which allows for escaping the
        $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal
        "$(VAR_NAME)". Escaped references will never be expanded, regardless of
        whether the variable exists or not. Defaults to "".
      * **valueFrom** ``Optional[EnvVarSource]`` - Source for the environment variable's value. Cannot be used if value is not
        empty.
    """
    name: 'str'
    value: 'Optional[str]' = None
    valueFrom: 'Optional[EnvVarSource]' = None


@dataclass
class EnvVarSource(DictMixin):
    """EnvVarSource represents a source for the value of an EnvVar.

      **parameters**

      * **configMapKeyRef** ``Optional[ConfigMapKeySelector]`` - Selects a key of a ConfigMap.
      * **fieldRef** ``Optional[ObjectFieldSelector]`` - Selects a field of the pod: supports metadata.name, metadata.namespace,
        `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName,
        spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
      * **resourceFieldRef** ``Optional[ResourceFieldSelector]`` - Selects a resource of the container: only resources limits and requests
        (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu,
        requests.memory and requests.ephemeral-storage) are currently supported.
      * **secretKeyRef** ``Optional[SecretKeySelector]`` - Selects a key of a secret in the pod's namespace
    """
    configMapKeyRef: 'Optional[ConfigMapKeySelector]' = None
    fieldRef: 'Optional[ObjectFieldSelector]' = None
    resourceFieldRef: 'Optional[ResourceFieldSelector]' = None
    secretKeyRef: 'Optional[SecretKeySelector]' = None


@dataclass
class EphemeralContainer(DictMixin):
    """An EphemeralContainer is a container that may be added temporarily to an
      existing pod for user-initiated activities such as debugging. Ephemeral
      containers have no resource or scheduling guarantees, and they will not be
      restarted when they exit or when a pod is removed or restarted. If an
      ephemeral container causes a pod to exceed its resource allocation, the pod
      may be evicted. Ephemeral containers may not be added by directly updating the
      pod spec. They must be added via the pod's ephemeralcontainers subresource,
      and they will appear in the pod spec once added. This is an alpha feature
      enabled by the EphemeralContainers feature flag.

      **parameters**

      * **name** ``str`` - Name of the ephemeral container specified as a DNS_LABEL. This name must be
        unique among all containers, init containers and ephemeral containers.
      * **args** ``Optional[List[str]]`` - Arguments to the entrypoint. The docker image's CMD is used if this is not
        provided. Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. Double $$ are reduced to a single $, which allows
        for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the
        string literal "$(VAR_NAME)". Escaped references will never be expanded,
        regardless of whether the variable exists or not. Cannot be updated. More
        info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **command** ``Optional[List[str]]`` - Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT
        is used if this is not provided. Variable references $(VAR_NAME) are expanded
        using the container's environment. If a variable cannot be resolved, the
        reference in the input string will be unchanged. Double $$ are reduced to a
        single $, which allows for escaping the $(VAR_NAME) syntax: i.e.
        "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped
        references will never be expanded, regardless of whether the variable exists
        or not. Cannot be updated. More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **env** ``Optional[List[EnvVar]]`` - List of environment variables to set in the container. Cannot be updated.
      * **envFrom** ``Optional[List[EnvFromSource]]`` - List of sources to populate environment variables in the container. The keys
        defined within a source must be a C_IDENTIFIER. All invalid keys will be
        reported as an event when the container is starting. When a key exists in
        multiple sources, the value associated with the last source will take
        precedence. Values defined by an Env with a duplicate key will take
        precedence. Cannot be updated.
      * **image** ``Optional[str]`` - Docker image name. More info:
        https://kubernetes.io/docs/concepts/containers/images
      * **imagePullPolicy** ``Optional[str]`` - Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if
        :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More
        info: https://kubernetes.io/docs/concepts/containers/images#updating-images
      * **lifecycle** ``Optional[Lifecycle]`` - Lifecycle is not allowed for ephemeral containers.
      * **livenessProbe** ``Optional[Probe]`` - Probes are not allowed for ephemeral containers.
      * **ports** ``Optional[List[ContainerPort]]`` - Ports are not allowed for ephemeral containers.
      * **readinessProbe** ``Optional[Probe]`` - Probes are not allowed for ephemeral containers.
      * **resources** ``Optional[ResourceRequirements]`` - Resources are not allowed for ephemeral containers. Ephemeral containers use
        spare resources already allocated to the pod.
      * **securityContext** ``Optional[SecurityContext]`` - Optional: SecurityContext defines the security options the ephemeral container
        should be run with. If set, the fields of SecurityContext override the
        equivalent fields of PodSecurityContext.
      * **startupProbe** ``Optional[Probe]`` - Probes are not allowed for ephemeral containers.
      * **stdin** ``Optional[bool]`` - Whether this container should allocate a buffer for stdin in the container
        runtime. If this is not set, reads from stdin in the container will always
        result in EOF. Default is false.
      * **stdinOnce** ``Optional[bool]`` - Whether the container runtime should close the stdin channel after it has been
        opened by a single attach. When stdin is true the stdin stream will remain
        open across multiple attach sessions. If stdinOnce is set to true, stdin is
        opened on container start, is empty until the first client attaches to stdin,
        and then remains open and accepts data until the client disconnects, at which
        time stdin is closed and remains closed until the container is restarted. If
        this flag is false, a container processes that reads from stdin will never
        receive an EOF. Default is false
      * **targetContainerName** ``Optional[str]`` - If set, the name of the container from PodSpec that this ephemeral container
        targets. The ephemeral container will be run in the namespaces (IPC, PID, etc)
        of this container. If not set then the ephemeral container is run in whatever
        namespaces are shared for the pod. Note that the container runtime must
        support this feature.
      * **terminationMessagePath** ``Optional[str]`` - Optional: Path at which the file to which the container's termination message
        will be written is mounted into the container's filesystem. Message written is
        intended to be brief final status, such as an assertion failure message. Will
        be truncated by the node if greater than 4096 bytes. The total message length
        across all containers will be limited to 12kb. Defaults to
        /dev/termination-log. Cannot be updated.
      * **terminationMessagePolicy** ``Optional[str]`` - Indicate how the termination message should be populated. File will use the
        contents of terminationMessagePath to populate the container status message on
        both success and failure. FallbackToLogsOnError will use the last chunk of
        container log output if the termination message file is empty and the
        container exited with an error. The log output is limited to 2048 bytes or 80
        lines, whichever is smaller. Defaults to File. Cannot be updated.
      * **tty** ``Optional[bool]`` - Whether this container should allocate a TTY for itself, also requires 'stdin'
        to be true. Default is false.
      * **volumeDevices** ``Optional[List[VolumeDevice]]`` - volumeDevices is the list of block devices to be used by the container.
      * **volumeMounts** ``Optional[List[VolumeMount]]`` - Pod volumes to mount into the container's filesystem. Cannot be updated.
      * **workingDir** ``Optional[str]`` - Container's working directory. If not specified, the container runtime's
        default will be used, which might be configured in the container image. Cannot
        be updated.
    """
    name: 'str'
    args: 'Optional[List[str]]' = None
    command: 'Optional[List[str]]' = None
    env: 'Optional[List[EnvVar]]' = None
    envFrom: 'Optional[List[EnvFromSource]]' = None
    image: 'Optional[str]' = None
    imagePullPolicy: 'Optional[str]' = None
    lifecycle: 'Optional[Lifecycle]' = None
    livenessProbe: 'Optional[Probe]' = None
    ports: 'Optional[List[ContainerPort]]' = None
    readinessProbe: 'Optional[Probe]' = None
    resources: 'Optional[ResourceRequirements]' = None
    securityContext: 'Optional[SecurityContext]' = None
    startupProbe: 'Optional[Probe]' = None
    stdin: 'Optional[bool]' = None
    stdinOnce: 'Optional[bool]' = None
    targetContainerName: 'Optional[str]' = None
    terminationMessagePath: 'Optional[str]' = None
    terminationMessagePolicy: 'Optional[str]' = None
    tty: 'Optional[bool]' = None
    volumeDevices: 'Optional[List[VolumeDevice]]' = None
    volumeMounts: 'Optional[List[VolumeMount]]' = None
    workingDir: 'Optional[str]' = None


@dataclass
class EphemeralVolumeSource(DictMixin):
    """Represents an ephemeral volume that is handled by a normal storage driver.

      **parameters**

      * **volumeClaimTemplate** ``Optional[PersistentVolumeClaimTemplate]`` - Will be used to create a stand-alone PVC to provision the volume. The pod in
        which this EphemeralVolumeSource is embedded will be the owner of the PVC,
        i.e. the PVC will be deleted together with the pod.  The name of the PVC will
        be `<pod name>-<volume name>` where `<volume name>` is the name from the
        `PodSpec.Volumes` array entry. Pod validation will reject the pod if the
        concatenated name is not valid for a PVC (for example, too long).
        An existing PVC with that name that is not owned by the pod will *not* be used
        for the pod to avoid using an unrelated volume by mistake. Starting the pod is
        then blocked until the unrelated PVC is removed. If such a pre-created PVC is
        meant to be used by the pod, the PVC has to updated with an owner reference to
        the pod once the pod exists. Normally this should not be necessary, but it may
        be useful when manually reconstructing a broken cluster.
        This field is read-only and no changes will be made by Kubernetes to the PVC
        after it has been created.
        Required, must not be nil.
    """
    volumeClaimTemplate: 'Optional[PersistentVolumeClaimTemplate]' = None


@dataclass
class Event(DictMixin):
    """Event is a report of an event somewhere in the cluster.  Events have a limited
      retention time and triggers and messages may evolve with time.  Event
      consumers should not rely on the timing of an event with a given Reason
      reflecting a consistent underlying trigger, or the continued existence of
      events with that Reason.  Events should be treated as informative,
      best-effort, supplemental data.

      **parameters**

      * **involvedObject** ``ObjectReference`` - The object that this event is about.
      * **metadata** ``meta_v1.ObjectMeta`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **action** ``Optional[str]`` - What action was taken/failed regarding to the Regarding object.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **count** ``Optional[int]`` - The number of times this event has occurred.
      * **eventTime** ``Optional[meta_v1.MicroTime]`` - Time when this Event was first observed.
      * **firstTimestamp** ``Optional[meta_v1.Time]`` - The time at which the event was first recorded. (Time of server receipt is in
        TypeMeta.)
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **lastTimestamp** ``Optional[meta_v1.Time]`` - The time at which the most recent occurrence of this event was recorded.
      * **message** ``Optional[str]`` - A human-readable description of the status of this operation.
      * **reason** ``Optional[str]`` - This should be a short, machine understandable string that gives the reason
        for the transition into the object's current status.
      * **related** ``Optional[ObjectReference]`` - Optional secondary object for more complex actions.
      * **reportingComponent** ``Optional[str]`` - Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
      * **reportingInstance** ``Optional[str]`` - ID of the controller instance, e.g. `kubelet-xyzf`.
      * **series** ``Optional[EventSeries]`` - Data about the Event series this event represents or nil if it's a singleton
        Event.
      * **source** ``Optional[EventSource]`` - The component reporting this event. Should be a short machine understandable
        string.
      * **type** ``Optional[str]`` - Type of this event (Normal, Warning), new types could be added in the future
    """
    involvedObject: 'ObjectReference'
    metadata: 'meta_v1.ObjectMeta'
    action: 'Optional[str]' = None
    apiVersion: 'Optional[str]' = None
    count: 'Optional[int]' = None
    eventTime: 'Optional[meta_v1.MicroTime]' = None
    firstTimestamp: 'Optional[meta_v1.Time]' = None
    kind: 'Optional[str]' = None
    lastTimestamp: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None
    related: 'Optional[ObjectReference]' = None
    reportingComponent: 'Optional[str]' = None
    reportingInstance: 'Optional[str]' = None
    series: 'Optional[EventSeries]' = None
    source: 'Optional[EventSource]' = None
    type: 'Optional[str]' = None


@dataclass
class EventList(DictMixin):
    """EventList is a list of events.

      **parameters**

      * **items** ``List[Event]`` - List of events
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Event]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class EventSeries(DictMixin):
    """EventSeries contain information on series of events, i.e. thing that was/is
      happening continuously for some time.

      **parameters**

      * **count** ``Optional[int]`` - Number of occurrences in this series up to the last heartbeat time
      * **lastObservedTime** ``Optional[meta_v1.MicroTime]`` - Time of the last occurrence observed
    """
    count: 'Optional[int]' = None
    lastObservedTime: 'Optional[meta_v1.MicroTime]' = None


@dataclass
class EventSource(DictMixin):
    """EventSource contains information for an event.

      **parameters**

      * **component** ``Optional[str]`` - Component from which the event is generated.
      * **host** ``Optional[str]`` - Node name on which the event is generated.
    """
    component: 'Optional[str]' = None
    host: 'Optional[str]' = None


@dataclass
class ExecAction(DictMixin):
    """ExecAction describes a "run in container" action.

      **parameters**

      * **command** ``Optional[List[str]]`` - Command is the command line to execute inside the container, the working
        directory for the command  is root ('/') in the container's filesystem. The
        command is simply exec'd, it is not run inside a shell, so traditional shell
        instructions ('|', etc) won't work. To use a shell, you need to explicitly
        call out to that shell. Exit status of 0 is treated as live/healthy and
        non-zero is unhealthy.
    """
    command: 'Optional[List[str]]' = None


@dataclass
class FCVolumeSource(DictMixin):
    """Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted
      as read/write once. Fibre Channel volumes support ownership management and
      SELinux relabeling.

      **parameters**

      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **lun** ``Optional[int]`` - Optional: FC target lun number
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts.
      * **targetWWNs** ``Optional[List[str]]`` - Optional: FC target worldwide names (WWNs)
      * **wwids** ``Optional[List[str]]`` - Optional: FC volume world wide identifiers (wwids) Either wwids or combination
        of targetWWNs and lun must be set, but not both simultaneously.
    """
    fsType: 'Optional[str]' = None
    lun: 'Optional[int]' = None
    readOnly: 'Optional[bool]' = None
    targetWWNs: 'Optional[List[str]]' = None
    wwids: 'Optional[List[str]]' = None


@dataclass
class FlexPersistentVolumeSource(DictMixin):
    """FlexPersistentVolumeSource represents a generic persistent volume resource
      that is provisioned/attached using an exec based plugin.

      **parameters**

      * **driver** ``str`` - Driver is the name of the driver to use for this volume.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on
        FlexVolume script.
      * **options** ``Optional[dict]`` - Optional: Extra command options if any.
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts.
      * **secretRef** ``Optional[SecretReference]`` - Optional: SecretRef is reference to the secret object containing sensitive
        information to pass to the plugin scripts. This may be empty if no secret
        object is specified. If the secret object contains more than one secret, all
        secrets are passed to the plugin scripts.
    """
    driver: 'str'
    fsType: 'Optional[str]' = None
    options: 'Optional[dict]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[SecretReference]' = None


@dataclass
class FlexVolumeSource(DictMixin):
    """FlexVolume represents a generic volume resource that is provisioned/attached
      using an exec based plugin.

      **parameters**

      * **driver** ``str`` - Driver is the name of the driver to use for this volume.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on
        FlexVolume script.
      * **options** ``Optional[dict]`` - Optional: Extra command options if any.
      * **readOnly** ``Optional[bool]`` - Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts.
      * **secretRef** ``Optional[LocalObjectReference]`` - Optional: SecretRef is reference to the secret object containing sensitive
        information to pass to the plugin scripts. This may be empty if no secret
        object is specified. If the secret object contains more than one secret, all
        secrets are passed to the plugin scripts.
    """
    driver: 'str'
    fsType: 'Optional[str]' = None
    options: 'Optional[dict]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[LocalObjectReference]' = None


@dataclass
class FlockerVolumeSource(DictMixin):
    """Represents a Flocker volume mounted by the Flocker agent. One and only one of
      datasetName and datasetUUID should be set. Flocker volumes do not support
      ownership management or SELinux relabeling.

      **parameters**

      * **datasetName** ``Optional[str]`` - Name of the dataset stored as metadata -> name on the dataset for Flocker
        should be considered as deprecated
      * **datasetUUID** ``Optional[str]`` - UUID of the dataset. This is unique identifier of a Flocker dataset
    """
    datasetName: 'Optional[str]' = None
    datasetUUID: 'Optional[str]' = None


@dataclass
class GCEPersistentDiskVolumeSource(DictMixin):
    """Represents a Persistent Disk resource in Google Compute Engine.
      
      A GCE PD must exist before mounting to a container. The disk must also be in
      the same GCE project and zone as the kubelet. A GCE PD can only be mounted as
      read/write once or read-only many times. GCE PDs support ownership management
      and SELinux relabeling.

      **parameters**

      * **pdName** ``str`` - Unique name of the PD resource in GCE. Used to identify the disk in GCE. More
        info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **fsType** ``Optional[str]`` - Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **partition** ``Optional[int]`` - The partition in the volume that you want to mount. If omitted, the default is
        to mount by volume name. Examples: For volume /dev/sda1, you specify the
        partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you
        can leave the property empty). More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """
    pdName: 'str'
    fsType: 'Optional[str]' = None
    partition: 'Optional[int]' = None
    readOnly: 'Optional[bool]' = None


@dataclass
class GitRepoVolumeSource(DictMixin):
    """Represents a volume that is populated with the contents of a git repository.
      Git repo volumes do not support ownership management. Git repo volumes support
      SELinux relabeling.
      
      DEPRECATED: GitRepo is deprecated. To provision a container with a git repo,
      mount an EmptyDir into an InitContainer that clones the repo using git, then
      mount the EmptyDir into the Pod's container.

      **parameters**

      * **repository** ``str`` - Repository URL
      * **directory** ``Optional[str]`` - Target directory name. Must not contain or start with '..'.  If '.' is
        supplied, the volume directory will be the git repository.  Otherwise, if
        specified, the volume will contain the git repository in the subdirectory with
        the given name.
      * **revision** ``Optional[str]`` - Commit hash for the specified revision.
    """
    repository: 'str'
    directory: 'Optional[str]' = None
    revision: 'Optional[str]' = None


@dataclass
class GlusterfsPersistentVolumeSource(DictMixin):
    """Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **endpoints** ``str`` - EndpointsName is the endpoint name that details Glusterfs topology. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **path** ``str`` - Path is the Glusterfs volume path. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **endpointsNamespace** ``Optional[str]`` - EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this
        field is empty, the EndpointNamespace defaults to the same namespace as the
        bound PVC. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the Glusterfs volume to be mounted with read-only
        permissions. Defaults to false. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    endpoints: 'str'
    path: 'str'
    endpointsNamespace: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None


@dataclass
class GlusterfsVolumeSource(DictMixin):
    """Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **endpoints** ``str`` - EndpointsName is the endpoint name that details Glusterfs topology. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **path** ``str`` - Path is the Glusterfs volume path. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the Glusterfs volume to be mounted with read-only
        permissions. Defaults to false. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    endpoints: 'str'
    path: 'str'
    readOnly: 'Optional[bool]' = None


@dataclass
class HTTPGetAction(DictMixin):
    """HTTPGetAction describes an action based on HTTP Get requests.

      **parameters**

      * **port** ``util_intstr.IntOrString`` - Name or number of the port to access on the container. Number must be in the
        range 1 to 65535. Name must be an IANA_SVC_NAME.
      * **host** ``Optional[str]`` - Host name to connect to, defaults to the pod IP. You probably want to set
        "Host" in httpHeaders instead.
      * **httpHeaders** ``Optional[List[HTTPHeader]]`` - Custom headers to set in the request. HTTP allows repeated headers.
      * **path** ``Optional[str]`` - Path to access on the HTTP server.
      * **scheme** ``Optional[str]`` - Scheme to use for connecting to the host. Defaults to HTTP.
    """
    port: 'util_intstr.IntOrString'
    host: 'Optional[str]' = None
    httpHeaders: 'Optional[List[HTTPHeader]]' = None
    path: 'Optional[str]' = None
    scheme: 'Optional[str]' = None


@dataclass
class HTTPHeader(DictMixin):
    """HTTPHeader describes a custom header to be used in HTTP probes

      **parameters**

      * **name** ``str`` - The header field name
      * **value** ``str`` - The header field value
    """
    name: 'str'
    value: 'str'


@dataclass
class Handler(DictMixin):
    """Handler defines a specific action that should be taken

      **parameters**

      * **exec** ``Optional[ExecAction]`` - One and only one of the following should be specified. Exec specifies the
        action to take.
      * **httpGet** ``Optional[HTTPGetAction]`` - HTTPGet specifies the http request to perform.
      * **tcpSocket** ``Optional[TCPSocketAction]`` - TCPSocket specifies an action involving a TCP port. TCP hooks not yet
        supported
    """
    exec: 'Optional[ExecAction]' = None
    httpGet: 'Optional[HTTPGetAction]' = None
    tcpSocket: 'Optional[TCPSocketAction]' = None


@dataclass
class HostAlias(DictMixin):
    """HostAlias holds the mapping between IP and hostnames that will be injected as
      an entry in the pod's hosts file.

      **parameters**

      * **hostnames** ``Optional[List[str]]`` - Hostnames for the above IP address.
      * **ip** ``Optional[str]`` - IP address of the host file entry.
    """
    hostnames: 'Optional[List[str]]' = None
    ip: 'Optional[str]' = None


@dataclass
class HostPathVolumeSource(DictMixin):
    """Represents a host path mapped into a pod. Host path volumes do not support
      ownership management or SELinux relabeling.

      **parameters**

      * **path** ``str`` - Path of the directory on the host. If the path is a symlink, it will follow
        the link to the real path. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
      * **type** ``Optional[str]`` - Type for HostPath Volume Defaults to "" More info:
        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
    """
    path: 'str'
    type: 'Optional[str]' = None


@dataclass
class ISCSIPersistentVolumeSource(DictMixin):
    """ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only
      be mounted as read/write once. ISCSI volumes support ownership management and
      SELinux relabeling.

      **parameters**

      * **iqn** ``str`` - Target iSCSI Qualified Name.
      * **lun** ``int`` - iSCSI Target Lun number.
      * **targetPortal** ``str`` - iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is
        other than default (typically TCP ports 860 and 3260).
      * **chapAuthDiscovery** ``Optional[bool]`` - whether support iSCSI Discovery CHAP authentication
      * **chapAuthSession** ``Optional[bool]`` - whether support iSCSI Session CHAP authentication
      * **fsType** ``Optional[str]`` - Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#iscsi
      * **initiatorName** ``Optional[str]`` - Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface
        simultaneously, new iSCSI interface <target portal>:<volume name> will be
        created for the connection.
      * **iscsiInterface** ``Optional[str]`` - iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default'
        (tcp).
      * **portals** ``Optional[List[str]]`` - iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the
        port is other than default (typically TCP ports 860 and 3260).
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false.
      * **secretRef** ``Optional[SecretReference]`` - CHAP Secret for iSCSI target and initiator authentication
    """
    iqn: 'str'
    lun: 'int'
    targetPortal: 'str'
    chapAuthDiscovery: 'Optional[bool]' = None
    chapAuthSession: 'Optional[bool]' = None
    fsType: 'Optional[str]' = None
    initiatorName: 'Optional[str]' = None
    iscsiInterface: 'Optional[str]' = None
    portals: 'Optional[List[str]]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[SecretReference]' = None


@dataclass
class ISCSIVolumeSource(DictMixin):
    """Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write
      once. ISCSI volumes support ownership management and SELinux relabeling.

      **parameters**

      * **iqn** ``str`` - Target iSCSI Qualified Name.
      * **lun** ``int`` - iSCSI Target Lun number.
      * **targetPortal** ``str`` - iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is
        other than default (typically TCP ports 860 and 3260).
      * **chapAuthDiscovery** ``Optional[bool]`` - whether support iSCSI Discovery CHAP authentication
      * **chapAuthSession** ``Optional[bool]`` - whether support iSCSI Session CHAP authentication
      * **fsType** ``Optional[str]`` - Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#iscsi
      * **initiatorName** ``Optional[str]`` - Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface
        simultaneously, new iSCSI interface <target portal>:<volume name> will be
        created for the connection.
      * **iscsiInterface** ``Optional[str]`` - iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default'
        (tcp).
      * **portals** ``Optional[List[str]]`` - iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the
        port is other than default (typically TCP ports 860 and 3260).
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false.
      * **secretRef** ``Optional[LocalObjectReference]`` - CHAP Secret for iSCSI target and initiator authentication
    """
    iqn: 'str'
    lun: 'int'
    targetPortal: 'str'
    chapAuthDiscovery: 'Optional[bool]' = None
    chapAuthSession: 'Optional[bool]' = None
    fsType: 'Optional[str]' = None
    initiatorName: 'Optional[str]' = None
    iscsiInterface: 'Optional[str]' = None
    portals: 'Optional[List[str]]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[LocalObjectReference]' = None


@dataclass
class KeyToPath(DictMixin):
    """Maps a string key to a path within a volume.

      **parameters**

      * **key** ``str`` - The key to project.
      * **path** ``str`` - The relative path of the file to map the key to. May not be an absolute path.
        May not contain the path element '..'. May not start with the string '..'.
      * **mode** ``Optional[int]`` - Optional: mode bits used to set permissions on this file. Must be an octal
        value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts
        both octal and decimal values, JSON requires decimal values for mode bits. If
        not specified, the volume defaultMode will be used. This might be in conflict
        with other options that affect the file mode, like fsGroup, and the result can
        be other mode bits set.
    """
    key: 'str'
    path: 'str'
    mode: 'Optional[int]' = None


@dataclass
class Lifecycle(DictMixin):
    """Lifecycle describes actions that the management system should take in response
      to container lifecycle events. For the PostStart and PreStop lifecycle
      handlers, management of the container blocks until the action is complete,
      unless the container process fails, in which case the handler is aborted.

      **parameters**

      * **postStart** ``Optional[Handler]`` - PostStart is called immediately after a container is created. If the handler
        fails, the container is terminated and restarted according to its restart
        policy. Other management of the container blocks until the hook completes.
        More info:
        https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
      * **preStop** ``Optional[Handler]`` - PreStop is called immediately before a container is terminated due to an API
        request or management event such as liveness/startup probe failure,
        preemption, resource contention, etc. The handler is not called if the
        container crashes or exits. The reason for termination is passed to the
        handler. The Pod's termination grace period countdown begins before the
        PreStop hooked is executed. Regardless of the outcome of the handler, the
        container will eventually terminate within the Pod's termination grace period.
        Other management of the container blocks until the hook completes or until the
        termination grace period is reached. More info:
        https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
    """
    postStart: 'Optional[Handler]' = None
    preStop: 'Optional[Handler]' = None


@dataclass
class LimitRange(DictMixin):
    """LimitRange sets resource usage limits for each kind of resource in a
      Namespace.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[LimitRangeSpec]`` - Spec defines the limits enforced. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[LimitRangeSpec]' = None


@dataclass
class LimitRangeItem(DictMixin):
    """LimitRangeItem defines a min/max usage limit for any resource that matches on
      kind.

      **parameters**

      * **type** ``str`` - Type of resource that this limit applies to.
      * **default** ``Optional[dict]`` - Default resource requirement limit value by resource name if resource limit is
        omitted.
      * **defaultRequest** ``Optional[dict]`` - DefaultRequest is the default resource requirement request value by resource
        name if resource request is omitted.
      * **max** ``Optional[dict]`` - Max usage constraints on this kind by resource name.
      * **maxLimitRequestRatio** ``Optional[dict]`` - MaxLimitRequestRatio if specified, the named resource must have a request and
        limit that are both non-zero where limit divided by request is less than or
        equal to the enumerated value; this represents the max burst for the named
        resource.
      * **min** ``Optional[dict]`` - Min usage constraints on this kind by resource name.
    """
    type: 'str'
    default: 'Optional[dict]' = None
    defaultRequest: 'Optional[dict]' = None
    max: 'Optional[dict]' = None
    maxLimitRequestRatio: 'Optional[dict]' = None
    min: 'Optional[dict]' = None


@dataclass
class LimitRangeList(DictMixin):
    """LimitRangeList is a list of LimitRange items.

      **parameters**

      * **items** ``List[LimitRange]`` - Items is a list of LimitRange objects. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[LimitRange]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class LimitRangeSpec(DictMixin):
    """LimitRangeSpec defines a min/max usage limit for resources that match on kind.

      **parameters**

      * **limits** ``List[LimitRangeItem]`` - Limits is the list of LimitRangeItem objects that are enforced.
    """
    limits: 'List[LimitRangeItem]'


@dataclass
class LoadBalancerIngress(DictMixin):
    """LoadBalancerIngress represents the status of a load-balancer ingress point:
      traffic intended for the service should be sent to an ingress point.

      **parameters**

      * **hostname** ``Optional[str]`` - Hostname is set for load-balancer ingress points that are DNS based (typically
        AWS load-balancers)
      * **ip** ``Optional[str]`` - IP is set for load-balancer ingress points that are IP based (typically GCE or
        OpenStack load-balancers)
      * **ports** ``Optional[List[PortStatus]]`` - Ports is a list of records of service ports If used, every port defined in the
        service should have an entry in it
    """
    hostname: 'Optional[str]' = None
    ip: 'Optional[str]' = None
    ports: 'Optional[List[PortStatus]]' = None


@dataclass
class LoadBalancerStatus(DictMixin):
    """LoadBalancerStatus represents the status of a load-balancer.

      **parameters**

      * **ingress** ``Optional[List[LoadBalancerIngress]]`` - Ingress is a list containing ingress points for the load-balancer. Traffic
        intended for the service should be sent to these ingress points.
    """
    ingress: 'Optional[List[LoadBalancerIngress]]' = None


@dataclass
class LocalObjectReference(DictMixin):
    """LocalObjectReference contains enough information to let you locate the
      referenced object inside the same namespace.

      **parameters**

      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    name: 'Optional[str]' = None


@dataclass
class LocalVolumeSource(DictMixin):
    """Local represents directly-attached storage with node affinity (Beta feature)

      **parameters**

      * **path** ``str`` - The full path to the volume on the node. It can be either a directory or block
        device (disk, partition, ...).
      * **fsType** ``Optional[str]`` - Filesystem type to mount. It applies only when the Path is a block device.
        Must be a filesystem type supported by the host operating system. Ex. "ext4",
        "xfs", "ntfs". The default value is to auto-select a fileystem if unspecified.
    """
    path: 'str'
    fsType: 'Optional[str]' = None


@dataclass
class NFSVolumeSource(DictMixin):
    """Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not
      support ownership management or SELinux relabeling.

      **parameters**

      * **path** ``str`` - Path that is exported by the NFS server. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **server** ``str`` - Server is the hostname or IP address of the NFS server. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the NFS export to be mounted with read-only
        permissions. Defaults to false. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
    """
    path: 'str'
    server: 'str'
    readOnly: 'Optional[bool]' = None


@dataclass
class Namespace(DictMixin):
    """Namespace provides a scope for Names. Use of multiple namespaces is optional.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[NamespaceSpec]`` - Spec defines the behavior of the Namespace. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[NamespaceStatus]`` - Status describes the current status of a Namespace. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[NamespaceSpec]' = None
    status: 'Optional[NamespaceStatus]' = None


@dataclass
class NamespaceCondition(DictMixin):
    """NamespaceCondition contains details about state of namespace.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of namespace controller condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - 
      * **message** ``Optional[str]`` - 
      * **reason** ``Optional[str]`` - 
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class NamespaceList(DictMixin):
    """NamespaceList is a list of Namespaces.

      **parameters**

      * **items** ``List[Namespace]`` - Items is the list of Namespace objects in the list. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Namespace]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class NamespaceSpec(DictMixin):
    """NamespaceSpec describes the attributes on a Namespace.

      **parameters**

      * **finalizers** ``Optional[List[str]]`` - Finalizers is an opaque list of values that must be empty to permanently
        remove object from storage. More info:
        https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
    """
    finalizers: 'Optional[List[str]]' = None


@dataclass
class NamespaceStatus(DictMixin):
    """NamespaceStatus is information about the current status of a Namespace.

      **parameters**

      * **conditions** ``Optional[List[NamespaceCondition]]`` - Represents the latest available observations of a namespace's current state.
      * **phase** ``Optional[str]`` - Phase is the current lifecycle phase of the namespace. More info:
        https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
    """
    conditions: 'Optional[List[NamespaceCondition]]' = None
    phase: 'Optional[str]' = None


@dataclass
class Node(DictMixin):
    """Node is a worker node in Kubernetes. Each node will have a unique identifier
      in the cache (i.e. in etcd).

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[NodeSpec]`` - Spec defines the behavior of a node.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[NodeStatus]`` - Most recently observed status of the node. Populated by the system. Read-only.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[NodeSpec]' = None
    status: 'Optional[NodeStatus]' = None


@dataclass
class NodeAddress(DictMixin):
    """NodeAddress contains information for the node's address.

      **parameters**

      * **address** ``str`` - The node address.
      * **type** ``str`` - Node address type, one of Hostname, ExternalIP or InternalIP.
    """
    address: 'str'
    type: 'str'


@dataclass
class NodeAffinity(DictMixin):
    """Node affinity is a group of node affinity scheduling rules.

      **parameters**

      * **preferredDuringSchedulingIgnoredDuringExecution** ``Optional[List[PreferredSchedulingTerm]]`` - The scheduler will prefer to schedule pods to nodes that satisfy the affinity
        expressions specified by this field, but it may choose a node that violates
        one or more of the expressions. The node that is most preferred is the one
        with the greatest sum of weights, i.e. for each node that meets all of the
        scheduling requirements (resource request, requiredDuringScheduling affinity
        expressions, etc.), compute a sum by iterating through the elements of this
        field and adding "weight" to the sum if the node matches the corresponding
        matchExpressions; the node(s) with the highest sum are the most preferred.
      * **requiredDuringSchedulingIgnoredDuringExecution** ``Optional[NodeSelector]`` - If the affinity requirements specified by this field are not met at scheduling
        time, the pod will not be scheduled onto the node. If the affinity
        requirements specified by this field cease to be met at some point during pod
        execution (e.g. due to an update), the system may or may not try to eventually
        evict the pod from its node.
    """
    preferredDuringSchedulingIgnoredDuringExecution: 'Optional[List[PreferredSchedulingTerm]]' = None
    requiredDuringSchedulingIgnoredDuringExecution: 'Optional[NodeSelector]' = None


@dataclass
class NodeCondition(DictMixin):
    """NodeCondition contains condition information for a node.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of node condition.
      * **lastHeartbeatTime** ``Optional[meta_v1.Time]`` - Last time we got an update on a given condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transit from one status to another.
      * **message** ``Optional[str]`` - Human readable message indicating details about last transition.
      * **reason** ``Optional[str]`` - (brief) reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastHeartbeatTime: 'Optional[meta_v1.Time]' = None
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class NodeConfigSource(DictMixin):
    """NodeConfigSource specifies a source of node configuration. Exactly one
      subfield (excluding metadata) must be non-nil. This API is deprecated since
      1.22

      **parameters**

      * **configMap** ``Optional[ConfigMapNodeConfigSource]`` - ConfigMap is a reference to a Node's ConfigMap
    """
    configMap: 'Optional[ConfigMapNodeConfigSource]' = None


@dataclass
class NodeConfigStatus(DictMixin):
    """NodeConfigStatus describes the status of the config assigned by
      Node.Spec.ConfigSource.

      **parameters**

      * **active** ``Optional[NodeConfigSource]`` - Active reports the checkpointed config the node is actively using. Active will
        represent either the current version of the Assigned config, or the current
        LastKnownGood config, depending on whether attempting to use the Assigned
        config results in an error.
      * **assigned** ``Optional[NodeConfigSource]`` - Assigned reports the checkpointed config the node will try to use. When
        Node.Spec.ConfigSource is updated, the node checkpoints the associated config
        payload to local disk, along with a record indicating intended config. The
        node refers to this record to choose its config checkpoint, and reports this
        record in Assigned. Assigned only updates in the status after the record has
        been checkpointed to disk. When the Kubelet is restarted, it tries to make the
        Assigned config the Active config by loading and validating the checkpointed
        payload identified by Assigned.
      * **error** ``Optional[str]`` - Error describes any problems reconciling the Spec.ConfigSource to the Active
        config. Errors may occur, for example, attempting to checkpoint
        Spec.ConfigSource to the local Assigned record, attempting to checkpoint the
        payload associated with Spec.ConfigSource, attempting to load or validate the
        Assigned config, etc. Errors may occur at different points while syncing
        config. Earlier errors (e.g. download or checkpointing errors) will not result
        in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later
        errors (e.g. loading or validating a checkpointed config) will result in a
        rollback to LastKnownGood. In the latter case, it is usually possible to
        resolve the error by fixing the config assigned in Spec.ConfigSource. You can
        find additional information for debugging by searching the error message in
        the Kubelet log. Error is a human-readable description of the error state;
        machines can check whether or not Error is empty, but should not rely on the
        stability of the Error text across Kubelet versions.
      * **lastKnownGood** ``Optional[NodeConfigSource]`` - LastKnownGood reports the checkpointed config the node will fall back to when
        it encounters an error attempting to use the Assigned config. The Assigned
        config becomes the LastKnownGood config when the node determines that the
        Assigned config is stable and correct. This is currently implemented as a
        10-minute soak period starting when the local record of Assigned config is
        updated. If the Assigned config is Active at the end of this period, it
        becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use
        local defaults), the LastKnownGood is also immediately reset to nil, because
        the local default config is always assumed good. You should not make
        assumptions about the node's method of determining config stability and
        correctness, as this may change or become configurable in the future.
    """
    active: 'Optional[NodeConfigSource]' = None
    assigned: 'Optional[NodeConfigSource]' = None
    error: 'Optional[str]' = None
    lastKnownGood: 'Optional[NodeConfigSource]' = None


@dataclass
class NodeDaemonEndpoints(DictMixin):
    """NodeDaemonEndpoints lists ports opened by daemons running on the Node.

      **parameters**

      * **kubeletEndpoint** ``Optional[DaemonEndpoint]`` - Endpoint on which Kubelet is listening.
    """
    kubeletEndpoint: 'Optional[DaemonEndpoint]' = None


@dataclass
class NodeList(DictMixin):
    """NodeList is the whole list of all Nodes which have been registered with
      master.

      **parameters**

      * **items** ``List[Node]`` - List of nodes
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Node]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class NodeSelector(DictMixin):
    """A node selector represents the union of the results of one or more label
      queries over a set of nodes; that is, it represents the OR of the selectors
      represented by the node selector terms.

      **parameters**

      * **nodeSelectorTerms** ``List[NodeSelectorTerm]`` - Required. A list of node selector terms. The terms are ORed.
    """
    nodeSelectorTerms: 'List[NodeSelectorTerm]'


@dataclass
class NodeSelectorRequirement(DictMixin):
    """A node selector requirement is a selector that contains values, a key, and an
      operator that relates the key and values.

      **parameters**

      * **key** ``str`` - The label key that the selector applies to.
      * **operator** ``str`` - Represents a key's relationship to a set of values. Valid operators are In,
        NotIn, Exists, DoesNotExist. Gt, and Lt.
      * **values** ``Optional[List[str]]`` - An array of string values. If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist, the values array
        must be empty. If the operator is Gt or Lt, the values array must have a
        single element, which will be interpreted as an integer. This array is
        replaced during a strategic merge patch.
    """
    key: 'str'
    operator: 'str'
    values: 'Optional[List[str]]' = None


@dataclass
class NodeSelectorTerm(DictMixin):
    """A null or empty node selector term matches no objects. The requirements of
      them are ANDed. The TopologySelectorTerm type implements a subset of the
      NodeSelectorTerm.

      **parameters**

      * **matchExpressions** ``Optional[List[NodeSelectorRequirement]]`` - A list of node selector requirements by node's labels.
      * **matchFields** ``Optional[List[NodeSelectorRequirement]]`` - A list of node selector requirements by node's fields.
    """
    matchExpressions: 'Optional[List[NodeSelectorRequirement]]' = None
    matchFields: 'Optional[List[NodeSelectorRequirement]]' = None


@dataclass
class NodeSpec(DictMixin):
    """NodeSpec describes the attributes that a node is created with.

      **parameters**

      * **configSource** ``Optional[NodeConfigSource]`` - Deprecated. If specified, the source of the node's configuration. The
        DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this
        field. This field is deprecated as of 1.22:
        https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
      * **externalID** ``Optional[str]`` - Deprecated. Not all kubelets will set this field. Remove field after 1.13.
        see: https://issues.k8s.io/61966
      * **podCIDR** ``Optional[str]`` - PodCIDR represents the pod IP range assigned to the node.
      * **podCIDRs** ``Optional[List[str]]`` - podCIDRs represents the IP ranges assigned to the node for usage by Pods on
        that node. If this field is specified, the 0th entry must match the podCIDR
        field. It may contain at most 1 value for each of IPv4 and IPv6.
      * **providerID** ``Optional[str]`` - ID of the node assigned by the cloud provider in the format:
        <ProviderName>://<ProviderSpecificNodeID>
      * **taints** ``Optional[List[Taint]]`` - If specified, the node's taints.
      * **unschedulable** ``Optional[bool]`` - Unschedulable controls node schedulability of new pods. By default, node is
        schedulable. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
    """
    configSource: 'Optional[NodeConfigSource]' = None
    externalID: 'Optional[str]' = None
    podCIDR: 'Optional[str]' = None
    podCIDRs: 'Optional[List[str]]' = None
    providerID: 'Optional[str]' = None
    taints: 'Optional[List[Taint]]' = None
    unschedulable: 'Optional[bool]' = None


@dataclass
class NodeStatus(DictMixin):
    """NodeStatus is information about the current status of a node.

      **parameters**

      * **addresses** ``Optional[List[NodeAddress]]`` - List of addresses reachable to the node. Queried from cloud provider, if
        available. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is
        declared as mergeable, but the merge key is not sufficiently unique, which can
        cause data corruption when it is merged. Callers should instead use a
        full-replacement patch. See http://pr.k8s.io/79391 for an example.
      * **allocatable** ``Optional[dict]`` - Allocatable represents the resources of a node that are available for
        scheduling. Defaults to Capacity.
      * **capacity** ``Optional[dict]`` - Capacity represents the total resources of a node. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
      * **conditions** ``Optional[List[NodeCondition]]`` - Conditions is an array of current observed node conditions. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#condition
      * **config** ``Optional[NodeConfigStatus]`` - Status of the config assigned to the node via the dynamic Kubelet config
        feature.
      * **daemonEndpoints** ``Optional[NodeDaemonEndpoints]`` - Endpoints of daemons running on the Node.
      * **images** ``Optional[List[ContainerImage]]`` - List of container images on this node
      * **nodeInfo** ``Optional[NodeSystemInfo]`` - Set of ids/uuids to uniquely identify the node. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#info
      * **phase** ``Optional[str]`` - NodePhase is the recently observed lifecycle phase of the node. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never
        populated, and now is deprecated.
      * **volumesAttached** ``Optional[List[AttachedVolume]]`` - List of volumes that are attached to the node.
      * **volumesInUse** ``Optional[List[str]]`` - List of attachable volumes in use (mounted) by the node.
    """
    addresses: 'Optional[List[NodeAddress]]' = None
    allocatable: 'Optional[dict]' = None
    capacity: 'Optional[dict]' = None
    conditions: 'Optional[List[NodeCondition]]' = None
    config: 'Optional[NodeConfigStatus]' = None
    daemonEndpoints: 'Optional[NodeDaemonEndpoints]' = None
    images: 'Optional[List[ContainerImage]]' = None
    nodeInfo: 'Optional[NodeSystemInfo]' = None
    phase: 'Optional[str]' = None
    volumesAttached: 'Optional[List[AttachedVolume]]' = None
    volumesInUse: 'Optional[List[str]]' = None


@dataclass
class NodeSystemInfo(DictMixin):
    """NodeSystemInfo is a set of ids/uuids to uniquely identify the node.

      **parameters**

      * **architecture** ``str`` - The Architecture reported by the node
      * **bootID** ``str`` - Boot ID reported by the node.
      * **containerRuntimeVersion** ``str`` - ContainerRuntime Version reported by the node through runtime remote API (e.g.
        docker://1.5.0).
      * **kernelVersion** ``str`` - Kernel Version reported by the node from 'uname -r' (e.g.
        3.16.0-0.bpo.4-amd64).
      * **kubeProxyVersion** ``str`` - KubeProxy Version reported by the node.
      * **kubeletVersion** ``str`` - Kubelet Version reported by the node.
      * **machineID** ``str`` - MachineID reported by the node. For unique machine identification in the
        cluster this field is preferred. Learn more from man(5) machine-id:
        http://man7.org/linux/man-pages/man5/machine-id.5.html
      * **operatingSystem** ``str`` - The Operating System reported by the node
      * **osImage** ``str`` - OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7
        (wheezy)).
      * **systemUUID** ``str`` - SystemUUID reported by the node. For unique machine identification MachineID
        is preferred. This field is specific to Red Hat hosts
        https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
    """
    architecture: 'str'
    bootID: 'str'
    containerRuntimeVersion: 'str'
    kernelVersion: 'str'
    kubeProxyVersion: 'str'
    kubeletVersion: 'str'
    machineID: 'str'
    operatingSystem: 'str'
    osImage: 'str'
    systemUUID: 'str'


@dataclass
class ObjectFieldSelector(DictMixin):
    """ObjectFieldSelector selects an APIVersioned field of an object.

      **parameters**

      * **fieldPath** ``str`` - Path of the field to select in the specified API version.
      * **apiVersion** ``Optional[str]`` - Version of the schema the FieldPath is written in terms of, defaults to "v1".
    """
    fieldPath: 'str'
    apiVersion: 'Optional[str]' = None


@dataclass
class ObjectReference(DictMixin):
    """ObjectReference contains enough information to let you inspect or modify the
      referred object.

      **parameters**

      * **apiVersion** ``Optional[str]`` - API version of the referent.
      * **fieldPath** ``Optional[str]`` - If referring to a piece of an object instead of an entire object, this string
        should contain a valid JSON/Go field access statement, such as
        desiredState.manifest.containers[2]. For example, if the object reference is
        to a container within a pod, this would take on a value like:
        "spec.containers{name}" (where "name" refers to the name of the container that
        triggered the event) or if no container name is specified "spec.containers[2]"
        (container with index 2 in this pod). This syntax is chosen only to have some
        well-defined way of referencing a part of an object.
      * **kind** ``Optional[str]`` - Kind of the referent. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **namespace** ``Optional[str]`` - Namespace of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
      * **resourceVersion** ``Optional[str]`` - Specific resourceVersion to which this reference is made, if any. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
      * **uid** ``Optional[str]`` - UID of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
    """
    apiVersion: 'Optional[str]' = None
    fieldPath: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    name: 'Optional[str]' = None
    namespace: 'Optional[str]' = None
    resourceVersion: 'Optional[str]' = None
    uid: 'Optional[str]' = None


@dataclass
class PersistentVolume(DictMixin):
    """PersistentVolume (PV) is a storage resource provisioned by an administrator.
      It is analogous to a node. More info:
      https://kubernetes.io/docs/concepts/storage/persistent-volumes

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PersistentVolumeSpec]`` - Spec defines a specification of a persistent volume owned by the cluster.
        Provisioned by an administrator. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
      * **status** ``Optional[PersistentVolumeStatus]`` - Status represents the current information/status for the persistent volume.
        Populated by the system. Read-only. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PersistentVolumeSpec]' = None
    status: 'Optional[PersistentVolumeStatus]' = None


@dataclass
class PersistentVolumeClaim(DictMixin):
    """PersistentVolumeClaim is a user's request for and claim to a persistent volume

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PersistentVolumeClaimSpec]`` - Spec defines the desired characteristics of a volume requested by a pod
        author. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **status** ``Optional[PersistentVolumeClaimStatus]`` - Status represents the current information/status of a persistent volume claim.
        Read-only. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PersistentVolumeClaimSpec]' = None
    status: 'Optional[PersistentVolumeClaimStatus]' = None


@dataclass
class PersistentVolumeClaimCondition(DictMixin):
    """PersistentVolumeClaimCondition contails details about state of pvc

      **parameters**

      * **status** ``str`` - 
      * **type** ``str`` - 
      * **lastProbeTime** ``Optional[meta_v1.Time]`` - Last time we probed the condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transitioned from one status to another.
      * **message** ``Optional[str]`` - Human-readable message indicating details about last transition.
      * **reason** ``Optional[str]`` - Unique, this should be a short, machine understandable string that gives the
        reason for condition's last transition. If it reports "ResizeStarted" that
        means the underlying persistent volume is being resized.
    """
    status: 'str'
    type: 'str'
    lastProbeTime: 'Optional[meta_v1.Time]' = None
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class PersistentVolumeClaimList(DictMixin):
    """PersistentVolumeClaimList is a list of PersistentVolumeClaim items.

      **parameters**

      * **items** ``List[PersistentVolumeClaim]`` - A list of persistent volume claims. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[PersistentVolumeClaim]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PersistentVolumeClaimSpec(DictMixin):
    """PersistentVolumeClaimSpec describes the common attributes of storage devices
      and allows a Source for provider-specific attributes

      **parameters**

      * **accessModes** ``Optional[List[str]]`` - AccessModes contains the desired access modes the volume should have. More
        info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
      * **dataSource** ``Optional[TypedLocalObjectReference]`` - This field can be used to specify either: * An existing VolumeSnapshot object
        (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC
        (PersistentVolumeClaim) If the provisioner or an external controller can
        support the specified data source, it will create a new volume based on the
        contents of the specified data source. If the AnyVolumeDataSource feature gate
        is enabled, this field will always have the same contents as the DataSourceRef
        field.
      * **dataSourceRef** ``Optional[TypedLocalObjectReference]`` - Specifies the object from which to populate the volume with data, if a
        non-empty volume is desired. This may be any local object from a non-empty API
        group (non core object) or a PersistentVolumeClaim object. When this field is
        specified, volume binding will only succeed if the type of the specified
        object matches some installed volume populator or dynamic provisioner. This
        field will replace the functionality of the DataSource field and as such if
        both fields are non-empty, they must have the same value. For backwards
        compatibility, both fields (DataSource and DataSourceRef) will be set to the
        same value automatically if one of them is empty and the other is non-empty.
        There are two important differences between DataSource and DataSourceRef: *
        While DataSource only allows two specific types of objects, DataSourceRef
          allows any non-core object, as well as PersistentVolumeClaim objects.
        * While DataSource ignores disallowed values (dropping them), DataSourceRef
          preserves all values, and generates an error if a disallowed value is
          specified.
        (Alpha) Using this field requires the AnyVolumeDataSource feature gate to be
        enabled.
      * **resources** ``Optional[ResourceRequirements]`` - Resources represents the minimum resources the volume should have. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
      * **selector** ``Optional[meta_v1.LabelSelector]`` - A label query over volumes to consider for binding.
      * **storageClassName** ``Optional[str]`` - Name of the StorageClass required by the claim. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
      * **volumeMode** ``Optional[str]`` - volumeMode defines what type of volume is required by the claim. Value of
        Filesystem is implied when not included in claim spec.
      * **volumeName** ``Optional[str]`` - VolumeName is the binding reference to the PersistentVolume backing this
        claim.
    """
    accessModes: 'Optional[List[str]]' = None
    dataSource: 'Optional[TypedLocalObjectReference]' = None
    dataSourceRef: 'Optional[TypedLocalObjectReference]' = None
    resources: 'Optional[ResourceRequirements]' = None
    selector: 'Optional[meta_v1.LabelSelector]' = None
    storageClassName: 'Optional[str]' = None
    volumeMode: 'Optional[str]' = None
    volumeName: 'Optional[str]' = None


@dataclass
class PersistentVolumeClaimStatus(DictMixin):
    """PersistentVolumeClaimStatus is the current status of a persistent volume
      claim.

      **parameters**

      * **accessModes** ``Optional[List[str]]`` - AccessModes contains the actual access modes the volume backing the PVC has.
        More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
      * **capacity** ``Optional[dict]`` - Represents the actual resources of the underlying volume.
      * **conditions** ``Optional[List[PersistentVolumeClaimCondition]]`` - Current Condition of persistent volume claim. If underlying persistent volume
        is being resized then the Condition will be set to 'ResizeStarted'.
      * **phase** ``Optional[str]`` - Phase represents the current phase of PersistentVolumeClaim.
    """
    accessModes: 'Optional[List[str]]' = None
    capacity: 'Optional[dict]' = None
    conditions: 'Optional[List[PersistentVolumeClaimCondition]]' = None
    phase: 'Optional[str]' = None


@dataclass
class PersistentVolumeClaimTemplate(DictMixin):
    """PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects
      as part of an EphemeralVolumeSource.

      **parameters**

      * **spec** ``PersistentVolumeClaimSpec`` - The specification for the PersistentVolumeClaim. The entire content is copied
        unchanged into the PVC that gets created from this template. The same fields
        as in a PersistentVolumeClaim are also valid here.
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - May contain labels and annotations that will be copied into the PVC when
        creating it. No other fields are allowed and will be rejected during
        validation.
    """
    spec: 'PersistentVolumeClaimSpec'
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class PersistentVolumeClaimVolumeSource(DictMixin):
    """PersistentVolumeClaimVolumeSource references the user's PVC in the same
      namespace. This volume finds the bound PV and mounts that volume for the pod.
      A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another
      type of volume that is owned by someone else (the system).

      **parameters**

      * **claimName** ``str`` - ClaimName is the name of a PersistentVolumeClaim in the same namespace as the
        pod using this volume. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **readOnly** ``Optional[bool]`` - Will force the ReadOnly setting in VolumeMounts. Default false.
    """
    claimName: 'str'
    readOnly: 'Optional[bool]' = None


@dataclass
class PersistentVolumeList(DictMixin):
    """PersistentVolumeList is a list of PersistentVolume items.

      **parameters**

      * **items** ``List[PersistentVolume]`` - List of persistent volumes. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[PersistentVolume]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PersistentVolumeSpec(DictMixin):
    """PersistentVolumeSpec is the specification of a persistent volume.

      **parameters**

      * **accessModes** ``Optional[List[str]]`` - AccessModes contains all ways the volume can be mounted. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
      * **awsElasticBlockStore** ``Optional[AWSElasticBlockStoreVolumeSource]`` - AWSElasticBlockStore represents an AWS Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **azureDisk** ``Optional[AzureDiskVolumeSource]`` - AzureDisk represents an Azure Data Disk mount on the host and bind mount to
        the pod.
      * **azureFile** ``Optional[AzureFilePersistentVolumeSource]`` - AzureFile represents an Azure File Service mount on the host and bind mount to
        the pod.
      * **capacity** ``Optional[dict]`` - A description of the persistent volume's resources and capacity. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
      * **cephfs** ``Optional[CephFSPersistentVolumeSource]`` - CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
      * **cinder** ``Optional[CinderPersistentVolumeSource]`` - Cinder represents a cinder volume attached and mounted on kubelets host
        machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
      * **claimRef** ``Optional[ObjectReference]`` - ClaimRef is part of a bi-directional binding between PersistentVolume and
        PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is
        the authoritative bind between PV and PVC. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
      * **csi** ``Optional[CSIPersistentVolumeSource]`` - CSI represents storage that is handled by an external CSI driver (Beta
        feature).
      * **fc** ``Optional[FCVolumeSource]`` - FC represents a Fibre Channel resource that is attached to a kubelet's host
        machine and then exposed to the pod.
      * **flexVolume** ``Optional[FlexPersistentVolumeSource]`` - FlexVolume represents a generic volume resource that is provisioned/attached
        using an exec based plugin.
      * **flocker** ``Optional[FlockerVolumeSource]`` - Flocker represents a Flocker volume attached to a kubelet's host machine and
        exposed to the pod for its usage. This depends on the Flocker control service
        being running
      * **gcePersistentDisk** ``Optional[GCEPersistentDiskVolumeSource]`` - GCEPersistentDisk represents a GCE Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **glusterfs** ``Optional[GlusterfsPersistentVolumeSource]`` - Glusterfs represents a Glusterfs volume that is attached to a host and exposed
        to the pod. Provisioned by an admin. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md
      * **hostPath** ``Optional[HostPathVolumeSource]`` - HostPath represents a directory on the host. Provisioned by a developer or
        tester. This is useful for single-node development and testing only! On-host
        storage is not supported in any way and WILL NOT WORK in a multi-node cluster.
        More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
      * **iscsi** ``Optional[ISCSIPersistentVolumeSource]`` - ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host
        machine and then exposed to the pod. Provisioned by an admin.
      * **local** ``Optional[LocalVolumeSource]`` - Local represents directly-attached storage with node affinity
      * **mountOptions** ``Optional[List[str]]`` - A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will
        simply fail if one is invalid. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
      * **nfs** ``Optional[NFSVolumeSource]`` - NFS represents an NFS mount on the host. Provisioned by an admin. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **nodeAffinity** ``Optional[VolumeNodeAffinity]`` - NodeAffinity defines constraints that limit what nodes this volume can be
        accessed from. This field influences the scheduling of pods that use this
        volume.
      * **persistentVolumeReclaimPolicy** ``Optional[str]`` - What happens to a persistent volume when released from its claim. Valid
        options are Retain (default for manually created PersistentVolumes), Delete
        (default for dynamically provisioned PersistentVolumes), and Recycle
        (deprecated). Recycle must be supported by the volume plugin underlying this
        PersistentVolume. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
      * **photonPersistentDisk** ``Optional[PhotonPersistentDiskVolumeSource]`` - PhotonPersistentDisk represents a PhotonController persistent disk attached
        and mounted on kubelets host machine
      * **portworxVolume** ``Optional[PortworxVolumeSource]`` - PortworxVolume represents a portworx volume attached and mounted on kubelets
        host machine
      * **quobyte** ``Optional[QuobyteVolumeSource]`` - Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
      * **rbd** ``Optional[RBDPersistentVolumeSource]`` - RBD represents a Rados Block Device mount on the host that shares a pod's
        lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
      * **scaleIO** ``Optional[ScaleIOPersistentVolumeSource]`` - ScaleIO represents a ScaleIO persistent volume attached and mounted on
        Kubernetes nodes.
      * **storageClassName** ``Optional[str]`` - Name of StorageClass to which this persistent volume belongs. Empty value
        means that this volume does not belong to any StorageClass.
      * **storageos** ``Optional[StorageOSPersistentVolumeSource]`` - StorageOS represents a StorageOS volume that is attached to the kubelet's host
        machine and mounted into the pod More info:
        https://examples.k8s.io/volumes/storageos/README.md
      * **volumeMode** ``Optional[str]`` - volumeMode defines if a volume is intended to be used with a formatted
        filesystem or to remain in raw block state. Value of Filesystem is implied
        when not included in spec.
      * **vsphereVolume** ``Optional[VsphereVirtualDiskVolumeSource]`` - VsphereVolume represents a vSphere volume attached and mounted on kubelets
        host machine
    """
    accessModes: 'Optional[List[str]]' = None
    awsElasticBlockStore: 'Optional[AWSElasticBlockStoreVolumeSource]' = None
    azureDisk: 'Optional[AzureDiskVolumeSource]' = None
    azureFile: 'Optional[AzureFilePersistentVolumeSource]' = None
    capacity: 'Optional[dict]' = None
    cephfs: 'Optional[CephFSPersistentVolumeSource]' = None
    cinder: 'Optional[CinderPersistentVolumeSource]' = None
    claimRef: 'Optional[ObjectReference]' = None
    csi: 'Optional[CSIPersistentVolumeSource]' = None
    fc: 'Optional[FCVolumeSource]' = None
    flexVolume: 'Optional[FlexPersistentVolumeSource]' = None
    flocker: 'Optional[FlockerVolumeSource]' = None
    gcePersistentDisk: 'Optional[GCEPersistentDiskVolumeSource]' = None
    glusterfs: 'Optional[GlusterfsPersistentVolumeSource]' = None
    hostPath: 'Optional[HostPathVolumeSource]' = None
    iscsi: 'Optional[ISCSIPersistentVolumeSource]' = None
    local: 'Optional[LocalVolumeSource]' = None
    mountOptions: 'Optional[List[str]]' = None
    nfs: 'Optional[NFSVolumeSource]' = None
    nodeAffinity: 'Optional[VolumeNodeAffinity]' = None
    persistentVolumeReclaimPolicy: 'Optional[str]' = None
    photonPersistentDisk: 'Optional[PhotonPersistentDiskVolumeSource]' = None
    portworxVolume: 'Optional[PortworxVolumeSource]' = None
    quobyte: 'Optional[QuobyteVolumeSource]' = None
    rbd: 'Optional[RBDPersistentVolumeSource]' = None
    scaleIO: 'Optional[ScaleIOPersistentVolumeSource]' = None
    storageClassName: 'Optional[str]' = None
    storageos: 'Optional[StorageOSPersistentVolumeSource]' = None
    volumeMode: 'Optional[str]' = None
    vsphereVolume: 'Optional[VsphereVirtualDiskVolumeSource]' = None


@dataclass
class PersistentVolumeStatus(DictMixin):
    """PersistentVolumeStatus is the current status of a persistent volume.

      **parameters**

      * **message** ``Optional[str]`` - A human-readable message indicating details about why the volume is in this
        state.
      * **phase** ``Optional[str]`` - Phase indicates if a volume is available, bound to a claim, or released by a
        claim. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
      * **reason** ``Optional[str]`` - Reason is a brief CamelCase string that describes any failure and is meant for
        machine parsing and tidy display in the CLI.
    """
    message: 'Optional[str]' = None
    phase: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class PhotonPersistentDiskVolumeSource(DictMixin):
    """Represents a Photon Controller persistent disk resource.

      **parameters**

      * **pdID** ``str`` - ID that identifies Photon Controller persistent disk
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
    """
    pdID: 'str'
    fsType: 'Optional[str]' = None


@dataclass
class Pod(DictMixin):
    """Pod is a collection of containers that can run on a host. This resource is
      created by clients and scheduled onto hosts.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PodSpec]`` - Specification of the desired behavior of the pod. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[PodStatus]`` - Most recently observed status of the pod. This data may not be up to date.
        Populated by the system. Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PodSpec]' = None
    status: 'Optional[PodStatus]' = None


@dataclass
class PodAffinity(DictMixin):
    """Pod affinity is a group of inter pod affinity scheduling rules.

      **parameters**

      * **preferredDuringSchedulingIgnoredDuringExecution** ``Optional[List[WeightedPodAffinityTerm]]`` - The scheduler will prefer to schedule pods to nodes that satisfy the affinity
        expressions specified by this field, but it may choose a node that violates
        one or more of the expressions. The node that is most preferred is the one
        with the greatest sum of weights, i.e. for each node that meets all of the
        scheduling requirements (resource request, requiredDuringScheduling affinity
        expressions, etc.), compute a sum by iterating through the elements of this
        field and adding "weight" to the sum if the node has pods which matches the
        corresponding podAffinityTerm; the node(s) with the highest sum are the most
        preferred.
      * **requiredDuringSchedulingIgnoredDuringExecution** ``Optional[List[PodAffinityTerm]]`` - If the affinity requirements specified by this field are not met at scheduling
        time, the pod will not be scheduled onto the node. If the affinity
        requirements specified by this field cease to be met at some point during pod
        execution (e.g. due to a pod label update), the system may or may not try to
        eventually evict the pod from its node. When there are multiple elements, the
        lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all
        terms must be satisfied.
    """
    preferredDuringSchedulingIgnoredDuringExecution: 'Optional[List[WeightedPodAffinityTerm]]' = None
    requiredDuringSchedulingIgnoredDuringExecution: 'Optional[List[PodAffinityTerm]]' = None


@dataclass
class PodAffinityTerm(DictMixin):
    """Defines a set of pods (namely those matching the labelSelector relative to the
      given namespace(s)) that this pod should be co-located (affinity) or not
      co-located (anti-affinity) with, where co-located is defined as running on a
      node whose value of the label with key <topologyKey> matches that of any node
      on which a pod of the set of pods is running

      **parameters**

      * **topologyKey** ``str`` - This pod should be co-located (affinity) or not co-located (anti-affinity)
        with the pods matching the labelSelector in the specified namespaces, where
        co-located is defined as running on a node whose value of the label with key
        topologyKey matches that of any node on which any of the selected pods is
        running. Empty topologyKey is not allowed.
      * **labelSelector** ``Optional[meta_v1.LabelSelector]`` - A label query over a set of resources, in this case pods.
      * **namespaceSelector** ``Optional[meta_v1.LabelSelector]`` - A label query over the set of namespaces that the term applies to. The term is
        applied to the union of the namespaces selected by this field and the ones
        listed in the namespaces field. null selector and null or empty namespaces
        list means "this pod's namespace". An empty selector ({}) matches all
        namespaces. This field is beta-level and is only honored when
        PodAffinityNamespaceSelector feature is enabled.
      * **namespaces** ``Optional[List[str]]`` - namespaces specifies a static list of namespace names that the term applies
        to. The term is applied to the union of the namespaces listed in this field
        and the ones selected by namespaceSelector. null or empty namespaces list and
        null namespaceSelector means "this pod's namespace"
    """
    topologyKey: 'str'
    labelSelector: 'Optional[meta_v1.LabelSelector]' = None
    namespaceSelector: 'Optional[meta_v1.LabelSelector]' = None
    namespaces: 'Optional[List[str]]' = None


@dataclass
class PodAntiAffinity(DictMixin):
    """Pod anti affinity is a group of inter pod anti affinity scheduling rules.

      **parameters**

      * **preferredDuringSchedulingIgnoredDuringExecution** ``Optional[List[WeightedPodAffinityTerm]]`` - The scheduler will prefer to schedule pods to nodes that satisfy the
        anti-affinity expressions specified by this field, but it may choose a node
        that violates one or more of the expressions. The node that is most preferred
        is the one with the greatest sum of weights, i.e. for each node that meets all
        of the scheduling requirements (resource request, requiredDuringScheduling
        anti-affinity expressions, etc.), compute a sum by iterating through the
        elements of this field and adding "weight" to the sum if the node has pods
        which matches the corresponding podAffinityTerm; the node(s) with the highest
        sum are the most preferred.
      * **requiredDuringSchedulingIgnoredDuringExecution** ``Optional[List[PodAffinityTerm]]`` - If the anti-affinity requirements specified by this field are not met at
        scheduling time, the pod will not be scheduled onto the node. If the
        anti-affinity requirements specified by this field cease to be met at some
        point during pod execution (e.g. due to a pod label update), the system may or
        may not try to eventually evict the pod from its node. When there are multiple
        elements, the lists of nodes corresponding to each podAffinityTerm are
        intersected, i.e. all terms must be satisfied.
    """
    preferredDuringSchedulingIgnoredDuringExecution: 'Optional[List[WeightedPodAffinityTerm]]' = None
    requiredDuringSchedulingIgnoredDuringExecution: 'Optional[List[PodAffinityTerm]]' = None


@dataclass
class PodCondition(DictMixin):
    """PodCondition contains details for the current condition of this pod.

      **parameters**

      * **status** ``str`` - Status is the status of the condition. Can be True, False, Unknown. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
      * **type** ``str`` - Type is the type of the condition. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
      * **lastProbeTime** ``Optional[meta_v1.Time]`` - Last time we probed the condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transitioned from one status to another.
      * **message** ``Optional[str]`` - Human-readable message indicating details about last transition.
      * **reason** ``Optional[str]`` - Unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastProbeTime: 'Optional[meta_v1.Time]' = None
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class PodDNSConfig(DictMixin):
    """PodDNSConfig defines the DNS parameters of a pod in addition to those
      generated from DNSPolicy.

      **parameters**

      * **nameservers** ``Optional[List[str]]`` - A list of DNS name server IP addresses. This will be appended to the base
        nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
      * **options** ``Optional[List[PodDNSConfigOption]]`` - A list of DNS resolver options. This will be merged with the base options
        generated from DNSPolicy. Duplicated entries will be removed. Resolution
        options given in Options will override those that appear in the base
        DNSPolicy.
      * **searches** ``Optional[List[str]]`` - A list of DNS search domains for host-name lookup. This will be appended to
        the base search paths generated from DNSPolicy. Duplicated search paths will
        be removed.
    """
    nameservers: 'Optional[List[str]]' = None
    options: 'Optional[List[PodDNSConfigOption]]' = None
    searches: 'Optional[List[str]]' = None


@dataclass
class PodDNSConfigOption(DictMixin):
    """PodDNSConfigOption defines DNS resolver options of a pod.

      **parameters**

      * **name** ``Optional[str]`` - Required.
      * **value** ``Optional[str]`` - 
    """
    name: 'Optional[str]' = None
    value: 'Optional[str]' = None


@dataclass
class PodIP(DictMixin):
    """IP address information for entries in the (plural) PodIPs field. Each entry
      includes:
         IP: An IP address allocated to the pod. Routable at least within the
      cluster.

      **parameters**

      * **ip** ``Optional[str]`` - ip is an IP address (IPv4 or IPv6) assigned to the pod
    """
    ip: 'Optional[str]' = None


@dataclass
class PodList(DictMixin):
    """PodList is a list of Pods.

      **parameters**

      * **items** ``List[Pod]`` - List of pods. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Pod]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PodReadinessGate(DictMixin):
    """PodReadinessGate contains the reference to a pod condition

      **parameters**

      * **conditionType** ``str`` - ConditionType refers to a condition in the pod's condition list with matching
        type.
    """
    conditionType: 'str'


@dataclass
class PodSecurityContext(DictMixin):
    """PodSecurityContext holds pod-level security attributes and common container
      settings. Some fields are also present in container.securityContext.  Field
      values of container.securityContext take precedence over field values of
      PodSecurityContext.

      **parameters**

      * **fsGroup** ``Optional[int]`` - A special supplemental group that applies to all containers in a pod. Some
        volume types allow the Kubelet to change the ownership of that volume to be
        owned by the pod:
        1. The owning GID will be the FSGroup 2. The setgid bit is set (new files
        created in the volume will be owned by FSGroup) 3. The permission bits are
        OR'd with rw-rw----
        If unset, the Kubelet will not modify the ownership and permissions of any
        volume.
      * **fsGroupChangePolicy** ``Optional[str]`` - fsGroupChangePolicy defines behavior of changing ownership and permission of
        the volume before being exposed inside Pod. This field will only apply to
        volume types which support fsGroup based ownership(and permissions). It will
        have no effect on ephemeral volume types such as: secret, configmaps and
        emptydir. Valid values are "OnRootMismatch" and "Always". If not specified,
        "Always" is used.
      * **runAsGroup** ``Optional[int]`` - The GID to run the entrypoint of the container process. Uses runtime default
        if unset. May also be set in SecurityContext.  If set in both SecurityContext
        and PodSecurityContext, the value specified in SecurityContext takes
        precedence for that container.
      * **runAsNonRoot** ``Optional[bool]`` - Indicates that the container must run as a non-root user. If true, the Kubelet
        will validate the image at runtime to ensure that it does not run as UID 0
        (root) and fail to start the container if it does. If unset or false, no such
        validation will be performed. May also be set in SecurityContext.  If set in
        both SecurityContext and PodSecurityContext, the value specified in
        SecurityContext takes precedence.
      * **runAsUser** ``Optional[int]`` - The UID to run the entrypoint of the container process. Defaults to user
        specified in image metadata if unspecified. May also be set in
        SecurityContext.  If set in both SecurityContext and PodSecurityContext, the
        value specified in SecurityContext takes precedence for that container.
      * **seLinuxOptions** ``Optional[SELinuxOptions]`` - The SELinux context to be applied to all containers. If unspecified, the
        container runtime will allocate a random SELinux context for each container.
        May also be set in SecurityContext.  If set in both SecurityContext and
        PodSecurityContext, the value specified in SecurityContext takes precedence
        for that container.
      * **seccompProfile** ``Optional[SeccompProfile]`` - The seccomp options to use by the containers in this pod.
      * **supplementalGroups** ``Optional[List[int]]`` - A list of groups applied to the first process run in each container, in
        addition to the container's primary GID.  If unspecified, no groups will be
        added to any container.
      * **sysctls** ``Optional[List[Sysctl]]`` - Sysctls hold a list of namespaced sysctls used for the pod. Pods with
        unsupported sysctls (by the container runtime) might fail to launch.
      * **windowsOptions** ``Optional[WindowsSecurityContextOptions]`` - The Windows specific settings applied to all containers. If unspecified, the
        options within a container's SecurityContext will be used. If set in both
        SecurityContext and PodSecurityContext, the value specified in SecurityContext
        takes precedence.
    """
    fsGroup: 'Optional[int]' = None
    fsGroupChangePolicy: 'Optional[str]' = None
    runAsGroup: 'Optional[int]' = None
    runAsNonRoot: 'Optional[bool]' = None
    runAsUser: 'Optional[int]' = None
    seLinuxOptions: 'Optional[SELinuxOptions]' = None
    seccompProfile: 'Optional[SeccompProfile]' = None
    supplementalGroups: 'Optional[List[int]]' = None
    sysctls: 'Optional[List[Sysctl]]' = None
    windowsOptions: 'Optional[WindowsSecurityContextOptions]' = None


@dataclass
class PodSpec(DictMixin):
    """PodSpec is a description of a pod.

      **parameters**

      * **containers** ``List[Container]`` - List of containers belonging to the pod. Containers cannot currently be added
        or removed. There must be at least one container in a Pod. Cannot be updated.
      * **activeDeadlineSeconds** ``Optional[int]`` - Optional duration in seconds the pod may be active on the node relative to
        StartTime before the system will actively try to mark it failed and kill
        associated containers. Value must be a positive integer.
      * **affinity** ``Optional[Affinity]`` - If specified, the pod's scheduling constraints
      * **automountServiceAccountToken** ``Optional[bool]`` - AutomountServiceAccountToken indicates whether a service account token should
        be automatically mounted.
      * **dnsConfig** ``Optional[PodDNSConfig]`` - Specifies the DNS parameters of a pod. Parameters specified here will be
        merged to the generated DNS configuration based on DNSPolicy.
      * **dnsPolicy** ``Optional[str]`` - Set DNS policy for the pod. Defaults to "ClusterFirst". Valid values are
        'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters
        given in DNSConfig will be merged with the policy selected with DNSPolicy. To
        have DNS options set along with hostNetwork, you have to specify DNS policy
        explicitly to 'ClusterFirstWithHostNet'.
      * **enableServiceLinks** ``Optional[bool]`` - EnableServiceLinks indicates whether information about services should be
        injected into pod's environment variables, matching the syntax of Docker
        links. Optional: Defaults to true.
      * **ephemeralContainers** ``Optional[List[EphemeralContainer]]`` - List of ephemeral containers run in this pod. Ephemeral containers may be run
        in an existing pod to perform user-initiated actions such as debugging. This
        list cannot be specified when creating a pod, and it cannot be modified by
        updating the pod spec. In order to add an ephemeral container to an existing
        pod, use the pod's ephemeralcontainers subresource. This field is alpha-level
        and is only honored by servers that enable the EphemeralContainers feature.
      * **hostAliases** ``Optional[List[HostAlias]]`` - HostAliases is an optional list of hosts and IPs that will be injected into
        the pod's hosts file if specified. This is only valid for non-hostNetwork
        pods.
      * **hostIPC** ``Optional[bool]`` - Use the host's ipc namespace. Optional: Default to false.
      * **hostNetwork** ``Optional[bool]`` - Host networking requested for this pod. Use the host's network namespace. If
        this option is set, the ports that will be used must be specified. Default to
        false.
      * **hostPID** ``Optional[bool]`` - Use the host's pid namespace. Optional: Default to false.
      * **hostname** ``Optional[str]`` - Specifies the hostname of the Pod If not specified, the pod's hostname will be
        set to a system-defined value.
      * **imagePullSecrets** ``Optional[List[LocalObjectReference]]`` - ImagePullSecrets is an optional list of references to secrets in the same
        namespace to use for pulling any of the images used by this PodSpec. If
        specified, these secrets will be passed to individual puller implementations
        for them to use. For example, in the case of docker, only DockerConfig type
        secrets are honored. More info:
        https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
      * **initContainers** ``Optional[List[Container]]`` - List of initialization containers belonging to the pod. Init containers are
        executed in order prior to containers being started. If any init container
        fails, the pod is considered to have failed and is handled according to its
        restartPolicy. The name for an init container or normal container must be
        unique among all containers. Init containers may not have Lifecycle actions,
        Readiness probes, Liveness probes, or Startup probes. The resourceRequirements
        of an init container are taken into account during scheduling by finding the
        highest request/limit for each resource type, and then using the max of of
        that value or the sum of the normal containers. Limits are applied to init
        containers in a similar fashion. Init containers cannot currently be added or
        removed. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
      * **nodeName** ``Optional[str]`` - NodeName is a request to schedule this pod onto a specific node. If it is
        non-empty, the scheduler simply schedules this pod onto that node, assuming
        that it fits resource requirements.
      * **nodeSelector** ``Optional[dict]`` - NodeSelector is a selector which must be true for the pod to fit on a node.
        Selector which must match a node's labels for the pod to be scheduled on that
        node. More info:
        https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
      * **overhead** ``Optional[dict]`` - Overhead represents the resource overhead associated with running a pod for a
        given RuntimeClass. This field will be autopopulated at admission time by the
        RuntimeClass admission controller. If the RuntimeClass admission controller is
        enabled, overhead must not be set in Pod create requests. The RuntimeClass
        admission controller will reject Pod create requests which have the overhead
        already set. If RuntimeClass is configured and selected in the PodSpec,
        Overhead will be set to the value defined in the corresponding RuntimeClass,
        otherwise it will remain unset and treated as zero. More info:
        https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md This
        field is beta-level as of Kubernetes v1.18, and is only honored by servers
        that enable the PodOverhead feature.
      * **preemptionPolicy** ``Optional[str]`` - PreemptionPolicy is the Policy for preempting pods with lower priority. One of
        Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This
        field is beta-level, gated by the NonPreemptingPriority feature-gate.
      * **priority** ``Optional[int]`` - The priority value. Various system components use this field to find the
        priority of the pod. When Priority Admission Controller is enabled, it
        prevents users from setting this field. The admission controller populates
        this field from PriorityClassName. The higher the value, the higher the
        priority.
      * **priorityClassName** ``Optional[str]`` - If specified, indicates the pod's priority. "system-node-critical" and
        "system-cluster-critical" are two special keywords which indicate the highest
        priorities with the former being the highest priority. Any other name must be
        defined by creating a PriorityClass object with that name. If not specified,
        the pod priority will be default or zero if there is no default.
      * **readinessGates** ``Optional[List[PodReadinessGate]]`` - If specified, all readiness gates will be evaluated for pod readiness. A pod
        is ready when all its containers are ready AND all conditions specified in the
        readiness gates have status equal to "True" More info:
        https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates
      * **restartPolicy** ``Optional[str]`` - Restart policy for all containers within the pod. One of Always, OnFailure,
        Never. Default to Always. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
      * **runtimeClassName** ``Optional[str]`` - RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group,
        which should be used to run this pod.  If no RuntimeClass resource matches the
        named class, the pod will not be run. If unset or empty, the "legacy"
        RuntimeClass will be used, which is an implicit class with an empty definition
        that uses the default runtime handler. More info:
        https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class This is a beta
        feature as of Kubernetes v1.14.
      * **schedulerName** ``Optional[str]`` - If specified, the pod will be dispatched by specified scheduler. If not
        specified, the pod will be dispatched by default scheduler.
      * **securityContext** ``Optional[PodSecurityContext]`` - SecurityContext holds pod-level security attributes and common container
        settings. Optional: Defaults to empty.  See type description for default
        values of each field.
      * **serviceAccount** ``Optional[str]`` - DeprecatedServiceAccount is a depreciated alias for ServiceAccountName.
        Deprecated: Use serviceAccountName instead.
      * **serviceAccountName** ``Optional[str]`` - ServiceAccountName is the name of the ServiceAccount to use to run this pod.
        More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
      * **setHostnameAsFQDN** ``Optional[bool]`` - If true the pod's hostname will be configured as the pod's FQDN, rather than
        the leaf name (the default). In Linux containers, this means setting the FQDN
        in the hostname field of the kernel (the nodename field of struct utsname). In
        Windows containers, this means setting the registry value of hostname for the
        registry key
        HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN.
        If a pod does not have FQDN, this has no effect. Default to false.
      * **shareProcessNamespace** ``Optional[bool]`` - Share a single process namespace between all of the containers in a pod. When
        this is set containers will be able to view and signal processes from other
        containers in the same pod, and the first process in each container will not
        be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set.
        Optional: Default to false.
      * **subdomain** ``Optional[str]`` - If specified, the fully qualified Pod hostname will be
        "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>". If not
        specified, the pod will not have a domainname at all.
      * **terminationGracePeriodSeconds** ``Optional[int]`` - Optional duration in seconds the pod needs to terminate gracefully. May be
        decreased in delete request. Value must be non-negative integer. The value
        zero indicates stop immediately via the kill signal (no opportunity to shut
        down). If this value is nil, the default grace period will be used instead.
        The grace period is the duration in seconds after the processes running in the
        pod are sent a termination signal and the time when the processes are forcibly
        halted with a kill signal. Set this value longer than the expected cleanup
        time for your process. Defaults to 30 seconds.
      * **tolerations** ``Optional[List[Toleration]]`` - If specified, the pod's tolerations.
      * **topologySpreadConstraints** ``Optional[List[TopologySpreadConstraint]]`` - TopologySpreadConstraints describes how a group of pods ought to spread across
        topology domains. Scheduler will schedule pods in a way which abides by the
        constraints. All topologySpreadConstraints are ANDed.
      * **volumes** ``Optional[List[Volume]]`` - List of volumes that can be mounted by containers belonging to the pod. More
        info: https://kubernetes.io/docs/concepts/storage/volumes
    """
    containers: 'List[Container]'
    activeDeadlineSeconds: 'Optional[int]' = None
    affinity: 'Optional[Affinity]' = None
    automountServiceAccountToken: 'Optional[bool]' = None
    dnsConfig: 'Optional[PodDNSConfig]' = None
    dnsPolicy: 'Optional[str]' = None
    enableServiceLinks: 'Optional[bool]' = None
    ephemeralContainers: 'Optional[List[EphemeralContainer]]' = None
    hostAliases: 'Optional[List[HostAlias]]' = None
    hostIPC: 'Optional[bool]' = None
    hostNetwork: 'Optional[bool]' = None
    hostPID: 'Optional[bool]' = None
    hostname: 'Optional[str]' = None
    imagePullSecrets: 'Optional[List[LocalObjectReference]]' = None
    initContainers: 'Optional[List[Container]]' = None
    nodeName: 'Optional[str]' = None
    nodeSelector: 'Optional[dict]' = None
    overhead: 'Optional[dict]' = None
    preemptionPolicy: 'Optional[str]' = None
    priority: 'Optional[int]' = None
    priorityClassName: 'Optional[str]' = None
    readinessGates: 'Optional[List[PodReadinessGate]]' = None
    restartPolicy: 'Optional[str]' = None
    runtimeClassName: 'Optional[str]' = None
    schedulerName: 'Optional[str]' = None
    securityContext: 'Optional[PodSecurityContext]' = None
    serviceAccount: 'Optional[str]' = None
    serviceAccountName: 'Optional[str]' = None
    setHostnameAsFQDN: 'Optional[bool]' = None
    shareProcessNamespace: 'Optional[bool]' = None
    subdomain: 'Optional[str]' = None
    terminationGracePeriodSeconds: 'Optional[int]' = None
    tolerations: 'Optional[List[Toleration]]' = None
    topologySpreadConstraints: 'Optional[List[TopologySpreadConstraint]]' = None
    volumes: 'Optional[List[Volume]]' = None


@dataclass
class PodStatus(DictMixin):
    """PodStatus represents information about the status of a pod. Status may trail
      the actual state of a system, especially if the node that hosts the pod cannot
      contact the control plane.

      **parameters**

      * **conditions** ``Optional[List[PodCondition]]`` - Current service state of pod. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
      * **containerStatuses** ``Optional[List[ContainerStatus]]`` - The list has one entry per container in the manifest. Each entry is currently
        the output of `docker inspect`. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
      * **ephemeralContainerStatuses** ``Optional[List[ContainerStatus]]`` - Status for any ephemeral containers that have run in this pod. This field is
        alpha-level and is only populated by servers that enable the
        EphemeralContainers feature.
      * **hostIP** ``Optional[str]`` - IP address of the host to which the pod is assigned. Empty if not yet
        scheduled.
      * **initContainerStatuses** ``Optional[List[ContainerStatus]]`` - The list has one entry per init container in the manifest. The most recent
        successful init container will have ready = true, the most recently started
        container will have startTime set. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
      * **message** ``Optional[str]`` - A human readable message indicating details about why the pod is in this
        condition.
      * **nominatedNodeName** ``Optional[str]`` - nominatedNodeName is set only when this pod preempts other pods on the node,
        but it cannot be scheduled right away as preemption victims receive their
        graceful termination periods. This field does not guarantee that the pod will
        be scheduled on this node. Scheduler may decide to place the pod elsewhere if
        other nodes become available sooner. Scheduler may also decide to give the
        resources on this node to a higher priority pod that is created after
        preemption. As a result, this field may be different than PodSpec.nodeName
        when the pod is scheduled.
      * **phase** ``Optional[str]`` - The phase of a Pod is a simple, high-level summary of where the Pod is in its
        lifecycle. The conditions array, the reason and message fields, and the
        individual container status arrays contain more detail about the pod's status.
        There are five possible phase values:
        Pending: The pod has been accepted by the Kubernetes system, but one or more
        of the container images has not been created. This includes time before being
        scheduled as well as time spent downloading images over the network, which
        could take a while. Running: The pod has been bound to a node, and all of the
        containers have been created. At least one container is still running, or is
        in the process of starting or restarting. Succeeded: All containers in the pod
        have terminated in success, and will not be restarted. Failed: All containers
        in the pod have terminated, and at least one container has terminated in
        failure. The container either exited with non-zero status or was terminated by
        the system. Unknown: For some reason the state of the pod could not be
        obtained, typically due to an error in communicating with the host of the pod.
        More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
      * **podIP** ``Optional[str]`` - IP address allocated to the pod. Routable at least within the cluster. Empty
        if not yet allocated.
      * **podIPs** ``Optional[List[PodIP]]`` - podIPs holds the IP addresses allocated to the pod. If this field is
        specified, the 0th entry must match the podIP field. Pods may be allocated at
        most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been
        allocated yet.
      * **qosClass** ``Optional[str]`` - The Quality of Service (QOS) classification assigned to the pod based on
        resource requirements See PodQOSClass type for available QOS classes More
        info:
        https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
      * **reason** ``Optional[str]`` - A brief CamelCase message indicating details about why the pod is in this
        state. e.g. 'Evicted'
      * **startTime** ``Optional[meta_v1.Time]`` - RFC 3339 date and time at which the object was acknowledged by the Kubelet.
        This is before the Kubelet pulled the container image(s) for the pod.
    """
    conditions: 'Optional[List[PodCondition]]' = None
    containerStatuses: 'Optional[List[ContainerStatus]]' = None
    ephemeralContainerStatuses: 'Optional[List[ContainerStatus]]' = None
    hostIP: 'Optional[str]' = None
    initContainerStatuses: 'Optional[List[ContainerStatus]]' = None
    message: 'Optional[str]' = None
    nominatedNodeName: 'Optional[str]' = None
    phase: 'Optional[str]' = None
    podIP: 'Optional[str]' = None
    podIPs: 'Optional[List[PodIP]]' = None
    qosClass: 'Optional[str]' = None
    reason: 'Optional[str]' = None
    startTime: 'Optional[meta_v1.Time]' = None


@dataclass
class PodTemplate(DictMixin):
    """PodTemplate describes a template for creating copies of a predefined pod.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **template** ``Optional[PodTemplateSpec]`` - Template defines the pods that will be created from this pod template.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    template: 'Optional[PodTemplateSpec]' = None


@dataclass
class PodTemplateList(DictMixin):
    """PodTemplateList is a list of PodTemplates.

      **parameters**

      * **items** ``List[PodTemplate]`` - List of pod templates
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[PodTemplate]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PodTemplateSpec(DictMixin):
    """PodTemplateSpec describes the data a pod should have when created from a
      template

      **parameters**

      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PodSpec]`` - Specification of the desired behavior of the pod. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PodSpec]' = None


@dataclass
class PortStatus(DictMixin):
    """

      **parameters**

      * **port** ``int`` - Port is the port number of the service port of which status is recorded here
      * **protocol** ``str`` - Protocol is the protocol of the service port of which status is recorded here
        The supported values are: "TCP", "UDP", "SCTP"
      * **error** ``Optional[str]`` - Error is to record the problem with the service port The format of the error
        shall comply with the following rules: - built-in error values shall be
        specified in this file and those shall use
          CamelCase names
        - cloud provider specific error values must have names that comply with the
          format foo.example.com/CamelCase.
    """
    port: 'int'
    protocol: 'str'
    error: 'Optional[str]' = None


@dataclass
class PortworxVolumeSource(DictMixin):
    """PortworxVolumeSource represents a Portworx volume resource.

      **parameters**

      * **volumeID** ``str`` - VolumeID uniquely identifies a Portworx volume
      * **fsType** ``Optional[str]`` - FSType represents the filesystem type to mount Must be a filesystem type
        supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred
        to be "ext4" if unspecified.
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
    """
    volumeID: 'str'
    fsType: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None


@dataclass
class PreferredSchedulingTerm(DictMixin):
    """An empty preferred scheduling term matches all objects with implicit weight 0
      (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e.
      is also a no-op).

      **parameters**

      * **preference** ``NodeSelectorTerm`` - A node selector term, associated with the corresponding weight.
      * **weight** ``int`` - Weight associated with matching the corresponding nodeSelectorTerm, in the
        range 1-100.
    """
    preference: 'NodeSelectorTerm'
    weight: 'int'


@dataclass
class Probe(DictMixin):
    """Probe describes a health check to be performed against a container to
      determine whether it is alive or ready to receive traffic.

      **parameters**

      * **exec** ``Optional[ExecAction]`` - One and only one of the following should be specified. Exec specifies the
        action to take.
      * **failureThreshold** ``Optional[int]`` - Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
      * **httpGet** ``Optional[HTTPGetAction]`` - HTTPGet specifies the http request to perform.
      * **initialDelaySeconds** ``Optional[int]`` - Number of seconds after the container has started before liveness probes are
        initiated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **periodSeconds** ``Optional[int]`` - How often (in seconds) to perform the probe. Default to 10 seconds. Minimum
        value is 1.
      * **successThreshold** ``Optional[int]`` - Minimum consecutive successes for the probe to be considered successful after
        having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
        value is 1.
      * **tcpSocket** ``Optional[TCPSocketAction]`` - TCPSocket specifies an action involving a TCP port. TCP hooks not yet
        supported
      * **terminationGracePeriodSeconds** ``Optional[int]`` - Optional duration in seconds the pod needs to terminate gracefully upon probe
        failure. The grace period is the duration in seconds after the processes
        running in the pod are sent a termination signal and the time when the
        processes are forcibly halted with a kill signal. Set this value longer than
        the expected cleanup time for your process. If this value is nil, the pod's
        terminationGracePeriodSeconds will be used. Otherwise, this value overrides
        the value provided by the pod spec. Value must be non-negative integer. The
        value zero indicates stop immediately via the kill signal (no opportunity to
        shut down). This is a beta field and requires enabling
        ProbeTerminationGracePeriod feature gate. Minimum value is 1.
        spec.terminationGracePeriodSeconds is used if unset.
      * **timeoutSeconds** ``Optional[int]`` - Number of seconds after which the probe times out. Defaults to 1 second.
        Minimum value is 1. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    """
    exec: 'Optional[ExecAction]' = None
    failureThreshold: 'Optional[int]' = None
    httpGet: 'Optional[HTTPGetAction]' = None
    initialDelaySeconds: 'Optional[int]' = None
    periodSeconds: 'Optional[int]' = None
    successThreshold: 'Optional[int]' = None
    tcpSocket: 'Optional[TCPSocketAction]' = None
    terminationGracePeriodSeconds: 'Optional[int]' = None
    timeoutSeconds: 'Optional[int]' = None


@dataclass
class ProjectedVolumeSource(DictMixin):
    """Represents a projected volume source

      **parameters**

      * **defaultMode** ``Optional[int]`` - Mode bits used to set permissions on created files by default. Must be an
        octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML
        accepts both octal and decimal values, JSON requires decimal values for mode
        bits. Directories within the path are not affected by this setting. This might
        be in conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
      * **sources** ``Optional[List[VolumeProjection]]`` - list of volume projections
    """
    defaultMode: 'Optional[int]' = None
    sources: 'Optional[List[VolumeProjection]]' = None


@dataclass
class QuobyteVolumeSource(DictMixin):
    """Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes
      do not support ownership management or SELinux relabeling.

      **parameters**

      * **registry** ``str`` - Registry represents a single or multiple Quobyte Registry services specified
        as a string as host:port pair (multiple entries are separated with commas)
        which acts as the central registry for volumes
      * **volume** ``str`` - Volume is a string that references an already created Quobyte volume by name.
      * **group** ``Optional[str]`` - Group to map volume access to Default is no group
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the Quobyte volume to be mounted with read-only
        permissions. Defaults to false.
      * **tenant** ``Optional[str]`` - Tenant owning the given Quobyte volume in the Backend Used with dynamically
        provisioned Quobyte volumes, value is set by the plugin
      * **user** ``Optional[str]`` - User to map volume access to Defaults to serivceaccount user
    """
    registry: 'str'
    volume: 'str'
    group: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    tenant: 'Optional[str]' = None
    user: 'Optional[str]' = None


@dataclass
class RBDPersistentVolumeSource(DictMixin):
    """Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD
      volumes support ownership management and SELinux relabeling.

      **parameters**

      * **image** ``str`` - The rados image name. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **monitors** ``List[str]`` - A collection of Ceph monitors. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **fsType** ``Optional[str]`` - Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#rbd
      * **keyring** ``Optional[str]`` - Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring.
        More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **pool** ``Optional[str]`` - The rados pool name. Default is rbd. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **secretRef** ``Optional[SecretReference]`` - SecretRef is name of the authentication secret for RBDUser. If provided
        overrides keyring. Default is nil. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **user** ``Optional[str]`` - The rados user name. Default is admin. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    image: 'str'
    monitors: 'List[str]'
    fsType: 'Optional[str]' = None
    keyring: 'Optional[str]' = None
    pool: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[SecretReference]' = None
    user: 'Optional[str]' = None


@dataclass
class RBDVolumeSource(DictMixin):
    """Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD
      volumes support ownership management and SELinux relabeling.

      **parameters**

      * **image** ``str`` - The rados image name. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **monitors** ``List[str]`` - A collection of Ceph monitors. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **fsType** ``Optional[str]`` - Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#rbd
      * **keyring** ``Optional[str]`` - Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring.
        More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **pool** ``Optional[str]`` - The rados pool name. Default is rbd. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **readOnly** ``Optional[bool]`` - ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **secretRef** ``Optional[LocalObjectReference]`` - SecretRef is name of the authentication secret for RBDUser. If provided
        overrides keyring. Default is nil. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **user** ``Optional[str]`` - The rados user name. Default is admin. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    image: 'str'
    monitors: 'List[str]'
    fsType: 'Optional[str]' = None
    keyring: 'Optional[str]' = None
    pool: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[LocalObjectReference]' = None
    user: 'Optional[str]' = None


@dataclass
class ReplicationController(DictMixin):
    """ReplicationController represents the configuration of a replication
      controller.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - If the Labels of a ReplicationController are empty, they are defaulted to be
        the same as the Pod(s) that the replication controller manages. Standard
        object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[ReplicationControllerSpec]`` - Spec defines the specification of the desired behavior of the replication
        controller. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[ReplicationControllerStatus]`` - Status is the most recently observed status of the replication controller.
        This data may be out of date by some window of time. Populated by the system.
        Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[ReplicationControllerSpec]' = None
    status: 'Optional[ReplicationControllerStatus]' = None


@dataclass
class ReplicationControllerCondition(DictMixin):
    """ReplicationControllerCondition describes the state of a replication controller
      at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of replication controller condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - The last time the condition transitioned from one status to another.
      * **message** ``Optional[str]`` - A human readable message indicating details about the transition.
      * **reason** ``Optional[str]`` - The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class ReplicationControllerList(DictMixin):
    """ReplicationControllerList is a collection of replication controllers.

      **parameters**

      * **items** ``List[ReplicationController]`` - List of replication controllers. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ReplicationController]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ReplicationControllerSpec(DictMixin):
    """ReplicationControllerSpec is the specification of a replication controller.

      **parameters**

      * **minReadySeconds** ``Optional[int]`` - Minimum number of seconds for which a newly created pod should be ready
        without any of its container crashing, for it to be considered available.
        Defaults to 0 (pod will be considered available as soon as it is ready)
      * **replicas** ``Optional[int]`` - Replicas is the number of desired replicas. This is a pointer to distinguish
        between explicit zero and unspecified. Defaults to 1. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
      * **selector** ``Optional[dict]`` - Selector is a label query over pods that should match the Replicas count. If
        Selector is empty, it is defaulted to the labels present on the Pod template.
        Label keys and values that must match in order to be controlled by this
        replication controller, if empty defaulted to labels on Pod template. More
        info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **template** ``Optional[PodTemplateSpec]`` - Template is the object that describes the pod that will be created if
        insufficient replicas are detected. This takes precedence over a TemplateRef.
        More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
    """
    minReadySeconds: 'Optional[int]' = None
    replicas: 'Optional[int]' = None
    selector: 'Optional[dict]' = None
    template: 'Optional[PodTemplateSpec]' = None


@dataclass
class ReplicationControllerStatus(DictMixin):
    """ReplicationControllerStatus represents the current status of a replication
      controller.

      **parameters**

      * **replicas** ``int`` - Replicas is the most recently oberved number of replicas. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
      * **availableReplicas** ``Optional[int]`` - The number of available replicas (ready for at least minReadySeconds) for this
        replication controller.
      * **conditions** ``Optional[List[ReplicationControllerCondition]]`` - Represents the latest available observations of a replication controller's
        current state.
      * **fullyLabeledReplicas** ``Optional[int]`` - The number of pods that have labels matching the labels of the pod template of
        the replication controller.
      * **observedGeneration** ``Optional[int]`` - ObservedGeneration reflects the generation of the most recently observed
        replication controller.
      * **readyReplicas** ``Optional[int]`` - The number of ready replicas for this replication controller.
    """
    replicas: 'int'
    availableReplicas: 'Optional[int]' = None
    conditions: 'Optional[List[ReplicationControllerCondition]]' = None
    fullyLabeledReplicas: 'Optional[int]' = None
    observedGeneration: 'Optional[int]' = None
    readyReplicas: 'Optional[int]' = None


@dataclass
class ResourceFieldSelector(DictMixin):
    """ResourceFieldSelector represents container resources (cpu, memory) and their
      output format

      **parameters**

      * **resource** ``str`` - Required: resource to select
      * **containerName** ``Optional[str]`` - Container name: required for volumes, optional for env vars
      * **divisor** ``Optional[resource.Quantity]`` - Specifies the output format of the exposed resources, defaults to "1"
    """
    resource: 'str'
    containerName: 'Optional[str]' = None
    divisor: 'Optional[resource.Quantity]' = None


@dataclass
class ResourceQuota(DictMixin):
    """ResourceQuota sets aggregate quota restrictions enforced per namespace

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[ResourceQuotaSpec]`` - Spec defines the desired quota.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[ResourceQuotaStatus]`` - Status defines the actual enforced quota and its current usage.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[ResourceQuotaSpec]' = None
    status: 'Optional[ResourceQuotaStatus]' = None


@dataclass
class ResourceQuotaList(DictMixin):
    """ResourceQuotaList is a list of ResourceQuota items.

      **parameters**

      * **items** ``List[ResourceQuota]`` - Items is a list of ResourceQuota objects. More info:
        https://kubernetes.io/docs/concepts/policy/resource-quotas/
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ResourceQuota]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ResourceQuotaSpec(DictMixin):
    """ResourceQuotaSpec defines the desired hard limits to enforce for Quota.

      **parameters**

      * **hard** ``Optional[dict]`` - hard is the set of desired hard limits for each named resource. More info:
        https://kubernetes.io/docs/concepts/policy/resource-quotas/
      * **scopeSelector** ``Optional[ScopeSelector]`` - scopeSelector is also a collection of filters like scopes that must match each
        object tracked by a quota but expressed using ScopeSelectorOperator in
        combination with possible values. For a resource to match, both scopes AND
        scopeSelector (if specified in spec), must be matched.
      * **scopes** ``Optional[List[str]]`` - A collection of filters that must match each object tracked by a quota. If not
        specified, the quota matches all objects.
    """
    hard: 'Optional[dict]' = None
    scopeSelector: 'Optional[ScopeSelector]' = None
    scopes: 'Optional[List[str]]' = None


@dataclass
class ResourceQuotaStatus(DictMixin):
    """ResourceQuotaStatus defines the enforced hard limits and observed use.

      **parameters**

      * **hard** ``Optional[dict]`` - Hard is the set of enforced hard limits for each named resource. More info:
        https://kubernetes.io/docs/concepts/policy/resource-quotas/
      * **used** ``Optional[dict]`` - Used is the current observed total usage of the resource in the namespace.
    """
    hard: 'Optional[dict]' = None
    used: 'Optional[dict]' = None


@dataclass
class ResourceRequirements(DictMixin):
    """ResourceRequirements describes the compute resource requirements.

      **parameters**

      * **limits** ``Optional[dict]`` - Limits describes the maximum amount of compute resources allowed. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
      * **requests** ``Optional[dict]`` - Requests describes the minimum amount of compute resources required. If
        Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
    """
    limits: 'Optional[dict]' = None
    requests: 'Optional[dict]' = None


@dataclass
class SELinuxOptions(DictMixin):
    """SELinuxOptions are the labels to be applied to the container

      **parameters**

      * **level** ``Optional[str]`` - Level is SELinux level label that applies to the container.
      * **role** ``Optional[str]`` - Role is a SELinux role label that applies to the container.
      * **type** ``Optional[str]`` - Type is a SELinux type label that applies to the container.
      * **user** ``Optional[str]`` - User is a SELinux user label that applies to the container.
    """
    level: 'Optional[str]' = None
    role: 'Optional[str]' = None
    type: 'Optional[str]' = None
    user: 'Optional[str]' = None


@dataclass
class ScaleIOPersistentVolumeSource(DictMixin):
    """ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume

      **parameters**

      * **gateway** ``str`` - The host address of the ScaleIO API Gateway.
      * **secretRef** ``SecretReference`` - SecretRef references to the secret for ScaleIO user and other sensitive
        information. If this is not provided, Login operation will fail.
      * **system** ``str`` - The name of the storage system as configured in ScaleIO.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
      * **protectionDomain** ``Optional[str]`` - The name of the ScaleIO Protection Domain for the configured storage.
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **sslEnabled** ``Optional[bool]`` - Flag to enable/disable SSL communication with Gateway, default false
      * **storageMode** ``Optional[str]`` - Indicates whether the storage for a volume should be ThickProvisioned or
        ThinProvisioned. Default is ThinProvisioned.
      * **storagePool** ``Optional[str]`` - The ScaleIO Storage Pool associated with the protection domain.
      * **volumeName** ``Optional[str]`` - The name of a volume already created in the ScaleIO system that is associated
        with this volume source.
    """
    gateway: 'str'
    secretRef: 'SecretReference'
    system: 'str'
    fsType: 'Optional[str]' = None
    protectionDomain: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    sslEnabled: 'Optional[bool]' = None
    storageMode: 'Optional[str]' = None
    storagePool: 'Optional[str]' = None
    volumeName: 'Optional[str]' = None


@dataclass
class ScaleIOVolumeSource(DictMixin):
    """ScaleIOVolumeSource represents a persistent ScaleIO volume

      **parameters**

      * **gateway** ``str`` - The host address of the ScaleIO API Gateway.
      * **secretRef** ``LocalObjectReference`` - SecretRef references to the secret for ScaleIO user and other sensitive
        information. If this is not provided, Login operation will fail.
      * **system** ``str`` - The name of the storage system as configured in ScaleIO.
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
      * **protectionDomain** ``Optional[str]`` - The name of the ScaleIO Protection Domain for the configured storage.
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **sslEnabled** ``Optional[bool]`` - Flag to enable/disable SSL communication with Gateway, default false
      * **storageMode** ``Optional[str]`` - Indicates whether the storage for a volume should be ThickProvisioned or
        ThinProvisioned. Default is ThinProvisioned.
      * **storagePool** ``Optional[str]`` - The ScaleIO Storage Pool associated with the protection domain.
      * **volumeName** ``Optional[str]`` - The name of a volume already created in the ScaleIO system that is associated
        with this volume source.
    """
    gateway: 'str'
    secretRef: 'LocalObjectReference'
    system: 'str'
    fsType: 'Optional[str]' = None
    protectionDomain: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    sslEnabled: 'Optional[bool]' = None
    storageMode: 'Optional[str]' = None
    storagePool: 'Optional[str]' = None
    volumeName: 'Optional[str]' = None


@dataclass
class ScopeSelector(DictMixin):
    """A scope selector represents the AND of the selectors represented by the
      scoped-resource selector requirements.

      **parameters**

      * **matchExpressions** ``Optional[List[ScopedResourceSelectorRequirement]]`` - A list of scope selector requirements by scope of the resources.
    """
    matchExpressions: 'Optional[List[ScopedResourceSelectorRequirement]]' = None


@dataclass
class ScopedResourceSelectorRequirement(DictMixin):
    """A scoped-resource selector requirement is a selector that contains values, a
      scope name, and an operator that relates the scope name and values.

      **parameters**

      * **operator** ``str`` - Represents a scope's relationship to a set of values. Valid operators are In,
        NotIn, Exists, DoesNotExist.
      * **scopeName** ``str`` - The name of the scope that the selector applies to.
      * **values** ``Optional[List[str]]`` - An array of string values. If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist, the values array
        must be empty. This array is replaced during a strategic merge patch.
    """
    operator: 'str'
    scopeName: 'str'
    values: 'Optional[List[str]]' = None


@dataclass
class SeccompProfile(DictMixin):
    """SeccompProfile defines a pod/container's seccomp profile settings. Only one
      profile source may be set.

      **parameters**

      * **type** ``str`` - type indicates which kind of seccomp profile will be applied. Valid options
        are:
        Localhost - a profile defined in a file on the node should be used.
        RuntimeDefault - the container runtime default profile should be used.
        Unconfined - no profile should be applied.
      * **localhostProfile** ``Optional[str]`` - localhostProfile indicates a profile defined in a file on the node should be
        used. The profile must be preconfigured on the node to work. Must be a
        descending path, relative to the kubelet's configured seccomp profile
        location. Must only be set if type is "Localhost".
    """
    type: 'str'
    localhostProfile: 'Optional[str]' = None


@dataclass
class Secret(DictMixin):
    """Secret holds secret data of a certain type. The total bytes of the values in
      the Data field must be less than MaxSecretSize bytes.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **data** ``Optional[dict]`` - Data contains the secret data. Each key must consist of alphanumeric
        characters, '-', '_' or '.'. The serialized form of the secret data is a
        base64 encoded string, representing the arbitrary (possibly non-string) data
        value here. Described in https://tools.ietf.org/html/rfc4648#section-4
      * **immutable** ``Optional[bool]`` - Immutable, if set to true, ensures that data stored in the Secret cannot be
        updated (only object metadata can be modified). If not set to true, the field
        can be modified at any time. Defaulted to nil.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **stringData** ``Optional[dict]`` - stringData allows specifying non-binary secret data in string form. It is
        provided as a write-only input field for convenience. All keys and values are
        merged into the data field on write, overwriting any existing values. The
        stringData field is never output when reading from the API.
      * **type** ``Optional[str]`` - Used to facilitate programmatic handling of secret data.
    """
    apiVersion: 'Optional[str]' = None
    data: 'Optional[dict]' = None
    immutable: 'Optional[bool]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    stringData: 'Optional[dict]' = None
    type: 'Optional[str]' = None


@dataclass
class SecretEnvSource(DictMixin):
    """SecretEnvSource selects a Secret to populate the environment variables with.
      
      The contents of the target Secret's Data field will represent the key-value
      pairs as environment variables.

      **parameters**

      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the Secret must be defined
    """
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class SecretKeySelector(DictMixin):
    """SecretKeySelector selects a key of a Secret.

      **parameters**

      * **key** ``str`` - The key of the secret to select from.  Must be a valid secret key.
      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the Secret or its key must be defined
    """
    key: 'str'
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class SecretList(DictMixin):
    """SecretList is a list of Secret.

      **parameters**

      * **items** ``List[Secret]`` - Items is a list of secret objects. More info:
        https://kubernetes.io/docs/concepts/configuration/secret
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Secret]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class SecretProjection(DictMixin):
    """Adapts a secret into a projected volume.
      
      The contents of the target Secret's Data field will be presented in a
      projected volume as files using the keys in the Data field as the file names.
      Note that this is identical to a secret volume source without the default
      mode.

      **parameters**

      * **items** ``Optional[List[KeyToPath]]`` - If unspecified, each key-value pair in the Data field of the referenced Secret
        will be projected into the volume as a file whose name is the key and content
        is the value. If specified, the listed keys will be projected into the
        specified paths, and unlisted keys will not be present. If a key is specified
        which is not present in the Secret, the volume setup will error unless it is
        marked optional. Paths must be relative and may not contain the '..' path or
        start with '..'.
      * **name** ``Optional[str]`` - Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``Optional[bool]`` - Specify whether the Secret or its key must be defined
    """
    items: 'Optional[List[KeyToPath]]' = None
    name: 'Optional[str]' = None
    optional: 'Optional[bool]' = None


@dataclass
class SecretReference(DictMixin):
    """SecretReference represents a Secret Reference. It has enough information to
      retrieve secret in any namespace

      **parameters**

      * **name** ``Optional[str]`` - Name is unique within a namespace to reference a secret resource.
      * **namespace** ``Optional[str]`` - Namespace defines the space within which the secret name must be unique.
    """
    name: 'Optional[str]' = None
    namespace: 'Optional[str]' = None


@dataclass
class SecretVolumeSource(DictMixin):
    """Adapts a Secret into a volume.
      
      The contents of the target Secret's Data field will be presented in a volume
      as files using the keys in the Data field as the file names. Secret volumes
      support ownership management and SELinux relabeling.

      **parameters**

      * **defaultMode** ``Optional[int]`` - Optional: mode bits used to set permissions on created files by default. Must
        be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
        YAML accepts both octal and decimal values, JSON requires decimal values for
        mode bits. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.
      * **items** ``Optional[List[KeyToPath]]`` - If unspecified, each key-value pair in the Data field of the referenced Secret
        will be projected into the volume as a file whose name is the key and content
        is the value. If specified, the listed keys will be projected into the
        specified paths, and unlisted keys will not be present. If a key is specified
        which is not present in the Secret, the volume setup will error unless it is
        marked optional. Paths must be relative and may not contain the '..' path or
        start with '..'.
      * **optional** ``Optional[bool]`` - Specify whether the Secret or its keys must be defined
      * **secretName** ``Optional[str]`` - Name of the secret in the pod's namespace to use. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#secret
    """
    defaultMode: 'Optional[int]' = None
    items: 'Optional[List[KeyToPath]]' = None
    optional: 'Optional[bool]' = None
    secretName: 'Optional[str]' = None


@dataclass
class SecurityContext(DictMixin):
    """SecurityContext holds security configuration that will be applied to a
      container. Some fields are present in both SecurityContext and
      PodSecurityContext.  When both are set, the values in SecurityContext take
      precedence.

      **parameters**

      * **allowPrivilegeEscalation** ``Optional[bool]`` - AllowPrivilegeEscalation controls whether a process can gain more privileges
        than its parent process. This bool directly controls if the no_new_privs flag
        will be set on the container process. AllowPrivilegeEscalation is true always
        when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
      * **capabilities** ``Optional[Capabilities]`` - The capabilities to add/drop when running containers. Defaults to the default
        set of capabilities granted by the container runtime.
      * **privileged** ``Optional[bool]`` - Run container in privileged mode. Processes in privileged containers are
        essentially equivalent to root on the host. Defaults to false.
      * **procMount** ``Optional[str]`` - procMount denotes the type of proc mount to use for the containers. The
        default is DefaultProcMount which uses the container runtime defaults for
        readonly paths and masked paths. This requires the ProcMountType feature flag
        to be enabled.
      * **readOnlyRootFilesystem** ``Optional[bool]`` - Whether this container has a read-only root filesystem. Default is false.
      * **runAsGroup** ``Optional[int]`` - The GID to run the entrypoint of the container process. Uses runtime default
        if unset. May also be set in PodSecurityContext.  If set in both
        SecurityContext and PodSecurityContext, the value specified in SecurityContext
        takes precedence.
      * **runAsNonRoot** ``Optional[bool]`` - Indicates that the container must run as a non-root user. If true, the Kubelet
        will validate the image at runtime to ensure that it does not run as UID 0
        (root) and fail to start the container if it does. If unset or false, no such
        validation will be performed. May also be set in PodSecurityContext.  If set
        in both SecurityContext and PodSecurityContext, the value specified in
        SecurityContext takes precedence.
      * **runAsUser** ``Optional[int]`` - The UID to run the entrypoint of the container process. Defaults to user
        specified in image metadata if unspecified. May also be set in
        PodSecurityContext.  If set in both SecurityContext and PodSecurityContext,
        the value specified in SecurityContext takes precedence.
      * **seLinuxOptions** ``Optional[SELinuxOptions]`` - The SELinux context to be applied to the container. If unspecified, the
        container runtime will allocate a random SELinux context for each container.
        May also be set in PodSecurityContext.  If set in both SecurityContext and
        PodSecurityContext, the value specified in SecurityContext takes precedence.
      * **seccompProfile** ``Optional[SeccompProfile]`` - The seccomp options to use by this container. If seccomp options are provided
        at both the pod & container level, the container options override the pod
        options.
      * **windowsOptions** ``Optional[WindowsSecurityContextOptions]`` - The Windows specific settings applied to all containers. If unspecified, the
        options from the PodSecurityContext will be used. If set in both
        SecurityContext and PodSecurityContext, the value specified in SecurityContext
        takes precedence.
    """
    allowPrivilegeEscalation: 'Optional[bool]' = None
    capabilities: 'Optional[Capabilities]' = None
    privileged: 'Optional[bool]' = None
    procMount: 'Optional[str]' = None
    readOnlyRootFilesystem: 'Optional[bool]' = None
    runAsGroup: 'Optional[int]' = None
    runAsNonRoot: 'Optional[bool]' = None
    runAsUser: 'Optional[int]' = None
    seLinuxOptions: 'Optional[SELinuxOptions]' = None
    seccompProfile: 'Optional[SeccompProfile]' = None
    windowsOptions: 'Optional[WindowsSecurityContextOptions]' = None


@dataclass
class Service(DictMixin):
    """Service is a named abstraction of software service (for example, mysql)
      consisting of local port (for example 3306) that the proxy listens on, and the
      selector that determines which pods will answer requests sent through the
      proxy.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[ServiceSpec]`` - Spec defines the behavior of a service.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[ServiceStatus]`` - Most recently observed status of the service. Populated by the system.
        Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[ServiceSpec]' = None
    status: 'Optional[ServiceStatus]' = None


@dataclass
class ServiceAccount(DictMixin):
    """ServiceAccount binds together: * a name, understood by users, and perhaps by
      peripheral systems, for an identity * a principal that can be authenticated
      and authorized * a set of secrets

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **automountServiceAccountToken** ``Optional[bool]`` - AutomountServiceAccountToken indicates whether pods running as this service
        account should have an API token automatically mounted. Can be overridden at
        the pod level.
      * **imagePullSecrets** ``Optional[List[LocalObjectReference]]`` - ImagePullSecrets is a list of references to secrets in the same namespace to
        use for pulling any images in pods that reference this ServiceAccount.
        ImagePullSecrets are distinct from Secrets because Secrets can be mounted in
        the pod, but ImagePullSecrets are only accessed by the kubelet. More info:
        https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **secrets** ``Optional[List[ObjectReference]]`` - Secrets is the list of secrets allowed to be used by pods running using this
        ServiceAccount. More info:
        https://kubernetes.io/docs/concepts/configuration/secret
    """
    apiVersion: 'Optional[str]' = None
    automountServiceAccountToken: 'Optional[bool]' = None
    imagePullSecrets: 'Optional[List[LocalObjectReference]]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    secrets: 'Optional[List[ObjectReference]]' = None


@dataclass
class ServiceAccountList(DictMixin):
    """ServiceAccountList is a list of ServiceAccount objects

      **parameters**

      * **items** ``List[ServiceAccount]`` - List of ServiceAccounts. More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ServiceAccount]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ServiceAccountTokenProjection(DictMixin):
    """ServiceAccountTokenProjection represents a projected service account token
      volume. This projection can be used to insert a service account token into the
      pods runtime filesystem for use against APIs (Kubernetes API Server or
      otherwise).

      **parameters**

      * **path** ``str`` - Path is the path relative to the mount point of the file to project the token
        into.
      * **audience** ``Optional[str]`` - Audience is the intended audience of the token. A recipient of a token must
        identify itself with an identifier specified in the audience of the token, and
        otherwise should reject the token. The audience defaults to the identifier of
        the apiserver.
      * **expirationSeconds** ``Optional[int]`` - ExpirationSeconds is the requested duration of validity of the service account
        token. As the token approaches expiration, the kubelet volume plugin will
        proactively rotate the service account token. The kubelet will start trying to
        rotate the token if the token is older than 80 percent of its time to live or
        if the token is older than 24 hours.Defaults to 1 hour and must be at least 10
        minutes.
    """
    path: 'str'
    audience: 'Optional[str]' = None
    expirationSeconds: 'Optional[int]' = None


@dataclass
class ServiceList(DictMixin):
    """ServiceList holds a list of services.

      **parameters**

      * **items** ``List[Service]`` - List of services
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Service]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ServicePort(DictMixin):
    """ServicePort contains information on service's port.

      **parameters**

      * **port** ``int`` - The port that will be exposed by this service.
      * **appProtocol** ``Optional[str]`` - The application protocol for this port. This field follows standard Kubernetes
        label syntax. Un-prefixed names are reserved for IANA standard service names
        (as per RFC-6335 and http://www.iana.org/assignments/service-names).
        Non-standard protocols should use prefixed names such as
        mycompany.com/my-custom-protocol.
      * **name** ``Optional[str]`` - The name of this port within the service. This must be a DNS_LABEL. All ports
        within a ServiceSpec must have unique names. When considering the endpoints
        for a Service, this must match the 'name' field in the EndpointPort. Optional
        if only one ServicePort is defined on this service.
      * **nodePort** ``Optional[int]`` - The port on each node on which this service is exposed when type is NodePort
        or LoadBalancer.  Usually assigned by the system. If a value is specified,
        in-range, and not in use it will be used, otherwise the operation will fail.
        If not specified, a port will be allocated if this Service requires one.  If
        this field is specified when creating a Service which does not need it,
        creation will fail. This field will be wiped when updating a Service to no
        longer need it (e.g. changing type from NodePort to ClusterIP). More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
      * **protocol** ``Optional[str]`` - The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is
        TCP.
      * **targetPort** ``Optional[util_intstr.IntOrString]`` - Number or name of the port to access on the pods targeted by the service.
        Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this
        is a string, it will be looked up as a named port in the target Pod's
        container ports. If this is not specified, the value of the 'port' field is
        used (an identity map). This field is ignored for services with
        clusterIP=None, and should be omitted or set equal to the 'port' field. More
        info:
        https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
    """
    port: 'int'
    appProtocol: 'Optional[str]' = None
    name: 'Optional[str]' = None
    nodePort: 'Optional[int]' = None
    protocol: 'Optional[str]' = None
    targetPort: 'Optional[util_intstr.IntOrString]' = None


@dataclass
class ServiceSpec(DictMixin):
    """ServiceSpec describes the attributes that a user creates on a service.

      **parameters**

      * **allocateLoadBalancerNodePorts** ``Optional[bool]`` - allocateLoadBalancerNodePorts defines if NodePorts will be automatically
        allocated for services with type LoadBalancer.  Default is "true". It may be
        set to "false" if the cluster load-balancer does not rely on NodePorts.  If
        the caller requests specific NodePorts (by specifying a value), those requests
        will be respected, regardless of this field. This field may only be set for
        services with type LoadBalancer and will be cleared if the type is changed to
        any other type. This field is beta-level and is only honored by servers that
        enable the ServiceLBNodePortControl feature.
      * **clusterIP** ``Optional[str]`` - clusterIP is the IP address of the service and is usually assigned randomly.
        If an address is specified manually, is in-range (as per system
        configuration), and is not in use, it will be allocated to the service;
        otherwise creation of the service will fail. This field may not be changed
        through updates unless the type field is also being changed to ExternalName
        (which requires this field to be blank) or the type field is being changed
        from ExternalName (in which case this field may optionally be specified, as
        describe above).  Valid values are "None", empty string (""), or a valid IP
        address. Setting this to "None" makes a "headless service" (no virtual IP),
        which is useful when direct endpoint connections are preferred and proxying is
        not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If
        this field is specified when creating a Service of type ExternalName, creation
        will fail. This field will be wiped when updating a Service to type
        ExternalName. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **clusterIPs** ``Optional[List[str]]`` - ClusterIPs is a list of IP addresses assigned to this service, and are usually
        assigned randomly.  If an address is specified manually, is in-range (as per
        system configuration), and is not in use, it will be allocated to the service;
        otherwise creation of the service will fail. This field may not be changed
        through updates unless the type field is also being changed to ExternalName
        (which requires this field to be empty) or the type field is being changed
        from ExternalName (in which case this field may optionally be specified, as
        describe above).  Valid values are "None", empty string (""), or a valid IP
        address.  Setting this to "None" makes a "headless service" (no virtual IP),
        which is useful when direct endpoint connections are preferred and proxying is
        not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If
        this field is specified when creating a Service of type ExternalName, creation
        will fail. This field will be wiped when updating a Service to type
        ExternalName.  If this field is not specified, it will be initialized from the
        clusterIP field.  If this field is specified, clients must ensure that
        clusterIPs[0] and clusterIP have the same value.
        Unless the "IPv6DualStack" feature gate is enabled, this field is limited to
        one value, which must be the same as the clusterIP field.  If the feature gate
        is enabled, this field may hold a maximum of two entries (dual-stack IPs, in
        either order).  These IPs must correspond to the values of the ipFamilies
        field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy
        field. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **externalIPs** ``Optional[List[str]]`` - externalIPs is a list of IP addresses for which nodes in the cluster will also
        accept traffic for this service.  These IPs are not managed by Kubernetes.
        The user is responsible for ensuring that traffic arrives at a node with this
        IP.  A common example is external load-balancers that are not part of the
        Kubernetes system.
      * **externalName** ``Optional[str]`` - externalName is the external reference that discovery mechanisms will return
        as an alias for this service (e.g. a DNS CNAME record). No proxying will be
        involved.  Must be a lowercase RFC-1123 hostname
        (https://tools.ietf.org/html/rfc1123) and requires `type` to be
        "ExternalName".
      * **externalTrafficPolicy** ``Optional[str]`` - externalTrafficPolicy denotes if this Service desires to route external
        traffic to node-local or cluster-wide endpoints. "Local" preserves the client
        source IP and avoids a second hop for LoadBalancer and Nodeport type services,
        but risks potentially imbalanced traffic spreading. "Cluster" obscures the
        client source IP and may cause a second hop to another node, but should have
        good overall load-spreading.
      * **healthCheckNodePort** ``Optional[int]`` - healthCheckNodePort specifies the healthcheck nodePort for the service. This
        only applies when type is set to LoadBalancer and externalTrafficPolicy is set
        to Local. If a value is specified, is in-range, and is not in use, it will be
        used.  If not specified, a value will be automatically allocated.  External
        systems (e.g. load-balancers) can use this port to determine if a given node
        holds endpoints for this service or not.  If this field is specified when
        creating a Service which does not need it, creation will fail. This field will
        be wiped when updating a Service to no longer need it (e.g. changing type).
      * **internalTrafficPolicy** ``Optional[str]`` - InternalTrafficPolicy specifies if the cluster internal traffic should be
        routed to all endpoints or node-local endpoints only. "Cluster" routes
        internal traffic to a Service to all endpoints. "Local" routes traffic to
        node-local endpoints only, traffic is dropped if no node-local endpoints are
        ready. The default value is "Cluster".
      * **ipFamilies** ``Optional[List[str]]`` - IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this
        service, and is gated by the "IPv6DualStack" feature gate.  This field is
        usually assigned automatically based on cluster configuration and the
        ipFamilyPolicy field. If this field is specified manually, the requested
        family is available in the cluster, and ipFamilyPolicy allows it, it will be
        used; otherwise creation of the service will fail.  This field is
        conditionally mutable: it allows for adding or removing a secondary IP family,
        but it does not allow changing the primary IP family of the Service.  Valid
        values are "IPv4" and "IPv6".  This field only applies to Services of types
        ClusterIP, NodePort, and LoadBalancer, and does apply to "headless" services.
        This field will be wiped when updating a Service to type ExternalName.
        This field may hold a maximum of two entries (dual-stack families, in either
        order).  These families must correspond to the values of the clusterIPs field,
        if specified. Both clusterIPs and ipFamilies are governed by the
        ipFamilyPolicy field.
      * **ipFamilyPolicy** ``Optional[str]`` - IPFamilyPolicy represents the dual-stack-ness requested or required by this
        Service, and is gated by the "IPv6DualStack" feature gate.  If there is no
        value provided, then this field will be set to SingleStack. Services can be
        "SingleStack" (a single IP family), "PreferDualStack" (two IP families on
        dual-stack configured clusters or a single IP family on single-stack
        clusters), or "RequireDualStack" (two IP families on dual-stack configured
        clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the
        value of this field.  This field will be wiped when updating a service to type
        ExternalName.
      * **loadBalancerClass** ``Optional[str]`` - loadBalancerClass is the class of the load balancer implementation this
        Service belongs to. If specified, the value of this field must be a
        label-style identifier, with an optional prefix, e.g. "internal-vip" or
        "example.com/internal-vip". Unprefixed names are reserved for end-users. This
        field can only be set when the Service type is 'LoadBalancer'. If not set, the
        default load balancer implementation is used, today this is typically done
        through the cloud provider integration, but should apply for any default
        implementation. If set, it is assumed that a load balancer implementation is
        watching for Services with a matching class. Any default load balancer
        implementation (e.g. cloud providers) should ignore Services that set this
        field. This field can only be set when creating or updating a Service to type
        'LoadBalancer'. Once set, it can not be changed. This field will be wiped when
        a service is updated to a non 'LoadBalancer' type.
      * **loadBalancerIP** ``Optional[str]`` - Only applies to Service Type: LoadBalancer LoadBalancer will get created with
        the IP specified in this field. This feature depends on whether the underlying
        cloud-provider supports specifying the loadBalancerIP when a load balancer is
        created. This field will be ignored if the cloud-provider does not support the
        feature.
      * **loadBalancerSourceRanges** ``Optional[List[str]]`` - If specified and supported by the platform, this will restrict traffic through
        the cloud-provider load-balancer will be restricted to the specified client
        IPs. This field will be ignored if the cloud-provider does not support the
        feature." More info:
        https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
      * **ports** ``Optional[List[ServicePort]]`` - The list of ports that are exposed by this service. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **publishNotReadyAddresses** ``Optional[bool]`` - publishNotReadyAddresses indicates that any agent which deals with endpoints
        for this Service should disregard any indications of ready/not-ready. The
        primary use case for setting this field is for a StatefulSet's Headless
        Service to propagate SRV DNS records for its Pods for the purpose of peer
        discovery. The Kubernetes controllers that generate Endpoints and
        EndpointSlice resources for Services interpret this to mean that all endpoints
        are considered "ready" even if the Pods themselves are not. Agents which
        consume only Kubernetes generated endpoints through the Endpoints or
        EndpointSlice resources can safely assume this behavior.
      * **selector** ``Optional[dict]`` - Route service traffic to pods with label keys and values matching this
        selector. If empty or not present, the service is assumed to have an external
        process managing its endpoints, which Kubernetes will not modify. Only applies
        to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is
        ExternalName. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/
      * **sessionAffinity** ``Optional[str]`` - Supports "ClientIP" and "None". Used to maintain session affinity. Enable
        client IP based session affinity. Must be ClientIP or None. Defaults to None.
        More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **sessionAffinityConfig** ``Optional[SessionAffinityConfig]`` - sessionAffinityConfig contains the configurations of session affinity.
      * **type** ``Optional[str]`` - type determines how the Service is exposed. Defaults to ClusterIP. Valid
        options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ClusterIP"
        allocates a cluster-internal IP address for load-balancing to endpoints.
        Endpoints are determined by the selector or if that is not specified, by
        manual construction of an Endpoints object or EndpointSlice objects. If
        clusterIP is "None", no virtual IP is allocated and the endpoints are
        published as a set of endpoints rather than a virtual IP. "NodePort" builds on
        ClusterIP and allocates a port on every node which routes to the same
        endpoints as the clusterIP. "LoadBalancer" builds on NodePort and creates an
        external load-balancer (if supported in the current cloud) which routes to the
        same endpoints as the clusterIP. "ExternalName" aliases this service to the
        specified externalName. Several other fields do not apply to ExternalName
        services. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
    """
    allocateLoadBalancerNodePorts: 'Optional[bool]' = None
    clusterIP: 'Optional[str]' = None
    clusterIPs: 'Optional[List[str]]' = None
    externalIPs: 'Optional[List[str]]' = None
    externalName: 'Optional[str]' = None
    externalTrafficPolicy: 'Optional[str]' = None
    healthCheckNodePort: 'Optional[int]' = None
    internalTrafficPolicy: 'Optional[str]' = None
    ipFamilies: 'Optional[List[str]]' = None
    ipFamilyPolicy: 'Optional[str]' = None
    loadBalancerClass: 'Optional[str]' = None
    loadBalancerIP: 'Optional[str]' = None
    loadBalancerSourceRanges: 'Optional[List[str]]' = None
    ports: 'Optional[List[ServicePort]]' = None
    publishNotReadyAddresses: 'Optional[bool]' = None
    selector: 'Optional[dict]' = None
    sessionAffinity: 'Optional[str]' = None
    sessionAffinityConfig: 'Optional[SessionAffinityConfig]' = None
    type: 'Optional[str]' = None


@dataclass
class ServiceStatus(DictMixin):
    """ServiceStatus represents the current status of a service.

      **parameters**

      * **conditions** ``Optional[List[meta_v1.Condition]]`` - Current service state
      * **loadBalancer** ``Optional[LoadBalancerStatus]`` - LoadBalancer contains the current status of the load-balancer, if one is
        present.
    """
    conditions: 'Optional[List[meta_v1.Condition]]' = None
    loadBalancer: 'Optional[LoadBalancerStatus]' = None


@dataclass
class SessionAffinityConfig(DictMixin):
    """SessionAffinityConfig represents the configurations of session affinity.

      **parameters**

      * **clientIP** ``Optional[ClientIPConfig]`` - clientIP contains the configurations of Client IP based session affinity.
    """
    clientIP: 'Optional[ClientIPConfig]' = None


@dataclass
class StorageOSPersistentVolumeSource(DictMixin):
    """Represents a StorageOS persistent volume resource.

      **parameters**

      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **secretRef** ``Optional[ObjectReference]`` - SecretRef specifies the secret to use for obtaining the StorageOS API
        credentials.  If not specified, default values will be attempted.
      * **volumeName** ``Optional[str]`` - VolumeName is the human-readable name of the StorageOS volume.  Volume names
        are only unique within a namespace.
      * **volumeNamespace** ``Optional[str]`` - VolumeNamespace specifies the scope of the volume within StorageOS.  If no
        namespace is specified then the Pod's namespace will be used.  This allows the
        Kubernetes name scoping to be mirrored within StorageOS for tighter
        integration. Set VolumeName to any name to override the default behaviour. Set
        to "default" if you are not using namespaces within StorageOS. Namespaces that
        do not pre-exist within StorageOS will be created.
    """
    fsType: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[ObjectReference]' = None
    volumeName: 'Optional[str]' = None
    volumeNamespace: 'Optional[str]' = None


@dataclass
class StorageOSVolumeSource(DictMixin):
    """Represents a StorageOS persistent volume resource.

      **parameters**

      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **readOnly** ``Optional[bool]`` - Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **secretRef** ``Optional[LocalObjectReference]`` - SecretRef specifies the secret to use for obtaining the StorageOS API
        credentials.  If not specified, default values will be attempted.
      * **volumeName** ``Optional[str]`` - VolumeName is the human-readable name of the StorageOS volume.  Volume names
        are only unique within a namespace.
      * **volumeNamespace** ``Optional[str]`` - VolumeNamespace specifies the scope of the volume within StorageOS.  If no
        namespace is specified then the Pod's namespace will be used.  This allows the
        Kubernetes name scoping to be mirrored within StorageOS for tighter
        integration. Set VolumeName to any name to override the default behaviour. Set
        to "default" if you are not using namespaces within StorageOS. Namespaces that
        do not pre-exist within StorageOS will be created.
    """
    fsType: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    secretRef: 'Optional[LocalObjectReference]' = None
    volumeName: 'Optional[str]' = None
    volumeNamespace: 'Optional[str]' = None


@dataclass
class Sysctl(DictMixin):
    """Sysctl defines a kernel parameter to be set

      **parameters**

      * **name** ``str`` - Name of a property to set
      * **value** ``str`` - Value of a property to set
    """
    name: 'str'
    value: 'str'


@dataclass
class TCPSocketAction(DictMixin):
    """TCPSocketAction describes an action based on opening a socket

      **parameters**

      * **port** ``util_intstr.IntOrString`` - Number or name of the port to access on the container. Number must be in the
        range 1 to 65535. Name must be an IANA_SVC_NAME.
      * **host** ``Optional[str]`` - Optional: Host name to connect to, defaults to the pod IP.
    """
    port: 'util_intstr.IntOrString'
    host: 'Optional[str]' = None


@dataclass
class Taint(DictMixin):
    """The node this Taint is attached to has the "effect" on any pod that does not
      tolerate the Taint.

      **parameters**

      * **effect** ``str`` - Required. The effect of the taint on pods that do not tolerate the taint.
        Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
      * **key** ``str`` - Required. The taint key to be applied to a node.
      * **timeAdded** ``Optional[meta_v1.Time]`` - TimeAdded represents the time at which the taint was added. It is only written
        for NoExecute taints.
      * **value** ``Optional[str]`` - The taint value corresponding to the taint key.
    """
    effect: 'str'
    key: 'str'
    timeAdded: 'Optional[meta_v1.Time]' = None
    value: 'Optional[str]' = None


@dataclass
class Toleration(DictMixin):
    """The pod this Toleration is attached to tolerates any taint that matches the
      triple <key,value,effect> using the matching operator <operator>.

      **parameters**

      * **effect** ``Optional[str]`` - Effect indicates the taint effect to match. Empty means match all taint
        effects. When specified, allowed values are NoSchedule, PreferNoSchedule and
        NoExecute.
      * **key** ``Optional[str]`` - Key is the taint key that the toleration applies to. Empty means match all
        taint keys. If the key is empty, operator must be Exists; this combination
        means to match all values and all keys.
      * **operator** ``Optional[str]`` - Operator represents a key's relationship to the value. Valid operators are
        Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for
        value, so that a pod can tolerate all taints of a particular category.
      * **tolerationSeconds** ``Optional[int]`` - TolerationSeconds represents the period of time the toleration (which must be
        of effect NoExecute, otherwise this field is ignored) tolerates the taint. By
        default, it is not set, which means tolerate the taint forever (do not evict).
        Zero and negative values will be treated as 0 (evict immediately) by the
        system.
      * **value** ``Optional[str]`` - Value is the taint value the toleration matches to. If the operator is Exists,
        the value should be empty, otherwise just a regular string.
    """
    effect: 'Optional[str]' = None
    key: 'Optional[str]' = None
    operator: 'Optional[str]' = None
    tolerationSeconds: 'Optional[int]' = None
    value: 'Optional[str]' = None


@dataclass
class TopologySelectorLabelRequirement(DictMixin):
    """A topology selector requirement is a selector that matches given label. This
      is an alpha feature and may change in the future.

      **parameters**

      * **key** ``str`` - The label key that the selector applies to.
      * **values** ``List[str]`` - An array of string values. One value must match the label to be selected. Each
        entry in Values is ORed.
    """
    key: 'str'
    values: 'List[str]'


@dataclass
class TopologySelectorTerm(DictMixin):
    """A topology selector term represents the result of label queries. A null or
      empty topology selector term matches no objects. The requirements of them are
      ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an
      alpha feature and may change in the future.

      **parameters**

      * **matchLabelExpressions** ``Optional[List[TopologySelectorLabelRequirement]]`` - A list of topology selector requirements by labels.
    """
    matchLabelExpressions: 'Optional[List[TopologySelectorLabelRequirement]]' = None


@dataclass
class TopologySpreadConstraint(DictMixin):
    """TopologySpreadConstraint specifies how to spread matching pods among the given
      topology.

      **parameters**

      * **maxSkew** ``int`` - MaxSkew describes the degree to which pods may be unevenly distributed. When
        `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference
        between the number of matching pods in the target topology and the global
        minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with
        the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |
        P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3
        to become 1/1/1; scheduling it onto zone1(zone2) would make the
        ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2,
        incoming pod can be scheduled onto any zone. When
        `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to
        topologies that satisfy it. It's a required field. Default value is 1 and 0 is
        not allowed.
      * **topologyKey** ``str`` - TopologyKey is the key of node labels. Nodes that have a label with this key
        and identical values are considered to be in the same topology. We consider
        each <key, value> as a "bucket", and try to put balanced number of pods into
        each bucket. It's a required field.
      * **whenUnsatisfiable** ``str`` - WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the
        spread constraint. - DoNotSchedule (default) tells the scheduler not to
        schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any
        location,
          but giving higher precedence to topologies that would help reduce the
          skew.
        A constraint is considered "Unsatisfiable" for an incoming pod if and only if
        every possible node assigment for that pod would violate "MaxSkew" on some
        topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with
        the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |
        P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can
        only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on
        zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be
        imbalanced, but scheduler won't make it *more* imbalanced. It's a required
        field.
      * **labelSelector** ``Optional[meta_v1.LabelSelector]`` - LabelSelector is used to find matching pods. Pods that match this label
        selector are counted to determine the number of pods in their corresponding
        topology domain.
    """
    maxSkew: 'int'
    topologyKey: 'str'
    whenUnsatisfiable: 'str'
    labelSelector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class TypedLocalObjectReference(DictMixin):
    """TypedLocalObjectReference contains enough information to let you locate the
      typed referenced object inside the same namespace.

      **parameters**

      * **kind** ``str`` - Kind is the type of resource being referenced
      * **name** ``str`` - Name is the name of resource being referenced
      * **apiGroup** ``Optional[str]`` - APIGroup is the group for the resource being referenced. If APIGroup is not
        specified, the specified Kind must be in the core API group. For any other
        third-party types, APIGroup is required.
    """
    kind: 'str'
    name: 'str'
    apiGroup: 'Optional[str]' = None


@dataclass
class Volume(DictMixin):
    """Volume represents a named volume in a pod that may be accessed by any
      container in the pod.

      **parameters**

      * **name** ``str`` - Volume's name. Must be a DNS_LABEL and unique within the pod. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **awsElasticBlockStore** ``Optional[AWSElasticBlockStoreVolumeSource]`` - AWSElasticBlockStore represents an AWS Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **azureDisk** ``Optional[AzureDiskVolumeSource]`` - AzureDisk represents an Azure Data Disk mount on the host and bind mount to
        the pod.
      * **azureFile** ``Optional[AzureFileVolumeSource]`` - AzureFile represents an Azure File Service mount on the host and bind mount to
        the pod.
      * **cephfs** ``Optional[CephFSVolumeSource]`` - CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
      * **cinder** ``Optional[CinderVolumeSource]`` - Cinder represents a cinder volume attached and mounted on kubelets host
        machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
      * **configMap** ``Optional[ConfigMapVolumeSource]`` - ConfigMap represents a configMap that should populate this volume
      * **csi** ``Optional[CSIVolumeSource]`` - CSI (Container Storage Interface) represents ephemeral storage that is handled
        by certain external CSI drivers (Beta feature).
      * **downwardAPI** ``Optional[DownwardAPIVolumeSource]`` - DownwardAPI represents downward API about the pod that should populate this
        volume
      * **emptyDir** ``Optional[EmptyDirVolumeSource]`` - EmptyDir represents a temporary directory that shares a pod's lifetime. More
        info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
      * **ephemeral** ``Optional[EphemeralVolumeSource]`` - Ephemeral represents a volume that is handled by a cluster storage driver. The
        volume's lifecycle is tied to the pod that defines it - it will be created
        before the pod starts, and deleted when the pod is removed.
        Use this if: a) the volume is only needed while the pod runs, b) features of
        normal volumes like restoring from snapshot or capacity
           tracking are needed,
        c) the storage driver is specified through a storage class, and d) the storage
        driver supports dynamic volume provisioning through
           a PersistentVolumeClaim (see EphemeralVolumeSource for more
           information on the connection between this volume type
           and PersistentVolumeClaim).
        Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that
        persist for longer than the lifecycle of an individual pod.
        Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to
        be used that way - see the documentation of the driver for more information.
        A pod can use both types of ephemeral volumes and persistent volumes at the
        same time.
        This is a beta feature and only available when the GenericEphemeralVolume
        feature gate is enabled.
      * **fc** ``Optional[FCVolumeSource]`` - FC represents a Fibre Channel resource that is attached to a kubelet's host
        machine and then exposed to the pod.
      * **flexVolume** ``Optional[FlexVolumeSource]`` - FlexVolume represents a generic volume resource that is provisioned/attached
        using an exec based plugin.
      * **flocker** ``Optional[FlockerVolumeSource]`` - Flocker represents a Flocker volume attached to a kubelet's host machine. This
        depends on the Flocker control service being running
      * **gcePersistentDisk** ``Optional[GCEPersistentDiskVolumeSource]`` - GCEPersistentDisk represents a GCE Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **gitRepo** ``Optional[GitRepoVolumeSource]`` - GitRepo represents a git repository at a particular revision. DEPRECATED:
        GitRepo is deprecated. To provision a container with a git repo, mount an
        EmptyDir into an InitContainer that clones the repo using git, then mount the
        EmptyDir into the Pod's container.
      * **glusterfs** ``Optional[GlusterfsVolumeSource]`` - Glusterfs represents a Glusterfs mount on the host that shares a pod's
        lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
      * **hostPath** ``Optional[HostPathVolumeSource]`` - HostPath represents a pre-existing file or directory on the host machine that
        is directly exposed to the container. This is generally used for system agents
        or other privileged things that are allowed to see the host machine. Most
        containers will NOT need this. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
      * **iscsi** ``Optional[ISCSIVolumeSource]`` - ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host
        machine and then exposed to the pod. More info:
        https://examples.k8s.io/volumes/iscsi/README.md
      * **nfs** ``Optional[NFSVolumeSource]`` - NFS represents an NFS mount on the host that shares a pod's lifetime More
        info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **persistentVolumeClaim** ``Optional[PersistentVolumeClaimVolumeSource]`` - PersistentVolumeClaimVolumeSource represents a reference to a
        PersistentVolumeClaim in the same namespace. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **photonPersistentDisk** ``Optional[PhotonPersistentDiskVolumeSource]`` - PhotonPersistentDisk represents a PhotonController persistent disk attached
        and mounted on kubelets host machine
      * **portworxVolume** ``Optional[PortworxVolumeSource]`` - PortworxVolume represents a portworx volume attached and mounted on kubelets
        host machine
      * **projected** ``Optional[ProjectedVolumeSource]`` - Items for all in one resources secrets, configmaps, and downward API
      * **quobyte** ``Optional[QuobyteVolumeSource]`` - Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
      * **rbd** ``Optional[RBDVolumeSource]`` - RBD represents a Rados Block Device mount on the host that shares a pod's
        lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
      * **scaleIO** ``Optional[ScaleIOVolumeSource]`` - ScaleIO represents a ScaleIO persistent volume attached and mounted on
        Kubernetes nodes.
      * **secret** ``Optional[SecretVolumeSource]`` - Secret represents a secret that should populate this volume. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#secret
      * **storageos** ``Optional[StorageOSVolumeSource]`` - StorageOS represents a StorageOS volume attached and mounted on Kubernetes
        nodes.
      * **vsphereVolume** ``Optional[VsphereVirtualDiskVolumeSource]`` - VsphereVolume represents a vSphere volume attached and mounted on kubelets
        host machine
    """
    name: 'str'
    awsElasticBlockStore: 'Optional[AWSElasticBlockStoreVolumeSource]' = None
    azureDisk: 'Optional[AzureDiskVolumeSource]' = None
    azureFile: 'Optional[AzureFileVolumeSource]' = None
    cephfs: 'Optional[CephFSVolumeSource]' = None
    cinder: 'Optional[CinderVolumeSource]' = None
    configMap: 'Optional[ConfigMapVolumeSource]' = None
    csi: 'Optional[CSIVolumeSource]' = None
    downwardAPI: 'Optional[DownwardAPIVolumeSource]' = None
    emptyDir: 'Optional[EmptyDirVolumeSource]' = None
    ephemeral: 'Optional[EphemeralVolumeSource]' = None
    fc: 'Optional[FCVolumeSource]' = None
    flexVolume: 'Optional[FlexVolumeSource]' = None
    flocker: 'Optional[FlockerVolumeSource]' = None
    gcePersistentDisk: 'Optional[GCEPersistentDiskVolumeSource]' = None
    gitRepo: 'Optional[GitRepoVolumeSource]' = None
    glusterfs: 'Optional[GlusterfsVolumeSource]' = None
    hostPath: 'Optional[HostPathVolumeSource]' = None
    iscsi: 'Optional[ISCSIVolumeSource]' = None
    nfs: 'Optional[NFSVolumeSource]' = None
    persistentVolumeClaim: 'Optional[PersistentVolumeClaimVolumeSource]' = None
    photonPersistentDisk: 'Optional[PhotonPersistentDiskVolumeSource]' = None
    portworxVolume: 'Optional[PortworxVolumeSource]' = None
    projected: 'Optional[ProjectedVolumeSource]' = None
    quobyte: 'Optional[QuobyteVolumeSource]' = None
    rbd: 'Optional[RBDVolumeSource]' = None
    scaleIO: 'Optional[ScaleIOVolumeSource]' = None
    secret: 'Optional[SecretVolumeSource]' = None
    storageos: 'Optional[StorageOSVolumeSource]' = None
    vsphereVolume: 'Optional[VsphereVirtualDiskVolumeSource]' = None


@dataclass
class VolumeDevice(DictMixin):
    """volumeDevice describes a mapping of a raw block device within a container.

      **parameters**

      * **devicePath** ``str`` - devicePath is the path inside of the container that the device will be mapped
        to.
      * **name** ``str`` - name must match the name of a persistentVolumeClaim in the pod
    """
    devicePath: 'str'
    name: 'str'


@dataclass
class VolumeMount(DictMixin):
    """VolumeMount describes a mounting of a Volume within a container.

      **parameters**

      * **mountPath** ``str`` - Path within the container at which the volume should be mounted.  Must not
        contain ':'.
      * **name** ``str`` - This must match the Name of a Volume.
      * **mountPropagation** ``Optional[str]`` - mountPropagation determines how mounts are propagated from the host to
        container and the other way around. When not set, MountPropagationNone is
        used. This field is beta in 1.10.
      * **readOnly** ``Optional[bool]`` - Mounted read-only if true, read-write otherwise (false or unspecified).
        Defaults to false.
      * **subPath** ``Optional[str]`` - Path within the volume from which the container's volume should be mounted.
        Defaults to "" (volume's root).
      * **subPathExpr** ``Optional[str]`` - Expanded path within the volume from which the container's volume should be
        mounted. Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root). SubPathExpr and SubPath are mutually exclusive.
    """
    mountPath: 'str'
    name: 'str'
    mountPropagation: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None
    subPath: 'Optional[str]' = None
    subPathExpr: 'Optional[str]' = None


@dataclass
class VolumeNodeAffinity(DictMixin):
    """VolumeNodeAffinity defines constraints that limit what nodes this volume can
      be accessed from.

      **parameters**

      * **required** ``Optional[NodeSelector]`` - Required specifies hard node constraints that must be met.
    """
    required: 'Optional[NodeSelector]' = None


@dataclass
class VolumeProjection(DictMixin):
    """Projection that may be projected along with other supported volume types

      **parameters**

      * **configMap** ``Optional[ConfigMapProjection]`` - information about the configMap data to project
      * **downwardAPI** ``Optional[DownwardAPIProjection]`` - information about the downwardAPI data to project
      * **secret** ``Optional[SecretProjection]`` - information about the secret data to project
      * **serviceAccountToken** ``Optional[ServiceAccountTokenProjection]`` - information about the serviceAccountToken data to project
    """
    configMap: 'Optional[ConfigMapProjection]' = None
    downwardAPI: 'Optional[DownwardAPIProjection]' = None
    secret: 'Optional[SecretProjection]' = None
    serviceAccountToken: 'Optional[ServiceAccountTokenProjection]' = None


@dataclass
class VsphereVirtualDiskVolumeSource(DictMixin):
    """Represents a vSphere volume resource.

      **parameters**

      * **volumePath** ``str`` - Path that identifies vSphere volume vmdk
      * **fsType** ``Optional[str]`` - Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **storagePolicyID** ``Optional[str]`` - Storage Policy Based Management (SPBM) profile ID associated with the
        StoragePolicyName.
      * **storagePolicyName** ``Optional[str]`` - Storage Policy Based Management (SPBM) profile name.
    """
    volumePath: 'str'
    fsType: 'Optional[str]' = None
    storagePolicyID: 'Optional[str]' = None
    storagePolicyName: 'Optional[str]' = None


@dataclass
class WeightedPodAffinityTerm(DictMixin):
    """The weights of all of the matched WeightedPodAffinityTerm fields are added
      per-node to find the most preferred node(s)

      **parameters**

      * **podAffinityTerm** ``PodAffinityTerm`` - Required. A pod affinity term, associated with the corresponding weight.
      * **weight** ``int`` - weight associated with matching the corresponding podAffinityTerm, in the
        range 1-100.
    """
    podAffinityTerm: 'PodAffinityTerm'
    weight: 'int'


@dataclass
class WindowsSecurityContextOptions(DictMixin):
    """WindowsSecurityContextOptions contain Windows-specific options and
      credentials.

      **parameters**

      * **gmsaCredentialSpec** ``Optional[str]`` - GMSACredentialSpec is where the GMSA admission webhook
        (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the
        GMSA credential spec named by the GMSACredentialSpecName field.
      * **gmsaCredentialSpecName** ``Optional[str]`` - GMSACredentialSpecName is the name of the GMSA credential spec to use.
      * **hostProcess** ``Optional[bool]`` - HostProcess determines if a container should be run as a 'Host Process'
        container. This field is alpha-level and will only be honored by components
        that enable the WindowsHostProcessContainers feature flag. Setting this field
        without the feature flag will result in errors when validating the Pod. All of
        a Pod's containers must have the same effective HostProcess value (it is not
        allowed to have a mix of HostProcess containers and non-HostProcess
        containers).  In addition, if HostProcess is true then HostNetwork must also
        be set to true.
      * **runAsUserName** ``Optional[str]`` - The UserName in Windows to run the entrypoint of the container process.
        Defaults to the user specified in image metadata if unspecified. May also be
        set in PodSecurityContext. If set in both SecurityContext and
        PodSecurityContext, the value specified in SecurityContext takes precedence.
    """
    gmsaCredentialSpec: 'Optional[str]' = None
    gmsaCredentialSpecName: 'Optional[str]' = None
    hostProcess: 'Optional[bool]' = None
    runAsUserName: 'Optional[str]' = None


