# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class Lease(DictMixin):
    """Lease defines a lease concept.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[LeaseSpec]`` - Specification of the Lease. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[LeaseSpec]' = None


@dataclass
class LeaseList(DictMixin):
    """LeaseList is a list of Lease objects.

      **parameters**

      * **items** ``List[Lease]`` - Items is a list of schema objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[Lease]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class LeaseSpec(DictMixin):
    """LeaseSpec is a specification of a Lease.

      **parameters**

      * **acquireTime** ``Optional[meta_v1.MicroTime]`` - acquireTime is a time when the current lease was acquired.
      * **holderIdentity** ``Optional[str]`` - holderIdentity contains the identity of the holder of a current lease.
      * **leaseDurationSeconds** ``Optional[int]`` - leaseDurationSeconds is a duration that candidates for a lease need to wait to
        force acquire it. This is measure against time of last observed RenewTime.
      * **leaseTransitions** ``Optional[int]`` - leaseTransitions is the number of transitions of a lease between holders.
      * **renewTime** ``Optional[meta_v1.MicroTime]`` - renewTime is a time when the current holder of a lease has last updated the
        lease.
    """
    acquireTime: 'Optional[meta_v1.MicroTime]' = None
    holderIdentity: 'Optional[str]' = None
    leaseDurationSeconds: 'Optional[int]' = None
    leaseTransitions: 'Optional[int]' = None
    renewTime: 'Optional[meta_v1.MicroTime]' = None


