# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1
from . import batch_v1


@dataclass
class CronJob(DictMixin):
    """CronJob represents the configuration of a single cron job.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[CronJobSpec]`` - Specification of the desired behavior of a cron job, including the schedule.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[CronJobStatus]`` - Current status of a cron job. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[CronJobSpec]' = None
    status: 'Optional[CronJobStatus]' = None


@dataclass
class CronJobList(DictMixin):
    """CronJobList is a collection of cron jobs.

      **parameters**

      * **items** ``List[CronJob]`` - items is the list of CronJobs.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[CronJob]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class CronJobSpec(DictMixin):
    """CronJobSpec describes how the job execution will look like and when it will
      actually run.

      **parameters**

      * **jobTemplate** ``JobTemplateSpec`` - Specifies the job that will be created when executing a CronJob.
      * **schedule** ``str`` - The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
      * **concurrencyPolicy** ``Optional[str]`` - Specifies how to treat concurrent executions of a Job. Valid values are: -
        "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids
        concurrent runs, skipping next run if previous run hasn't finished yet; -
        "Replace": cancels currently running job and replaces it with a new one
      * **failedJobsHistoryLimit** ``Optional[int]`` - The number of failed finished jobs to retain. This is a pointer to distinguish
        between explicit zero and not specified. Defaults to 1.
      * **startingDeadlineSeconds** ``Optional[int]`` - Optional deadline in seconds for starting the job if it misses scheduled time
        for any reason.  Missed jobs executions will be counted as failed ones.
      * **successfulJobsHistoryLimit** ``Optional[int]`` - The number of successful finished jobs to retain. This is a pointer to
        distinguish between explicit zero and not specified. Defaults to 3.
      * **suspend** ``Optional[bool]`` - This flag tells the controller to suspend subsequent executions, it does not
        apply to already started executions.  Defaults to false.
    """
    jobTemplate: 'JobTemplateSpec'
    schedule: 'str'
    concurrencyPolicy: 'Optional[str]' = None
    failedJobsHistoryLimit: 'Optional[int]' = None
    startingDeadlineSeconds: 'Optional[int]' = None
    successfulJobsHistoryLimit: 'Optional[int]' = None
    suspend: 'Optional[bool]' = None


@dataclass
class CronJobStatus(DictMixin):
    """CronJobStatus represents the current state of a cron job.

      **parameters**

      * **active** ``Optional[List[core_v1.ObjectReference]]`` - A list of pointers to currently running jobs.
      * **lastScheduleTime** ``Optional[meta_v1.Time]`` - Information when was the last time the job was successfully scheduled.
      * **lastSuccessfulTime** ``Optional[meta_v1.Time]`` - Information when was the last time the job successfully completed.
    """
    active: 'Optional[List[core_v1.ObjectReference]]' = None
    lastScheduleTime: 'Optional[meta_v1.Time]' = None
    lastSuccessfulTime: 'Optional[meta_v1.Time]' = None


@dataclass
class JobTemplateSpec(DictMixin):
    """JobTemplateSpec describes the data a Job should have when created from a
      template

      **parameters**

      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata of the jobs created from this template. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[batch_v1.JobSpec]`` - Specification of the desired behavior of the job. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[batch_v1.JobSpec]' = None


