# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1


@dataclass
class CronJob(DictMixin):
    """CronJob represents the configuration of a single cron job.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[CronJobSpec]`` - Specification of the desired behavior of a cron job, including the schedule.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[CronJobStatus]`` - Current status of a cron job. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[CronJobSpec]' = None
    status: 'Optional[CronJobStatus]' = None


@dataclass
class CronJobList(DictMixin):
    """CronJobList is a collection of cron jobs.

      **parameters**

      * **items** ``List[CronJob]`` - items is the list of CronJobs.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[CronJob]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class CronJobSpec(DictMixin):
    """CronJobSpec describes how the job execution will look like and when it will
      actually run.

      **parameters**

      * **jobTemplate** ``JobTemplateSpec`` - Specifies the job that will be created when executing a CronJob.
      * **schedule** ``str`` - The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
      * **concurrencyPolicy** ``Optional[str]`` - Specifies how to treat concurrent executions of a Job. Valid values are: -
        "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids
        concurrent runs, skipping next run if previous run hasn't finished yet; -
        "Replace": cancels currently running job and replaces it with a new one
      * **failedJobsHistoryLimit** ``Optional[int]`` - The number of failed finished jobs to retain. Value must be non-negative
        integer. Defaults to 1.
      * **startingDeadlineSeconds** ``Optional[int]`` - Optional deadline in seconds for starting the job if it misses scheduled time
        for any reason.  Missed jobs executions will be counted as failed ones.
      * **successfulJobsHistoryLimit** ``Optional[int]`` - The number of successful finished jobs to retain. Value must be non-negative
        integer. Defaults to 3.
      * **suspend** ``Optional[bool]`` - This flag tells the controller to suspend subsequent executions, it does not
        apply to already started executions.  Defaults to false.
    """
    jobTemplate: 'JobTemplateSpec'
    schedule: 'str'
    concurrencyPolicy: 'Optional[str]' = None
    failedJobsHistoryLimit: 'Optional[int]' = None
    startingDeadlineSeconds: 'Optional[int]' = None
    successfulJobsHistoryLimit: 'Optional[int]' = None
    suspend: 'Optional[bool]' = None


@dataclass
class CronJobStatus(DictMixin):
    """CronJobStatus represents the current state of a cron job.

      **parameters**

      * **active** ``Optional[List[core_v1.ObjectReference]]`` - A list of pointers to currently running jobs.
      * **lastScheduleTime** ``Optional[meta_v1.Time]`` - Information when was the last time the job was successfully scheduled.
      * **lastSuccessfulTime** ``Optional[meta_v1.Time]`` - Information when was the last time the job successfully completed.
    """
    active: 'Optional[List[core_v1.ObjectReference]]' = None
    lastScheduleTime: 'Optional[meta_v1.Time]' = None
    lastSuccessfulTime: 'Optional[meta_v1.Time]' = None


@dataclass
class Job(DictMixin):
    """Job represents the configuration of a single job.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[JobSpec]`` - Specification of the desired behavior of a job. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[JobStatus]`` - Current status of a job. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[JobSpec]' = None
    status: 'Optional[JobStatus]' = None


@dataclass
class JobCondition(DictMixin):
    """JobCondition describes current state of a job.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of job condition, Complete or Failed.
      * **lastProbeTime** ``Optional[meta_v1.Time]`` - Last time the condition was checked.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transit from one status to another.
      * **message** ``Optional[str]`` - Human readable message indicating details about last transition.
      * **reason** ``Optional[str]`` - (brief) reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastProbeTime: 'Optional[meta_v1.Time]' = None
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class JobList(DictMixin):
    """JobList is a collection of jobs.

      **parameters**

      * **items** ``List[Job]`` - items is the list of Jobs.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[Job]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class JobSpec(DictMixin):
    """JobSpec describes how the job execution will look like.

      **parameters**

      * **template** ``core_v1.PodTemplateSpec`` - Describes the pod that will be created when executing a job. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **activeDeadlineSeconds** ``Optional[int]`` - Specifies the duration in seconds relative to the startTime that the job may
        be continuously active before the system tries to terminate it; value must be
        positive integer. If a Job is suspended (at creation or through an update),
        this timer will effectively be stopped and reset when the Job is resumed
        again.
      * **backoffLimit** ``Optional[int]`` - Specifies the number of retries before marking this job failed. Defaults to 6
      * **completionMode** ``Optional[str]`` - CompletionMode specifies how Pod completions are tracked. It can be
        `NonIndexed` (default) or `Indexed`.
        `NonIndexed` means that the Job is considered complete when there have been
        .spec.completions successfully completed Pods. Each Pod completion is
        homologous to each other.
        `Indexed` means that the Pods of a Job get an associated completion index from
        0 to (.spec.completions - 1), available in the annotation
        batch.kubernetes.io/job-completion-index. The Job is considered complete when
        there is one successfully completed Pod for each index. When value is
        `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be
        less than or equal to 10^5. In addition, The Pod name takes the form
        `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form
        `$(job-name)-$(index)`.
        This field is beta-level. More completion modes can be added in the future. If
        the Job controller observes a mode that it doesn't recognize, the controller
        skips updates for the Job.
      * **completions** ``Optional[int]`` - Specifies the desired number of successfully finished pods the job should be
        run with.  Setting to nil means that the success of any pod signals the
        success of all pods, and allows parallelism to have any positive value.
        Setting to 1 means that parallelism is limited to 1 and the success of that
        pod signals the success of the job. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **manualSelector** ``Optional[bool]`` - manualSelector controls generation of pod labels and pod selectors. Leave
        `manualSelector` unset unless you are certain what you are doing. When false
        or unset, the system pick labels unique to this job and appends those labels
        to the pod template.  When true, the user is responsible for picking unique
        labels and specifying the selector.  Failure to pick a unique label may cause
        this and other jobs to not function correctly.  However, You may see
        `manualSelector=true` in jobs that were created with the old
        `extensions/v1beta1` API. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
      * **parallelism** ``Optional[int]`` - Specifies the maximum desired number of pods the job should run at any given
        time. The actual number of pods running in steady state will be less than this
        number when ((.spec.completions - .status.successful) < .spec.parallelism),
        i.e. when the work left to do is less than max parallelism. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **selector** ``Optional[meta_v1.LabelSelector]`` - A label query over pods that should match the pod count. Normally, the system
        sets this field for you. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **suspend** ``Optional[bool]`` - Suspend specifies whether the Job controller should create Pods or not. If a
        Job is created with suspend set to true, no Pods are created by the Job
        controller. If a Job is suspended after creation (i.e. the flag goes from
        false to true), the Job controller will delete all active Pods associated with
        this Job. Users must design their workload to gracefully handle this.
        Suspending a Job will reset the StartTime field of the Job, effectively
        resetting the ActiveDeadlineSeconds timer too. Defaults to false.
        This field is beta-level, gated by SuspendJob feature flag (enabled by
        default).
      * **ttlSecondsAfterFinished** ``Optional[int]`` - ttlSecondsAfterFinished limits the lifetime of a Job that has finished
        execution (either Complete or Failed). If this field is set,
        ttlSecondsAfterFinished after the Job finishes, it is eligible to be
        automatically deleted. When the Job is being deleted, its lifecycle guarantees
        (e.g. finalizers) will be honored. If this field is unset, the Job won't be
        automatically deleted. If this field is set to zero, the Job becomes eligible
        to be deleted immediately after it finishes. This field is alpha-level and is
        only honored by servers that enable the TTLAfterFinished feature.
    """
    template: 'core_v1.PodTemplateSpec'
    activeDeadlineSeconds: 'Optional[int]' = None
    backoffLimit: 'Optional[int]' = None
    completionMode: 'Optional[str]' = None
    completions: 'Optional[int]' = None
    manualSelector: 'Optional[bool]' = None
    parallelism: 'Optional[int]' = None
    selector: 'Optional[meta_v1.LabelSelector]' = None
    suspend: 'Optional[bool]' = None
    ttlSecondsAfterFinished: 'Optional[int]' = None


@dataclass
class JobStatus(DictMixin):
    """JobStatus represents the current state of a Job.

      **parameters**

      * **active** ``Optional[int]`` - The number of actively running pods.
      * **completedIndexes** ``Optional[str]`` - CompletedIndexes holds the completed indexes when .spec.completionMode =
        "Indexed" in a text format. The indexes are represented as decimal integers
        separated by commas. The numbers are listed in increasing order. Three or more
        consecutive numbers are compressed and represented by the first and last
        element of the series, separated by a hyphen. For example, if the completed
        indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
      * **completionTime** ``Optional[meta_v1.Time]`` - Represents time when the job was completed. It is not guaranteed to be set in
        happens-before order across separate operations. It is represented in RFC3339
        form and is in UTC. The completion time is only set when the job finishes
        successfully.
      * **conditions** ``Optional[List[JobCondition]]`` - The latest available observations of an object's current state. When a Job
        fails, one of the conditions will have type "Failed" and status true. When a
        Job is suspended, one of the conditions will have type "Suspended" and status
        true; when the Job is resumed, the status of this condition will become false.
        When a Job is completed, one of the conditions will have type "Complete" and
        status true. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
      * **failed** ``Optional[int]`` - The number of pods which reached phase Failed.
      * **startTime** ``Optional[meta_v1.Time]`` - Represents time when the job controller started processing a job. When a Job
        is created in the suspended state, this field is not set until the first time
        it is resumed. This field is reset every time a Job is resumed from
        suspension. It is represented in RFC3339 form and is in UTC.
      * **succeeded** ``Optional[int]`` - The number of pods which reached phase Succeeded.
      * **uncountedTerminatedPods** ``Optional[UncountedTerminatedPods]`` - UncountedTerminatedPods holds the UIDs of Pods that have terminated but the
        job controller hasn't yet accounted for in the status counters.
        The job controller creates pods with a finalizer. When a pod terminates
        (succeeded or failed), the controller does three steps to account for it in
        the job status: (1) Add the pod UID to the arrays in this field. (2) Remove
        the pod finalizer. (3) Remove the pod UID from the arrays while increasing the
        corresponding
            counter.
        This field is alpha-level. The job controller only makes use of this field
        when the feature gate PodTrackingWithFinalizers is enabled. Old jobs might not
        be tracked using this field, in which case the field remains null.
    """
    active: 'Optional[int]' = None
    completedIndexes: 'Optional[str]' = None
    completionTime: 'Optional[meta_v1.Time]' = None
    conditions: 'Optional[List[JobCondition]]' = None
    failed: 'Optional[int]' = None
    startTime: 'Optional[meta_v1.Time]' = None
    succeeded: 'Optional[int]' = None
    uncountedTerminatedPods: 'Optional[UncountedTerminatedPods]' = None


@dataclass
class JobTemplateSpec(DictMixin):
    """JobTemplateSpec describes the data a Job should have when created from a
      template

      **parameters**

      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata of the jobs created from this template. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[JobSpec]`` - Specification of the desired behavior of the job. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[JobSpec]' = None


@dataclass
class UncountedTerminatedPods(DictMixin):
    """UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't
      been accounted in Job status counters.

      **parameters**

      * **failed** ``Optional[List[str]]`` - Failed holds UIDs of failed Pods.
      * **succeeded** ``Optional[List[str]]`` - Succeeded holds UIDs of succeeded Pods.
    """
    failed: 'Optional[List[str]]' = None
    succeeded: 'Optional[List[str]]' = None


