# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import resource


@dataclass
class ContainerResourceMetricSource(DictMixin):
    """ContainerResourceMetricSource indicates how to scale on a resource metric
      known to Kubernetes, as specified in requests and limits, describing each pod
      in the current scale target (e.g. CPU or memory).  The values will be averaged
      together before being compared to the target.  Such metrics are built in to
      Kubernetes, and have special scaling options on top of those available to
      normal per-pod metrics using the "pods" source.  Only one "target" type should
      be set.

      **parameters**

      * **container** ``str`` - container is the name of the container in the pods of the scaling target
      * **name** ``str`` - name is the name of the resource in question.
      * **targetAverageUtilization** ``Optional[int]`` - targetAverageUtilization is the target value of the average of the resource
        metric across all relevant pods, represented as a percentage of the requested
        value of the resource for the pods.
      * **targetAverageValue** ``Optional[resource.Quantity]`` - targetAverageValue is the target value of the average of the resource metric
        across all relevant pods, as a raw value (instead of as a percentage of the
        request), similar to the "pods" metric source type.
    """
    container: 'str'
    name: 'str'
    targetAverageUtilization: 'Optional[int]' = None
    targetAverageValue: 'Optional[resource.Quantity]' = None


@dataclass
class ContainerResourceMetricStatus(DictMixin):
    """ContainerResourceMetricStatus indicates the current value of a resource metric
      known to Kubernetes, as specified in requests and limits, describing a single
      container in each pod in the current scale target (e.g. CPU or memory).  Such
      metrics are built in to Kubernetes, and have special scaling options on top of
      those available to normal per-pod metrics using the "pods" source.

      **parameters**

      * **container** ``str`` - container is the name of the container in the pods of the scaling target
      * **currentAverageValue** ``resource.Quantity`` - currentAverageValue is the current value of the average of the resource metric
        across all relevant pods, as a raw value (instead of as a percentage of the
        request), similar to the "pods" metric source type. It will always be set,
        regardless of the corresponding metric specification.
      * **name** ``str`` - name is the name of the resource in question.
      * **currentAverageUtilization** ``Optional[int]`` - currentAverageUtilization is the current value of the average of the resource
        metric across all relevant pods, represented as a percentage of the requested
        value of the resource for the pods.  It will only be present if
        `targetAverageValue` was set in the corresponding metric specification.
    """
    container: 'str'
    currentAverageValue: 'resource.Quantity'
    name: 'str'
    currentAverageUtilization: 'Optional[int]' = None


@dataclass
class CrossVersionObjectReference(DictMixin):
    """CrossVersionObjectReference contains enough information to let you identify
      the referred resource.

      **parameters**

      * **kind** ``str`` - Kind of the referent; More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
      * **name** ``str`` - Name of the referent; More info:
        http://kubernetes.io/docs/user-guide/identifiers#names
      * **apiVersion** ``Optional[str]`` - API version of the referent
    """
    kind: 'str'
    name: 'str'
    apiVersion: 'Optional[str]' = None


@dataclass
class ExternalMetricSource(DictMixin):
    """ExternalMetricSource indicates how to scale on a metric not associated with
      any Kubernetes object (for example length of queue in cloud messaging service,
      or QPS from loadbalancer running outside of cluster). Exactly one "target"
      type should be set.

      **parameters**

      * **metricName** ``str`` - metricName is the name of the metric in question.
      * **metricSelector** ``Optional[meta_v1.LabelSelector]`` - metricSelector is used to identify a specific time series within a given
        metric.
      * **targetAverageValue** ``Optional[resource.Quantity]`` - targetAverageValue is the target per-pod value of global metric (as a
        quantity). Mutually exclusive with TargetValue.
      * **targetValue** ``Optional[resource.Quantity]`` - targetValue is the target value of the metric (as a quantity). Mutually
        exclusive with TargetAverageValue.
    """
    metricName: 'str'
    metricSelector: 'Optional[meta_v1.LabelSelector]' = None
    targetAverageValue: 'Optional[resource.Quantity]' = None
    targetValue: 'Optional[resource.Quantity]' = None


@dataclass
class ExternalMetricStatus(DictMixin):
    """ExternalMetricStatus indicates the current value of a global metric not
      associated with any Kubernetes object.

      **parameters**

      * **currentValue** ``resource.Quantity`` - currentValue is the current value of the metric (as a quantity)
      * **metricName** ``str`` - metricName is the name of a metric used for autoscaling in metric system.
      * **currentAverageValue** ``Optional[resource.Quantity]`` - currentAverageValue is the current value of metric averaged over autoscaled
        pods.
      * **metricSelector** ``Optional[meta_v1.LabelSelector]`` - metricSelector is used to identify a specific time series within a given
        metric.
    """
    currentValue: 'resource.Quantity'
    metricName: 'str'
    currentAverageValue: 'Optional[resource.Quantity]' = None
    metricSelector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class HorizontalPodAutoscaler(DictMixin):
    """HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler,
      which automatically manages the replica count of any resource implementing the
      scale subresource based on the metrics specified.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - metadata is the standard object metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[HorizontalPodAutoscalerSpec]`` - spec is the specification for the behaviour of the autoscaler. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
      * **status** ``Optional[HorizontalPodAutoscalerStatus]`` - status is the current information about the autoscaler.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[HorizontalPodAutoscalerSpec]' = None
    status: 'Optional[HorizontalPodAutoscalerStatus]' = None


@dataclass
class HorizontalPodAutoscalerCondition(DictMixin):
    """HorizontalPodAutoscalerCondition describes the state of a
      HorizontalPodAutoscaler at a certain point.

      **parameters**

      * **status** ``str`` - status is the status of the condition (True, False, Unknown)
      * **type** ``str`` - type describes the current condition
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - lastTransitionTime is the last time the condition transitioned from one status
        to another
      * **message** ``Optional[str]`` - message is a human-readable explanation containing details about the
        transition
      * **reason** ``Optional[str]`` - reason is the reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class HorizontalPodAutoscalerList(DictMixin):
    """HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.

      **parameters**

      * **items** ``List[HorizontalPodAutoscaler]`` - items is the list of horizontal pod autoscaler objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - metadata is the standard list metadata.
    """
    items: 'List[HorizontalPodAutoscaler]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class HorizontalPodAutoscalerSpec(DictMixin):
    """HorizontalPodAutoscalerSpec describes the desired functionality of the
      HorizontalPodAutoscaler.

      **parameters**

      * **maxReplicas** ``int`` - maxReplicas is the upper limit for the number of replicas to which the
        autoscaler can scale up. It cannot be less that minReplicas.
      * **scaleTargetRef** ``CrossVersionObjectReference`` - scaleTargetRef points to the target resource to scale, and is used to the pods
        for which metrics should be collected, as well as to actually change the
        replica count.
      * **metrics** ``Optional[List[MetricSpec]]`` - metrics contains the specifications for which to use to calculate the desired
        replica count (the maximum replica count across all metrics will be used).
        The desired replica count is calculated multiplying the ratio between the
        target value and the current value by the current number of pods.  Ergo,
        metrics used must decrease as the pod count is increased, and vice-versa.  See
        the individual metric source types for more information about how each type of
        metric must respond.
      * **minReplicas** ``Optional[int]`` - minReplicas is the lower limit for the number of replicas to which the
        autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to
        be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one
        Object or External metric is configured.  Scaling is active as long as at
        least one metric value is available.
    """
    maxReplicas: 'int'
    scaleTargetRef: 'CrossVersionObjectReference'
    metrics: 'Optional[List[MetricSpec]]' = None
    minReplicas: 'Optional[int]' = None


@dataclass
class HorizontalPodAutoscalerStatus(DictMixin):
    """HorizontalPodAutoscalerStatus describes the current status of a horizontal pod
      autoscaler.

      **parameters**

      * **conditions** ``List[HorizontalPodAutoscalerCondition]`` - conditions is the set of conditions required for this autoscaler to scale its
        target, and indicates whether or not those conditions are met.
      * **currentReplicas** ``int`` - currentReplicas is current number of replicas of pods managed by this
        autoscaler, as last seen by the autoscaler.
      * **desiredReplicas** ``int`` - desiredReplicas is the desired number of replicas of pods managed by this
        autoscaler, as last calculated by the autoscaler.
      * **currentMetrics** ``Optional[List[MetricStatus]]`` - currentMetrics is the last read state of the metrics used by this autoscaler.
      * **lastScaleTime** ``Optional[meta_v1.Time]`` - lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number
        of pods, used by the autoscaler to control how often the number of pods is
        changed.
      * **observedGeneration** ``Optional[int]`` - observedGeneration is the most recent generation observed by this autoscaler.
    """
    conditions: 'List[HorizontalPodAutoscalerCondition]'
    currentReplicas: 'int'
    desiredReplicas: 'int'
    currentMetrics: 'Optional[List[MetricStatus]]' = None
    lastScaleTime: 'Optional[meta_v1.Time]' = None
    observedGeneration: 'Optional[int]' = None


@dataclass
class MetricSpec(DictMixin):
    """MetricSpec specifies how to scale based on a single metric (only `type` and
      one other matching field should be set at once).

      **parameters**

      * **type** ``str`` - type is the type of metric source.  It should be one of "ContainerResource",
        "External", "Object", "Pods" or "Resource", each mapping to a matching field
        in the object. Note: "ContainerResource" type is available on when the
        feature-gate HPAContainerMetrics is enabled
      * **containerResource** ``Optional[ContainerResourceMetricSource]`` - container resource refers to a resource metric (such as those specified in
        requests and limits) known to Kubernetes describing a single container in each
        pod of the current scale target (e.g. CPU or memory). Such metrics are built
        in to Kubernetes, and have special scaling options on top of those available
        to normal per-pod metrics using the "pods" source. This is an alpha feature
        and can be enabled by the HPAContainerMetrics feature flag.
      * **external** ``Optional[ExternalMetricSource]`` - external refers to a global metric that is not associated with any Kubernetes
        object. It allows autoscaling based on information coming from components
        running outside of cluster (for example length of queue in cloud messaging
        service, or QPS from loadbalancer running outside of cluster).
      * **object** ``Optional[ObjectMetricSource]`` - object refers to a metric describing a single kubernetes object (for example,
        hits-per-second on an Ingress object).
      * **pods** ``Optional[PodsMetricSource]`` - pods refers to a metric describing each pod in the current scale target (for
        example, transactions-processed-per-second).  The values will be averaged
        together before being compared to the target value.
      * **resource** ``Optional[ResourceMetricSource]`` - resource refers to a resource metric (such as those specified in requests and
        limits) known to Kubernetes describing each pod in the current scale target
        (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have
        special scaling options on top of those available to normal per-pod metrics
        using the "pods" source.
    """
    type: 'str'
    containerResource: 'Optional[ContainerResourceMetricSource]' = None
    external: 'Optional[ExternalMetricSource]' = None
    object: 'Optional[ObjectMetricSource]' = None
    pods: 'Optional[PodsMetricSource]' = None
    resource: 'Optional[ResourceMetricSource]' = None


@dataclass
class MetricStatus(DictMixin):
    """MetricStatus describes the last-read state of a single metric.

      **parameters**

      * **type** ``str`` - type is the type of metric source.  It will be one of "ContainerResource",
        "External", "Object", "Pods" or "Resource", each corresponds to a matching
        field in the object. Note: "ContainerResource" type is available on when the
        feature-gate HPAContainerMetrics is enabled
      * **containerResource** ``Optional[ContainerResourceMetricStatus]`` - container resource refers to a resource metric (such as those specified in
        requests and limits) known to Kubernetes describing a single container in each
        pod in the current scale target (e.g. CPU or memory). Such metrics are built
        in to Kubernetes, and have special scaling options on top of those available
        to normal per-pod metrics using the "pods" source.
      * **external** ``Optional[ExternalMetricStatus]`` - external refers to a global metric that is not associated with any Kubernetes
        object. It allows autoscaling based on information coming from components
        running outside of cluster (for example length of queue in cloud messaging
        service, or QPS from loadbalancer running outside of cluster).
      * **object** ``Optional[ObjectMetricStatus]`` - object refers to a metric describing a single kubernetes object (for example,
        hits-per-second on an Ingress object).
      * **pods** ``Optional[PodsMetricStatus]`` - pods refers to a metric describing each pod in the current scale target (for
        example, transactions-processed-per-second).  The values will be averaged
        together before being compared to the target value.
      * **resource** ``Optional[ResourceMetricStatus]`` - resource refers to a resource metric (such as those specified in requests and
        limits) known to Kubernetes describing each pod in the current scale target
        (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have
        special scaling options on top of those available to normal per-pod metrics
        using the "pods" source.
    """
    type: 'str'
    containerResource: 'Optional[ContainerResourceMetricStatus]' = None
    external: 'Optional[ExternalMetricStatus]' = None
    object: 'Optional[ObjectMetricStatus]' = None
    pods: 'Optional[PodsMetricStatus]' = None
    resource: 'Optional[ResourceMetricStatus]' = None


@dataclass
class ObjectMetricSource(DictMixin):
    """ObjectMetricSource indicates how to scale on a metric describing a kubernetes
      object (for example, hits-per-second on an Ingress object).

      **parameters**

      * **metricName** ``str`` - metricName is the name of the metric in question.
      * **target** ``CrossVersionObjectReference`` - target is the described Kubernetes object.
      * **targetValue** ``resource.Quantity`` - targetValue is the target value of the metric (as a quantity).
      * **averageValue** ``Optional[resource.Quantity]`` - averageValue is the target value of the average of the metric across all
        relevant pods (as a quantity)
      * **selector** ``Optional[meta_v1.LabelSelector]`` - selector is the string-encoded form of a standard kubernetes label selector
        for the given metric When set, it is passed as an additional parameter to the
        metrics server for more specific metrics scoping When unset, just the
        metricName will be used to gather metrics.
    """
    metricName: 'str'
    target: 'CrossVersionObjectReference'
    targetValue: 'resource.Quantity'
    averageValue: 'Optional[resource.Quantity]' = None
    selector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class ObjectMetricStatus(DictMixin):
    """ObjectMetricStatus indicates the current value of a metric describing a
      kubernetes object (for example, hits-per-second on an Ingress object).

      **parameters**

      * **currentValue** ``resource.Quantity`` - currentValue is the current value of the metric (as a quantity).
      * **metricName** ``str`` - metricName is the name of the metric in question.
      * **target** ``CrossVersionObjectReference`` - target is the described Kubernetes object.
      * **averageValue** ``Optional[resource.Quantity]`` - averageValue is the current value of the average of the metric across all
        relevant pods (as a quantity)
      * **selector** ``Optional[meta_v1.LabelSelector]`` - selector is the string-encoded form of a standard kubernetes label selector
        for the given metric When set in the ObjectMetricSource, it is passed as an
        additional parameter to the metrics server for more specific metrics scoping.
        When unset, just the metricName will be used to gather metrics.
    """
    currentValue: 'resource.Quantity'
    metricName: 'str'
    target: 'CrossVersionObjectReference'
    averageValue: 'Optional[resource.Quantity]' = None
    selector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class PodsMetricSource(DictMixin):
    """PodsMetricSource indicates how to scale on a metric describing each pod in the
      current scale target (for example, transactions-processed-per-second). The
      values will be averaged together before being compared to the target value.

      **parameters**

      * **metricName** ``str`` - metricName is the name of the metric in question
      * **targetAverageValue** ``resource.Quantity`` - targetAverageValue is the target value of the average of the metric across all
        relevant pods (as a quantity)
      * **selector** ``Optional[meta_v1.LabelSelector]`` - selector is the string-encoded form of a standard kubernetes label selector
        for the given metric When set, it is passed as an additional parameter to the
        metrics server for more specific metrics scoping When unset, just the
        metricName will be used to gather metrics.
    """
    metricName: 'str'
    targetAverageValue: 'resource.Quantity'
    selector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class PodsMetricStatus(DictMixin):
    """PodsMetricStatus indicates the current value of a metric describing each pod
      in the current scale target (for example, transactions-processed-per-second).

      **parameters**

      * **currentAverageValue** ``resource.Quantity`` - currentAverageValue is the current value of the average of the metric across
        all relevant pods (as a quantity)
      * **metricName** ``str`` - metricName is the name of the metric in question
      * **selector** ``Optional[meta_v1.LabelSelector]`` - selector is the string-encoded form of a standard kubernetes label selector
        for the given metric When set in the PodsMetricSource, it is passed as an
        additional parameter to the metrics server for more specific metrics scoping.
        When unset, just the metricName will be used to gather metrics.
    """
    currentAverageValue: 'resource.Quantity'
    metricName: 'str'
    selector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class ResourceMetricSource(DictMixin):
    """ResourceMetricSource indicates how to scale on a resource metric known to
      Kubernetes, as specified in requests and limits, describing each pod in the
      current scale target (e.g. CPU or memory).  The values will be averaged
      together before being compared to the target.  Such metrics are built in to
      Kubernetes, and have special scaling options on top of those available to
      normal per-pod metrics using the "pods" source.  Only one "target" type should
      be set.

      **parameters**

      * **name** ``str`` - name is the name of the resource in question.
      * **targetAverageUtilization** ``Optional[int]`` - targetAverageUtilization is the target value of the average of the resource
        metric across all relevant pods, represented as a percentage of the requested
        value of the resource for the pods.
      * **targetAverageValue** ``Optional[resource.Quantity]`` - targetAverageValue is the target value of the average of the resource metric
        across all relevant pods, as a raw value (instead of as a percentage of the
        request), similar to the "pods" metric source type.
    """
    name: 'str'
    targetAverageUtilization: 'Optional[int]' = None
    targetAverageValue: 'Optional[resource.Quantity]' = None


@dataclass
class ResourceMetricStatus(DictMixin):
    """ResourceMetricStatus indicates the current value of a resource metric known to
      Kubernetes, as specified in requests and limits, describing each pod in the
      current scale target (e.g. CPU or memory).  Such metrics are built in to
      Kubernetes, and have special scaling options on top of those available to
      normal per-pod metrics using the "pods" source.

      **parameters**

      * **currentAverageValue** ``resource.Quantity`` - currentAverageValue is the current value of the average of the resource metric
        across all relevant pods, as a raw value (instead of as a percentage of the
        request), similar to the "pods" metric source type. It will always be set,
        regardless of the corresponding metric specification.
      * **name** ``str`` - name is the name of the resource in question.
      * **currentAverageUtilization** ``Optional[int]`` - currentAverageUtilization is the current value of the average of the resource
        metric across all relevant pods, represented as a percentage of the requested
        value of the resource for the pods.  It will only be present if
        `targetAverageValue` was set in the corresponding metric specification.
    """
    currentAverageValue: 'resource.Quantity'
    name: 'str'
    currentAverageUtilization: 'Optional[int]' = None


