# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1
from . import runtime
from . import util_intstr


@dataclass
class ControllerRevision(DictMixin):
    """ControllerRevision implements an immutable snapshot of state data. Clients are
      responsible for serializing and deserializing the objects that contain their
      internal state. Once a ControllerRevision has been successfully created, it
      can not be updated. The API Server will fail validation of all requests that
      attempt to mutate the Data field. ControllerRevisions may, however, be
      deleted. Note that, due to its use by both the DaemonSet and StatefulSet
      controllers for update and rollback, this object is beta. However, it may be
      subject to name and representation changes in future releases, and clients
      should not depend on its stability. It is primarily for internal use by
      controllers.

      **parameters**

      * **revision** ``int`` - Revision indicates the revision of the state represented by Data.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **data** ``Optional[runtime.RawExtension]`` - Data is the serialized representation of the state.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    revision: 'int'
    apiVersion: 'Optional[str]' = None
    data: 'Optional[runtime.RawExtension]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class ControllerRevisionList(DictMixin):
    """ControllerRevisionList is a resource containing a list of ControllerRevision
      objects.

      **parameters**

      * **items** ``List[ControllerRevision]`` - Items is the list of ControllerRevisions
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[ControllerRevision]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class DaemonSet(DictMixin):
    """DaemonSet represents the configuration of a daemon set.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[DaemonSetSpec]`` - The desired behavior of this daemon set. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[DaemonSetStatus]`` - The current status of this daemon set. This data may be out of date by some
        window of time. Populated by the system. Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[DaemonSetSpec]' = None
    status: 'Optional[DaemonSetStatus]' = None


@dataclass
class DaemonSetCondition(DictMixin):
    """DaemonSetCondition describes the state of a DaemonSet at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of DaemonSet condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transitioned from one status to another.
      * **message** ``Optional[str]`` - A human readable message indicating details about the transition.
      * **reason** ``Optional[str]`` - The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class DaemonSetList(DictMixin):
    """DaemonSetList is a collection of daemon sets.

      **parameters**

      * **items** ``List[DaemonSet]`` - A list of daemon sets.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[DaemonSet]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class DaemonSetSpec(DictMixin):
    """DaemonSetSpec is the specification of a daemon set.

      **parameters**

      * **selector** ``meta_v1.LabelSelector`` - A label query over pods that are managed by the daemon set. Must match in
        order to be controlled. It must match the pod template's labels. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **template** ``core_v1.PodTemplateSpec`` - An object that describes the pod that will be created. The DaemonSet will
        create exactly one copy of this pod on every node that matches the template's
        node selector (or on every node if no node selector is specified). More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
      * **minReadySeconds** ``Optional[int]`` - The minimum number of seconds for which a newly created DaemonSet pod should
        be ready without any of its container crashing, for it to be considered
        available. Defaults to 0 (pod will be considered available as soon as it is
        ready).
      * **revisionHistoryLimit** ``Optional[int]`` - The number of old history to retain to allow rollback. This is a pointer to
        distinguish between explicit zero and not specified. Defaults to 10.
      * **updateStrategy** ``Optional[DaemonSetUpdateStrategy]`` - An update strategy to replace existing DaemonSet pods with new pods.
    """
    selector: 'meta_v1.LabelSelector'
    template: 'core_v1.PodTemplateSpec'
    minReadySeconds: 'Optional[int]' = None
    revisionHistoryLimit: 'Optional[int]' = None
    updateStrategy: 'Optional[DaemonSetUpdateStrategy]' = None


@dataclass
class DaemonSetStatus(DictMixin):
    """DaemonSetStatus represents the current status of a daemon set.

      **parameters**

      * **currentNumberScheduled** ``int`` - The number of nodes that are running at least 1 daemon pod and are supposed to
        run the daemon pod. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
      * **desiredNumberScheduled** ``int`` - The total number of nodes that should be running the daemon pod (including
        nodes correctly running the daemon pod). More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
      * **numberMisscheduled** ``int`` - The number of nodes that are running the daemon pod, but are not supposed to
        run the daemon pod. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
      * **numberReady** ``int`` - The number of nodes that should be running the daemon pod and have one or more
        of the daemon pod running and ready.
      * **collisionCount** ``Optional[int]`` - Count of hash collisions for the DaemonSet. The DaemonSet controller uses this
        field as a collision avoidance mechanism when it needs to create the name for
        the newest ControllerRevision.
      * **conditions** ``Optional[List[DaemonSetCondition]]`` - Represents the latest available observations of a DaemonSet's current state.
      * **numberAvailable** ``Optional[int]`` - The number of nodes that should be running the daemon pod and have one or more
        of the daemon pod running and available (ready for at least
        spec.minReadySeconds)
      * **numberUnavailable** ``Optional[int]`` - The number of nodes that should be running the daemon pod and have none of the
        daemon pod running and available (ready for at least spec.minReadySeconds)
      * **observedGeneration** ``Optional[int]`` - The most recent generation observed by the daemon set controller.
      * **updatedNumberScheduled** ``Optional[int]`` - The total number of nodes that are running updated daemon pod
    """
    currentNumberScheduled: 'int'
    desiredNumberScheduled: 'int'
    numberMisscheduled: 'int'
    numberReady: 'int'
    collisionCount: 'Optional[int]' = None
    conditions: 'Optional[List[DaemonSetCondition]]' = None
    numberAvailable: 'Optional[int]' = None
    numberUnavailable: 'Optional[int]' = None
    observedGeneration: 'Optional[int]' = None
    updatedNumberScheduled: 'Optional[int]' = None


@dataclass
class DaemonSetUpdateStrategy(DictMixin):
    """DaemonSetUpdateStrategy is a struct used to control the update strategy for a
      DaemonSet.

      **parameters**

      * **rollingUpdate** ``Optional[RollingUpdateDaemonSet]`` - Rolling update config params. Present only if type = "RollingUpdate".
      * **type** ``Optional[str]`` - Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is
        RollingUpdate.
    """
    rollingUpdate: 'Optional[RollingUpdateDaemonSet]' = None
    type: 'Optional[str]' = None


@dataclass
class Deployment(DictMixin):
    """Deployment enables declarative updates for Pods and ReplicaSets.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[DeploymentSpec]`` - Specification of the desired behavior of the Deployment.
      * **status** ``Optional[DeploymentStatus]`` - Most recently observed status of the Deployment.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[DeploymentSpec]' = None
    status: 'Optional[DeploymentStatus]' = None


@dataclass
class DeploymentCondition(DictMixin):
    """DeploymentCondition describes the state of a deployment at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of deployment condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transitioned from one status to another.
      * **lastUpdateTime** ``Optional[meta_v1.Time]`` - The last time this condition was updated.
      * **message** ``Optional[str]`` - A human readable message indicating details about the transition.
      * **reason** ``Optional[str]`` - The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    lastUpdateTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class DeploymentList(DictMixin):
    """DeploymentList is a list of Deployments.

      **parameters**

      * **items** ``List[Deployment]`` - Items is the list of Deployments.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata.
    """
    items: 'List[Deployment]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class DeploymentSpec(DictMixin):
    """DeploymentSpec is the specification of the desired behavior of the Deployment.

      **parameters**

      * **selector** ``meta_v1.LabelSelector`` - Label selector for pods. Existing ReplicaSets whose pods are selected by this
        will be the ones affected by this deployment. It must match the pod template's
        labels.
      * **template** ``core_v1.PodTemplateSpec`` - Template describes the pods that will be created.
      * **minReadySeconds** ``Optional[int]`` - Minimum number of seconds for which a newly created pod should be ready
        without any of its container crashing, for it to be considered available.
        Defaults to 0 (pod will be considered available as soon as it is ready)
      * **paused** ``Optional[bool]`` - Indicates that the deployment is paused.
      * **progressDeadlineSeconds** ``Optional[int]`` - The maximum time in seconds for a deployment to make progress before it is
        considered to be failed. The deployment controller will continue to process
        failed deployments and a condition with a ProgressDeadlineExceeded reason will
        be surfaced in the deployment status. Note that progress will not be estimated
        during the time a deployment is paused. Defaults to 600s.
      * **replicas** ``Optional[int]`` - Number of desired pods. This is a pointer to distinguish between explicit zero
        and not specified. Defaults to 1.
      * **revisionHistoryLimit** ``Optional[int]`` - The number of old ReplicaSets to retain to allow rollback. This is a pointer
        to distinguish between explicit zero and not specified. Defaults to 10.
      * **strategy** ``Optional[DeploymentStrategy]`` - The deployment strategy to use to replace existing pods with new ones.
    """
    selector: 'meta_v1.LabelSelector'
    template: 'core_v1.PodTemplateSpec'
    minReadySeconds: 'Optional[int]' = None
    paused: 'Optional[bool]' = None
    progressDeadlineSeconds: 'Optional[int]' = None
    replicas: 'Optional[int]' = None
    revisionHistoryLimit: 'Optional[int]' = None
    strategy: 'Optional[DeploymentStrategy]' = None


@dataclass
class DeploymentStatus(DictMixin):
    """DeploymentStatus is the most recently observed status of the Deployment.

      **parameters**

      * **availableReplicas** ``Optional[int]`` - Total number of available pods (ready for at least minReadySeconds) targeted
        by this deployment.
      * **collisionCount** ``Optional[int]`` - Count of hash collisions for the Deployment. The Deployment controller uses
        this field as a collision avoidance mechanism when it needs to create the name
        for the newest ReplicaSet.
      * **conditions** ``Optional[List[DeploymentCondition]]`` - Represents the latest available observations of a deployment's current state.
      * **observedGeneration** ``Optional[int]`` - The generation observed by the deployment controller.
      * **readyReplicas** ``Optional[int]`` - Total number of ready pods targeted by this deployment.
      * **replicas** ``Optional[int]`` - Total number of non-terminated pods targeted by this deployment (their labels
        match the selector).
      * **unavailableReplicas** ``Optional[int]`` - Total number of unavailable pods targeted by this deployment. This is the
        total number of pods that are still required for the deployment to have 100%
        available capacity. They may either be pods that are running but not yet
        available or pods that still have not been created.
      * **updatedReplicas** ``Optional[int]`` - Total number of non-terminated pods targeted by this deployment that have the
        desired template spec.
    """
    availableReplicas: 'Optional[int]' = None
    collisionCount: 'Optional[int]' = None
    conditions: 'Optional[List[DeploymentCondition]]' = None
    observedGeneration: 'Optional[int]' = None
    readyReplicas: 'Optional[int]' = None
    replicas: 'Optional[int]' = None
    unavailableReplicas: 'Optional[int]' = None
    updatedReplicas: 'Optional[int]' = None


@dataclass
class DeploymentStrategy(DictMixin):
    """DeploymentStrategy describes how to replace existing pods with new ones.

      **parameters**

      * **rollingUpdate** ``Optional[RollingUpdateDeployment]`` - Rolling update config params. Present only if DeploymentStrategyType =
        RollingUpdate.
      * **type** ``Optional[str]`` - Type of deployment. Can be "Recreate" or "RollingUpdate". Default is
        RollingUpdate.
    """
    rollingUpdate: 'Optional[RollingUpdateDeployment]' = None
    type: 'Optional[str]' = None


@dataclass
class ReplicaSet(DictMixin):
    """ReplicaSet ensures that a specified number of pod replicas are running at any
      given time.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - If the Labels of a ReplicaSet are empty, they are defaulted to be the same as
        the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[ReplicaSetSpec]`` - Spec defines the specification of the desired behavior of the ReplicaSet. More
        info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[ReplicaSetStatus]`` - Status is the most recently observed status of the ReplicaSet. This data may
        be out of date by some window of time. Populated by the system. Read-only.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[ReplicaSetSpec]' = None
    status: 'Optional[ReplicaSetStatus]' = None


@dataclass
class ReplicaSetCondition(DictMixin):
    """ReplicaSetCondition describes the state of a replica set at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of replica set condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - The last time the condition transitioned from one status to another.
      * **message** ``Optional[str]`` - A human readable message indicating details about the transition.
      * **reason** ``Optional[str]`` - The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class ReplicaSetList(DictMixin):
    """ReplicaSetList is a collection of ReplicaSets.

      **parameters**

      * **items** ``List[ReplicaSet]`` - List of ReplicaSets. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ReplicaSet]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class ReplicaSetSpec(DictMixin):
    """ReplicaSetSpec is the specification of a ReplicaSet.

      **parameters**

      * **selector** ``meta_v1.LabelSelector`` - Selector is a label query over pods that should match the replica count. Label
        keys and values that must match in order to be controlled by this replica set.
        It must match the pod template's labels. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **minReadySeconds** ``Optional[int]`` - Minimum number of seconds for which a newly created pod should be ready
        without any of its container crashing, for it to be considered available.
        Defaults to 0 (pod will be considered available as soon as it is ready)
      * **replicas** ``Optional[int]`` - Replicas is the number of desired replicas. This is a pointer to distinguish
        between explicit zero and unspecified. Defaults to 1. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
      * **template** ``Optional[core_v1.PodTemplateSpec]`` - Template is the object that describes the pod that will be created if
        insufficient replicas are detected. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
    """
    selector: 'meta_v1.LabelSelector'
    minReadySeconds: 'Optional[int]' = None
    replicas: 'Optional[int]' = None
    template: 'Optional[core_v1.PodTemplateSpec]' = None


@dataclass
class ReplicaSetStatus(DictMixin):
    """ReplicaSetStatus represents the current status of a ReplicaSet.

      **parameters**

      * **replicas** ``int`` - Replicas is the most recently oberved number of replicas. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
      * **availableReplicas** ``Optional[int]`` - The number of available replicas (ready for at least minReadySeconds) for this
        replica set.
      * **conditions** ``Optional[List[ReplicaSetCondition]]`` - Represents the latest available observations of a replica set's current state.
      * **fullyLabeledReplicas** ``Optional[int]`` - The number of pods that have labels matching the labels of the pod template of
        the replicaset.
      * **observedGeneration** ``Optional[int]`` - ObservedGeneration reflects the generation of the most recently observed
        ReplicaSet.
      * **readyReplicas** ``Optional[int]`` - The number of ready replicas for this replica set.
    """
    replicas: 'int'
    availableReplicas: 'Optional[int]' = None
    conditions: 'Optional[List[ReplicaSetCondition]]' = None
    fullyLabeledReplicas: 'Optional[int]' = None
    observedGeneration: 'Optional[int]' = None
    readyReplicas: 'Optional[int]' = None


@dataclass
class RollingUpdateDaemonSet(DictMixin):
    """Spec to control the desired behavior of daemon set rolling update.

      **parameters**

      * **maxSurge** ``Optional[util_intstr.IntOrString]`` - The maximum number of nodes with an existing available DaemonSet pod that can
        have an updated DaemonSet pod during during an update. Value can be an
        absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can
        not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage
        by rounding up to a minimum of 1. Default value is 0. Example: when this is
        set to 30%, at most 30% of the total number of nodes that should be running
        the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod
        created before the old pod is marked as deleted. The update starts by
        launching new pods on 30% of nodes. Once an updated pod is available (Ready
        for at least minReadySeconds) the old DaemonSet pod on that node is marked
        deleted. If the old pod becomes unavailable for any reason (Ready transitions
        to false, is evicted, or is drained) an updated pod is immediatedly created on
        that node without considering surge limits. Allowing surge implies the
        possibility that the resources consumed by the daemonset on any given node can
        double if the readiness check fails, and so resource intensive daemonsets
        should take into account that they may cause evictions during disruption. This
        is beta field and enabled/disabled by DaemonSetUpdateSurge feature gate.
      * **maxUnavailable** ``Optional[util_intstr.IntOrString]`` - The maximum number of DaemonSet pods that can be unavailable during the
        update. Value can be an absolute number (ex: 5) or a percentage of total
        number of DaemonSet pods at the start of the update (ex: 10%). Absolute number
        is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is
        0 Default value is 1. Example: when this is set to 30%, at most 30% of the
        total number of nodes that should be running the daemon pod (i.e.
        status.desiredNumberScheduled) can have their pods stopped for an update at
        any given time. The update starts by stopping at most 30% of those DaemonSet
        pods and then brings up new DaemonSet pods in their place. Once the new pods
        are available, it then proceeds onto other DaemonSet pods, thus ensuring that
        at least 70% of original number of DaemonSet pods are available at all times
        during the update.
    """
    maxSurge: 'Optional[util_intstr.IntOrString]' = None
    maxUnavailable: 'Optional[util_intstr.IntOrString]' = None


@dataclass
class RollingUpdateDeployment(DictMixin):
    """Spec to control the desired behavior of rolling update.

      **parameters**

      * **maxSurge** ``Optional[util_intstr.IntOrString]`` - The maximum number of pods that can be scheduled above the desired number of
        pods. Value can be an absolute number (ex: 5) or a percentage of desired pods
        (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is
        calculated from percentage by rounding up. Defaults to 25%. Example: when this
        is set to 30%, the new ReplicaSet can be scaled up immediately when the
        rolling update starts, such that the total number of old and new pods do not
        exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet
        can be scaled up further, ensuring that total number of pods running at any
        time during the update is at most 130% of desired pods.
      * **maxUnavailable** ``Optional[util_intstr.IntOrString]`` - The maximum number of pods that can be unavailable during the update. Value
        can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding down. This can not
        be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the
        old ReplicaSet can be scaled down to 70% of desired pods immediately when the
        rolling update starts. Once new pods are ready, old ReplicaSet can be scaled
        down further, followed by scaling up the new ReplicaSet, ensuring that the
        total number of pods available at all times during the update is at least 70%
        of desired pods.
    """
    maxSurge: 'Optional[util_intstr.IntOrString]' = None
    maxUnavailable: 'Optional[util_intstr.IntOrString]' = None


@dataclass
class RollingUpdateStatefulSetStrategy(DictMixin):
    """RollingUpdateStatefulSetStrategy is used to communicate parameter for
      RollingUpdateStatefulSetStrategyType.

      **parameters**

      * **partition** ``Optional[int]`` - Partition indicates the ordinal at which the StatefulSet should be
        partitioned. Default value is 0.
    """
    partition: 'Optional[int]' = None


@dataclass
class StatefulSet(DictMixin):
    """StatefulSet represents a set of pods with consistent identities. Identities
      are defined as:
       - Network: A single stable DNS and hostname.
       - Storage: As many VolumeClaims as requested.
      The StatefulSet guarantees that a given network identity will always map to
      the same storage identity.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[StatefulSetSpec]`` - Spec defines the desired identities of pods in this set.
      * **status** ``Optional[StatefulSetStatus]`` - Status is the current status of Pods in this StatefulSet. This data may be out
        of date by some window of time.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[StatefulSetSpec]' = None
    status: 'Optional[StatefulSetStatus]' = None


@dataclass
class StatefulSetCondition(DictMixin):
    """StatefulSetCondition describes the state of a statefulset at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of statefulset condition.
      * **lastTransitionTime** ``Optional[meta_v1.Time]`` - Last time the condition transitioned from one status to another.
      * **message** ``Optional[str]`` - A human readable message indicating details about the transition.
      * **reason** ``Optional[str]`` - The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class StatefulSetList(DictMixin):
    """StatefulSetList is a collection of StatefulSets.

      **parameters**

      * **items** ``List[StatefulSet]`` - Items is the list of stateful sets.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[StatefulSet]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class StatefulSetSpec(DictMixin):
    """A StatefulSetSpec is the specification of a StatefulSet.

      **parameters**

      * **selector** ``meta_v1.LabelSelector`` - selector is a label query over pods that should match the replica count. It
        must match the pod template's labels. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **serviceName** ``str`` - serviceName is the name of the service that governs this StatefulSet. This
        service must exist before the StatefulSet, and is responsible for the network
        identity of the set. Pods get DNS/hostnames that follow the pattern:
        pod-specific-string.serviceName.default.svc.cluster.local where
        "pod-specific-string" is managed by the StatefulSet controller.
      * **template** ``core_v1.PodTemplateSpec`` - template is the object that describes the pod that will be created if
        insufficient replicas are detected. Each pod stamped out by the StatefulSet
        will fulfill this Template, but have a unique identity from the rest of the
        StatefulSet.
      * **minReadySeconds** ``Optional[int]`` - Minimum number of seconds for which a newly created pod should be ready
        without any of its container crashing for it to be considered available.
        Defaults to 0 (pod will be considered available as soon as it is ready) This
        is an alpha field and requires enabling StatefulSetMinReadySeconds feature
        gate.
      * **podManagementPolicy** ``Optional[str]`` - podManagementPolicy controls how pods are created during initial scale up,
        when replacing pods on nodes, or when scaling down. The default policy is
        `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1,
        etc) and the controller will wait until each pod is ready before continuing.
        When scaling down, the pods are removed in the opposite order. The alternative
        policy is `Parallel` which will create pods in parallel to match the desired
        scale without waiting, and on scale down will delete all pods at once.
      * **replicas** ``Optional[int]`` - replicas is the desired number of replicas of the given Template. These are
        replicas in the sense that they are instantiations of the same Template, but
        individual replicas also have a consistent identity. If unspecified, defaults
        to 1.
      * **revisionHistoryLimit** ``Optional[int]`` - revisionHistoryLimit is the maximum number of revisions that will be
        maintained in the StatefulSet's revision history. The revision history
        consists of all revisions not represented by a currently applied
        StatefulSetSpec version. The default value is 10.
      * **updateStrategy** ``Optional[StatefulSetUpdateStrategy]`` - updateStrategy indicates the StatefulSetUpdateStrategy that will be employed
        to update Pods in the StatefulSet when a revision is made to Template.
      * **volumeClaimTemplates** ``Optional[List[core_v1.PersistentVolumeClaim]]`` - volumeClaimTemplates is a list of claims that pods are allowed to reference.
        The StatefulSet controller is responsible for mapping network identities to
        claims in a way that maintains the identity of a pod. Every claim in this list
        must have at least one matching (by name) volumeMount in one container in the
        template. A claim in this list takes precedence over any volumes in the
        template, with the same name.
    """
    selector: 'meta_v1.LabelSelector'
    serviceName: 'str'
    template: 'core_v1.PodTemplateSpec'
    minReadySeconds: 'Optional[int]' = None
    podManagementPolicy: 'Optional[str]' = None
    replicas: 'Optional[int]' = None
    revisionHistoryLimit: 'Optional[int]' = None
    updateStrategy: 'Optional[StatefulSetUpdateStrategy]' = None
    volumeClaimTemplates: 'Optional[List[core_v1.PersistentVolumeClaim]]' = None


@dataclass
class StatefulSetStatus(DictMixin):
    """StatefulSetStatus represents the current state of a StatefulSet.

      **parameters**

      * **replicas** ``int`` - replicas is the number of Pods created by the StatefulSet controller.
      * **availableReplicas** ``Optional[int]`` - Total number of available pods (ready for at least minReadySeconds) targeted
        by this statefulset. This is an alpha field and requires enabling
        StatefulSetMinReadySeconds feature gate. Remove omitempty when graduating to
        beta
      * **collisionCount** ``Optional[int]`` - collisionCount is the count of hash collisions for the StatefulSet. The
        StatefulSet controller uses this field as a collision avoidance mechanism when
        it needs to create the name for the newest ControllerRevision.
      * **conditions** ``Optional[List[StatefulSetCondition]]`` - Represents the latest available observations of a statefulset's current state.
      * **currentReplicas** ``Optional[int]`` - currentReplicas is the number of Pods created by the StatefulSet controller
        from the StatefulSet version indicated by currentRevision.
      * **currentRevision** ``Optional[str]`` - currentRevision, if not empty, indicates the version of the StatefulSet used
        to generate Pods in the sequence [0,currentReplicas).
      * **observedGeneration** ``Optional[int]`` - observedGeneration is the most recent generation observed for this
        StatefulSet. It corresponds to the StatefulSet's generation, which is updated
        on mutation by the API Server.
      * **readyReplicas** ``Optional[int]`` - readyReplicas is the number of Pods created by the StatefulSet controller that
        have a Ready Condition.
      * **updateRevision** ``Optional[str]`` - updateRevision, if not empty, indicates the version of the StatefulSet used to
        generate Pods in the sequence [replicas-updatedReplicas,replicas)
      * **updatedReplicas** ``Optional[int]`` - updatedReplicas is the number of Pods created by the StatefulSet controller
        from the StatefulSet version indicated by updateRevision.
    """
    replicas: 'int'
    availableReplicas: 'Optional[int]' = None
    collisionCount: 'Optional[int]' = None
    conditions: 'Optional[List[StatefulSetCondition]]' = None
    currentReplicas: 'Optional[int]' = None
    currentRevision: 'Optional[str]' = None
    observedGeneration: 'Optional[int]' = None
    readyReplicas: 'Optional[int]' = None
    updateRevision: 'Optional[str]' = None
    updatedReplicas: 'Optional[int]' = None


@dataclass
class StatefulSetUpdateStrategy(DictMixin):
    """StatefulSetUpdateStrategy indicates the strategy that the StatefulSet
      controller will use to perform updates. It includes any additional parameters
      necessary to perform the update for the indicated strategy.

      **parameters**

      * **rollingUpdate** ``Optional[RollingUpdateStatefulSetStrategy]`` - RollingUpdate is used to communicate parameters when Type is
        RollingUpdateStatefulSetStrategyType.
      * **type** ``Optional[str]`` - Type indicates the type of the StatefulSetUpdateStrategy. Default is
        RollingUpdate.
    """
    rollingUpdate: 'Optional[RollingUpdateStatefulSetStrategy]' = None
    type: 'Optional[str]' = None


