/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataOutputStream;
import ibis.io.DummyOutputStream;
import ibis.io.IbisIOException;
import ibis.io.Replacer;
import ibis.io.SerializationOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class SunSerializationOutputStream
extends ObjectOutputStream
implements SerializationOutput {
    private Replacer replacer;
    private OutputStream out;

    public SunSerializationOutputStream(OutputStream out) throws IOException {
        super(new DummyOutputStream(out));
        this.out = out;
        this.flush();
    }

    public SunSerializationOutputStream(DataOutputStream out) throws IOException {
        super(new DummyOutputStream(out));
        this.out = out;
        this.flush();
    }

    @Override
    public void reset(boolean cleartypes) throws IOException {
        this.reset();
    }

    @Override
    public String serializationImplName() {
        return "sun";
    }

    @Override
    public boolean reInitOnNewConnection() {
        return true;
    }

    @Override
    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            boolean[] temp = new boolean[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            byte[] temp = new byte[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(short[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            short[] temp = new short[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(char[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            char[] temp = new char[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(int[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            int[] temp = new int[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(long[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            long[] temp = new long[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(float[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            float[] temp = new float[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(double[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            double[] temp = new double[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(Object[] ref, int off, int len) throws IOException {
        if (off == 0 && len == ref.length) {
            this.writeUnshared(ref);
        } else {
            Object[] temp = new Object[len];
            System.arraycopy(ref, off, temp, 0, len);
            this.writeObject(temp);
        }
    }

    @Override
    public void writeArray(boolean[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(byte[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(short[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(char[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(int[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(long[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(float[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(double[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeArray(Object[] ref) throws IOException {
        this.writeUnshared(ref);
    }

    @Override
    public void writeString(String ref) throws IOException {
        this.writeObject(ref);
    }

    @Override
    public void writeShort(short r) throws IOException {
        super.writeShort(r);
    }

    @Override
    public void writeChar(char r) throws IOException {
        super.writeChar(r);
    }

    @Override
    public void writeByte(byte r) throws IOException {
        super.writeByte(r);
    }

    @Override
    public void statistics() {
    }

    @Override
    public void realClose() throws IOException {
        this.close();
        this.out.close();
    }

    @Override
    public void setReplacer(Replacer replacer) throws IOException {
        try {
            this.enableReplaceObject(true);
        }
        catch (Throwable e) {
            throw new IbisIOException("enableReplaceObject threw exception: ", e);
        }
        this.replacer = replacer;
    }

    @Override
    protected Object replaceObject(Object obj) {
        if (obj != null && this.replacer != null) {
            obj = this.replacer.replace(obj);
        }
        return obj;
    }

    @Override
    public void writeByteBuffer(ByteBuffer value) throws IOException {
        int len = value.limit() - value.position();
        if (value.hasArray()) {
            this.writeArray(value.array(), value.arrayOffset(), len);
        } else {
            byte[] temp = new byte[len];
            value.get(temp);
            this.writeArray(temp);
        }
    }
}

