/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.ByteSerializationInputStream;
import ibis.io.DataInputStream;
import ibis.io.IOProperties;
import ibis.io.SerializationError;
import ibis.io.SerializationTimer;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSerializationInputStream
extends ByteSerializationInputStream {
    private static Logger logger = LoggerFactory.getLogger(DataSerializationInputStream.class);
    private static final boolean NO_ARRAY_BUFFERS = IOProperties.properties.getBooleanProperty("ibis.io.noarraybuffers");
    private static final boolean TIME_DATA_SERIALIZATION = IOProperties.properties.getBooleanProperty("ibis.io.serialization.timer.data") || IOProperties.properties.getBooleanProperty("ibis.io.serialization.timer.ibis");
    static final int TYPE_ARRAY = 1;
    private static final boolean DEBUG = IOProperties.DEBUG;
    private short[] indices_short;
    private byte[] byte_buffer;
    private char[] char_buffer;
    private short[] short_buffer;
    private int[] int_buffer;
    private long[] long_buffer;
    private float[] float_buffer;
    private double[] double_buffer;
    private int byte_index;
    private int char_index;
    private int short_index;
    private int int_index;
    private int long_index;
    private int float_index;
    private int double_index;
    private int array_index;
    private int max_byte_index;
    private int max_char_index;
    private int max_short_index;
    private int max_int_index;
    private int max_long_index;
    private int max_float_index;
    private int max_double_index;
    private int max_array_index;
    private final int BYTE_BUFFER_SIZE;
    private final int CHAR_BUFFER_SIZE;
    private final int SHORT_BUFFER_SIZE;
    private final int INT_BUFFER_SIZE;
    private final int LONG_BUFFER_SIZE;
    private final int FLOAT_BUFFER_SIZE;
    private final int DOUBLE_BUFFER_SIZE;
    final SerializationTimer timer;

    static int typedBufferSize(int bufferSize, int elSize) {
        return (bufferSize - 16) / elSize;
    }

    public DataSerializationInputStream(DataInputStream in) throws IOException {
        super(in);
        int bufferSize = in.bufferSize();
        if (bufferSize <= 0) {
            bufferSize = IOProperties.TYPED_BUFFER_SIZE;
        }
        this.BYTE_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 1);
        this.CHAR_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 2);
        this.SHORT_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 2);
        this.INT_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 4);
        this.LONG_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 8);
        this.FLOAT_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 4);
        this.DOUBLE_BUFFER_SIZE = DataSerializationInputStream.typedBufferSize(bufferSize, 8);
        if (!NO_ARRAY_BUFFERS) {
            this.initArrays();
        }
        this.timer = TIME_DATA_SERIALIZATION ? new SerializationTimer(this.toString()) : null;
    }

    protected DataSerializationInputStream() throws IOException {
        this.BYTE_BUFFER_SIZE = 0;
        this.CHAR_BUFFER_SIZE = 0;
        this.SHORT_BUFFER_SIZE = 0;
        this.INT_BUFFER_SIZE = 0;
        this.LONG_BUFFER_SIZE = 0;
        this.FLOAT_BUFFER_SIZE = 0;
        this.DOUBLE_BUFFER_SIZE = 0;
        this.timer = TIME_DATA_SERIALIZATION ? new SerializationTimer(this.toString()) : null;
    }

    @Override
    public String serializationImplName() {
        return "data";
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readBoolean();
        } else {
            while (this.byte_index == this.max_byte_index) {
                this.receive();
            }
            boolean bl = a = this.byte_buffer[this.byte_index++] != 0;
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read boolean: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public byte readByte() throws IOException {
        byte a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readByte();
        } else {
            while (this.byte_index == this.max_byte_index) {
                this.receive();
            }
            a = this.byte_buffer[this.byte_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read byte: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public char readChar() throws IOException {
        char a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readChar();
        } else {
            while (this.char_index == this.max_char_index) {
                this.receive();
            }
            a = this.char_buffer[this.char_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read char: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public short readShort() throws IOException {
        short a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readShort();
        } else {
            while (this.short_index == this.max_short_index) {
                this.receive();
            }
            a = this.short_buffer[this.short_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read short: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public int readInt() throws IOException {
        int a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readInt();
        } else {
            while (this.int_index == this.max_int_index) {
                this.receive();
            }
            a = this.int_buffer[this.int_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read int[HEX]: " + a + "[0x" + Integer.toHexString(a) + "]");
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public long readLong() throws IOException {
        long a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readLong();
        } else {
            while (this.long_index == this.max_long_index) {
                this.receive();
            }
            a = this.long_buffer[this.long_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read long: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public float readFloat() throws IOException {
        float a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readFloat();
        } else {
            while (this.float_index == this.max_float_index) {
                this.receive();
            }
            a = this.float_buffer[this.float_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read float: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    @Override
    public double readDouble() throws IOException {
        double a;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        if (NO_ARRAY_BUFFERS) {
            a = this.in.readDouble();
        } else {
            while (this.double_index == this.max_double_index) {
                this.receive();
            }
            a = this.double_buffer[this.double_index++];
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read double: " + a);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        return a;
    }

    protected void readBooleanArray(boolean[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 1) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayBoolean: offset: " + off + " len: " + len + " type: " + 1);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readBoolean();
            }
        }
    }

    protected void readByteArray(byte[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 1) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayByte: offset: " + off + " len: " + len + " type: " + 2);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readByte();
            }
        }
    }

    protected void internalReadByteBuffer(ByteBuffer value) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readByteBuffer(value);
        } else {
            int len = value.limit() - value.position();
            if (len >= IOProperties.SMALL_ARRAY_BOUND / 1) {
                while (this.array_index == this.max_array_index) {
                    this.receive();
                }
                ++this.array_index;
                this.in.readByteBuffer(value);
            } else {
                for (int i = 0; i < len; ++i) {
                    value.put(this.readByte());
                }
            }
        }
    }

    protected void readCharArray(char[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 2) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayChar: offset: " + off + " len: " + len + " type: " + 3);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readChar();
            }
        }
    }

    protected void readShortArray(short[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 2) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayShort: offset: " + off + " len: " + len + " type: " + 4);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readShort();
            }
        }
    }

    protected void readIntArray(int[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 4) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayInt: offset: " + off + " len: " + len + " type: " + 5);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readInt();
            }
        }
    }

    protected void readLongArray(long[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 8) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayLong: offset: " + off + " len: " + len + " type: " + 6);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readLong();
            }
        }
    }

    protected void readFloatArray(float[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 4) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayFloat: offset: " + off + " len: " + len + " type: " + 7);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readFloat();
            }
        }
    }

    protected void readDoubleArray(double[] ref, int off, int len) throws IOException {
        if (NO_ARRAY_BUFFERS) {
            this.in.readArray(ref, off, len);
        } else if (len >= IOProperties.SMALL_ARRAY_BOUND / 8) {
            while (this.array_index == this.max_array_index) {
                this.receive();
            }
            ++this.array_index;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readArrayDouble: offset: " + off + " len: " + len + " type: " + 8);
            }
            this.in.readArray(ref, off, len);
        } else {
            for (int i = off; i < off + len; ++i) {
                ref[i] = this.readDouble();
            }
        }
    }

    @Override
    public void readArray(boolean[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readBooleanArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readByteBuffer(ByteBuffer value) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.internalReadByteBuffer(value);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(byte[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readByteArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(char[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readCharArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(short[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readShortArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(int[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readIntArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(long[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readLongArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(float[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readFloatArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(double[] ref, int off, int len) throws IOException {
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        this.readDoubleArray(ref, off, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
    }

    private void initArrays() {
        this.indices_short = new short[9];
        this.byte_buffer = new byte[this.BYTE_BUFFER_SIZE];
        this.char_buffer = new char[this.CHAR_BUFFER_SIZE];
        this.short_buffer = new short[this.SHORT_BUFFER_SIZE];
        this.int_buffer = new int[this.INT_BUFFER_SIZE];
        this.long_buffer = new long[this.LONG_BUFFER_SIZE];
        this.float_buffer = new float[this.FLOAT_BUFFER_SIZE];
        this.double_buffer = new double[this.DOUBLE_BUFFER_SIZE];
    }

    private void receive() throws IOException {
        int sum;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("doing a receive()");
        }
        if (IOProperties.ASSERTS && (sum = this.max_byte_index - this.byte_index + (this.max_char_index - this.char_index) + (this.max_short_index - this.short_index) + (this.max_int_index - this.int_index) + (this.max_long_index - this.long_index) + (this.max_float_index - this.float_index) + (this.max_double_index - this.double_index) + (this.max_array_index - this.array_index)) != 0) {
            logger.debug("EEEEK : receiving while there is data in buffer !!!");
            logger.debug("byte_index " + (this.max_byte_index - this.byte_index));
            logger.debug("char_index " + (this.max_char_index - this.char_index));
            logger.debug("short_index " + (this.max_short_index - this.short_index));
            logger.debug("int_index " + (this.max_int_index - this.int_index));
            logger.debug("long_index " + (this.max_long_index - this.long_index));
            logger.debug("float_index " + (this.max_float_index - this.float_index));
            logger.debug("double_index " + (this.max_double_index - this.double_index));
            logger.debug("array_index " + (this.max_array_index - this.array_index));
            throw new SerializationError("Internal error!");
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.suspend();
        }
        this.in.readArray(this.indices_short, 1, 8);
        this.array_index = 0;
        this.byte_index = 0;
        this.char_index = 0;
        this.short_index = 0;
        this.int_index = 0;
        this.long_index = 0;
        this.float_index = 0;
        this.double_index = 0;
        this.max_array_index = this.indices_short[1];
        this.max_byte_index = this.indices_short[2];
        this.max_char_index = this.indices_short[3];
        this.max_short_index = this.indices_short[4];
        this.max_int_index = this.indices_short[5];
        this.max_long_index = this.indices_short[6];
        this.max_float_index = this.indices_short[7];
        this.max_double_index = this.indices_short[8];
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("reading arrays " + this.max_array_index);
            logger.debug("reading bytes " + this.max_byte_index);
            logger.debug("reading char " + this.max_char_index);
            logger.debug("reading short " + this.max_short_index);
            logger.debug("reading int " + this.max_int_index);
            logger.debug("reading long " + this.max_long_index);
            logger.debug("reading float " + this.max_float_index);
            logger.debug("reading double " + this.max_double_index);
        }
        if (this.max_byte_index > 0) {
            if (this.max_byte_index > this.byte_buffer.length) {
                this.byte_buffer = new byte[this.max_byte_index];
            }
            this.in.readArray(this.byte_buffer, 0, this.max_byte_index);
        }
        if (this.max_char_index > 0) {
            if (this.max_char_index > this.char_buffer.length) {
                this.char_buffer = new char[this.max_char_index];
            }
            this.in.readArray(this.char_buffer, 0, this.max_char_index);
        }
        if (this.max_short_index > 0) {
            if (this.max_short_index > this.short_buffer.length) {
                this.short_buffer = new short[this.max_short_index];
            }
            this.in.readArray(this.short_buffer, 0, this.max_short_index);
        }
        if (this.max_int_index > 0) {
            if (this.max_int_index > this.int_buffer.length) {
                this.int_buffer = new int[this.max_int_index];
            }
            this.in.readArray(this.int_buffer, 0, this.max_int_index);
        }
        if (this.max_long_index > 0) {
            if (this.max_long_index > this.long_buffer.length) {
                this.long_buffer = new long[this.max_long_index];
            }
            this.in.readArray(this.long_buffer, 0, this.max_long_index);
        }
        if (this.max_float_index > 0) {
            if (this.max_float_index > this.float_buffer.length) {
                this.float_buffer = new float[this.max_float_index];
            }
            this.in.readArray(this.float_buffer, 0, this.max_float_index);
        }
        if (this.max_double_index > 0) {
            if (this.max_double_index > this.double_buffer.length) {
                this.double_buffer = new double[this.max_double_index];
            }
            this.in.readArray(this.double_buffer, 0, this.max_double_index);
        }
        if (TIME_DATA_SERIALIZATION) {
            this.timer.resume();
        }
    }

    @Override
    public int available() throws IOException {
        return super.available() + (this.max_byte_index - this.byte_index) * 1 + (this.max_char_index - this.char_index) * 2 + (this.max_short_index - this.short_index) * 2 + (this.max_int_index - this.int_index) * 4 + (this.max_long_index - this.long_index) * 8 + (this.max_float_index - this.float_index) * 4 + (this.max_double_index - this.double_index) * 8;
    }

    public String readUTF() throws IOException {
        int i;
        if (TIME_DATA_SERIALIZATION) {
            this.timer.start();
        }
        int bn = this.readInt();
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readUTF: len = " + bn);
        }
        if (bn == -1) {
            if (TIME_DATA_SERIALIZATION) {
                this.timer.stop();
            }
            return null;
        }
        byte[] b = new byte[bn];
        this.readByteArray(b, 0, bn);
        int len = 0;
        char[] c = new char[bn];
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readUTF: len = " + bn);
            for (i = 0; i < bn; ++i) {
                logger.debug("readUTF: b[" + i + "] = " + (b[i] & 0xFF));
            }
        }
        for (i = 0; i < bn; ++i) {
            int bi = b[i] & 0xFF;
            if ((bi & 0xFFFFFF80) == 0) {
                c[len++] = (char)(bi & 0x7F);
                continue;
            }
            if ((bi & 0xE0) == 192) {
                if (i + 1 >= bn || (b[i + 1] & 0xC0) != 128) {
                    if (logger.isErrorEnabled()) {
                        logger.error("i = " + i + ", len = " + bn + ", bi = " + bi);
                        StringBuffer sb = new StringBuffer();
                        sb.append("bytes: ");
                        for (int j = 0; j < bn; ++j) {
                            sb.append(" " + b[j]);
                        }
                        logger.error(sb.toString());
                    }
                    throw new UTFDataFormatException("UTF Data Format Exception");
                }
                c[len++] = (char)((bi & 0x1F) << 6 | b[i + 1] & 0x3F);
                ++i;
                continue;
            }
            if ((bi & 0xF0) == 224) {
                if (i + 2 >= bn || (b[i + 1] & 0xC0) != 128 || (b[i + 2] & 0xC0) != 128) {
                    if (logger.isErrorEnabled()) {
                        logger.error("i = " + i + ", len = " + bn + ", bi = " + bi);
                        StringBuffer sb = new StringBuffer();
                        sb.append("bytes: ");
                        for (int j = 0; j < bn; ++j) {
                            sb.append(" " + b[j]);
                        }
                        logger.error(sb.toString());
                    }
                    throw new UTFDataFormatException("UTF Data Format Exception");
                }
                c[len++] = (char)((bi & 0xF) << 12 | (b[i + 1] & 0x3F) << 6 | b[i + 2] & 0x3F);
                i += 2;
                continue;
            }
            if (logger.isErrorEnabled()) {
                logger.error("i = " + i + ", len = " + bn + ", bi = " + bi);
                StringBuffer sb = new StringBuffer();
                sb.append("bytes: ");
                for (int j = 0; j < bn; ++j) {
                    sb.append(" " + b[j]);
                }
                logger.error(sb.toString());
            }
            throw new UTFDataFormatException("UTF Data Format Exception");
        }
        String s = new String(c, 0, len);
        if (TIME_DATA_SERIALIZATION) {
            this.timer.stop();
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read string " + s);
        }
        return s;
    }

    @Override
    public String readString() throws IOException {
        return this.readUTF();
    }

    @Override
    public void close() throws IOException {
        this.indices_short = null;
        this.byte_buffer = null;
        this.char_buffer = null;
        this.short_buffer = null;
        this.int_buffer = null;
        this.long_buffer = null;
        this.float_buffer = null;
        this.double_buffer = null;
        super.close();
    }
}

