/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.torque;

import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.torque.TorqueScheduler;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.schedulers.Scheduler;

public class TorqueSchedulerAdaptor
extends ScriptingSchedulerAdaptor {
    public static final String ADAPTOR_NAME = "torque";
    public static final String PREFIX = "xenon.adaptors.schedulers.torque.";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"local://[/workdir]", "ssh://host[:port][/workdir]"};
    public static final String IGNORE_VERSION_PROPERTY = "xenon.adaptors.schedulers.torque.ignore.version";
    public static final String ACCOUNTING_GRACE_TIME_PROPERTY = "xenon.adaptors.schedulers.torque.accounting.grace.time";
    public static final String POLL_DELAY_PROPERTY = "xenon.adaptors.schedulers.torque.poll.delay";
    public static final String ADAPTOR_DESCRIPTION = "The Torque Adaptor submits jobs to a TORQUE batch system. This adaptor uses either the local or the ssh scheduler adaptor to run commands on the machine running TORQUE,  and the file or the stfp filesystem adaptor to gain access to the filesystem of that machine.";
    public static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.schedulers.torque.ignore.version", XenonPropertyDescription.Type.BOOLEAN, "false", "Skip version check is skipped when connecting to remote machines. WARNING: it is not recommended to use this setting in production environments!"), new XenonPropertyDescription("xenon.adaptors.schedulers.torque.accounting.grace.time", XenonPropertyDescription.Type.LONG, "60000", "Number of milliseconds a job is allowed to take going from the queue to the accinfo output."), new XenonPropertyDescription("xenon.adaptors.schedulers.torque.poll.delay", XenonPropertyDescription.Type.LONG, "1000", "Number of milliseconds between polling the status of a job.")};

    public TorqueSchedulerAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public Scheduler createScheduler(String location, Credential credential, Map<String, String> properties) throws XenonException {
        return new TorqueScheduler(this.getNewUniqueID(), location, credential, properties);
    }
}

