/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import nl.esciencecenter.xenon.schedulers.Scheduler;
import nl.esciencecenter.xenon.schedulers.Streams;
import nl.esciencecenter.xenon.utils.InputWriter;
import nl.esciencecenter.xenon.utils.OutputReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCommandRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCommandRunner.class);
    private final int exitCode;
    private final String output;
    private final String error;

    public RemoteCommandRunner(Scheduler scheduler, String stdin, String executable, String ... arguments) throws XenonException {
        long start = System.currentTimeMillis();
        JobDescription description = new JobDescription();
        description.setExecutable(executable);
        description.setArguments(arguments);
        description.setQueueName("unlimited");
        Streams streams = scheduler.submitInteractiveJob(description);
        InputWriter in = new InputWriter(stdin, streams.getStdin());
        OutputReader out = new OutputReader(streams.getStdout());
        OutputReader err = new OutputReader(streams.getStderr());
        in.waitUntilFinished();
        out.waitUntilFinished();
        err.waitUntilFinished();
        JobStatus status = scheduler.getJobStatus(streams.getJobIdentifier());
        if (!status.isDone()) {
            status = scheduler.waitUntilDone(streams.getJobIdentifier(), 0L);
        }
        if (status.hasException()) {
            throw new XenonException(scheduler.getAdaptorName(), "Could not run command remotely", status.getException());
        }
        this.exitCode = status.getExitCode();
        this.output = out.getResultAsString();
        this.error = err.getResultAsString();
        long runtime = System.currentTimeMillis() - start;
        LOGGER.debug("CommandRunner took {} ms, executable = {}, arguments = {}, exitcode = {}, stdout:\n{}\nstderr:\n{}", new Object[]{runtime, executable, arguments, this.exitCode, this.output, this.error});
    }

    public String getStdout() {
        return this.output;
    }

    public String getStderr() {
        return this.error;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean success() {
        return this.exitCode == 0 && this.error.isEmpty();
    }

    public String toString() {
        return "CommandRunner[exitCode=" + this.exitCode + ",output=" + this.output + ",error=" + this.error + "]";
    }
}

