/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.ftp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Map;
import nl.esciencecenter.xenon.InvalidCredentialException;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.FileAdaptor;
import nl.esciencecenter.xenon.adaptors.filesystems.ftp.FtpFileSystem;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.PasswordCredential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.NoSuchPathException;
import nl.esciencecenter.xenon.filesystems.Path;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFileAdaptor
extends FileAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpFileAdaptor.class);
    public static final String ADAPTOR_NAME = "ftp";
    protected static final int DEFAULT_PORT = 21;
    private static final String ADAPTOR_DESCRIPTION = "The FTP adaptor implements file access on remote ftp servers.";
    private static final String[] ADAPTOR_LOCATIONS = new String[]{"host[:port][/workdir]"};
    public static final String PREFIX = "xenon.adaptors.filesystems.ftp.";
    public static final String BUFFER_SIZE = "xenon.adaptors.filesystems.ftp.bufferSize";
    protected static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.filesystems.ftp.bufferSize", XenonPropertyDescription.Type.SIZE, "64K", "The buffer size to use when copying files (in bytes).")};

    public FtpFileAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    protected FTPClient connect(String location, Credential credential) throws XenonException {
        URI uri;
        try {
            uri = new URI("ftp://" + location);
        }
        catch (Exception e) {
            throw new InvalidLocationException(ADAPTOR_NAME, "Failed to parse location: " + location, e);
        }
        FTPClient ftpClient = new FTPClient();
        ftpClient.setListHiddenFiles(true);
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = 21;
        }
        this.connectToServer(host, port, ftpClient);
        this.login(credential, ftpClient);
        try {
            ftpClient.enterLocalPassiveMode();
        }
        catch (Exception e) {
            throw new XenonException(ADAPTOR_NAME, "Failed to switch to PASSIVE mode");
        }
        return ftpClient;
    }

    @Override
    public FileSystem createFileSystem(String location, Credential credential, Map<String, String> properties) throws XenonException {
        LOGGER.debug("newFileSystem ftp location = {} credential = {} properties = {}", new Object[]{location, credential, properties});
        if (credential == null) {
            throw new InvalidCredentialException(this.getName(), "Credentials was null.");
        }
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        long bufferSize = xp.getSizeProperty(BUFFER_SIZE);
        if (bufferSize <= 0L || bufferSize >= Integer.MAX_VALUE) {
            throw new InvalidPropertyException(ADAPTOR_NAME, "Invalid value for xenon.adaptors.filesystems.ftp.bufferSize: " + bufferSize + " (must be between 1 and " + Integer.MAX_VALUE + ")");
        }
        FTPClient ftpClient = this.connect(location, credential);
        String cwd = null;
        try {
            cwd = this.getCurrentWorkingDirectory(ftpClient, location);
        }
        catch (Exception e) {
            try {
                ftpClient.disconnect();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
        return new FtpFileSystem(this.getNewUniqueID(), ADAPTOR_NAME, location, new Path(cwd), (int)bufferSize, ftpClient, credential, this, xp);
    }

    private String getCurrentWorkingDirectory(FTPClient ftpClient, String location) throws XenonException {
        try {
            String pathFromURI = new URI("ftp://" + location).getPath();
            if (pathFromURI == null || pathFromURI.isEmpty()) {
                return ftpClient.printWorkingDirectory();
            }
            if (ftpClient.changeWorkingDirectory(pathFromURI)) {
                return pathFromURI;
            }
            throw new NoSuchPathException(ADAPTOR_NAME, "Specified working directory does not exist: " + pathFromURI);
        }
        catch (URISyntaxException e) {
            throw new InvalidLocationException(ADAPTOR_NAME, "Failed to parse location: " + location, e);
        }
        catch (IOException e) {
            throw new XenonException(this.getName(), "Could not set current working directory", e);
        }
    }

    private void connectToServer(String host, int port, FTPClient ftp) throws XenonException {
        try {
            ftp.connect(host, port);
        }
        catch (IOException e) {
            throw new XenonException(this.getName(), "Failed to connect", e);
        }
    }

    private void login(Credential credential, FTPClient ftp) throws XenonException {
        try {
            this.loginWithCredentialOrDefault(ftp, credential);
            int replyCode = ftp.getReplyCode();
            this.verifyLoginSuccess(replyCode);
        }
        catch (IOException | XenonException e) {
            throw new XenonException(this.getName(), "Failed to login", e);
        }
    }

    private void verifyLoginSuccess(int replyCode) throws XenonException {
        if (replyCode < 200 || replyCode >= 300) {
            String message = MessageFormat.format("Server status not succesfull after login (status code {0}).", replyCode);
            throw new XenonException(this.getName(), message);
        }
    }

    private void loginWithCredentialOrDefault(FTPClient ftp, Credential credential) throws IOException {
        String password = "";
        String user = "anonymous";
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            password = new String(passwordCredential.getPassword());
            user = passwordCredential.getUsername();
        }
        ftp.login(user, password);
    }

    @Override
    public boolean supportsReadingPosixPermissions() {
        return true;
    }

    @Override
    public boolean canAppend() {
        return true;
    }
}

