/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.ClassInfo;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;

public class BCELClassInfo
implements ClassInfo {
    private JavaClass cl;

    public BCELClassInfo(JavaClass cl) {
        this.cl = cl;
    }

    @Override
    public String getClassName() {
        return this.cl.getClassName();
    }

    @Override
    public Object getClassObject() {
        return this.cl;
    }

    void setClassObject(JavaClass cl) {
        this.cl = cl;
    }

    @Override
    public void dump(String fileName) throws IOException {
        this.cl.dump(fileName);
    }

    @Override
    public byte[] getBytes() {
        return this.cl.getBytes();
    }

    @Override
    public boolean doVerify() {
        Verifier verf = VerifierFactory.getVerifier((String)this.cl.getClassName());
        boolean verification_failed = false;
        VerificationResult res = verf.doPass1();
        if (res.getStatus() == 2) {
            System.out.println("Ibisc: Verification pass 1 failed.");
            System.out.println(res.getMessage());
            verification_failed = true;
        } else {
            res = verf.doPass2();
            if (res.getStatus() == 2) {
                System.out.println("Ibisc: Verification pass 2 failed.");
                System.out.println(res.getMessage());
                verification_failed = true;
            } else {
                Method[] cMethods = this.cl.getMethods();
                for (int i = 0; i < cMethods.length; ++i) {
                    res = verf.doPass3a(i);
                    if (res.getStatus() == 2) {
                        System.out.println("Ibisc: Verification pass 3a failed for method " + cMethods[i].getName());
                        System.out.println(res.getMessage());
                        verification_failed = true;
                        continue;
                    }
                    res = verf.doPass3b(i);
                    if (res.getStatus() != 2) continue;
                    System.out.println("Ibisc: Verification pass 3b failed for method " + cMethods[i].getName());
                    System.out.println(res.getMessage());
                    verification_failed = true;
                }
            }
        }
        return !verification_failed;
    }
}

