/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.rpc;

import ibis.ipl.Ibis;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.util.rpc.RPCInvocationHandler;
import ibis.ipl.util.rpc.RemoteException;
import ibis.ipl.util.rpc.RemoteObject;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class RPC {
    public static final PortType rpcRequestPortType = new PortType(new String[]{"communication.reliable", "serialization.object", "receive.autoupcalls", "connection.manytoone"});
    public static final PortType rpcReplyPortType = new PortType(new String[]{"communication.reliable", "serialization.object", "receive.explicit", "connection.onetoone"});
    public static final PortType[] rpcPortTypes = new PortType[]{rpcRequestPortType, rpcReplyPortType};

    public static <InterfaceType> RemoteObject<InterfaceType> exportObject(Class<InterfaceType> interfaceClass, InterfaceType theObject, String name, Ibis ibis) throws IOException, RemoteException {
        return new RemoteObject<InterfaceType>(interfaceClass, theObject, name, ibis);
    }

    public static <InterfaceType> InterfaceType createProxy(Class<InterfaceType> interfaceClass, ReceivePortIdentifier address, Ibis ibis) {
        return RPC.createProxy(interfaceClass, address.ibisIdentifier(), address.name(), ibis);
    }

    public static <InterfaceType> InterfaceType createProxy(Class<InterfaceType> interfaceClass, IbisIdentifier address, String name, Ibis ibis) {
        RPCInvocationHandler handler = new RPCInvocationHandler(address, name, ibis);
        Object result = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)handler);
        return (InterfaceType)result;
    }
}

