/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.server;

import ibis.ipl.Location;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.central.Election;
import ibis.ipl.registry.central.ElectionSet;
import ibis.ipl.registry.central.Event;
import ibis.ipl.registry.central.EventList;
import ibis.ipl.registry.central.ListMemberSet;
import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.MemberSet;
import ibis.ipl.registry.central.Protocol;
import ibis.ipl.registry.central.TreeMemberSet;
import ibis.ipl.registry.central.server.IterativeEventPusher;
import ibis.ipl.registry.central.server.OndemandEventPusher;
import ibis.ipl.registry.central.server.RandomEventPusher;
import ibis.ipl.registry.statistics.Statistics;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Pool
implements Runnable {
    public static final int BOOTSTRAP_LIST_SIZE = 25;
    private static final long RECENTLY_SEEN_THRESHOLD = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(Pool.class);
    private final VirtualSocketFactory socketFactory;
    private final EventList events;
    private final boolean peerBootstrap;
    private final long heartbeatInterval;
    private int currentEventTime;
    private int minEventTime;
    private final ElectionSet elections;
    private final MemberSet members;
    private final OndemandEventPusher pusher;
    private final String name;
    private final String implementationVersion;
    private final boolean closedWorld;
    private final int fixedSize;
    private final boolean printEvents;
    private final boolean printErrors;
    private final boolean purgeHistory;
    private final int connectTimeout;
    private final Statistics statistics;
    private final int[] eventStats;
    private final Map<String, Integer> sequencers;
    private int nextID;
    private boolean ended = false;
    private boolean closed = false;
    private Event closeEvent = null;
    private boolean terminated = false;
    private Event terminateEvent = null;

    Pool(String name, VirtualSocketFactory socketFactory, boolean peerBootstrap, long heartbeatInterval, long eventPushInterval, boolean gossip, long gossipInterval, boolean adaptGossipInterval, boolean tree, boolean closedWorld, int poolSize, boolean keepStatistics, long statisticsInterval, int connectTimeout, String implementationVersion, boolean printEvents, boolean printErrors, boolean purgeHistory) {
        Pool.print("creating new pool: \"" + name + "\"");
        this.name = name;
        this.socketFactory = socketFactory;
        this.peerBootstrap = peerBootstrap;
        this.heartbeatInterval = heartbeatInterval;
        this.closedWorld = closedWorld;
        this.fixedSize = poolSize;
        this.implementationVersion = implementationVersion;
        this.printEvents = printEvents;
        this.printErrors = printErrors;
        this.purgeHistory = purgeHistory;
        this.connectTimeout = connectTimeout;
        if (keepStatistics) {
            this.statistics = new Statistics(Protocol.OPCODE_NAMES);
            this.statistics.setID("server", name);
            this.statistics.startWriting(statisticsInterval);
        } else {
            this.statistics = null;
        }
        this.currentEventTime = 0;
        this.minEventTime = 0;
        this.nextID = 0;
        this.sequencers = new HashMap<String, Integer>();
        this.events = new EventList();
        this.eventStats = new int[8];
        this.elections = new ElectionSet();
        if (gossip) {
            this.members = new ListMemberSet();
            new IterativeEventPusher(this, eventPushInterval, false, false);
            new RandomEventPusher(this, gossipInterval, adaptGossipInterval);
        } else if (tree) {
            this.members = new TreeMemberSet();
            new IterativeEventPusher(this, 1000L, true, true);
            new IterativeEventPusher(this, eventPushInterval, false, false);
        } else {
            this.members = new ListMemberSet();
            new IterativeEventPusher(this, eventPushInterval, true, false);
        }
        this.pusher = new OndemandEventPusher(this);
        ThreadPool.createNew((Runnable)this, (String)"pool pinger thread");
    }

    private static void print(String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        } else {
            System.err.printf("%tT Central Registry: %s\n", System.currentTimeMillis(), message);
        }
    }

    private void printError(String message, Exception exception) {
        if (logger.isErrorEnabled()) {
            if (this.printErrors) {
                logger.error(message, (Throwable)exception);
            } else {
                logger.error(message);
            }
        } else if (this.printErrors) {
            System.err.printf("%tT Central Registry: %s caused by:\n", System.currentTimeMillis(), message);
            exception.printStackTrace(System.err);
        } else {
            System.err.printf("%tT Central Registry: %s\n", System.currentTimeMillis(), message);
        }
    }

    synchronized int getEventTime() {
        return this.currentEventTime;
    }

    synchronized int getMinEventTime() {
        return this.minEventTime;
    }

    synchronized Event addEvent(int type, String description, IbisIdentifier ibis, IbisIdentifier ... ibisses) {
        Event event = new Event(this.currentEventTime, type, description, ibis, ibisses);
        if (logger.isDebugEnabled()) {
            logger.debug("adding new event: " + event);
        }
        this.events.add(event);
        int n = type;
        this.eventStats[n] = this.eventStats[n] + 1;
        ++this.currentEventTime;
        this.notifyAll();
        return event;
    }

    synchronized void waitForEventTime(int time, long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        if (timeout == 0L) {
            deadline = Long.MAX_VALUE;
        }
        while (this.getEventTime() < time) {
            if (this.hasEnded()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime >= deadline) {
                return;
            }
            try {
                this.wait(deadline - currentTime);
            }
            catch (InterruptedException e) {}
        }
    }

    synchronized int getSize() {
        return this.members.size();
    }

    synchronized Location[] getLocations() {
        HashSet<Location> locations = new HashSet<Location>();
        for (Member member : this.members.asArray()) {
            locations.add(member.getIbis().location());
        }
        return (Location[])locations.toArray(new ibis.ipl.impl.Location[0]);
    }

    int getFixedSize() {
        return this.fixedSize;
    }

    public boolean isClosedWorld() {
        return this.closedWorld;
    }

    synchronized boolean hasEnded() {
        return this.ended;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized boolean hasTerminated() {
        return this.terminated;
    }

    synchronized void end() {
        this.ended = true;
        this.pusher.enqueue(null);
        if (this.statistics != null) {
            this.statistics.write();
            this.statistics.end();
        }
    }

    public void saveStatistics() {
        if (this.statistics != null) {
            this.statistics.write();
        }
    }

    String getName() {
        return this.name;
    }

    synchronized Member join(byte[] implementationData, byte[] clientAddress, ibis.ipl.impl.Location location, String implementationVersion, byte[] applicationTag) throws IOException {
        if (this.hasEnded()) {
            throw new IOException("Pool already ended");
        }
        if (this.isClosed()) {
            throw new IOException("Pool already closed");
        }
        if (implementationVersion == null || !this.implementationVersion.equals(implementationVersion)) {
            throw new IOException("Ibis implementation " + implementationVersion + " does not match pool's Ibis implementation: " + this.implementationVersion);
        }
        String id = Integer.toString(this.nextID);
        ++this.nextID;
        IbisIdentifier identifier = new IbisIdentifier(id, implementationData, clientAddress, location, this.name, applicationTag);
        Event event = this.addEvent(0, null, identifier, new IbisIdentifier[0]);
        Member member = new Member(identifier, event);
        member.setCurrentTime(this.getMinEventTime());
        member.updateTime();
        this.members.add(member);
        if (logger.isDebugEnabled()) {
            logger.debug("members now: " + this.members);
        }
        if (this.statistics != null) {
            this.statistics.newPoolSize(this.members.size());
        }
        if (this.printEvents) {
            Pool.print(identifier + " joined pool \"" + this.name + "\" now " + this.members.size() + " members");
        }
        if (this.closedWorld && this.nextID >= this.fixedSize) {
            this.close();
        }
        return member;
    }

    private synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeEvent = this.addEvent(6, null, null, new IbisIdentifier[0]);
        if (this.printEvents) {
            Pool.print("pool \"" + this.name + "\" now closed");
        }
    }

    void writeBootstrapList(DataOutputStream out) throws IOException {
        if (!this.peerBootstrap) {
            out.writeInt(0);
            return;
        }
        Member[] peers = this.getRandomMembers(25);
        out.writeInt(peers.length);
        for (Member member : peers) {
            member.getIbis().writeTo((DataOutput)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(DataOutputStream out, int joinTime) throws IOException {
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(arrayOut);
        Pool pool = this;
        synchronized (pool) {
            dataOut.writeInt(this.currentEventTime);
            this.members.writeTo(dataOut);
            this.elections.writeTo(dataOut);
            Event[] signals = this.events.getSignalEvents(joinTime, this.currentEventTime);
            dataOut.writeInt(signals.length);
            for (Event event : signals) {
                event.writeTo(dataOut);
            }
            dataOut.writeBoolean(this.closed);
            if (this.closed) {
                this.closeEvent.writeTo(dataOut);
            }
            dataOut.writeBoolean(this.terminated);
            if (this.terminated) {
                this.terminateEvent.writeTo(dataOut);
            }
        }
        dataOut.flush();
        byte[] bytes = arrayOut.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
        if (logger.isDebugEnabled()) {
            logger.debug("pool state size = " + bytes.length);
        }
    }

    synchronized void leave(IbisIdentifier identifier) throws Exception {
        Election[] deadElections;
        if (this.members.remove(identifier) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("unknown ibis " + identifier + " tried to leave");
            }
            return;
        }
        if (this.printEvents) {
            Pool.print(identifier + " left pool \"" + this.name + "\" now " + this.members.size() + " members");
        }
        this.addEvent(1, null, identifier, new IbisIdentifier[0]);
        if (this.statistics != null) {
            this.statistics.newPoolSize(this.members.size());
        }
        for (Election election : deadElections = this.elections.getElectionsWonBy(identifier)) {
            this.addEvent(5, election.getName(), election.getWinner(), new IbisIdentifier[0]);
            if (this.statistics != null) {
                this.statistics.electionEvent();
            }
            this.elections.remove(election.getName());
        }
        if (this.members.size() == 0) {
            this.end();
            Pool.print("pool \"" + this.name + "\" ended");
            this.notifyAll();
        }
    }

    synchronized void dead(IbisIdentifier identifier, Exception exception) {
        Election[] deadElections;
        Member member = this.members.remove(identifier);
        if (member == null) {
            return;
        }
        if (this.printEvents) {
            this.printError(identifier + " died in pool \"" + this.name + "\" now " + this.members.size() + " members", exception);
        }
        this.addEvent(2, null, identifier, new IbisIdentifier[0]);
        if (this.statistics != null) {
            this.statistics.newPoolSize(this.members.size());
        }
        for (Election election : deadElections = this.elections.getElectionsWonBy(identifier)) {
            this.addEvent(5, election.getName(), election.getWinner(), new IbisIdentifier[0]);
            if (this.statistics != null) {
                this.statistics.electionEvent();
            }
            this.elections.remove(election.getName());
        }
        if (this.members.size() == 0) {
            this.end();
            Pool.print("pool " + this.name + " ended");
            this.notifyAll();
        }
        this.pusher.enqueue(member);
    }

    synchronized Event[] getEvents(int startTime) {
        return this.events.getList(startTime);
    }

    synchronized IbisIdentifier elect(String electionName, IbisIdentifier candidate) throws IOException {
        Election election = this.elections.get(electionName);
        if (election == null) {
            if (!this.members.contains(candidate)) {
                throw new IOException(candidate + " tries to win election " + electionName + ", but is not a member of the pool");
            }
            Event event = this.addEvent(4, electionName, candidate, new IbisIdentifier[0]);
            if (this.statistics != null) {
                this.statistics.electionEvent();
            }
            election = new Election(event);
            this.elections.put(election);
            if (this.printEvents) {
                Pool.print(candidate + " won election \"" + electionName + "\" in pool \"" + this.name + "\"");
            }
        }
        return election.getWinner();
    }

    synchronized long getSequenceNumber(String name) {
        Integer currentValue = this.sequencers.get(name);
        if (currentValue == null) {
            currentValue = new Integer(0);
        }
        int result = currentValue;
        this.sequencers.put(name, currentValue + 1);
        return result;
    }

    synchronized void maybeDead(IbisIdentifier identifier) {
        Member member = this.members.get(identifier);
        if (member != null) {
            if (member.getTime() > System.currentTimeMillis() - 1000L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("got maybeDead for member of pool " + identifier + ", but recently contacted it, ignoring report");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("got maybeDead for member of pool: " + identifier);
                }
                member.clearTime();
                this.notifyAll();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("got maybeDead for " + identifier + " which is not in pool");
        }
    }

    synchronized void signal(String signal, IbisIdentifier source, IbisIdentifier[] targets) {
        ArrayList<IbisIdentifier> result = new ArrayList<IbisIdentifier>();
        for (IbisIdentifier target : targets) {
            if (!this.members.contains(target)) continue;
            result.add(target);
        }
        this.addEvent(3, signal, source, result.toArray(new IbisIdentifier[result.size()]));
        this.notifyAll();
    }

    synchronized void terminate(IbisIdentifier source) {
        if (this.terminated) {
            return;
        }
        this.close();
        this.terminated = true;
        this.terminateEvent = this.addEvent(7, null, source, new IbisIdentifier[0]);
        if (this.printEvents) {
            Pool.print("pool \"" + this.name + "\" now terminated");
        }
        this.notifyAll();
    }

    void ping(Member member) {
        long start = System.currentTimeMillis();
        if (this.hasEnded()) {
            return;
        }
        if (!this.isMember(member)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("pinging " + member);
        }
        Connection connection = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("creating connection to " + member);
            }
            connection = new Connection(member.getIbis(), this.connectTimeout, true, this.socketFactory, 302);
            if (logger.isDebugEnabled()) {
                logger.debug("connection created to " + member + ", send opcode, checking for reply");
            }
            connection.out().writeByte(54);
            connection.out().writeByte(8);
            connection.out().flush();
            connection.getAndCheckReply();
            IbisIdentifier result = new IbisIdentifier((DataInput)connection.in());
            connection.close();
            if (!result.equals((Object)member.getIbis())) {
                throw new Exception("ping ended up at wrong ibis");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ping to " + member + " successful");
            }
            member.updateTime();
            if (this.statistics != null) {
                this.statistics.add((byte)8, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("error on pinging ibis " + member, (Throwable)e);
            }
            if (connection != null) {
                connection.close();
            }
            this.dead(member.getIbis(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(Member member, boolean force, boolean isBroadcast) {
        byte opcode = isBroadcast ? (byte)10 : 9;
        long start = System.currentTimeMillis();
        if (this.hasEnded() && !force) {
            return;
        }
        if (!this.isMember(member) && !force) {
            return;
        }
        if (logger.isDebugEnabled()) {
            if (force) {
                logger.debug("forced pushing entries to " + member);
            } else {
                logger.debug("pushing entries to " + member);
            }
        }
        Connection connection = null;
        try {
            long connecting = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("creating connection to push events to " + member);
            }
            connection = new Connection(member.getIbis(), this.connectTimeout, true, this.socketFactory, 302);
            long connected = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("connection to " + member + " created");
            }
            connection.out().writeByte(54);
            connection.out().writeByte(opcode);
            connection.out().writeUTF(this.getName());
            connection.out().flush();
            long writtenOpcode = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("waiting for info of peer " + member);
            }
            boolean requestBootstrap = connection.in().readBoolean();
            int joinTime = connection.in().readInt();
            int requestedEventTime = connection.in().readInt();
            long readInfo = System.currentTimeMillis();
            connection.sendOKReply();
            long sendOk = System.currentTimeMillis();
            if (requestBootstrap) {
                this.writeState(connection.out(), joinTime);
            }
            long writtenState = System.currentTimeMillis();
            member.setCurrentTime(requestedEventTime);
            Event[] events = this.getEvents(requestedEventTime);
            long gotEvents = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("sending " + events.length + " entries to " + member);
            }
            connection.out().writeInt(events.length);
            for (int i = 0; i < events.length; ++i) {
                events[i].writeTo(connection.out());
            }
            long writtenEvents = System.currentTimeMillis();
            connection.out().writeInt(this.getMinEventTime());
            connection.out().flush();
            long writtenAll = System.currentTimeMillis();
            connection.close();
            long closedConnection = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("connection to " + member + " closed");
            }
            member.updateTime();
            long done = System.currentTimeMillis();
            if (this.statistics != null) {
                long end = System.currentTimeMillis();
                this.statistics.add(opcode, end - start, connection.read(), connection.written(), false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("connecting = " + (connecting - start) + ", connected = " + (connected - connecting) + ", writtenOpcode = " + (writtenOpcode - connected) + ", readInfo = " + (readInfo - writtenOpcode) + ", sendOk = " + (sendOk - readInfo) + ", writtenState (" + requestBootstrap + ") = " + (writtenState - sendOk) + "\n\t\t\t" + "gotEvents = " + (gotEvents - writtenState) + ", writtenEvents = " + (writtenEvents - gotEvents) + ", writtenAll = " + (writtenAll - writtenEvents) + ", closedConnection = " + (closedConnection - writtenAll) + ", done = " + (done - closedConnection));
            }
        }
        catch (IOException e) {
            if (this.isMember(member)) {
                this.printError("cannot reach " + member + " to push events to", e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private synchronized Member getSuspectMember() {
        while (!this.hasEnded()) {
            Member oldest = this.members.getLeastRecentlySeen();
            if (logger.isDebugEnabled()) {
                logger.debug("oldest = " + oldest);
            }
            long currentTime = System.currentTimeMillis();
            long timeout = oldest == null ? 1000L : oldest.getTime() + this.heartbeatInterval - currentTime;
            if (timeout <= 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug(oldest + " now a suspect");
                }
                return oldest;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(timeout + " milliseconds until " + oldest + " needs checking");
                }
                this.wait(timeout);
            }
            catch (InterruptedException e) {}
        }
        return null;
    }

    synchronized void gotHeartbeat(IbisIdentifier identifier) {
        Member member = this.members.get(identifier);
        if (logger.isDebugEnabled()) {
            logger.debug("updating last seen time for " + member);
        }
        if (member != null) {
            member.updateTime();
        }
    }

    synchronized Member[] getRandomMembers(int size) {
        return this.members.getRandom(size);
    }

    synchronized Member getRandomMember() {
        return this.members.getRandom();
    }

    synchronized boolean isMember(Member member) {
        return this.members.contains(member);
    }

    synchronized Member[] getMembers() {
        return this.members.asArray();
    }

    synchronized Member[] getChildren() {
        return this.members.getRootChildren();
    }

    public String toString() {
        return "Pool " + this.name + ": value = " + this.getSize() + ", event time = " + this.getEventTime();
    }

    public synchronized String getStatsString() {
        StringBuilder message = new StringBuilder();
        Formatter formatter = new Formatter(message);
        if (this.isClosedWorld()) {
            formatter.format("%s\n     %12d %5d %6d %5d %9d %7d %10d %6b %10b %5b", this.getName(), this.getSize(), this.eventStats[0], this.eventStats[1], this.eventStats[2], this.eventStats[4], this.eventStats[3], this.getFixedSize(), this.isClosed(), this.hasTerminated(), this.ended);
        } else {
            formatter.format("%s\n     %12d %5d %6d %5d %9d %7d %10s %6b %10b %5b", this.getName(), this.getSize(), this.eventStats[0], this.eventStats[1], this.eventStats[2], this.eventStats[4], this.eventStats[3], "N.A.", this.isClosed(), this.hasTerminated(), this.ended);
        }
        return message.toString();
    }

    public synchronized Map<String, String> getStatsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.name + ".size", "" + this.getSize());
        result.put(this.name + ".joins", "" + this.eventStats[0]);
        result.put(this.name + ".leaves", "" + this.eventStats[1]);
        result.put(this.name + ".dieds", "" + this.eventStats[2]);
        result.put(this.name + ".elections", "" + this.eventStats[4]);
        result.put(this.name + ".signals", "" + this.eventStats[3]);
        result.put(this.name + ".fixed.size", "" + this.getFixedSize());
        result.put(this.name + ".closed", "" + this.isClosed());
        result.put(this.name + ".ended", "" + this.ended);
        result.put(this.name + ".terminated", "" + this.terminated);
        return result;
    }

    synchronized void purgeHistory() {
        if (!this.purgeHistory) {
            return;
        }
        int newMinimum = this.members.getMinimumTime();
        if (newMinimum == -1) {
            newMinimum = this.getEventTime();
        }
        if (newMinimum < this.minEventTime) {
            logger.error("tried to set minimum event time backwards");
            return;
        }
        this.events.setMinimum(newMinimum);
        this.minEventTime = newMinimum;
    }

    @Override
    public void run() {
        Member suspect;
        if (logger.isDebugEnabled()) {
            logger.debug("new pinger thread started");
        }
        if ((suspect = this.getSuspectMember()) != null) {
            suspect.updateTime();
        }
        if (this.hasEnded()) {
            return;
        }
        ThreadPool.createNew((Runnable)this, (String)"pool pinger thread");
        if (suspect != null) {
            this.ping(suspect);
        }
    }

    Statistics getStatistics() {
        return this.statistics;
    }
}

