/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.registry.central.Event;
import ibis.util.ThreadPool;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Upcaller
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Upcaller.class);
    private RegistryEventHandler handler;
    private final List<Event> pendingEvents;
    private boolean registryUpcallerEnabled = false;
    private boolean busyUpcaller = false;

    Upcaller(RegistryEventHandler handler) {
        this.handler = handler;
        this.pendingEvents = new LinkedList<Event>();
        ThreadPool.createNew((Runnable)this, (String)"upcaller");
    }

    synchronized void enableEvents() {
        this.registryUpcallerEnabled = true;
        this.notifyAll();
    }

    synchronized void disableEvents() {
        this.registryUpcallerEnabled = false;
        while (this.busyUpcaller) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    private synchronized void setBusyUpcaller() {
        this.busyUpcaller = true;
    }

    private synchronized void clearBusyUpcaller() {
        this.busyUpcaller = false;
        this.notifyAll();
    }

    private synchronized Event waitForEvent() {
        while (!this.registryUpcallerEnabled || this.pendingEvents.isEmpty()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        return this.pendingEvents.remove(0);
    }

    synchronized void newEvent(Event event) {
        if (logger.isDebugEnabled()) {
            logger.debug("newEvent: " + event);
        }
        this.pendingEvents.add(event);
        this.notifyAll();
    }

    synchronized void stop() {
        this.pendingEvents.add(null);
        this.notifyAll();
    }

    @Override
    public void run() {
        Event event;
        while ((event = this.waitForEvent()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("doing upcall for event: " + event);
            }
            this.setBusyUpcaller();
            try {
                switch (event.getType()) {
                    case 0: {
                        this.handler.joined((IbisIdentifier)event.getIbis());
                        break;
                    }
                    case 1: {
                        this.handler.left((IbisIdentifier)event.getIbis());
                        break;
                    }
                    case 2: {
                        this.handler.died((IbisIdentifier)event.getIbis());
                        break;
                    }
                    case 3: {
                        this.handler.gotSignal(event.getDescription(), (IbisIdentifier)event.getIbis());
                        break;
                    }
                    case 4: {
                        this.handler.electionResult(event.getDescription(), (IbisIdentifier)event.getIbis());
                        break;
                    }
                    case 5: {
                        this.handler.electionResult(event.getDescription(), null);
                        break;
                    }
                    case 6: {
                        this.handler.poolClosed();
                        break;
                    }
                    case 7: {
                        this.handler.poolTerminated((IbisIdentifier)event.getIbis());
                        break;
                    }
                    default: {
                        logger.error("unknown event type: " + event.getType());
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error("error on handling event", t);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("upcall for event " + event + " done");
            }
            this.clearBusyUpcaller();
        }
        return;
    }
}

