/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.ipl.registry.central.client.CommunicationHandler;
import ibis.ipl.registry.central.client.Pool;
import ibis.util.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeat
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Heartbeat.class);
    private final Pool pool;
    private final CommunicationHandler commHandler;
    private final long heartbeatInterval;
    private final boolean exitOnServerFailure;
    private long heartbeatDeadline;
    private long serverFailureDeadline;

    Heartbeat(CommunicationHandler commHandler, Pool pool, long heartbeatInterval, boolean exitOnServerFailure) {
        this.commHandler = commHandler;
        this.pool = pool;
        this.heartbeatInterval = heartbeatInterval;
        this.exitOnServerFailure = exitOnServerFailure;
        ThreadPool.createNew((Runnable)this, (String)"heartbeat thread");
    }

    synchronized void resetServerDeadline() {
        this.serverFailureDeadline = System.currentTimeMillis() + this.heartbeatInterval * 5L;
    }

    synchronized void resetHeartbeatDeadline() {
        this.heartbeatDeadline = System.currentTimeMillis() + (long)((double)this.heartbeatInterval * (0.3 + Math.random() / 2.0));
    }

    synchronized void resetDeadlines() {
        this.resetHeartbeatDeadline();
        this.resetServerDeadline();
        if (logger.isDebugEnabled()) {
            logger.debug("deadlines reset");
        }
    }

    synchronized boolean serverDeadlineExpired() {
        return System.currentTimeMillis() > this.serverFailureDeadline;
    }

    synchronized void nudge() {
        this.notifyAll();
    }

    synchronized void waitForHeartbeatDeadline() {
        int timeout;
        while ((timeout = (int)(this.heartbeatDeadline - System.currentTimeMillis())) > 0) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting " + timeout + " for heartbeat");
                }
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    @Override
    public void run() {
        this.resetDeadlines();
        while (!this.pool.isStopped()) {
            this.waitForHeartbeatDeadline();
            boolean success = this.commHandler.sendHeartBeat();
            if (success) {
                this.resetServerDeadline();
                this.resetHeartbeatDeadline();
            } else {
                this.resetHeartbeatDeadline();
            }
            if (!this.serverDeadlineExpired()) continue;
            if (this.exitOnServerFailure) {
                logger.error("Registry: contact with server lost, terminating JVM");
                System.exit(1);
                continue;
            }
            logger.warn("Registry: contact with server lost");
        }
    }
}

