/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.nio.NioDissipator;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonBlockingChannelNioDissipator
extends NioDissipator {
    private static Logger logger = LoggerFactory.getLogger(NonBlockingChannelNioDissipator.class);
    Selector selector;

    NonBlockingChannelNioDissipator(ReadableByteChannel channel) throws IOException {
        super(channel);
        if (!(channel instanceof SelectableChannel)) {
            throw new IOException("wrong type of channel given on creation of ChannelNioDissipator");
        }
        this.selector = Selector.open();
        SelectableChannel sc = (SelectableChannel)((Object)this.channel);
        sc.configureBlocking(false);
        sc.register(this.selector, 1);
    }

    @Override
    protected void fillBuffer(int minimum) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("filling buffer");
        }
        this.readFromChannel();
        while (this.unUsedLength() < minimum) {
            if (logger.isDebugEnabled()) {
                logger.debug("doing a select for data");
            }
            this.selector.select();
            this.selector.selectedKeys().clear();
            this.readFromChannel();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("filled buffer");
        }
    }

    @Override
    public void close() throws IOException {
        this.selector.close();
        super.close();
    }
}

