/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.io;

import ibis.ipl.impl.stacking.lrmc.LabelRoutingMulticast;
import ibis.ipl.impl.stacking.lrmc.util.Message;
import ibis.ipl.impl.stacking.lrmc.util.MessageCache;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrmcOutputStream
extends OutputStream {
    private static final Logger logger = LoggerFactory.getLogger(LrmcOutputStream.class);
    private final LabelRoutingMulticast mcast;
    private final MessageCache cache;
    public int currentID = 1;
    private int currentNUM = 0;
    private boolean closed = false;
    private boolean firstPacket = false;
    private Message message;

    public LrmcOutputStream(LabelRoutingMulticast mcast, MessageCache cache) {
        this.mcast = mcast;
        this.cache = cache;
        this.message = cache.get();
    }

    public void reset() {
        this.firstPacket = true;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public int getPrefferedBufferSize() {
        return this.mcast.getPrefferedMessageSize();
    }

    public byte[] getBuffer() {
        return this.message.buffer;
    }

    public byte[] write(int off, int len, boolean lastPacket) {
        if (this.closed) {
            logger.info("____ got write(" + len + ") while closed!");
            return null;
        }
        if (this.firstPacket) {
            this.firstPacket = false;
            this.currentNUM = 0;
        } else {
            ++this.currentNUM;
        }
        this.message.off = 0;
        this.message.len = len;
        if (lastPacket) {
            this.message.num = this.currentNUM | Integer.MIN_VALUE;
            this.message.id = this.currentID++;
        } else {
            this.message.num = this.currentNUM;
            this.message.id = this.currentID;
        }
        if (this.mcast.send(this.message)) {
            return this.message.buffer;
        }
        this.message = this.cache.get();
        return this.message.buffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
    }
}

