/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.NodePair;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.ImmutableGraphEltSet;

public class TGLayout
implements Runnable {
    private TGPanel tgPanel;
    private Thread relaxer;
    private double damper = 0.0;
    private double maxMotion = 0.0;
    private double lastMaxMotion = 0.0;
    private double motionRatio = 0.0;
    private boolean damping = true;
    private double rigidity = 1.0;
    private double newRigidity = 1.0;
    Node dragNode = null;

    public TGLayout(TGPanel tgp) {
        this.tgPanel = tgp;
        this.relaxer = null;
    }

    void setRigidity(double r) {
        this.newRigidity = r;
    }

    void setDragNode(Node n) {
        this.dragNode = n;
    }

    private synchronized void relaxEdges() {
        ImmutableGraphEltSet ges = this.tgPanel.getGES();
        if (ges == null) {
            return;
        }
        Iterable<Edge> iter = ges.getEdgeIterable();
        if (iter == null) {
            return;
        }
        for (Edge e : iter) {
            double massfade;
            double vx = e.to.x - e.from.x;
            double vy = e.to.y - e.from.y;
            double len = Math.sqrt(vx * vx + vy * vy);
            double dx = vx * this.rigidity;
            double dy = vy * this.rigidity;
            dx /= (double)(e.getLength() * 100);
            dy /= (double)(e.getLength() * 100);
            dx *= len;
            dy *= len;
            if (e.to.justMadeLocal || e.to.markedForRemoval || !e.from.justMadeLocal && !e.from.markedForRemoval) {
                e.to.dx -= dx;
                e.to.dy -= dy;
            } else {
                massfade = e.from.markedForRemoval ? e.from.massfade : 1.0 - e.from.massfade;
                massfade *= massfade;
                e.to.dx -= dx * massfade;
                e.to.dy -= dy * massfade;
            }
            if (e.from.justMadeLocal || e.from.markedForRemoval || !e.to.justMadeLocal && !e.to.markedForRemoval) {
                e.from.dx += dx;
                e.from.dy += dy;
                continue;
            }
            massfade = e.to.markedForRemoval ? e.to.massfade : 1.0 - e.to.massfade;
            massfade *= massfade;
            e.from.dx += dx * massfade;
            e.from.dy += dy * massfade;
        }
    }

    private synchronized void avoidLabels() {
        for (NodePair pair : this.tgPanel.getGES().getNodePairIterable()) {
            double massfade;
            Node n1 = pair.n1;
            Node n2 = pair.n2;
            double dx = 0.0;
            double dy = 0.0;
            double vx = n1.x - n2.x;
            double vy = n1.y - n2.y;
            double len = vx * vx + vy * vy;
            if (len == 0.0) {
                dx = Math.random();
                dy = Math.random();
            } else if (len < 360000.0) {
                dx = vx / len;
                dy = vy / len;
            }
            if (dx == 0.0 && dy == 0.0) continue;
            int repSum = n1.repulsion * n2.repulsion / 100;
            double dxdiff = dx * (double)repSum * this.rigidity;
            double dydiff = dy * (double)repSum * this.rigidity;
            if (n1.justMadeLocal || n1.markedForRemoval || !n2.justMadeLocal && !n2.markedForRemoval) {
                n1.dx += dxdiff;
                n1.dy += dydiff;
            } else {
                massfade = n2.markedForRemoval ? n2.massfade : 1.0 - n2.massfade;
                massfade *= massfade;
                n1.dx += dxdiff * massfade;
                n1.dy += dydiff * massfade;
            }
            if (n2.justMadeLocal || n2.markedForRemoval || !n1.justMadeLocal && !n1.markedForRemoval) {
                n2.dx -= dxdiff;
                n2.dy -= dydiff;
                continue;
            }
            massfade = n1.markedForRemoval ? n1.massfade : 1.0 - n1.massfade;
            massfade *= massfade;
            n2.dx -= dxdiff * massfade;
            n2.dy -= dydiff * massfade;
        }
    }

    public synchronized void startDamper() {
        this.damping = true;
        if (!this.myWaitCondition()) {
            this.notifyAll();
        }
    }

    public synchronized void stopDamper() {
        this.damping = false;
        this.damper = 1.0;
        if (!this.myWaitCondition()) {
            this.notifyAll();
        }
    }

    public synchronized void resetDamper() {
        this.damping = true;
        this.damper = 1.0;
        if (!this.myWaitCondition()) {
            this.notifyAll();
        }
    }

    public synchronized void stopMotion() {
        this.damping = true;
        this.damper = this.damper > 0.3 ? 0.3 : 0.0;
        if (!this.myWaitCondition()) {
            this.notifyAll();
        }
    }

    public synchronized void damp() {
        if (this.damping && this.motionRatio <= 0.001) {
            if ((this.maxMotion < 0.2 || this.maxMotion > 1.0 && this.damper < 0.9) && this.damper > 0.01) {
                this.damper -= 0.01;
            } else if (this.maxMotion < 0.4 && this.damper > 0.003) {
                this.damper -= 0.003;
            } else if (this.damper > 1.0E-4) {
                this.damper -= 1.0E-4;
            }
        }
        if (this.maxMotion < 0.001 && this.damping) {
            this.damper = 0.0;
        }
        if (!this.myWaitCondition()) {
            this.notifyAll();
        }
    }

    private synchronized void moveNodes() {
        this.lastMaxMotion = this.maxMotion;
        this.maxMotion = 0.0;
        for (Node n : this.tgPanel.getGES().getNodeIterable()) {
            double dx = n.dx;
            double dy = n.dy;
            n.dx = (dx *= this.damper) / 2.0;
            n.dy = (dy *= this.damper) / 2.0;
            double distMoved = Math.sqrt(dx * dx + dy * dy);
            if (!n.fixed && n != this.dragNode) {
                n.x += Math.max(-30.0, Math.min(30.0, dx));
                n.y += Math.max(-30.0, Math.min(30.0, dy));
            }
            this.maxMotion = Math.max(distMoved, this.maxMotion);
            if (!n.justMadeLocal && !n.markedForRemoval) {
                n.massfade = 1.0;
                continue;
            }
            if (!(n.massfade >= 0.004)) continue;
            n.massfade -= 0.004;
        }
        this.motionRatio = this.maxMotion > 0.0 ? this.lastMaxMotion / this.maxMotion - 1.0 : 0.0;
        this.damp();
    }

    private synchronized void relax() {
        for (int i = 0; i < 10; ++i) {
            this.relaxEdges();
            this.avoidLabels();
            this.moveNodes();
        }
        if (this.rigidity != this.newRigidity) {
            this.rigidity = this.newRigidity;
        }
        this.tgPanel.repaintAfterMove();
    }

    private boolean myWaitCondition() {
        return this.damper < 0.1 && this.damping && this.maxMotion < 0.001;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        while (this.relaxer == me) {
            try {
                this.relax();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                Thread.sleep(20L);
                TGLayout e = this;
                synchronized (e) {
                    while (this.myWaitCondition()) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    public void stop() {
        this.relaxer = null;
    }
}

