/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.throughput.mtnio;

import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import test.virtual.throughput.mtnio.DataSink;
import test.virtual.throughput.mtnio.DataSource;
import test.virtual.throughput.mtnio.Receiver;
import test.virtual.throughput.mtnio.Sender;

public class MTNIOThroughput {
    private static int OPCODE_META = 42;
    private static int OPCODE_DATA = 24;
    private static int DEFAULT_STREAMS = 2;
    private static int DEFAULT_REPEAT = 10;
    private static int DEFAULT_COUNT = -1;
    private static int TIMEOUT = 15000;
    private static int DEFAULT_SIZE = 65536;
    private static long DEFAULT_TOTAL_SIZE;
    private static long total;
    private static int count;
    private static int repeat;
    private static int size;
    private static int streams;
    private static VirtualSocketFactory sf;
    private static HashMap<String, Object> connectProperties;

    private static void configure(VirtualSocket s) throws SocketException {
        s.setTcpNoDelay(true);
        System.out.println("Configured socket: ");
        System.out.println(" sendbuffer     = " + s.getSendBufferSize());
        System.out.println(" receiverbuffer = " + s.getReceiveBufferSize());
        System.out.println(" no delay       = " + s.getTcpNoDelay());
    }

    private static void createStreamOut(VirtualSocketAddress target, DataSource d, int id, int size) {
        try {
            VirtualSocket s = sf.createClientSocket(target, TIMEOUT, connectProperties);
            System.out.println("Created DATA connection to " + target);
            MTNIOThroughput.configure(s);
            DataInputStream in = new DataInputStream(s.getInputStream());
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            out.writeInt(OPCODE_DATA);
            out.writeInt(id);
            out.flush();
            new Sender(d, s, out, in, size).start();
        }
        catch (IOException e) {
            throw new Error("Failed to create connection to " + target, e);
        }
    }

    private static double performance(long time, long size) {
        double tp = 1000.0 * (double)size / (1048576.0 * (double)time);
        double mbit = 8000.0 * (double)size / (1048576.0 * (double)time);
        if (mbit > 1000.0) {
            double tmp = mbit / 1024.0;
            System.out.printf("Test took %d ms. Througput = %4.1f MByte/s (%3.1f GBit/s)\n", time, tp, tmp);
        } else {
            System.out.printf("Test took %d ms. Througput = %4.1f MByte/s (%3.1f MBit/s)\n", time, tp, mbit);
        }
        return mbit;
    }

    public static double[] client(VirtualSocketAddress target) {
        try {
            System.out.println("Starting test: " + size + " " + count + " " + streams);
            VirtualSocket s = sf.createClientSocket(target, TIMEOUT, connectProperties);
            System.out.println("Created META connection to " + target);
            MTNIOThroughput.configure(s);
            DataInputStream in = new DataInputStream(s.getInputStream());
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            int id = 42;
            out.writeInt(OPCODE_META);
            out.writeInt(size);
            out.writeInt(count);
            out.writeInt(repeat);
            out.writeInt(streams);
            out.writeInt(id);
            out.flush();
            double[] results = new double[repeat];
            DataSource d = new DataSource();
            for (int i = 0; i < streams; ++i) {
                MTNIOThroughput.createStreamOut(target, d, id, size);
            }
            System.out.println("Starting test");
            for (int r = 0; r < repeat; ++r) {
                long start = System.currentTimeMillis();
                d.set(count);
                in.readInt();
                long end = System.currentTimeMillis();
                results[r] = MTNIOThroughput.performance(end - start, (long)count * (long)size);
            }
            d.done();
            VirtualSocketFactory.close(s, out, in);
            return results;
        }
        catch (Exception e) {
            throw new Error("Failed to create connection to " + target, e);
        }
    }

    private static void createStreamIn(VirtualServerSocket ss, DataSink d, int id, int size) {
        try {
            VirtualSocket s = ss.accept();
            System.out.println("Incoming connection from " + s.getRemoteSocketAddress());
            MTNIOThroughput.configure(s);
            DataInputStream in = new DataInputStream(s.getInputStream());
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            int opcode = in.readInt();
            if (opcode != OPCODE_DATA) {
                throw new Error("EEK: sender out of sync (2)!");
            }
            int tmp = in.readInt();
            if (tmp != id) {
                throw new Error("EEK: sender out of sync (3)!");
            }
            new Receiver(d, s, out, in, size).start();
        }
        catch (Exception e) {
            throw new Error("EEK: got exception while accepting!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void server() throws IOException {
        System.out.println("Creating server");
        VirtualServerSocket ss = sf.createServerSocket(0, 0, connectProperties);
        System.out.println("Created server on " + ss.getLocalSocketAddress());
        while (true) {
            System.out.println("Server waiting for connections");
            VirtualSocket s = null;
            DataInputStream in = null;
            DataOutputStream out = null;
            try {
                s = ss.accept();
                System.out.println("Incoming connection from " + s.getRemoteSocketAddress());
                MTNIOThroughput.configure(s);
                in = new DataInputStream(s.getInputStream());
                out = new DataOutputStream(s.getOutputStream());
                int opcode = in.readInt();
                if (opcode != OPCODE_META) {
                    throw new Error("EEK: sender out of sync!");
                }
                size = in.readInt();
                count = in.readInt();
                repeat = in.readInt();
                streams = in.readInt();
                int id = in.readInt();
                DataSink d = new DataSink();
                for (int i = 0; i < streams; ++i) {
                    MTNIOThroughput.createStreamIn(ss, d, id, size);
                }
                for (int r = 0; r < repeat; ++r) {
                    d.waitForCount(streams);
                    out.writeInt(streams);
                    out.flush();
                }
                System.out.println("done!");
            }
            catch (Exception e) {
                try {
                    throw new Error("Server got exception ", e);
                }
                catch (Throwable throwable) {
                    VirtualSocketFactory.close(s, out, in);
                    throw throwable;
                }
            }
            VirtualSocketFactory.close(s, out, in);
        }
    }

    private static void printResult(double[] result, int size) {
        double sum = 0.0;
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < result.length; ++i) {
            if (result[i] < min) {
                min = result[i];
            }
            if (result[i] > max) {
                max = result[i];
            }
            sum += result[i];
        }
        double avg = sum / (double)result.length;
        System.out.println("*** " + avg + " " + max + " " + min);
    }

    public static void main(String[] args) throws IOException {
        int i;
        connectProperties = new HashMap();
        VirtualSocketAddress target = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-target")) {
                target = new VirtualSocketAddress(args[++i]);
                continue;
            }
            if (args[i].equals("-size")) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-total")) {
                total = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-count")) {
                count = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-repeat")) {
                repeat = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-streams")) {
                streams = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-buffers")) {
                int size = Integer.parseInt(args[++i]);
                connectProperties.put("sendbuffer", size);
                connectProperties.put("receivebuffer", size);
                continue;
            }
            System.err.println("Unknown option: " + args[i]);
        }
        try {
            sf = VirtualSocketFactory.createSocketFactory(connectProperties, true);
        }
        catch (InitializationException e) {
            throw new Error("Failed to create socketfactory!", e);
        }
        if (target == null) {
            MTNIOThroughput.server();
        } else if (size > 0) {
            if (count == -1) {
                count = (int)(total / (long)size);
            }
            MTNIOThroughput.client(target);
        } else {
            for (i = 1024; i <= 262144; i *= 2) {
                size = i;
                count = (int)(total / (long)size);
                double[] result = MTNIOThroughput.client(target);
                MTNIOThroughput.printResult(result, i);
            }
        }
    }

    static {
        total = DEFAULT_TOTAL_SIZE = 0x40000000L;
        count = DEFAULT_COUNT;
        repeat = DEFAULT_REPEAT;
        size = DEFAULT_SIZE;
        streams = DEFAULT_STREAMS;
    }
}

