/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.hub;

import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.util.Arrays;

public class VizTest {
    private VirtualSocketFactory factory;
    private int state = 0;
    private boolean done = false;

    public VizTest(VirtualSocketFactory factory) throws IOException {
        this.factory = factory;
        System.out.println("##### VIZ TEST START #####");
        boolean ok = factory.getServiceLink().registerProperty("smartsockets.viz", "I^ibis0,@little@house@ontheprairy");
        if (!ok) {
            System.out.println("EEP: registration failed!");
        }
    }

    public synchronized void done() {
        this.done = true;
    }

    public synchronized boolean getDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.getDone()) {
                Object[] hubs = this.factory.getKnownHubs();
                System.out.println("Known hubs: " + Arrays.deepToString(hubs));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String tmp = "I^ibis" + this.state++ + ",@little@house@ontheprairy";
                System.out.println("PROP: " + tmp);
                boolean ok = this.factory.getServiceLink().updateProperty("smartsockets.viz", tmp);
                if (!ok) {
                    System.out.println("EEP: update failed!");
                }
                if (this.state < 5) continue;
                this.done();
            }
        }
        catch (Exception e) {
            System.err.println("Oops: " + e);
            e.printStackTrace(System.err);
        }
        finally {
            try {
                this.factory.end();
            }
            catch (Exception exception) {}
        }
        System.out.println("Done!");
        try {
            Thread.sleep(50000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            VirtualSocketFactory factory = VirtualSocketFactory.createSocketFactory(null, true);
            System.out.println("Created socket factory");
            new VizTest(factory).run();
        }
        catch (Exception e) {
            System.err.println("Oops: " + e);
            e.printStackTrace(System.err);
        }
    }
}

