/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.alltoall;

import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Client {
    static final int TIMEOUT = 5000;
    static final int MAX_TRIES = 5;
    static final int MAX_WAIT = 60000;
    static VirtualServerSocket server;
    static VirtualSocketFactory factory;
    static int rank;
    static int size;
    static VirtualSocketAddress[] others;
    static boolean[] outgoing;
    static boolean[] incoming;
    static Exception[] outgoingExceptions;
    static int outgoingCount;

    static void close(VirtualSocket s, OutputStream out, InputStream in) {
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getPoolFromServer(VirtualSocketAddress a) throws IOException {
        System.out.println("Connecting to server " + a);
        VirtualSocket s = factory.createClientSocket(a, 5000, null);
        System.out.println("Got connection");
        DataInputStream in = new DataInputStream(s.getInputStream());
        DataOutputStream out = new DataOutputStream(s.getOutputStream());
        System.out.println("Writing my address");
        out.writeUTF(server.getLocalSocketAddress().toString());
        out.flush();
        System.out.println("Waiting for reply");
        rank = in.readInt();
        System.out.println("My rank: " + rank);
        size = in.readInt();
        System.out.println("Total machines: " + size);
        others = new VirtualSocketAddress[size];
        outgoing = new boolean[size];
        incoming = new boolean[size];
        Arrays.fill(outgoing, false);
        Arrays.fill(incoming, false);
        outgoingExceptions = new Exception[size];
        for (int i = 0; i < size; ++i) {
            Client.others[i] = new VirtualSocketAddress(in.readUTF());
            System.out.println("Machine " + i + " -> " + others[i]);
        }
        System.out.println("Closing connection to server");
        Client.close(s, out, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectTo(int i) {
        DataOutputStream out;
        DataInputStream in;
        VirtualSocket s;
        block5: {
            s = null;
            in = null;
            out = null;
            try {
                System.out.println("Setting up connection to " + others[i]);
                s = factory.createClientSocket(others[i], 5000, null);
                in = new DataInputStream(s.getInputStream());
                out = new DataOutputStream(s.getOutputStream());
                out.writeInt(rank);
                out.flush();
                int src = in.readInt();
                if (src == i) {
                    Client.outgoing[i] = true;
                    System.out.println("Connection to " + others[i] + " OK!");
                    ++outgoingCount;
                    break block5;
                }
                System.out.println("Connection to " + others[i] + " failed! Got " + src + " instead!");
                Client.outgoingExceptions[i] = new Exception("Wrong receiver");
            }
            catch (Exception e) {
                try {
                    System.out.println("Connection to " + i + " failed! Got exception " + e);
                    Client.outgoingExceptions[i] = e;
                }
                catch (Throwable throwable) {
                    Client.close(s, out, in);
                    throw throwable;
                }
                Client.close(s, out, in);
            }
        }
        Client.close(s, out, in);
    }

    private static void connectToOthers() {
        for (int tries = 0; outgoingCount < others.length - 1 && tries < 5; ++tries) {
            System.out.println("Connection to other machines (try " + tries + " of " + 5 + ")");
            for (int i = 0; i < others.length; ++i) {
                if (i == rank || outgoing[i]) continue;
                Client.connectTo(i);
            }
            System.out.println(outgoingCount + " of " + (others.length - 1) + " succeeded");
        }
    }

    private static void printResults() {
        System.out.println();
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println();
        System.out.println("Machine: " + server.getLocalSocketAddress());
        System.out.println();
        System.out.println("Rank: " + rank);
        System.out.println("Size: " + size);
        System.out.println();
        System.out.println("End result of connection tests: ");
        for (int i = 0; i < others.length; ++i) {
            if (i == rank) continue;
            boolean ok = outgoing[i] && incoming[i];
            System.out.println(i + ": " + others[i] + " " + (ok ? "ok" : "failed"));
            if (outgoing[i]) {
                System.out.println(" out - OK");
            } else {
                Exception e = outgoingExceptions[i];
                System.out.println(" out - FAILED (" + (e == null ? "?" : e.toString()) + ")");
            }
            if (incoming[i]) {
                System.out.println(" in - OK");
            } else {
                System.out.println(" in - FAILED");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage java test.alltoall.Client <server>");
            System.exit(1);
        }
        try {
            System.out.println("Client started");
            factory = VirtualSocketFactory.createSocketFactory();
            server = factory.createServerSocket(0, 50, null);
            System.out.println("Created server socket " + server.getLocalSocketAddress());
            Client.getPoolFromServer(new VirtualSocketAddress(args[0]));
            AcceptThread a = new AcceptThread();
            a.start();
            System.out.println("Connection to others...");
            Client.connectToOthers();
            System.out.println("Done connection to others, waiting for incoming connections...");
            int sleep = 0;
            while (!a.done() && sleep < 60000) {
                try {
                    sleep += 5000;
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
            a.quit();
            Client.printResults();
        }
        catch (Exception e) {
            System.err.println("Client got exception " + e);
            e.printStackTrace(System.err);
        }
    }

    static {
        outgoingCount = 0;
    }

    private static class AcceptThread
    extends Thread {
        int count = 0;
        boolean quit = false;

        private AcceptThread() {
        }

        synchronized boolean done() {
            return this.count == others.length - 1;
        }

        synchronized void quit() {
            this.quit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VirtualSocket s = null;
            DataInputStream in = null;
            DataOutputStream out = null;
            boolean stop = false;
            while (!stop && !this.done()) {
                block12: {
                    try {
                        server.setSoTimeout(5000);
                        s = server.accept();
                        in = new DataInputStream(s.getInputStream());
                        out = new DataOutputStream(s.getOutputStream());
                        int src = in.readInt();
                        out.writeInt(rank);
                        out.flush();
                        if (!incoming[src]) {
                            Client.incoming[src] = true;
                            AcceptThread acceptThread = this;
                            synchronized (acceptThread) {
                                ++this.count;
                            }
                            System.out.println("AcceptThread: connection from " + src + " (NEW)");
                            break block12;
                        }
                        System.out.println("AcceptThread: connection from " + src + " (DOUBLE)");
                    }
                    catch (Exception e) {
                        try {
                            System.out.println("AcceptThread: exception " + e);
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            Client.close(s, out, in);
                            s = null;
                            in = null;
                            out = null;
                            throw throwable;
                        }
                        Client.close(s, out, in);
                        s = null;
                        in = null;
                        out = null;
                    }
                }
                Client.close(s, out, in);
                s = null;
                in = null;
                out = null;
                AcceptThread acceptThread = this;
                synchronized (acceptThread) {
                    stop = this.quit;
                }
            }
        }
    }
}

