/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.state;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.Selector;
import java.util.LinkedList;

public class DirectionsSelector
extends Selector {
    private LinkedList<DirectSocketAddress> good = new LinkedList();
    private LinkedList<DirectSocketAddress> bad = new LinkedList();
    private final DirectSocketAddress client;
    private final boolean includeLocal;

    public DirectionsSelector(DirectSocketAddress client, boolean includeLocal) {
        this.client = client;
        this.includeLocal = includeLocal;
    }

    @Override
    public boolean needAll() {
        return true;
    }

    @Override
    public void select(HubDescription description) {
        if (description.containsClient(this.client)) {
            if (description.isLocal() && this.includeLocal) {
                this.good.addFirst(description.hubAddress);
            } else if (description.haveConnection()) {
                this.good.addLast(description.hubAddress);
            } else {
                HubDescription indirect = description.getIndirection();
                if (indirect != null && indirect.haveConnection()) {
                    this.bad.addFirst(indirect.hubAddress);
                }
            }
        }
    }

    public LinkedList<DirectSocketAddress> getResult() {
        LinkedList<DirectSocketAddress> result = new LinkedList<DirectSocketAddress>();
        result.addAll(this.good);
        result.addAll(this.bad);
        return result;
    }
}

