/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.servicelink;

import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.connections.VirtualConnectionIndex;
import ibis.smartsockets.hub.servicelink.CallBack;
import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.hub.servicelink.HubInfo;
import ibis.smartsockets.hub.servicelink.VirtualConnectionCallBack;
import ibis.smartsockets.util.ThreadPool;
import ibis.smartsockets.util.TypedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLink
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.servicelink");
    private static final Logger statslogger = LoggerFactory.getLogger((String)"ibis.smartsockets.statistics");
    private final HashMap<String, Object> callbacks = new HashMap();
    private final HashMap<Integer, Object> infoRequests = new HashMap();
    private final DirectSocketFactory factory;
    private final DirectSocketAddress myAddress;
    private final List<DirectSocketAddress> hubs;
    private DirectSocketAddress hubAddress;
    private boolean connected = false;
    private boolean done = false;
    private DirectSocket hub;
    private DataOutputStream out;
    private DataInputStream in;
    private int nextCallbackID = 0;
    private int maxWaitTime;
    private final VirtualConnectionIndex vcIndex = new VirtualConnectionIndex(true);
    private VirtualConnectionCallBack vcCallBack = null;
    private int sendBuffer = -1;
    private int receiveBuffer = -1;
    private long incomingConnections;
    private long acceptedIncomingConnections;
    private long rejectedIncomingConnections;
    private long failedIncomingConnections;
    private long outgoingConnections;
    private long acceptedOutgoingConnections;
    private long rejectedOutgoingConnections;
    private long failedOutgoingConnections;
    private long incomingBytes;
    private long outgoingBytes;
    private long incomingDataMessages;
    private long outgoingDataMessages;
    private long incomingMetaMessages;
    private long outgoingMetaMessages;
    private final int virtualHubPort;
    private final long maxReconnect;
    private final boolean forceConnection;
    private final boolean keepAlive;
    private final int timeout;

    private ServiceLink(TypedProperties properties, List<DirectSocketAddress> hubs, DirectSocketAddress myAddress, int sendBuffer, int receiveBuffer, int virtualHubPort, long maxReconnect, boolean forceConnection, boolean keepAlive) throws IOException {
        this.hubs = hubs;
        this.sendBuffer = sendBuffer;
        this.receiveBuffer = receiveBuffer;
        this.myAddress = myAddress;
        this.maxReconnect = maxReconnect;
        this.forceConnection = forceConnection;
        this.keepAlive = keepAlive;
        this.virtualHubPort = virtualHubPort;
        this.factory = DirectSocketFactory.getSocketFactory(properties);
        this.timeout = this.factory.getDefaultTimeout();
        this.maxWaitTime = 2 * this.timeout;
        ThreadPool.createNew(this, "ServiceLink Message Reader");
    }

    public synchronized boolean getDone() {
        return this.done;
    }

    public synchronized void setDone() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.closeConnectionToHub();
    }

    public synchronized void registerVCCallBack(VirtualConnectionCallBack cb) {
        this.vcCallBack = cb;
    }

    public synchronized VirtualConnectionCallBack getVCCallBack() {
        return this.vcCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String identifier, CallBack callback) {
        HashMap<String, Object> hashMap = this.callbacks;
        synchronized (hashMap) {
            if (this.callbacks.containsKey(identifier)) {
                logger.warn("ServiceLink: refusing to override callback " + identifier, (Throwable)new Exception());
                return;
            }
            this.callbacks.put(identifier, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findCallback(String identifier) {
        HashMap<String, Object> hashMap = this.callbacks;
        synchronized (hashMap) {
            return this.callbacks.get(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCallback(String identifier) {
        HashMap<String, Object> hashMap = this.callbacks;
        synchronized (hashMap) {
            this.callbacks.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerInfoRequest(Integer identifier) {
        HashMap<Integer, Object> hashMap = this.infoRequests;
        synchronized (hashMap) {
            if (this.infoRequests.containsKey(identifier)) {
                logger.warn("ServiceLink: refusing to override simple callback " + identifier, (Throwable)new Exception());
                return;
            }
            this.infoRequests.put(identifier, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInfoRequest(Integer identifier) {
        HashMap<Integer, Object> hashMap = this.infoRequests;
        synchronized (hashMap) {
            this.infoRequests.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeInfoReply(Integer identifier, Object value) {
        HashMap<Integer, Object> hashMap = this.infoRequests;
        synchronized (hashMap) {
            if (this.infoRequests.containsKey(identifier)) {
                this.infoRequests.put(identifier, value);
                this.infoRequests.notifyAll();
            } else if (logger.isInfoEnabled()) {
                logger.info("Dropped info reply for: " + identifier + " (" + value + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getInfoReply(Integer identifier) {
        HashMap<Integer, Object> hashMap = this.infoRequests;
        synchronized (hashMap) {
            Object result = this.infoRequests.get(identifier);
            while (result == null) {
                try {
                    this.infoRequests.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                result = this.infoRequests.get(identifier);
            }
            this.infoRequests.remove(identifier);
            return result;
        }
    }

    protected boolean getInfoReply(Integer identifier, int value) {
        Object result = this.getInfoReply(identifier);
        if (result instanceof Integer) {
            return (Integer)result == value;
        }
        return false;
    }

    private synchronized void setConnected(boolean value) {
        this.connected = value;
        this.notifyAll();
    }

    private synchronized boolean getConnected() {
        return this.connected;
    }

    public synchronized void waitConnected(int time) throws IOException {
        if (time < 0) {
            if (!this.connected) {
                throw new IOException("No connection to hub!");
            }
            return;
        }
        long deadline = System.currentTimeMillis() + (long)time;
        long timeleft = time;
        while (!this.connected) {
            try {
                if (time > 0) {
                    this.wait(timeleft);
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.connected || time <= 0 || (timeleft = deadline - System.currentTimeMillis()) > 0L) continue;
            throw new IOException("No connection to hub!");
        }
    }

    private synchronized void closeConnectionToHub() {
        if (!this.getConnected()) {
            return;
        }
        this.setConnected(false);
        DirectSocketFactory.close(this.hub, (OutputStream)this.out, (InputStream)this.in);
    }

    private void connectToHub(DirectSocketAddress address) throws IOException {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Service link attempting to connect to hub: " + address);
            }
            this.hub = this.factory.createSocket(address, this.timeout, 0, this.sendBuffer, this.receiveBuffer, null, false, this.virtualHubPort);
            this.hub.setTcpNoDelay(true);
            if (logger.isDebugEnabled()) {
                logger.debug("Service link send buffer = " + this.hub.getSendBufferSize());
                logger.debug("Service link recv buffer = " + this.hub.getReceiveBufferSize());
            }
            this.out = new DataOutputStream(new BufferedOutputStream(this.hub.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(this.hub.getInputStream()));
            this.out.write(2);
            this.out.writeUTF(this.myAddress.toString());
            this.out.flush();
            int reply = this.in.read();
            if (reply != 3) {
                throw new IOException("Hub denied connection request (got: " + reply);
            }
            this.hubAddress = DirectSocketAddress.getByAddress(this.in.readUTF());
            if (logger.isInfoEnabled()) {
                logger.info("Hub at " + address + " accepted connection, it's real address is: " + this.hubAddress);
            }
            this.hub.setSoTimeout(0);
            this.hub.setKeepAlive(this.keepAlive);
            this.setConnected(true);
        }
        catch (IOException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Connection setup to hub at " + address + " failed: ", (Throwable)e);
            }
            this.closeConnectionToHub();
            throw e;
        }
    }

    private final void skip(int bytes) throws IOException {
        while (bytes > 0) {
            bytes = (int)((long)bytes - this.in.skip(bytes));
        }
    }

    private void handleInfoMessage() throws IOException {
        CallBack cb;
        DirectSocketAddress source = DirectSocketAddress.read(this.in);
        DirectSocketAddress sourceHub = DirectSocketAddress.read(this.in);
        this.skip(4);
        boolean returnedToSender = this.in.readBoolean();
        DirectSocketAddress.skip(this.in);
        DirectSocketAddress.skip(this.in);
        String targetModule = this.in.readUTF();
        int opcode = this.in.readInt();
        byte[][] message = this.readMessageBlob();
        if (logger.isInfoEnabled()) {
            logger.info("ServiceLink: Received message for " + targetModule + " (returnToSender: " + returnedToSender + ")");
        }
        if ((cb = (CallBack)this.findCallback(targetModule)) == null) {
            logger.warn("ServiceLink: Callback " + targetModule + " not found");
        } else {
            cb.gotMessage(source, sourceHub, opcode, returnedToSender, message);
        }
        ++this.incomingMetaMessages;
    }

    private void handleInfo() throws IOException {
        int id = this.in.readInt();
        int count = this.in.readInt();
        if (logger.isInfoEnabled()) {
            logger.info("ServiceLink: Received info for " + id + ".  Receiving " + count + " strings....");
        }
        String[] info = new String[count];
        for (int i = 0; i < count; ++i) {
            info[i] = this.in.readUTF();
            if (!logger.isInfoEnabled()) continue;
            logger.info(i + ": " + info[i]);
        }
        if (logger.isInfoEnabled()) {
            logger.info("done receiving info");
        }
        this.storeInfoReply(id, info);
    }

    private void handlePropertyAck() throws IOException {
        int id = this.in.readInt();
        int value = this.in.readInt();
        if (logger.isInfoEnabled()) {
            logger.info("ServiceLink: Received property ack for " + id + "  (" + value + ")");
        }
        this.storeInfoReply(id, value);
    }

    private void handleIncomingConnection() throws IOException {
        VirtualConnectionCallBack vcb;
        ++this.incomingConnections;
        DirectSocketAddress source = DirectSocketAddress.read(this.in);
        DirectSocketAddress sourceHub = DirectSocketAddress.read(this.in);
        DirectSocketAddress.skip(this.in);
        DirectSocketAddress.skip(this.in);
        long index = this.in.readLong();
        int timeout = this.in.readInt();
        int port = this.in.readInt();
        int fragment = this.in.readInt();
        int buffer = this.in.readInt();
        if (logger.isInfoEnabled()) {
            logger.info("ServiceLink: Received request for incoming connection from " + source + " (" + index + ")");
        }
        if ((vcb = this.getVCCallBack()) == null) {
            if (logger.isInfoEnabled()) {
                logger.info("DENIED connection: " + index + ": no callback!");
            }
            this.nackVirtualConnection(index, (byte)1);
            return;
        }
        vcb.connect(source, sourceHub, port, fragment, buffer, timeout, index);
        if (logger.isInfoEnabled()) {
            logger.info("QUEUED connection: " + index + ": waiting for accept");
        }
    }

    private void handleIncomingConnectionACK() throws IOException {
        long index = this.in.readLong();
        int fragment = this.in.readInt();
        int buffer = this.in.readInt();
        VirtualConnectionCallBack vcb = this.getVCCallBack();
        if (vcb == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Cannot deliver ACK: " + index + ": no callback!");
            }
            this.closeVirtualConnection(index);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Delivering ACK: " + index + "(" + fragment + ", " + buffer + ")");
        }
        vcb.connectACK(index, fragment, buffer);
    }

    private void handleIncomingConnectionACKACK() throws IOException {
        long index = this.in.readLong();
        boolean succes = this.in.readBoolean();
        VirtualConnectionCallBack vcb = this.getVCCallBack();
        if (vcb == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Cannot deliver ACK ACK: " + index + ": no callback!");
            }
            if (succes) {
                this.closeVirtualConnection(index);
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Delivering ACK ACK: " + index);
        }
        vcb.connectACKACK(index, succes);
    }

    private void handleIncomingConnectionNACK() throws IOException {
        long index = this.in.readLong();
        byte reason = this.in.readByte();
        VirtualConnectionCallBack vcb = this.getVCCallBack();
        if (vcb == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Cannot deliver NACK: " + index + ": no callback!");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Delivering NACK: " + index);
        }
        vcb.connectNACK(index, reason);
    }

    private void disconnectCallback(long index) {
        VirtualConnectionCallBack vcb = this.getVCCallBack();
        if (vcb == null) {
            logger.warn("Cannot forward disconnect(" + index + "): no callback!");
            return;
        }
        vcb.disconnect(index);
    }

    private void handleIncomingClose() throws IOException {
        long index = this.in.readLong();
        if (logger.isDebugEnabled()) {
            logger.debug("Got close for connection: " + index);
        }
        this.disconnectCallback(index);
    }

    private void handleIncomingMessage() throws IOException {
        long index = this.in.readLong();
        int len = this.in.readInt();
        if (logger.isDebugEnabled()) {
            logger.debug("Reading virtual message(" + len + ") for connection: " + index);
        }
        ++this.incomingDataMessages;
        this.incomingBytes += (long)len;
        VirtualConnectionCallBack vcb = this.getVCCallBack();
        if (vcb == null) {
            logger.warn("Received virtual message(" + len + ") for connection: " + index + " which doesn't exist!!");
            this.skip(len);
            this.closeVirtualConnection(index);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Delivering virtual message(" + len + ") for connection: " + index);
        }
        if (!vcb.gotMessage(index, len, this.in)) {
            if (logger.isInfoEnabled()) {
                logger.debug("Message for " + index + " not read!");
            }
            this.skip(len);
        }
    }

    private void handleIncomingAck() throws IOException {
        VirtualConnectionCallBack vcb;
        long index = this.in.readLong();
        int data = this.in.readInt();
        if (logger.isDebugEnabled()) {
            logger.debug("Got Message ACK for connection: " + index);
        }
        if ((vcb = this.getVCCallBack()) == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Cannot delivering virtual message ACK for connection: " + index);
            }
            this.closeVirtualConnection(index);
            return;
        }
        vcb.gotMessageACK(index, data);
    }

    void receiveMessages() {
        block15: while (this.getConnected()) {
            try {
                int header = this.in.read();
                if (logger.isDebugEnabled()) {
                    logger.debug("Servicelink got message (type: " + header + ")");
                }
                switch (header) {
                    case -1: {
                        this.closeConnectionToHub();
                        continue block15;
                    }
                    case 69: {
                        this.handleInfoMessage();
                        continue block15;
                    }
                    case 60: {
                        this.handleIncomingConnection();
                        continue block15;
                    }
                    case 61: {
                        this.handleIncomingConnectionACK();
                        continue block15;
                    }
                    case 63: {
                        this.handleIncomingConnectionACKACK();
                        continue block15;
                    }
                    case 62: {
                        this.handleIncomingConnectionNACK();
                        continue block15;
                    }
                    case 64: {
                        this.handleIncomingClose();
                        continue block15;
                    }
                    case 65: {
                        this.handleIncomingMessage();
                        continue block15;
                    }
                    case 66: {
                        this.handleIncomingAck();
                        continue block15;
                    }
                    case 49: {
                        this.handleInfo();
                        continue block15;
                    }
                    case 33: {
                        this.handlePropertyAck();
                        continue block15;
                    }
                }
                logger.warn("ServiceLink: Received unknown opcode!: " + header);
                this.closeConnectionToHub();
            }
            catch (IOException e) {
                if (!this.getDone()) {
                    logger.warn("ServiceLink: Exception while receiving!", (Throwable)e);
                }
                this.closeConnectionToHub();
            }
        }
    }

    private byte[][] readMessageBlob() throws IOException {
        Object message = null;
        int bytes = this.in.readInt();
        if (bytes > 0) {
            int len = this.in.readInt();
            message = new byte[len][];
            for (int i = 0; i < len; ++i) {
                int tmp = this.in.readInt();
                message[i] = new byte[tmp];
                if (tmp <= 0) continue;
                this.in.readFully(message[i]);
            }
        }
        return message;
    }

    private void writeMessageBlob(byte[][] message) throws IOException {
        if (message == null) {
            this.out.writeInt(0);
        } else {
            int totalBytes = 4;
            for (byte[] b : message) {
                totalBytes += 4;
                if (b == null) continue;
                totalBytes += b.length;
            }
            this.out.writeInt(totalBytes);
            this.out.writeInt(message.length);
            for (byte[] b : message) {
                if (b == null) {
                    this.out.writeInt(0);
                    continue;
                }
                this.out.writeInt(b.length);
                this.out.write(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DirectSocketAddress target, DirectSocketAddress targetHub, String targetModule, int opcode, byte[][] message) {
        if (!this.getConnected()) {
            if (logger.isInfoEnabled()) {
                logger.info("Cannot send message: not connected to hub");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Sending message to hub: [" + target.toString() + ", " + targetModule + ", " + opcode + ", " + Arrays.deepToString((Object[])message) + "]");
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(69);
                DirectSocketAddress.write(this.myAddress, this.out);
                DirectSocketAddress.write(this.hubAddress, this.out);
                this.out.writeInt(-1);
                this.out.writeBoolean(false);
                DirectSocketAddress.write(target, this.out);
                DirectSocketAddress.write(targetHub, this.out);
                this.out.writeUTF(targetModule);
                this.out.writeInt(opcode);
                this.writeMessageBlob(message);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
        }
        ++this.outgoingMetaMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataMessage(DirectSocketAddress target, DirectSocketAddress targetHub, String targetModule, byte[] message) {
        if (!this.getConnected()) {
            if (logger.isInfoEnabled()) {
                logger.info("Cannot send message: not connected to hub");
            }
            return;
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(68);
                this.out.writeInt(4 + targetHub.getAddress().length + 4 + target.getAddress().length + 4 + (message == null ? 0 : message.length));
                DirectSocketAddress.write(targetHub, this.out);
                DirectSocketAddress.write(target, this.out);
                if (message == null) {
                    this.out.writeInt(0);
                } else {
                    this.out.writeInt(message.length);
                    this.out.write(message);
                }
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
        }
        ++this.outgoingMetaMessages;
    }

    private synchronized int getNextSimpleCallbackID() {
        return this.nextCallbackID++;
    }

    public ClientInfo[] localClients() throws IOException {
        return this.clients(this.hubAddress, "");
    }

    public ClientInfo[] localClients(String tag) throws IOException {
        return this.clients(this.hubAddress, tag);
    }

    public ClientInfo[] clients(DirectSocketAddress hub) throws IOException {
        return this.clients(hub, "");
    }

    private ClientInfo[] convertToClientInfo(String[] message) {
        ClientInfo[] result = new ClientInfo[message.length];
        for (int i = 0; i < message.length; ++i) {
            result[i] = new ClientInfo(message[i]);
        }
        return result;
    }

    private HubInfo[] convertToHubInfo(String[] message) {
        HubInfo[] result = new HubInfo[message.length];
        for (int i = 0; i < message.length; ++i) {
            result[i] = new HubInfo(message[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo[] clients(DirectSocketAddress hub, String tag) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting client list from hub");
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            ClientInfo[] clientInfoArray = this.out;
            synchronized (this.out) {
                this.out.write(42);
                this.out.writeInt(id);
                this.out.writeUTF(hub.toString());
                this.out.writeUTF(tag);
                this.out.flush();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                clientInfoArray = this.convertToClientInfo((String[])this.getInfoReply(id));
                return clientInfoArray;
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    public ClientInfo[] clients() throws IOException {
        return this.clients("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo[] clients(String tag) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting client list from hub");
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            ClientInfo[] clientInfoArray = this.out;
            synchronized (this.out) {
                this.out.write(43);
                this.out.writeInt(id);
                this.out.writeUTF(tag);
                this.out.flush();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                clientInfoArray = this.convertToClientInfo((String[])this.getInfoReply(id));
                return clientInfoArray;
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectSocketAddress[] hubs() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting hub list from hub");
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            DirectSocketAddress[] directSocketAddressArray = this.out;
            synchronized (this.out) {
                this.out.write(40);
                this.out.writeInt(id);
                this.out.flush();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                directSocketAddressArray = DirectSocketAddress.convertToSocketAddressSet((String[])this.getInfoReply(id));
                return directSocketAddressArray;
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    public void addHubs(DirectSocketAddress ... hubs) {
    }

    public void addHubs(String ... hubs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HubInfo[] hubDetails() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting hub details from hub");
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            HubInfo[] hubInfoArray = this.out;
            synchronized (this.out) {
                this.out.write(44);
                this.out.writeInt(id);
                this.out.flush();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                hubInfoArray = this.convertToHubInfo((String[])this.getInfoReply(id));
                return hubInfoArray;
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectSocketAddress[] locateClient(String client) throws IOException {
        this.waitConnected(this.maxWaitTime);
        if (logger.isInfoEnabled()) {
            logger.info("Requesting direction to client " + client + " from hub");
        }
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            DirectSocketAddress[] directSocketAddressArray = this.out;
            synchronized (this.out) {
                this.out.write(45);
                this.out.writeInt(id);
                this.out.writeUTF(client);
                this.out.flush();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                directSocketAddressArray = DirectSocketAddress.convertToSocketAddressSet((String[])this.getInfoReply(id));
                return directSocketAddressArray;
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    public DirectSocketAddress getAddress() throws IOException {
        this.waitConnected(this.maxWaitTime);
        return this.hubAddress;
    }

    public long getConnectionNumber() {
        return this.vcIndex.nextIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVirtualConnection(long index, DirectSocketAddress target, DirectSocketAddress targetHub, int port, int fragment, int buffer, int timeout) throws IOException {
        if (!this.getConnected()) {
            throw new IOException("No connection to hub!");
        }
        if (timeout < 0) {
            timeout = 0;
        }
        if (logger.isInfoEnabled()) {
            logger.debug("Creating virtual connection: " + index);
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(60);
                DirectSocketAddress.write(this.myAddress, this.out);
                DirectSocketAddress.write(this.hubAddress, this.out);
                DirectSocketAddress.write(target, this.out);
                DirectSocketAddress.write(targetHub, this.out);
                this.out.writeLong(index);
                this.out.writeInt(timeout);
                this.out.writeInt(port);
                this.out.writeInt(fragment);
                this.out.writeInt(buffer);
                this.out.flush();
            }
            ++this.outgoingConnections;
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackVirtualConnection(long index, int fragment, int buffer) {
        if (!this.getConnected()) {
            logger.warn("Failed to ACK virtual connection: no connection to hub");
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(61);
                this.out.writeLong(index);
                this.out.writeInt(fragment);
                this.out.writeInt(buffer);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing ACK to hub!", (Throwable)e);
            this.closeConnectionToHub();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Send ACK for connection: " + index + " (" + fragment + ", " + buffer + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackAckVirtualConnection(long index, boolean success) {
        if (!this.getConnected()) {
            logger.warn("Failed to ACK virtual connection: no connection to hub");
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeByte(63);
                this.out.writeLong(index);
                this.out.writeBoolean(success);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing ACK to hub!", (Throwable)e);
            this.closeConnectionToHub();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Send ACK for connection: " + index + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nackVirtualConnection(long index, byte reason) {
        ++this.rejectedIncomingConnections;
        if (!this.getConnected()) {
            logger.warn("Failed to NACK virtual connection: no connection to hub");
            return;
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(62);
                this.out.writeLong(index);
                this.out.writeByte(reason);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing NACK to hub!", (Throwable)e);
            this.closeConnectionToHub();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Send NACK for connection: " + index + "(" + reason + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeVirtualConnection(long index) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing virtual connection: " + index);
        }
        if (!this.getConnected()) {
            throw new IOException("No connection to hub");
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(64);
                this.out.writeLong(index);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Virtual connection " + index + " closed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendVirtualMessage(long index, byte[] message, int off, int len, int timeout) throws IOException {
        if (!this.getConnected()) {
            throw new IOException("No connection to hub!");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Sending virtual message for connection: " + index);
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(65);
                this.out.writeLong(index);
                this.out.writeInt(len);
                this.out.write(message, off, len);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
        }
        ++this.outgoingDataMessages;
        this.outgoingBytes += (long)len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackVirtualMessage(long index, int data) throws IOException {
        if (!this.getConnected()) {
            throw new IOException("No connection to hub!");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Ack virtual message: " + index);
        }
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(66);
                this.out.writeLong(index);
                this.out.writeInt(data);
                this.out.flush();
            }
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerProperty(String tag, String value) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting info registration: " + tag + " " + value);
        }
        if (value == null) {
            value = "";
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(30);
                this.out.writeInt(id);
                this.out.writeUTF(tag);
                this.out.writeUTF(value);
                this.out.flush();
            }
            boolean bl = this.getInfoReply(id, 34);
            return bl;
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateProperty(String tag, String value) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting info update: " + tag + " " + value);
        }
        if (value == null) {
            value = "";
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(31);
                this.out.writeInt(id);
                this.out.writeUTF(tag);
                this.out.writeUTF(value);
                this.out.flush();
            }
            boolean bl = this.getInfoReply(id, 34);
            return bl;
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProperty(String tag) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("Requesting info removal: " + tag);
        }
        this.waitConnected(this.maxWaitTime);
        Integer id = this.getNextSimpleCallbackID();
        this.registerInfoRequest(id);
        try {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.write(32);
                this.out.writeInt(id);
                this.out.writeUTF(tag);
                this.out.flush();
            }
            boolean bl = this.getInfoReply(id, 34);
            return bl;
        }
        catch (IOException e) {
            logger.warn("ServiceLink: Exception while writing to hub!", (Throwable)e);
            this.closeConnectionToHub();
            throw new IOException("Connection to hub lost!");
        }
        finally {
            this.removeInfoRequest(id);
        }
    }

    public void printStatistics(String prefix) {
        if (statslogger.isInfoEnabled()) {
            // empty if block
        }
    }

    @Override
    public void run() {
        while (!this.getDone()) {
            int sleep = 1000;
            long end = System.currentTimeMillis() + this.maxReconnect;
            do {
                if (this.hubAddress == null) {
                    for (DirectSocketAddress a : this.hubs) {
                        try {
                            this.connectToHub(a);
                            this.hubAddress = a;
                            break;
                        }
                        catch (IOException e) {
                            if (!logger.isInfoEnabled()) continue;
                            logger.info("Failed to connect to hub: " + a);
                        }
                    }
                    if (!this.getConnected()) {
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    try {
                        this.connectToHub(this.hubAddress);
                    }
                    catch (IOException e) {
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (sleep < 16000) {
                    sleep *= 2;
                }
                if (!this.forceConnection || this.maxReconnect <= 0L || System.currentTimeMillis() <= end) continue;
                logger.error("Permanent failure of servicelink! -- will exit");
                System.exit(1);
            } while (!this.getConnected());
            sleep = 1000;
            this.receiveMessages();
        }
    }

    public static ServiceLink getServiceLink(TypedProperties p, List<DirectSocketAddress> hubs, DirectSocketAddress myAddress) {
        if (hubs == null || hubs.size() == 0) {
            throw new NullPointerException("Hub address is null!");
        }
        if (myAddress == null) {
            throw new NullPointerException("Local address is null!");
        }
        int sendBuffer = -1;
        int receiveBuffer = -1;
        int virtualHubPort = 42;
        boolean force = true;
        boolean keepAlive = false;
        long maxReconnect = 0L;
        if (p != null) {
            sendBuffer = p.getIntProperty("smartsockets.servicelink.sendbuffer", -1);
            receiveBuffer = p.getIntProperty("smartsockets.servicelink.receivebuffer", -1);
            virtualHubPort = p.getIntProperty("smartsockets.hub.virtualPort", 42);
            force = p.booleanProperty("smartsockets.servicelink.force");
            keepAlive = p.booleanProperty("smartsockets.servicelink.keepalive");
            if (force) {
                maxReconnect = (long)p.getIntProperty("smartsockets.servicelink.retries") * (long)p.getIntProperty("smartsockets.servicelink.timeout");
            }
        }
        try {
            return new ServiceLink(p, hubs, myAddress, sendBuffer, receiveBuffer, virtualHubPort, maxReconnect, force, keepAlive);
        }
        catch (Exception e) {
            logger.warn("ServiceLink: Failed to connect to hub!", (Throwable)e);
            return null;
        }
    }
}

