/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.connections;

import ibis.smartsockets.hub.connections.VirtualConnection;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualConnections {
    private static Logger vclogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.virtual");
    private final HashMap<String, VirtualConnection> vcs = new HashMap();

    public synchronized void register(VirtualConnection vc) {
        if (vclogger.isDebugEnabled()) {
            vclogger.debug("register VC: " + vc);
        }
        this.vcs.put(vc.key1, vc);
        this.vcs.put(vc.key2, vc);
    }

    public synchronized VirtualConnection find(String key) {
        if (vclogger.isDebugEnabled()) {
            vclogger.debug("find VC: " + key);
        }
        VirtualConnection vc = this.vcs.get(key);
        if (vclogger.isInfoEnabled()) {
            vclogger.info("found VC: " + vc);
        }
        return vc;
    }

    public synchronized VirtualConnection remove(String key) {
        VirtualConnection vc = this.vcs.get(key);
        if (vc == null) {
            if (vclogger.isInfoEnabled()) {
                vclogger.info("cannot remove VC: " + key + " since it doesn't exist!");
            }
            return null;
        }
        if (vclogger.isInfoEnabled()) {
            vclogger.info("removing VC: " + vc);
        }
        this.vcs.remove(vc.key1);
        this.vcs.remove(vc.key2);
        return vc;
    }

    public synchronized LinkedList<VirtualConnection> removeAll(String prefix) {
        LinkedList<String> remove = new LinkedList<String>();
        LinkedList<VirtualConnection> result = new LinkedList<VirtualConnection>();
        for (String key : this.vcs.keySet()) {
            if (!key.startsWith(prefix)) continue;
            remove.add(key);
        }
        for (String key : remove) {
            result.add(this.vcs.remove(key));
        }
        return result;
    }
}

