/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.discovery;

import ibis.smartsockets.discovery.AnsweringMachine;
import ibis.smartsockets.discovery.Callback;
import ibis.smartsockets.discovery.Receiver;
import ibis.smartsockets.discovery.SendReceive;
import ibis.smartsockets.discovery.Sender;
import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.ThreadPool;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Discovery {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.discovery");
    protected static final int MAGIC = 0x42FF42FF;
    private Receiver receiver;
    private Sender sender;
    private AnsweringMachine answer;
    private final int sendPort;
    private final int receivePort;
    private final int timeout;

    public Discovery(int receivePort, int sendPort, int timeout) {
        this.receivePort = receivePort;
        this.sendPort = sendPort;
        this.timeout = timeout;
    }

    protected static void write(byte[] buffer, int pos, int value) {
        buffer[pos] = (byte)(0xFF & value >> 24);
        buffer[pos + 1] = (byte)(0xFF & value >> 16);
        buffer[pos + 2] = (byte)(0xFF & value >> 8);
        buffer[pos + 3] = (byte)(0xFF & value);
    }

    protected static int read(byte[] buffer, int pos) {
        return (buffer[pos] & 0xFF) << 24 | (buffer[pos + 1] & 0xFF) << 16 | (buffer[pos + 2] & 0xFF) << 8 | buffer[pos + 3] & 0xFF;
    }

    public void advertise(String message) {
        InetAddress[] addresses = NetworkUtils.getAllHostAddresses();
        try {
            this.sender = new Sender(addresses, this.sendPort, this.receivePort, this.timeout, message);
            this.sender.start();
        }
        catch (Exception e) {
            logger.warn("Failed to create sender!", (Throwable)e);
        }
    }

    public void listnen(Callback callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        InetAddress[] addresses = NetworkUtils.getAllHostAddresses();
        try {
            this.receiver = new Receiver(addresses, this.receivePort, callback);
            this.receiver.start();
        }
        catch (Exception e) {
            logger.warn("Failed to create receiver!", (Throwable)e);
        }
    }

    public void answeringMachine(String prefix, String[] tags, String reply) {
        try {
            this.answer = new AnsweringMachine(this.receivePort, prefix, tags, reply);
            ThreadPool.createNew(this.answer, "discovery.AnsweringMachine");
        }
        catch (SocketException e) {
            logger.warn("Failed to create answering machine!", (Throwable)e);
        }
    }

    public String broadcastWithReply(String message) {
        try {
            SendReceive sr = new SendReceive(this.sendPort);
            sr.setMessage(message, this.receivePort);
            long end = System.currentTimeMillis() + (long)this.timeout;
            long left = this.timeout;
            while (this.timeout == 0 || left > 0L) {
                sr.send((int)left);
                String result = null;
                try {
                    result = sr.receive(500);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                if (result != null) {
                    return result;
                }
                if (this.timeout <= 0) continue;
                left = end - System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to perform broadcastWithReply!", (Throwable)e);
        }
        return null;
    }
}

