/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl;

import ibis.ipl.CapabilitySet;
import ibis.ipl.Credentials;
import ibis.ipl.Ibis;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisFactory;
import ibis.ipl.PortType;
import ibis.ipl.RegistryEventHandler;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class IbisStarter {
    private final String nickName;
    private final String iplVersion;
    private final String implementationVersion;

    public static IbisStarter createInstance(String className, ClassLoader classLoader, String nickName, String iplVersion, String implementationVersion) {
        try {
            Class<?> starterClass = Class.forName(className, false, classLoader);
            Constructor<?> constructor = starterClass.getConstructor(String.class, String.class, String.class);
            return (IbisStarter)constructor.newInstance(nickName, iplVersion, implementationVersion);
        }
        catch (Throwable t) {
            System.err.println("Could not create starter from class name " + className + " : " + t);
            return null;
        }
    }

    protected IbisStarter(String nickName, String iplVersion, String implementationVersion) {
        this.nickName = nickName;
        this.iplVersion = iplVersion;
        this.implementationVersion = implementationVersion;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getIplVersion() {
        return this.iplVersion;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String toString() {
        return this.nickName;
    }

    public abstract boolean matches(IbisCapabilities var1, PortType[] var2);

    public abstract CapabilitySet unmatchedIbisCapabilities(IbisCapabilities var1, PortType[] var2);

    public abstract PortType[] unmatchedPortTypes(IbisCapabilities var1, PortType[] var2);

    public abstract Ibis startIbis(IbisFactory var1, RegistryEventHandler var2, Properties var3, IbisCapabilities var4, Credentials var5, byte[] var6, PortType[] var7, String var8) throws IbisCreationFailedException;
}

