# Important Notice: File Changes during Software Upgrades

**Attention:** This directory contains files that are subject to change during software upgrades. Any modifications made to these files will be overwritten and lost when upgrading to new versions of the software.

## Why This Matters

Software upgrades are essential to ensure that you have access to the latest features, improvements, and security updates. As part of this process, certain files in the software distribution may need to be updated or replaced with new versions. This is done to maintain compatibility, enhance performance, and address any known issues.

## Best Practices

To avoid losing your customizations or changes, we recommend following these best practices:

1. **Backup Your Modifications:** Before initiating a software upgrade, make sure to create backups of any files you have modified within this directory. This will allow you to restore your changes after the upgrade.

2. **Document Your Changes:** Keep a record of the changes you've made to the files. This documentation will be invaluable when you need to reapply your modifications after an upgrade.

3. **Check Release Notes:** Before upgrading, review the software's release notes or upgrade documentation. This information will often highlight any specific changes that might impact your customizations.

4. **Version Control:** If applicable, consider using version control systems (such as Git) to track your modifications. This can help you manage changes, merge updates, and maintain a history of your alterations.

## Contact and Support

If you have any questions, concerns, or need assistance, don't hesitate to reach out to us [on our project forums](https://community.archesproject.org/). We are here to help you navigate the upgrade process and address any challenges you might encounter.
