# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachine']


class VirtualMachine(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acpi: Optional[pulumi.Input[bool]] = None,
                 agent: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']]] = None,
                 audio_device: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']]] = None,
                 bios: Optional[pulumi.Input[str]] = None,
                 cdrom: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']]] = None,
                 clone: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']]] = None,
                 cpu: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]]] = None,
                 initialization: Optional[pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']]] = None,
                 keyboard_layout: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]]] = None,
                 node_name: Optional[pulumi.Input[str]] = None,
                 operating_system: Optional[pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]]] = None,
                 started: Optional[pulumi.Input[bool]] = None,
                 tablet_device: Optional[pulumi.Input[bool]] = None,
                 template: Optional[pulumi.Input[bool]] = None,
                 vga: Optional[pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']]] = None,
                 vm_id: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a VirtualMachine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acpi: Whether to enable ACPI
        :param pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']] agent: The QEMU agent configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']] audio_device: The audio devices
        :param pulumi.Input[str] bios: The BIOS implementation
        :param pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']] cdrom: The CDROM drive
        :param pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']] clone: The cloning configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]] disks: The disk devices
        :param pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']] initialization: The cloud-init configuration
        :param pulumi.Input[str] keyboard_layout: The keyboard layout
        :param pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']] memory: The memory allocation
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]] network_devices: The network devices
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the virtual machine to
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]] serial_devices: The serial devices
        :param pulumi.Input[bool] started: Whether to start the virtual machine
        :param pulumi.Input[bool] tablet_device: Whether to enable the USB tablet device
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']] vga: The VGA configuration
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acpi'] = acpi
            __props__['agent'] = agent
            __props__['audio_device'] = audio_device
            __props__['bios'] = bios
            __props__['cdrom'] = cdrom
            __props__['clone'] = clone
            __props__['cpu'] = cpu
            __props__['description'] = description
            __props__['disks'] = disks
            __props__['initialization'] = initialization
            __props__['keyboard_layout'] = keyboard_layout
            __props__['memory'] = memory
            __props__['name'] = name
            __props__['network_devices'] = network_devices
            if node_name is None:
                raise TypeError("Missing required property 'node_name'")
            __props__['node_name'] = node_name
            __props__['operating_system'] = operating_system
            __props__['pool_id'] = pool_id
            __props__['serial_devices'] = serial_devices
            __props__['started'] = started
            __props__['tablet_device'] = tablet_device
            __props__['template'] = template
            __props__['vga'] = vga
            __props__['vm_id'] = vm_id
            __props__['ipv4_addresses'] = None
            __props__['ipv6_addresses'] = None
            __props__['mac_addresses'] = None
            __props__['network_interface_names'] = None
        super(VirtualMachine, __self__).__init__(
            'proxmox:VM/virtualMachine:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acpi: Optional[pulumi.Input[bool]] = None,
            agent: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']]] = None,
            audio_device: Optional[pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']]] = None,
            bios: Optional[pulumi.Input[str]] = None,
            cdrom: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']]] = None,
            clone: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']]] = None,
            cpu: Optional[pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]]] = None,
            initialization: Optional[pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']]] = None,
            ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
            keyboard_layout: Optional[pulumi.Input[str]] = None,
            mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            memory: Optional[pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]]] = None,
            network_interface_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            node_name: Optional[pulumi.Input[str]] = None,
            operating_system: Optional[pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            serial_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]]] = None,
            started: Optional[pulumi.Input[bool]] = None,
            tablet_device: Optional[pulumi.Input[bool]] = None,
            template: Optional[pulumi.Input[bool]] = None,
            vga: Optional[pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']]] = None,
            vm_id: Optional[pulumi.Input[int]] = None) -> 'VirtualMachine':
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acpi: Whether to enable ACPI
        :param pulumi.Input[pulumi.InputType['VirtualMachineAgentArgs']] agent: The QEMU agent configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineAudioDeviceArgs']] audio_device: The audio devices
        :param pulumi.Input[str] bios: The BIOS implementation
        :param pulumi.Input[pulumi.InputType['VirtualMachineCdromArgs']] cdrom: The CDROM drive
        :param pulumi.Input[pulumi.InputType['VirtualMachineCloneArgs']] clone: The cloning configuration
        :param pulumi.Input[pulumi.InputType['VirtualMachineCpuArgs']] cpu: The CPU allocation
        :param pulumi.Input[str] description: The description
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineDiskArgs']]]] disks: The disk devices
        :param pulumi.Input[pulumi.InputType['VirtualMachineInitializationArgs']] initialization: The cloud-init configuration
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] ipv4_addresses: The IPv4 addresses published by the QEMU agent
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] ipv6_addresses: The IPv6 addresses published by the QEMU agent
        :param pulumi.Input[str] keyboard_layout: The keyboard layout
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_addresses: The MAC addresses for the network interfaces
        :param pulumi.Input[pulumi.InputType['VirtualMachineMemoryArgs']] memory: The memory allocation
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineNetworkDeviceArgs']]]] network_devices: The network devices
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_names: The network interface names published by the QEMU agent
        :param pulumi.Input[str] node_name: The node name
        :param pulumi.Input[pulumi.InputType['VirtualMachineOperatingSystemArgs']] operating_system: The operating system configuration
        :param pulumi.Input[str] pool_id: The ID of the pool to assign the virtual machine to
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualMachineSerialDeviceArgs']]]] serial_devices: The serial devices
        :param pulumi.Input[bool] started: Whether to start the virtual machine
        :param pulumi.Input[bool] tablet_device: Whether to enable the USB tablet device
        :param pulumi.Input[bool] template: Whether to create a template
        :param pulumi.Input[pulumi.InputType['VirtualMachineVgaArgs']] vga: The VGA configuration
        :param pulumi.Input[int] vm_id: The VM identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acpi"] = acpi
        __props__["agent"] = agent
        __props__["audio_device"] = audio_device
        __props__["bios"] = bios
        __props__["cdrom"] = cdrom
        __props__["clone"] = clone
        __props__["cpu"] = cpu
        __props__["description"] = description
        __props__["disks"] = disks
        __props__["initialization"] = initialization
        __props__["ipv4_addresses"] = ipv4_addresses
        __props__["ipv6_addresses"] = ipv6_addresses
        __props__["keyboard_layout"] = keyboard_layout
        __props__["mac_addresses"] = mac_addresses
        __props__["memory"] = memory
        __props__["name"] = name
        __props__["network_devices"] = network_devices
        __props__["network_interface_names"] = network_interface_names
        __props__["node_name"] = node_name
        __props__["operating_system"] = operating_system
        __props__["pool_id"] = pool_id
        __props__["serial_devices"] = serial_devices
        __props__["started"] = started
        __props__["tablet_device"] = tablet_device
        __props__["template"] = template
        __props__["vga"] = vga
        __props__["vm_id"] = vm_id
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acpi(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable ACPI
        """
        return pulumi.get(self, "acpi")

    @property
    @pulumi.getter
    def agent(self) -> pulumi.Output[Optional['outputs.VirtualMachineAgent']]:
        """
        The QEMU agent configuration
        """
        return pulumi.get(self, "agent")

    @property
    @pulumi.getter(name="audioDevice")
    def audio_device(self) -> pulumi.Output[Optional['outputs.VirtualMachineAudioDevice']]:
        """
        The audio devices
        """
        return pulumi.get(self, "audio_device")

    @property
    @pulumi.getter
    def bios(self) -> pulumi.Output[Optional[str]]:
        """
        The BIOS implementation
        """
        return pulumi.get(self, "bios")

    @property
    @pulumi.getter
    def cdrom(self) -> pulumi.Output[Optional['outputs.VirtualMachineCdrom']]:
        """
        The CDROM drive
        """
        return pulumi.get(self, "cdrom")

    @property
    @pulumi.getter
    def clone(self) -> pulumi.Output[Optional['outputs.VirtualMachineClone']]:
        """
        The cloning configuration
        """
        return pulumi.get(self, "clone")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional['outputs.VirtualMachineCpu']]:
        """
        The CPU allocation
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineDisk']]]:
        """
        The disk devices
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def initialization(self) -> pulumi.Output[Optional['outputs.VirtualMachineInitialization']]:
        """
        The cloud-init configuration
        """
        return pulumi.get(self, "initialization")

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> pulumi.Output[Sequence[Sequence[str]]]:
        """
        The IPv4 addresses published by the QEMU agent
        """
        return pulumi.get(self, "ipv4_addresses")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[Sequence[str]]]:
        """
        The IPv6 addresses published by the QEMU agent
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="keyboardLayout")
    def keyboard_layout(self) -> pulumi.Output[Optional[str]]:
        """
        The keyboard layout
        """
        return pulumi.get(self, "keyboard_layout")

    @property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The MAC addresses for the network interfaces
        """
        return pulumi.get(self, "mac_addresses")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional['outputs.VirtualMachineMemory']]:
        """
        The memory allocation
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkDevices")
    def network_devices(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineNetworkDevice']]]:
        """
        The network devices
        """
        return pulumi.get(self, "network_devices")

    @property
    @pulumi.getter(name="networkInterfaceNames")
    def network_interface_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The network interface names published by the QEMU agent
        """
        return pulumi.get(self, "network_interface_names")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Output[str]:
        """
        The node name
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[Optional['outputs.VirtualMachineOperatingSystem']]:
        """
        The operating system configuration
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the pool to assign the virtual machine to
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="serialDevices")
    def serial_devices(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualMachineSerialDevice']]]:
        """
        The serial devices
        """
        return pulumi.get(self, "serial_devices")

    @property
    @pulumi.getter
    def started(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to start the virtual machine
        """
        return pulumi.get(self, "started")

    @property
    @pulumi.getter(name="tabletDevice")
    def tablet_device(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable the USB tablet device
        """
        return pulumi.get(self, "tablet_device")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a template
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def vga(self) -> pulumi.Output[Optional['outputs.VirtualMachineVga']]:
        """
        The VGA configuration
        """
        return pulumi.get(self, "vga")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> pulumi.Output[Optional[int]]:
        """
        The VM identifier
        """
        return pulumi.get(self, "vm_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

