# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['User']


class User(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserAclArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keys: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserAclArgs']]]] acls: The access control list
        :param pulumi.Input[str] comment: The user comment
        :param pulumi.Input[str] email: The user's email address
        :param pulumi.Input[bool] enabled: Whether the user account is enabled
        :param pulumi.Input[str] expiration_date: The user account's expiration date
        :param pulumi.Input[str] first_name: The user's first name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: The user's groups
        :param pulumi.Input[str] keys: The user's keys
        :param pulumi.Input[str] last_name: The user's last name
        :param pulumi.Input[str] password: The user's password
        :param pulumi.Input[str] user_id: The user id
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acls'] = acls
            __props__['comment'] = comment
            __props__['email'] = email
            __props__['enabled'] = enabled
            __props__['expiration_date'] = expiration_date
            __props__['first_name'] = first_name
            __props__['groups'] = groups
            __props__['keys'] = keys
            __props__['last_name'] = last_name
            if password is None:
                raise TypeError("Missing required property 'password'")
            __props__['password'] = password
            if user_id is None:
                raise TypeError("Missing required property 'user_id'")
            __props__['user_id'] = user_id
        super(User, __self__).__init__(
            'proxmox:Permission/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserAclArgs']]]]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            expiration_date: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            keys: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserAclArgs']]]] acls: The access control list
        :param pulumi.Input[str] comment: The user comment
        :param pulumi.Input[str] email: The user's email address
        :param pulumi.Input[bool] enabled: Whether the user account is enabled
        :param pulumi.Input[str] expiration_date: The user account's expiration date
        :param pulumi.Input[str] first_name: The user's first name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: The user's groups
        :param pulumi.Input[str] keys: The user's keys
        :param pulumi.Input[str] last_name: The user's last name
        :param pulumi.Input[str] password: The user's password
        :param pulumi.Input[str] user_id: The user id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acls"] = acls
        __props__["comment"] = comment
        __props__["email"] = email
        __props__["enabled"] = enabled
        __props__["expiration_date"] = expiration_date
        __props__["first_name"] = first_name
        __props__["groups"] = groups
        __props__["keys"] = keys
        __props__["last_name"] = last_name
        __props__["password"] = password
        __props__["user_id"] = user_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[Sequence['outputs.UserAcl']]]:
        """
        The access control list
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        The user comment
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The user's email address
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the user account is enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[str]]:
        """
        The user account's expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[str]]:
        """
        The user's first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The user's groups
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Optional[str]]:
        """
        The user's keys
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[str]]:
        """
        The user's last name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The user's password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The user id
        """
        return pulumi.get(self, "user_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

