# Autogenerated constants for Power service
from enum import IntEnum
from jacdac.constants import *
from jacdac.system.constants import *
JD_SERVICE_CLASS_POWER = const(0x1fa4c95a)


class PowerPowerStatus(IntEnum):
    DISALLOWED = const(0x0)
    POWERING = const(0x1)
    OVERLOAD = const(0x2)
    OVERPROVISION = const(0x3)


JD_POWER_REG_ALLOWED = const(JD_REG_INTENSITY)
JD_POWER_REG_MAX_POWER = const(JD_REG_MAX_POWER)
JD_POWER_REG_POWER_STATUS = const(0x181)
JD_POWER_REG_CURRENT_DRAW = const(JD_REG_READING)
JD_POWER_REG_BATTERY_VOLTAGE = const(0x180)
JD_POWER_REG_BATTERY_CHARGE = const(0x182)
JD_POWER_REG_BATTERY_CAPACITY = const(0x183)
JD_POWER_REG_KEEP_ON_PULSE_DURATION = const(0x80)
JD_POWER_REG_KEEP_ON_PULSE_PERIOD = const(0x81)
JD_POWER_CMD_SHUTDOWN = const(0x80)
JD_POWER_EV_POWER_STATUS_CHANGED = const(JD_EV_CHANGE)
JD_POWER_PACK_FORMATS = {
    JD_POWER_REG_ALLOWED: "u8",
    JD_POWER_REG_MAX_POWER: "u16",
    JD_POWER_REG_POWER_STATUS: "u8",
    JD_POWER_REG_CURRENT_DRAW: "u16",
    JD_POWER_REG_BATTERY_VOLTAGE: "u16",
    JD_POWER_REG_BATTERY_CHARGE: "u0.16",
    JD_POWER_REG_BATTERY_CAPACITY: "u32",
    JD_POWER_REG_KEEP_ON_PULSE_DURATION: "u16",
    JD_POWER_REG_KEEP_ON_PULSE_PERIOD: "u16",
    JD_POWER_EV_POWER_STATUS_CHANGED: "u8"
}
