# Autogenerated constants for Barcode reader service
from enum import IntEnum
from jacdac.constants import *
from jacdac.system.constants import *
JD_SERVICE_CLASS_BARCODE_READER = const(0x1c739e6c)


class BarcodeReaderFormat(IntEnum):
    AZTEC = const(0x1)
    CODE128 = const(0x2)
    CODE39 = const(0x3)
    CODE93 = const(0x4)
    CODABAR = const(0x5)
    DATA_MATRIX = const(0x6)
    EAN13 = const(0x8)
    EAN8 = const(0x9)
    ITF = const(0xa)
    PDF417 = const(0xb)
    QR_CODE = const(0xc)
    UPC_A = const(0xd)
    UPC_E = const(0xe)


JD_BARCODE_READER_REG_ENABLED = const(JD_REG_INTENSITY)
JD_BARCODE_READER_REG_FORMATS = const(0x180)
JD_BARCODE_READER_EV_DETECT = const(JD_EV_ACTIVE)
JD_BARCODE_READER_PACK_FORMATS = {
    JD_BARCODE_READER_REG_ENABLED: "u8",
    JD_BARCODE_READER_REG_FORMATS: "r: u8",
    JD_BARCODE_READER_EV_DETECT: "u8 s"
}
