# serviceb-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import serviceb_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import serviceb_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import serviceb_client
from pprint import pprint
from serviceb_client.api import genres_api
from serviceb_client.model.genre import Genre
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = serviceb_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with serviceb_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = genres_api.GenresApi(api_client)

    try:
        # Get Genres
        api_response = api_instance.get_genres_genres_get()
        pprint(api_response)
    except serviceb_client.ApiException as e:
        print("Exception when calling GenresApi->get_genres_genres_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*GenresApi* | [**get_genres_genres_get**](docs/GenresApi.md#get_genres_genres_get) | **GET** /genres/ | Get Genres
*ListsApi* | [**add_movie_to_list_lists_list_id_movies_movie_id_post**](docs/ListsApi.md#add_movie_to_list_lists_list_id_movies_movie_id_post) | **POST** /lists/{list_id}/movies/{movie_id} | Add Movie To List
*ListsApi* | [**create_list_for_user_users_lists_post**](docs/ListsApi.md#create_list_for_user_users_lists_post) | **POST** /users/lists/ | Create List For User
*ListsApi* | [**delete_list_lists_list_id_delete**](docs/ListsApi.md#delete_list_lists_list_id_delete) | **DELETE** /lists/{list_id} | Delete List
*ListsApi* | [**get_list_lists_list_id_get**](docs/ListsApi.md#get_list_lists_list_id_get) | **GET** /lists/{list_id} | Get List
*ListsApi* | [**get_lists_for_user_users_lists_get**](docs/ListsApi.md#get_lists_for_user_users_lists_get) | **GET** /users/lists/ | Get Lists For User
*ListsApi* | [**remove_movie_from_list_lists_list_id_movies_movie_id_delete**](docs/ListsApi.md#remove_movie_from_list_lists_list_id_movies_movie_id_delete) | **DELETE** /lists/{list_id}/movies/{movie_id} | Remove Movie From List
*ListsApi* | [**update_list_lists_list_id_put**](docs/ListsApi.md#update_list_lists_list_id_put) | **PUT** /lists/{list_id} | Update List
*MoviesApi* | [**add_movie_to_list_lists_list_id_movies_movie_id_post**](docs/MoviesApi.md#add_movie_to_list_lists_list_id_movies_movie_id_post) | **POST** /lists/{list_id}/movies/{movie_id} | Add Movie To List
*MoviesApi* | [**get_movie_movies_movie_id_get**](docs/MoviesApi.md#get_movie_movies_movie_id_get) | **GET** /movies/{movie_id} | Get Movie
*MoviesApi* | [**get_movies_movies_get**](docs/MoviesApi.md#get_movies_movies_get) | **GET** /movies/ | Get Movies
*MoviesApi* | [**remove_movie_from_list_lists_list_id_movies_movie_id_delete**](docs/MoviesApi.md#remove_movie_from_list_lists_list_id_movies_movie_id_delete) | **DELETE** /lists/{list_id}/movies/{movie_id} | Remove Movie From List
*Oauth2Api* | [**login_for_access_token_token_post**](docs/Oauth2Api.md#login_for_access_token_token_post) | **POST** /token | Login For Access Token
*Oauth2Api* | [**read_users_me_users_me_get**](docs/Oauth2Api.md#read_users_me_users_me_get) | **GET** /users/me/ | Read Users Me
*UsersApi* | [**create_list_for_user_users_lists_post**](docs/UsersApi.md#create_list_for_user_users_lists_post) | **POST** /users/lists/ | Create List For User
*UsersApi* | [**create_user_users_post**](docs/UsersApi.md#create_user_users_post) | **POST** /users/ | Create User
*UsersApi* | [**get_lists_for_user_users_lists_get**](docs/UsersApi.md#get_lists_for_user_users_lists_get) | **GET** /users/lists/ | Get Lists For User
*UsersApi* | [**patch_user_users_user_id_patch**](docs/UsersApi.md#patch_user_users_user_id_patch) | **PATCH** /users/{user_id} | Patch User
*UsersApi* | [**read_user_users_user_id_get**](docs/UsersApi.md#read_user_users_user_id_get) | **GET** /users/{user_id} | Read User
*UsersApi* | [**remove_user_photo_users_upload_photo_user_id_delete**](docs/UsersApi.md#remove_user_photo_users_upload_photo_user_id_delete) | **DELETE** /users/upload_photo/{user_id} | Remove User Photo
*UsersApi* | [**update_user_users_profile_put**](docs/UsersApi.md#update_user_users_profile_put) | **PUT** /users/profile/ | Update User
*UsersApi* | [**update_user_users_user_id_put**](docs/UsersApi.md#update_user_users_user_id_put) | **PUT** /users/{user_id} | Update User
*UsersApi* | [**upload_user_photo_users_upload_photo_user_id_put**](docs/UsersApi.md#upload_user_photo_users_upload_photo_user_id_put) | **PUT** /users/upload_photo/{user_id} | Upload User Photo


## Documentation For Models

 - [Genre](docs/Genre.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ListCreate](docs/ListCreate.md)
 - [ListSchema](docs/ListSchema.md)
 - [ListUpdate](docs/ListUpdate.md)
 - [Movie](docs/Movie.md)
 - [Token](docs/Token.md)
 - [User](docs/User.md)
 - [UserCreate](docs/UserCreate.md)
 - [UserUpdate](docs/UserUpdate.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization


## OAuth2PasswordBearer

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: N/A


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in serviceb_client.apis and serviceb_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from serviceb_client.api.default_api import DefaultApi`
- `from serviceb_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import serviceb_client
from serviceb_client.apis import *
from serviceb_client.models import *
```

