# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydatafaker']

package_data = \
{'': ['*']}

install_requires = \
['faker>=4.1.2,<5.0.0', 'pandas>=1.1.1,<2.0.0']

setup_kwargs = {
    'name': 'pydatafaker',
    'version': '0.1.2',
    'description': 'A python package to create fake data with relationships between tables.',
    'long_description': '![logo](https://raw.githubusercontent.com/SamEdwardes/pydatafaker/master/docs/source/_static/logo_with_grey_text.png)\n\n![test_with_pytest](https://github.com/SamEdwardes/pydatafaker/workflows/test_with_pytest/badge.svg)\n[![Documentation Status](https://readthedocs.org/projects/pydatafaker/badge/?version=latest)](https://pydatafaker.readthedocs.io/en/latest/?badge=latest)\n\nPyDataFaker is a python package to create fake data with relationships between tables. Creating fake data can be useful for many different applications such as creating product demos or testing software. \n\nPython already has a great package for creating fake data called Faker [https://faker.readthedocs.io/en/master/](https://faker.readthedocs.io/en/master/). Faker is great for creating individual fake units of data, but it can be time consuming to create more complicated fake data that is actually related to one another.\n\nImagine you are developing a new enterprise resource planning (ERP) software to challenge SAP. You may need to create some fake data to test your application. You will need an invoice table, a vendor listing, purchase order table, and more. PyDataFaker allows your to quickly create these tables and generates relationships between them!\n\nPyDataFaker is currently under development. At this time it is possible to create the following entities:\n\n- **Business**: create a fake business with common ERP like tables\n- **School**: create a fake school\n\nMore entities are currently being developed. If you  have any ideas of additional entities that should be included please submit an issue here: [https://github.com/SamEdwardes/pydatafaker/issues](https://github.com/SamEdwardes/pydatafaker/issues).\n\n## Table of contents\n\n- [Installation](#installation)\n- [Documentation](#documentation)\n- [Usage](#usage)\n- [Contributing](#contributing)\n- [Credits](#credits)\n\n## Installation\n\n```bash\npip install pydatafaker\n```\n\n## Documentation\n\nDocumentation can be found at [https://pydatafaker.readthedocs.io/en/latest/index.html](https://pydatafaker.readthedocs.io/en/latest/index.html). The package is distributed through PyPi at [https://pypi.org/project/pydatafaker/](https://pypi.org/project/pydatafaker/)\n\n## Usage\n\n### Business\n\nThe business module allows you to create fake business data. Calling `business.create_business()` will return a dictionary of related tables.\n\n\n```python\nimport pandas as pd\nfrom pydatafaker import business\nbiz =  business.create_business()\nbiz.keys()\n```\n\n\n\n\n    dict_keys([\'vendor_table\', \'po_table\', \'invoice_summary_table\', \'invoice_line_item_table\', \'employee_table\', \'contract_table\', \'rate_sheet_table\', \'timesheet_table\'])\n\n\n\nEach value inside the dictionary contains a Pandas DataFrame.\n\n\n```python\nbiz[\'invoice_summary_table\']\n```\n\n\n\n\n<div>\n<style scoped>\n    .dataframe tbody tr th:only-of-type {\n        vertical-align: middle;\n    }\n\n    .dataframe tbody tr th {\n        vertical-align: top;\n    }\n\n    .dataframe thead th {\n        text-align: right;\n    }\n</style>\n<table border="1" class="dataframe">\n  <thead>\n    <tr style="text-align: right;">\n      <th></th>\n      <th>invoice_id</th>\n      <th>amount</th>\n      <th>invoice_date</th>\n      <th>po_id</th>\n      <th>vendor_id</th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr>\n      <th>0</th>\n      <td>inv_00001</td>\n      <td>59157</td>\n      <td>2011-01-20</td>\n      <td>po_00001</td>\n      <td>vendor_00001</td>\n    </tr>\n    <tr>\n      <th>1</th>\n      <td>inv_00002</td>\n      <td>87796</td>\n      <td>2007-09-06</td>\n      <td>po_00002</td>\n      <td>vendor_00002</td>\n    </tr>\n    <tr>\n      <th>2</th>\n      <td>inv_00003</td>\n      <td>57963</td>\n      <td>2000-03-06</td>\n      <td>po_00003</td>\n      <td>vendor_00003</td>\n    </tr>\n    <tr>\n      <th>3</th>\n      <td>inv_00004</td>\n      <td>59409</td>\n      <td>2001-03-31</td>\n      <td>po_00004</td>\n      <td>vendor_00004</td>\n    </tr>\n    <tr>\n      <th>4</th>\n      <td>inv_00005</td>\n      <td>86614</td>\n      <td>2002-01-12</td>\n      <td>po_00005</td>\n      <td>vendor_00005</td>\n    </tr>\n    <tr>\n      <th>...</th>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n    </tr>\n    <tr>\n      <th>445</th>\n      <td>inv_00446</td>\n      <td>83316</td>\n      <td>2012-09-02</td>\n      <td>po_00087</td>\n      <td>vendor_00087</td>\n    </tr>\n    <tr>\n      <th>446</th>\n      <td>inv_00447</td>\n      <td>45707</td>\n      <td>2008-07-10</td>\n      <td>po_00101</td>\n      <td>vendor_00098</td>\n    </tr>\n    <tr>\n      <th>447</th>\n      <td>inv_00448</td>\n      <td>111932</td>\n      <td>2002-09-26</td>\n      <td>po_00158</td>\n      <td>vendor_00012</td>\n    </tr>\n    <tr>\n      <th>448</th>\n      <td>inv_00449</td>\n      <td>35104</td>\n      <td>2012-09-21</td>\n      <td>po_00133</td>\n      <td>vendor_00075</td>\n    </tr>\n    <tr>\n      <th>449</th>\n      <td>inv_00450</td>\n      <td>15397</td>\n      <td>2015-12-15</td>\n      <td>po_00054</td>\n      <td>vendor_00054</td>\n    </tr>\n  </tbody>\n</table>\n<p>450 rows × 5 columns</p>\n</div>\n\n\n\nTables can be joined together to add additional details.\n\n\n```python\ninvoice_summary = biz[\'invoice_summary_table\']\nvendors = biz[\'vendor_table\']\npd.merge(invoice_summary, vendors, how=\'left\', on=\'vendor_id\')\n```\n\n\n\n\n<div>\n<style scoped>\n    .dataframe tbody tr th:only-of-type {\n        vertical-align: middle;\n    }\n\n    .dataframe tbody tr th {\n        vertical-align: top;\n    }\n\n    .dataframe thead th {\n        text-align: right;\n    }\n</style>\n<table border="1" class="dataframe">\n  <thead>\n    <tr style="text-align: right;">\n      <th></th>\n      <th>invoice_id</th>\n      <th>amount</th>\n      <th>invoice_date</th>\n      <th>po_id</th>\n      <th>vendor_id</th>\n      <th>vendor_name</th>\n      <th>vendor_description</th>\n      <th>address</th>\n      <th>phone</th>\n      <th>email</th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr>\n      <th>0</th>\n      <td>inv_00001</td>\n      <td>59157</td>\n      <td>2011-01-20</td>\n      <td>po_00001</td>\n      <td>vendor_00001</td>\n      <td>Smith-Scott</td>\n      <td>Front-line multimedia emulation</td>\n      <td>75343 Harper Corners Suite 581\\nJuanberg, AK 0...</td>\n      <td>(193)898-1652x129</td>\n      <td>ftodd@example.org</td>\n    </tr>\n    <tr>\n      <th>1</th>\n      <td>inv_00002</td>\n      <td>87796</td>\n      <td>2007-09-06</td>\n      <td>po_00002</td>\n      <td>vendor_00002</td>\n      <td>Walker-Morgan</td>\n      <td>Cross-platform radical solution</td>\n      <td>941 Susan Isle\\nThorntonberg, KS 82841</td>\n      <td>+1-636-744-9620x3991</td>\n      <td>rdunn@example.com</td>\n    </tr>\n    <tr>\n      <th>2</th>\n      <td>inv_00003</td>\n      <td>57963</td>\n      <td>2000-03-06</td>\n      <td>po_00003</td>\n      <td>vendor_00003</td>\n      <td>Noble and Sons</td>\n      <td>Configurable demand-driven emulation</td>\n      <td>1442 Jason Rapid Apt. 409\\nEast Jade, RI 44983</td>\n      <td>477-214-2021x973</td>\n      <td>tinaschmidt@example.com</td>\n    </tr>\n    <tr>\n      <th>3</th>\n      <td>inv_00004</td>\n      <td>59409</td>\n      <td>2001-03-31</td>\n      <td>po_00004</td>\n      <td>vendor_00004</td>\n      <td>Baker, Walker and Davenport</td>\n      <td>Focused analyzing synergy</td>\n      <td>89120 Kimberly Extensions\\nSouth Annettetown, ...</td>\n      <td>(643)621-7544x290</td>\n      <td>sarahstephenson@example.com</td>\n    </tr>\n    <tr>\n      <th>4</th>\n      <td>inv_00005</td>\n      <td>86614</td>\n      <td>2002-01-12</td>\n      <td>po_00005</td>\n      <td>vendor_00005</td>\n      <td>Patterson LLC</td>\n      <td>Profound maximized productivity</td>\n      <td>880 Bryan Tunnel Apt. 542\\nKaylabury, AK 50221</td>\n      <td>586-422-7311x0127</td>\n      <td>littleyesenia@example.net</td>\n    </tr>\n    <tr>\n      <th>...</th>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n    </tr>\n    <tr>\n      <th>445</th>\n      <td>inv_00446</td>\n      <td>83316</td>\n      <td>2012-09-02</td>\n      <td>po_00087</td>\n      <td>vendor_00087</td>\n      <td>Wagner-Gutierrez</td>\n      <td>Multi-lateral motivating projection</td>\n      <td>8771 Roger Road Suite 781\\nDanielton, ID 88428</td>\n      <td>001-023-820-3050x78454</td>\n      <td>colliernicole@example.net</td>\n    </tr>\n    <tr>\n      <th>446</th>\n      <td>inv_00447</td>\n      <td>45707</td>\n      <td>2008-07-10</td>\n      <td>po_00101</td>\n      <td>vendor_00098</td>\n      <td>Simmons-Leonard</td>\n      <td>Focused reciprocal secured line</td>\n      <td>9010 Ashley Mountains\\nMarthaton, VT 68298</td>\n      <td>391-162-6024</td>\n      <td>serranonancy@example.org</td>\n    </tr>\n    <tr>\n      <th>447</th>\n      <td>inv_00448</td>\n      <td>111932</td>\n      <td>2002-09-26</td>\n      <td>po_00158</td>\n      <td>vendor_00012</td>\n      <td>Welch LLC</td>\n      <td>Versatile methodical interface</td>\n      <td>4016 Brianna Road\\nPort Andrealand, AR 22214</td>\n      <td>+1-837-862-5571x172</td>\n      <td>williamoliver@example.com</td>\n    </tr>\n    <tr>\n      <th>448</th>\n      <td>inv_00449</td>\n      <td>35104</td>\n      <td>2012-09-21</td>\n      <td>po_00133</td>\n      <td>vendor_00075</td>\n      <td>Franklin-Bennett</td>\n      <td>Digitized holistic methodology</td>\n      <td>68125 Vega Plains Apt. 062\\nEast Emily, OK 80097</td>\n      <td>001-979-468-2358x530</td>\n      <td>leroymoore@example.org</td>\n    </tr>\n    <tr>\n      <th>449</th>\n      <td>inv_00450</td>\n      <td>15397</td>\n      <td>2015-12-15</td>\n      <td>po_00054</td>\n      <td>vendor_00054</td>\n      <td>Barton-Oneill</td>\n      <td>Mandatory 4thgeneration hierarchy</td>\n      <td>107 Julie Passage Suite 904\\nSouth George, OH ...</td>\n      <td>(491)397-7771x41615</td>\n      <td>jacksonrachel@example.com</td>\n    </tr>\n  </tbody>\n</table>\n<p>450 rows × 10 columns</p>\n</div>\n\n\n\n### School\n\n\n```python\nimport pandas as pd\nfrom pydatafaker import school\nskool =  school.create_school()\nskool.keys()\nskool[\'student_table\']\n```\n\n\n\n\n<div>\n<style scoped>\n    .dataframe tbody tr th:only-of-type {\n        vertical-align: middle;\n    }\n\n    .dataframe tbody tr th {\n        vertical-align: top;\n    }\n\n    .dataframe thead th {\n        text-align: right;\n    }\n</style>\n<table border="1" class="dataframe">\n  <thead>\n    <tr style="text-align: right;">\n      <th></th>\n      <th>student_id</th>\n      <th>name</th>\n      <th>grade</th>\n      <th>teacher_id</th>\n    </tr>\n  </thead>\n  <tbody>\n    <tr>\n      <th>0</th>\n      <td>student_0001</td>\n      <td>Tyler Campbell</td>\n      <td>1</td>\n      <td>teacher_0007</td>\n    </tr>\n    <tr>\n      <th>1</th>\n      <td>student_0003</td>\n      <td>Melissa Coleman</td>\n      <td>1</td>\n      <td>teacher_0010</td>\n    </tr>\n    <tr>\n      <th>2</th>\n      <td>student_0011</td>\n      <td>Crystal Church</td>\n      <td>1</td>\n      <td>teacher_0014</td>\n    </tr>\n    <tr>\n      <th>3</th>\n      <td>student_0017</td>\n      <td>Paul Gray</td>\n      <td>1</td>\n      <td>teacher_0007</td>\n    </tr>\n    <tr>\n      <th>4</th>\n      <td>student_0023</td>\n      <td>Joshua Morales</td>\n      <td>1</td>\n      <td>teacher_0010</td>\n    </tr>\n    <tr>\n      <th>...</th>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n      <td>...</td>\n    </tr>\n    <tr>\n      <th>31</th>\n      <td>student_0258</td>\n      <td>Nicole Hoffman</td>\n      <td>7</td>\n      <td>teacher_0015</td>\n    </tr>\n    <tr>\n      <th>32</th>\n      <td>student_0261</td>\n      <td>Joseph Lewis</td>\n      <td>7</td>\n      <td>teacher_0009</td>\n    </tr>\n    <tr>\n      <th>33</th>\n      <td>student_0294</td>\n      <td>Susan Jacobs</td>\n      <td>7</td>\n      <td>teacher_0015</td>\n    </tr>\n    <tr>\n      <th>34</th>\n      <td>student_0299</td>\n      <td>Mark Whitehead</td>\n      <td>7</td>\n      <td>teacher_0009</td>\n    </tr>\n    <tr>\n      <th>35</th>\n      <td>student_0300</td>\n      <td>Melissa Sosa</td>\n      <td>7</td>\n      <td>teacher_0015</td>\n    </tr>\n  </tbody>\n</table>\n<p>300 rows × 4 columns</p>\n</div>\n\n\n\n## Contributing\n\nPlease see [docs/source/contributing.rst](docs/source/contributing.rst).\n\n## Credits\n\nDeveloped by:\n\n* Sam Edwardes\n\nLogo:\n\n* Icon made by [Freepik](https://www.flaticon.com/authors/freepik) from [www.flaticon.com](https://www.flaticon.com/)\n* Front from [fontmeme.com/retro-fonts/](https://fontmeme.com/retro-fonts/)\n* Logo generated using [logomakr.com](logomakr.com/7scB4)\n',
    'author': 'Sam Edwardes',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/SamEdwardes/pydatafaker',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
