# coding: utf-8

"""
    IcoTest Voice

    IcoTest Voice API  # noqa: E501

    The version of the OpenAPI document: 1.0.29
    Contact: shaun.hirst@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from icotest_voice.api_client import ApiClient
from icotest_voice.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ControllersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_controller(self, controller_id, **kwargs):  # noqa: E501
        """DELETE Controller  # noqa: E501

        Delete an existing controller. WARNING: all devices and requests belonging to this controller, will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_controller(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_controller_with_http_info(controller_id, **kwargs)  # noqa: E501

    def delete_controller_with_http_info(self, controller_id, **kwargs):  # noqa: E501
        """DELETE Controller  # noqa: E501

        Delete an existing controller. WARNING: all devices and requests belonging to this controller, will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_controller_with_http_info(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_controller" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `delete_controller`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_controller`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_controller`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `delete_controller`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'controller_id' in local_var_params and local_var_params['controller_id'] is not None:  # noqa: E501
            query_params.append(('controller_id', local_var_params['controller_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/controllers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_controllers(self, **kwargs):  # noqa: E501
        """GET controllers  # noqa: E501

        Get a list of registered controllers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_controllers(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Controller]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_controllers_with_http_info(**kwargs)  # noqa: E501

    def get_controllers_with_http_info(self, **kwargs):  # noqa: E501
        """GET controllers  # noqa: E501

        Get a list of registered controllers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_controllers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Controller], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_controllers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_controllers`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_controllers`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_controllers`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'controller_id' in local_var_params and local_var_params['controller_id'] is not None:  # noqa: E501
            query_params.append(('controller_id', local_var_params['controller_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/controllers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Controller]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_controller_heartbeat(self, controller_id, **kwargs):  # noqa: E501
        """POST Controller heartbeat  # noqa: E501

        Controller heartbeat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_controller_heartbeat(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_controller_heartbeat_with_http_info(controller_id, **kwargs)  # noqa: E501

    def post_controller_heartbeat_with_http_info(self, controller_id, **kwargs):  # noqa: E501
        """POST Controller heartbeat  # noqa: E501

        Controller heartbeat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_controller_heartbeat_with_http_info(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of a controller (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_controller_heartbeat" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `post_controller_heartbeat`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `post_controller_heartbeat`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `post_controller_heartbeat`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `post_controller_heartbeat`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/controllers/{controller_id}/heartbeat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_controller(self, **kwargs):  # noqa: E501
        """PUT controller  # noqa: E501

        Add or update a controller  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_controller(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Controller controller: The model of a controller
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_controller_with_http_info(**kwargs)  # noqa: E501

    def put_controller_with_http_info(self, **kwargs):  # noqa: E501
        """PUT controller  # noqa: E501

        Add or update a controller  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_controller_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Controller controller: The model of a controller
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_controller" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'controller' in local_var_params:
            body_params = local_var_params['controller']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/controllers', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
