from psychopy import visual

from .stim import StimulusData


class ShapeStim(StimulusData):
    def __init__(
        self,
        units="",
        colorSpace="rgb",
        fillColor=False,
        lineColor=False,
        lineWidth=1.5,
        vertices=((-0.5, 0), (0, 0.5), (0.5, 0)),
        windingRule=None,
        closeShape=True,
        pos=(0, 0),
        size=1,
        ori=0.0,
        opacity=1.0,
        contrast=1.0,
        depth=0,
        interpolate=True,
        name=None,
        autoLog=None,
        autoDraw=False,
        color=False,
        lineRGB=False,
        fillRGB=False,
        fillColorSpace=None,
        lineColorSpace=None,
    ):
        super().__init__(
            stimulus_type=visual.ShapeStim,
            units=units,
            colorSpace=colorSpace,
            fillColor=fillColor,
            lineColor=lineColor,
            lineWidth=lineWidth,
            vertices=vertices,
            windingRule=windingRule,
            closeShape=closeShape,
            pos=pos,
            size=size,
            ori=ori,
            opacity=opacity,
            contrast=contrast,
            depth=depth,
            interpolate=interpolate,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            color=color,
            lineRGB=lineRGB,
            fillRGB=fillRGB,
            fillColorSpace=fillColorSpace,
            lineColorSpace=lineColorSpace,
        )


class Rect(StimulusData):
    def __init__(
        self,
        width=0.5,
        height=0.5,
        units="",
        lineWidth=1.5,
        lineColor=None,
        lineColorSpace=None,
        fillColor=None,
        fillColorSpace=None,
        pos=(0, 0),
        size=None,
        ori=0.0,
        opacity=None,
        contrast=1.0,
        depth=0,
        interpolate=True,
        lineRGB=False,
        fillRGB=False,
        name=None,
        autoLog=None,
        autoDraw=False,
        color=None,
        colorSpace="rgb",
    ):
        super().__init__(
            stimulus_type=visual.Rect,
            width=width,
            height=height,
            units=units,
            lineWidth=lineWidth,
            lineColor=lineColor,
            lineColorSpace=lineColorSpace,
            fillColor=fillColor,
            fillColorSpace=fillColorSpace,
            pos=pos,
            size=size,
            ori=ori,
            opacity=opacity,
            contrast=contrast,
            depth=depth,
            interpolate=interpolate,
            lineRGB=lineRGB,
            fillRGB=fillRGB,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            color=color,
            colorSpace=colorSpace,
        )


class Circle(StimulusData):
    def __init__(
        self,
        radius=0.5,
        edges=32,
        units="",
        lineWidth=1.5,
        lineColor=None,
        lineColorSpace=None,
        fillColor=None,
        fillColorSpace=None,
        pos=(0, 0),
        size=1.0,
        ori=0.0,
        opacity=None,
        contrast=1.0,
        depth=0,
        interpolate=True,
        lineRGB=False,
        fillRGB=False,
        name=None,
        autoLog=None,
        autoDraw=False,
        color=None,
        colorSpace="rgb",
    ):
        super().__init__(
            stimulus_type=visual.Circle,
            radius=radius,
            edges=edges,
            units=units,
            lineWidth=lineWidth,
            lineColor=lineColor,
            lineColorSpace=lineColorSpace,
            fillColor=fillColor,
            fillColorSpace=fillColorSpace,
            pos=pos,
            size=size,
            ori=ori,
            opacity=opacity,
            contrast=contrast,
            depth=depth,
            interpolate=interpolate,
            lineRGB=lineRGB,
            fillRGB=fillRGB,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            color=color,
            colorSpace=colorSpace,
        )


class Polygon(StimulusData):
    def __init__(
        self,
        edges=3,
        radius=0.5,
        units="",
        lineWidth=1.5,
        lineColor=None,
        lineColorSpace=None,
        fillColor=None,
        fillColorSpace=None,
        pos=(0, 0),
        size=1.0,
        ori=0.0,
        opacity=None,
        contrast=1.0,
        depth=0,
        interpolate=True,
        lineRGB=False,
        fillRGB=False,
        name=None,
        autoLog=None,
        autoDraw=False,
        color=None,
        colorSpace="rgb",
    ):
        super().__init__(
            stimulus_type=visual.Polygon,
            edges=edges,
            radius=radius,
            units=units,
            lineWidth=lineWidth,
            lineColor=lineColor,
            lineColorSpace=lineColorSpace,
            fillColor=fillColor,
            fillColorSpace=fillColorSpace,
            pos=pos,
            size=size,
            ori=ori,
            opacity=opacity,
            contrast=contrast,
            depth=depth,
            interpolate=interpolate,
            lineRGB=lineRGB,
            fillRGB=fillRGB,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            color=color,
            colorSpace=colorSpace,
        )


class Line(StimulusData):
    def __init__(
        self,
        begin=(-0.5, -0.5),
        end=(0.5, 0.5),
        units="",
        lineWidth=1.5,
        lineColor=None,
        fillColor=None,
        lineColorSpace=None,
        pos=(0, 0),
        size=1.0,
        ori=0.0,
        opacity=None,
        contrast=1.0,
        depth=0,
        interpolate=True,
        lineRGB=False,
        fillRGB=False,
        name=None,
        autoLog=None,
        autoDraw=False,
        color=None,
        colorSpace="rgb",
    ):
        super().__init__(
            stimulus_type=visual.Line,
            begin=begin,
            end=end,
            units=units,
            lineWidth=lineWidth,
            lineColor=lineColor,
            fillColor=fillColor,
            lineColorSpace=lineColorSpace,
            pos=pos,
            size=size,
            ori=ori,
            opacity=opacity,
            contrast=contrast,
            depth=depth,
            interpolate=interpolate,
            lineRGB=lineRGB,
            fillRGB=fillRGB,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            color=color,
            colorSpace=colorSpace,
        )


class Pie(StimulusData):
    def __init__(
        self,
        radius=0.5,
        begin=0.0,
        end=90.0,
        edges=32,
        units="",
        lineWidth=1.5,
        lineColor=None,
        lineColorSpace="rgb",
        fillColor=None,
        fillColorSpace="rgb",
        pos=(0, 0),
        size=1.0,
        ori=0.0,
        opacity=1.0,
        contrast=1.0,
        depth=0,
        interpolate=True,
        lineRGB=False,
        fillRGB=False,
        name=None,
        autoLog=None,
        autoDraw=False,
        color=None,
        colorSpace=None,
    ):
        super().__init__(
            stimulus_type=visual.Pie,
            radius=radius,
            begin=begin,
            end=end,
            edges=edges,
            units=units,
            lineWidth=lineWidth,
            lineColor=lineColor,
            lineColorSpace=lineColorSpace,
            fillColor=fillColor,
            fillColorSpace=fillColorSpace,
            pos=pos,
            size=size,
            ori=ori,
            opacity=opacity,
            contrast=contrast,
            depth=depth,
            interpolate=interpolate,
            lineRGB=lineRGB,
            fillRGB=fillRGB,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            color=color,
            colorSpace=colorSpace,
        )


class ImageStim(StimulusData):
    def __init__(
        self,
        image=None,
        mask=None,
        units="",
        pos=(0.0, 0.0),
        size=None,
        ori=0.0,
        color=(1.0, 1.0, 1.0),
        colorSpace="rgb",
        contrast=1.0,
        opacity=None,
        depth=0,
        interpolate=False,
        flipHoriz=False,
        flipVert=False,
        texRes=128,
        name=None,
        autoLog=None,
        maskParams=None,
    ):
        super().__init__(
            stimulus_type=visual.ImageStim,
            image=image,
            mask=mask,
            units=units,
            pos=pos,
            size=size,
            ori=ori,
            color=color,
            colorSpace=colorSpace,
            contrast=contrast,
            opacity=opacity,
            depth=depth,
            interpolate=interpolate,
            flipHoriz=flipHoriz,
            flipVert=flipVert,
            texRes=texRes,
            name=name,
            autoLog=autoLog,
            maskParams=maskParams,
        )


class TextStim(StimulusData):
    def __init__(
        self,
        text="Hello World",
        font="",
        pos=(0.0, 0.0),
        depth=0,
        rgb=None,
        color=(1.0, 1.0, 1.0),
        colorSpace="rgb",
        opacity=1.0,
        contrast=1.0,
        units="",
        ori=0.0,
        height=None,
        antialias=True,
        bold=False,
        italic=False,
        alignHoriz=None,
        alignVert=None,
        alignText="center",
        anchorHoriz="center",
        anchorVert="center",
        fontFiles=(),
        wrapWidth=None,
        flipHoriz=False,
        flipVert=False,
        languageStyle="LTR",
        name=None,
        autoLog=None,
    ):
        super().__init__(
            stimulus_type=visual.TextStim,
            text=text,
            font=font,
            pos=pos,
            depth=depth,
            rgb=rgb,
            color=color,
            colorSpace=colorSpace,
            opacity=opacity,
            contrast=contrast,
            units=units,
            ori=ori,
            height=height,
            antialias=antialias,
            bold=bold,
            italic=italic,
            alignHoriz=alignHoriz,
            alignVert=alignVert,
            alignText=alignText,
            anchorHoriz=anchorHoriz,
            anchorVert=anchorVert,
            fontFiles=fontFiles,
            wrapWidth=wrapWidth,
            flipHoriz=flipHoriz,
            flipVert=flipVert,
            languageStyle=languageStyle,
            name=name,
            autoLog=autoLog,
        )


class GratingStim(StimulusData):
    def __init__(
        self,
        tex="sin",
        mask="none",
        units="",
        pos=(0.0, 0.0),
        size=None,
        sf=None,
        ori=0.0,
        phase=(0.0, 0.0),
        texRes=128,
        rgb=None,
        dkl=None,
        lms=None,
        color=(1.0, 1.0, 1.0),
        colorSpace="rgb",
        contrast=1.0,
        opacity=None,
        depth=0,
        rgbPedestal=(0.0, 0.0, 0.0),
        interpolate=False,
        blendmode="avg",
        name=None,
        autoLog=None,
        autoDraw=False,
        maskParams=None,
    ):
        super().__init__(
            stimulus_type=visual.GratingStim,
            tex=tex,
            mask=mask,
            units=units,
            pos=pos,
            size=size,
            sf=sf,
            ori=ori,
            phase=phase,
            texRes=texRes,
            rgb=rgb,
            dkl=dkl,
            lms=lms,
            color=color,
            colorSpace=colorSpace,
            contrast=contrast,
            opacity=opacity,
            depth=depth,
            rgbPedestal=rgbPedestal,
            interpolate=interpolate,
            blendmode=blendmode,
            name=name,
            autoLog=autoLog,
            autoDraw=autoDraw,
            maskParams=maskParams,
        )


class RadialStim(StimulusData):
    def __init__(
        self,
        tex="sqrXsqr",
        mask="none",
        units="",
        pos=(0.0, 0.0),
        size=(1.0, 1.0),
        radialCycles=3,
        angularCycles=4,
        radialPhase=0,
        angularPhase=0,
        ori=0.0,
        texRes=64,
        angularRes=100,
        visibleWedge=(0, 360),
        rgb=None,
        color=(1.0, 1.0, 1.0),
        colorSpace="rgb",
        dkl=None,
        lms=None,
        contrast=1.0,
        opacity=1.0,
        depth=0,
        rgbPedestal=(0.0, 0.0, 0.0),
        interpolate=False,
        name=None,
        autoLog=None,
        maskParams=None,
    ):
        super().__init__(
            stimulus_type=visual.RadialStim,
            tex=tex,
            mask=mask,
            units=units,
            pos=pos,
            size=size,
            radialCycles=radialCycles,
            angularCycles=angularCycles,
            radialPhase=radialPhase,
            angularPhase=angularPhase,
            ori=ori,
            texRes=texRes,
            angularRes=angularRes,
            visibleWedge=visibleWedge,
            rgb=rgb,
            color=color,
            colorSpace=colorSpace,
            dkl=dkl,
            lms=lms,
            contrast=contrast,
            opacity=opacity,
            depth=depth,
            rgbPedestal=rgbPedestal,
            interpolate=interpolate,
            name=name,
            autoLog=autoLog,
            maskParams=maskParams,
        )


class LightSource(StimulusData):
    def __init__(
        self,
        pos=(0.0, 0.0, 0.0),
        diffuseColor=(1.0, 1.0, 1.0),
        specularColor=(1.0, 1.0, 1.0),
        ambientColor=(0.0, 0.0, 0.0),
        colorSpace="rgb",
        lightType="point",
        attenuation=(1, 0, 0),
    ):
        super().__init__(
            stimulus_type=visual.LightSource,
            pos=pos,
            diffuseColor=diffuseColor,
            specularColor=specularColor,
            ambientColor=ambientColor,
            colorSpace=colorSpace,
            lightType=lightType,
            attenuation=attenuation,
        )


class SceneSkybox(StimulusData):
    def __init__(self, tex=(), ori=0.0, axis=(0, 1, 0)):
        super().__init__(
            stimulus_type=visual.SceneSkybox, tex=tex, ori=ori, axis=axis
        )


class SphereStim(StimulusData):
    def __init__(
        self,
        radius=0.5,
        subdiv=(32, 32),
        flipFaces=False,
        pos=(0.0, 0.0, 0.0),
        ori=(0.0, 0.0, 0.0, 1.0),
        color=(0.0, 0.0, 0.0),
        colorSpace="rgb",
        contrast=1.0,
        opacity=1.0,
        useMaterial=None,
        useShaders=False,
        name="",
        autoLog=True,
    ):
        super().__init__(
            stimulus_type=visual.SphereStim,
            radius=radius,
            subdiv=subdiv,
            flipFaces=flipFaces,
            pos=pos,
            ori=ori,
            color=color,
            colorSpace=colorSpace,
            contrast=contrast,
            opacity=opacity,
            useMaterial=useMaterial,
            useShaders=useShaders,
            name=name,
            autoLog=autoLog,
        )


class BoxStim(StimulusData):
    def __init__(
        self,
        size=(0.5, 0.5, 0.5),
        flipFaces=False,
        pos=(0.0, 0.0, 0.0),
        ori=(0.0, 0.0, 0.0, 1.0),
        color=(0.0, 0.0, 0.0),
        colorSpace="rgb",
        contrast=1.0,
        opacity=1.0,
        useMaterial=None,
        useShaders=False,
        textureScale=None,
        name="",
        autoLog=True,
    ):
        super().__init__(
            stimulus_type=visual.BoxStim,
            size=size,
            flipFaces=flipFaces,
            pos=pos,
            ori=ori,
            color=color,
            colorSpace=colorSpace,
            contrast=contrast,
            opacity=opacity,
            useMaterial=useMaterial,
            useShaders=useShaders,
            textureScale=textureScale,
            name=name,
            autoLog=autoLog,
        )


class PlaneStim(StimulusData):
    def __init__(
        self,
        size=(0.5, 0.5),
        pos=(0.0, 0.0, 0.0),
        ori=(0.0, 0.0, 0.0, 1.0),
        color=(0.0, 0.0, 0.0),
        colorSpace="rgb",
        contrast=1.0,
        opacity=1.0,
        useMaterial=None,
        useShaders=False,
        textureScale=None,
        name="",
        autoLog=True,
    ):
        super().__init__(
            stimulus_type=visual.PlaneStim,
            size=size,
            pos=pos,
            ori=ori,
            color=color,
            colorSpace=colorSpace,
            contrast=contrast,
            opacity=opacity,
            useMaterial=useMaterial,
            useShaders=useShaders,
            textureScale=textureScale,
            name=name,
            autoLog=autoLog,
        )


class MovieStim(StimulusData):
    def __init__(
        self,
        filename="",
        units="pix",
        size=None,
        pos=(0.0, 0.0),
        ori=0.0,
        flipVert=False,
        flipHoriz=False,
        color=(1.0, 1.0, 1.0),
        colorSpace="rgb",
        opacity=1.0,
        volume=1.0,
        name=None,
        loop=False,
        autoLog=None,
        depth=0.0,
    ):
        super().__init__(
            stimulus_type=visual.MovieStim,
            filename=filename,
            units=units,
            size=size,
            pos=pos,
            ori=ori,
            flipVert=flipVert,
            flipHoriz=flipHoriz,
            color=color,
            colorSpace=colorSpace,
            opacity=opacity,
            volume=volume,
            name=name,
            loop=loop,
            autoLog=autoLog,
            depth=depth,
        )


class BufferImageStim(StimulusData):
    def __init__(
        self,
        buffer="back",
        rect=(-1, 1, 1, -1),
        sqPower2=False,
        stim=(),
        interpolate=True,
        flipHoriz=False,
        flipVert=False,
        mask="None",
        pos=(0, 0),
        name=None,
        autoLog=None,
    ):
        super().__init__(
            stimulus_type=visual.BufferImageStim,
            buffer=buffer,
            rect=rect,
            sqPower2=sqPower2,
            stim=stim,
            interpolate=interpolate,
            flipHoriz=flipHoriz,
            flipVert=flipVert,
            mask=mask,
            pos=pos,
            name=name,
            autoLog=autoLog,
        )
