/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.LoggingApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LogData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LoggerBackend;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LoggingException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.MessageUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.Checks;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.RecursionDepth;
import com.google.errorprone.annotations.CheckReturnValue;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@CheckReturnValue
public abstract class AbstractLogger<API extends LoggingApi<API>> {
    private static final int MAX_ALLOWED_RECURSION_DEPTH = 100;
    private final LoggerBackend backend;

    protected AbstractLogger(LoggerBackend backend) {
        this.backend = Checks.checkNotNull(backend, "backend");
    }

    public abstract API at(Level var1);

    public final API atSevere() {
        return this.at(Level.SEVERE);
    }

    public final API atWarning() {
        return this.at(Level.WARNING);
    }

    public final API atInfo() {
        return this.at(Level.INFO);
    }

    public final API atConfig() {
        return this.at(Level.CONFIG);
    }

    public final API atFine() {
        return this.at(Level.FINE);
    }

    public final API atFiner() {
        return this.at(Level.FINER);
    }

    public final API atFinest() {
        return this.at(Level.FINEST);
    }

    protected String getName() {
        return this.backend.getLoggerName();
    }

    protected final boolean isLoggable(Level level) {
        return this.backend.isLoggable(level);
    }

    final LoggerBackend getBackend() {
        return this.backend;
    }

    final void write(LogData data) {
        Checks.checkNotNull(data, "data");
        try (RecursionDepth depth = RecursionDepth.enterLogStatement();){
            if (depth.getValue() <= 100) {
                this.backend.log(data);
            } else {
                AbstractLogger.reportError("unbounded recursion in log statement", data);
            }
        }
        catch (RuntimeException logError) {
            this.handleErrorRobustly(logError, data);
        }
    }

    private void handleErrorRobustly(RuntimeException logError, LogData data) {
        try {
            this.backend.handleError(logError, data);
        }
        catch (LoggingException allowed) {
            throw allowed;
        }
        catch (RuntimeException badError) {
            AbstractLogger.reportError(badError.getClass().getName() + ": " + badError.getMessage(), data);
            try {
                badError.printStackTrace(System.err);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private static void reportError(String message, LogData data) {
        StringBuilder out = new StringBuilder();
        out.append(AbstractLogger.formatTimestampIso8601(data)).append(": logging error [");
        MessageUtils.appendLogSite(data.getLogSite(), out);
        out.append("]: ").append(message);
        System.err.println(out);
        System.err.flush();
    }

    private static String formatTimestampIso8601(LogData data) {
        Date timestamp = new Date(TimeUnit.NANOSECONDS.toMillis(data.getTimestampNanos()));
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(timestamp);
    }
}

