"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class BashExecFunction extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        if ((props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile)) {
            // Copy your Dockerfile to Dockerfile.custom.
            fs.copyFileSync(props === null || props === void 0 ? void 0 : props.dockerfile, path.join(__dirname, '../docker.d/Dockerfile.custom'));
        }
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // copy the user script to the docker.d directory as main.sh so we can bundle it up into a new docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: lambda.DockerImageCode.fromImageAsset(dockerDirPath, {
                file: (props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile) ? 'Dockerfile.custom' : undefined,
            }),
            timeout: (_b = props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.seconds(60),
            logRetention: logs.RetentionDays.ONE_DAY,
            environment: props.environment,
        });
        new core_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
    /**
     * @stability stable
     */
    run(ops = {}) {
        const onEvent = new lambda.DockerImageFunction(this, 'OnEventHandler', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../docker.d'), {
                cmd: ['function.sh.onEvent'],
            }),
            environment: {
                LAMBDA_FUNCTION_ARN: this.handler.functionArn,
            },
            timeout: core_1.Duration.seconds(60),
        });
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
        });
        const staging = new core_1.AssetStaging(this, 'Staging', {
            sourcePath: path.join(__dirname, '../docker.d'),
        });
        const resource = new core_1.CustomResource(this, 'RunLambdaBash', {
            resourceType: 'Custom::RunLambdaBash',
            serviceToken: myProvider.serviceToken,
            properties: {
                assetHash: ops.runOnUpdate ? staging.assetHash : undefined,
            },
        });
        this.handler.grantInvoke(onEvent.grantPrincipal);
        return resource;
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-lambda-bash.BashExecFunction", version: "0.5.47" };
//# sourceMappingURL=data:application/json;base64,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