"""Define the types of beasts in FaIR, how they roar, and whether they are friendly."""

#: Species types recognised by FaIR.
species_types = [
    "co2 ffi",
    "co2 afolu",
    "co2",
    "ch4",
    "n2o",
    "cfc-11",
    "other halogen",
    "f-gas",
    "sulfur",
    "black carbon",
    "organic carbon",
    "other slcf",
    "nox aviation",
    "eesc",
    "ozone",
    "ari",
    "aci",
    "contrails",
    "lapsi",
    "h2o stratospheric",
    "land use",
    "volcanic",
    "solar",
    "unspecified",
]

#: Valid run modes for each species.
valid_input_modes = {
    "co2 ffi": ["emissions"],
    "co2 afolu": ["emissions"],
    "co2": ["emissions", "calculated", "concentration", "forcing"],
    "ch4": ["emissions", "concentration", "forcing"],
    "n2o": ["emissions", "concentration", "forcing"],
    "cfc-11": ["emissions", "concentration", "forcing"],
    "other halogen": ["emissions", "concentration", "forcing"],
    "f-gas": ["emissions", "concentration", "forcing"],
    "sulfur": ["emissions"],
    "black carbon": ["emissions"],
    "organic carbon": ["emissions"],
    "other slcf": ["emissions"],
    "nox aviation": ["emissions"],
    "eesc": ["concentration", "calculated"],
    "ozone": ["calculated", "forcing"],
    "ari": ["calculated", "forcing"],
    "aci": ["calculated", "forcing"],
    "contrails": ["calculated", "forcing"],
    "lapsi": ["calculated", "forcing"],
    "h2o stratospheric": ["calculated", "forcing"],
    "land use": ["calculated", "forcing"],
    "volcanic": ["forcing"],
    "solar": ["forcing"],
    "unspecified": ["forcing"],
}

#: Whether multiple instances are allowed for each specie type.
multiple_allowed = {
    "co2 ffi": False,
    "co2 afolu": False,
    "co2": False,
    "ch4": False,
    "n2o": False,
    "cfc-11": False,
    "other halogen": True,
    "f-gas": True,
    "sulfur": False,
    "black carbon": False,
    "organic carbon": False,
    "other slcf": True,
    "nox aviation": False,
    "eesc": False,
    "ozone": False,
    "ari": False,
    "aci": False,
    "contrails": False,
    "lapsi": False,
    "h2o stratospheric": False,
    "land use": False,
    "volcanic": False,
    "solar": False,
    "unspecified": True,
}
