"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagOptions = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const util_1 = require("./private/util");
const validation_1 = require("./private/validation");
const aws_servicecatalog_1 = require("aws-cdk-lib/aws-servicecatalog");
/**
 * Defines a set of TagOptions, which are a list of key-value pairs managed in AWS Service Catalog.
 * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
 * See https://docs.aws.amazon.com/servicecatalog/latest/adminguide/tagoptions.html
 *
 * @resource AWS::ServiceCatalog::TagOption
 */
class TagOptions extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalog_alpha_TagOptionsProps(props);
        this._cfnTagOptions = this.createUnderlyingTagOptions(props.allowedValuesForTags);
    }
    createUnderlyingTagOptions(allowedValuesForTags) {
        if (Object.keys(allowedValuesForTags).length === 0) {
            throw new Error(`No tag option keys or values were provided for resource ${this.node.path}`);
        }
        var tagOptions = [];
        for (const [tagKey, tagValues] of Object.entries(allowedValuesForTags)) {
            validation_1.InputValidator.validateLength(this.node.addr, 'TagOption key', 1, 128, tagKey);
            const uniqueTagValues = new Set(tagValues);
            if (uniqueTagValues.size === 0) {
                throw new Error(`No tag option values were provided for tag option key ${tagKey} for resource ${this.node.path}`);
            }
            uniqueTagValues.forEach((tagValue) => {
                validation_1.InputValidator.validateLength(this.node.addr, 'TagOption value', 1, 256, tagValue);
                const tagOptionIdentifier = util_1.hashValues(tagKey, tagValue);
                const tagOption = new aws_servicecatalog_1.CfnTagOption(this, tagOptionIdentifier, {
                    key: tagKey,
                    value: tagValue,
                    active: true,
                });
                tagOptions.push(tagOption);
            });
        }
        return tagOptions;
    }
}
exports.TagOptions = TagOptions;
_a = JSII_RTTI_SYMBOL_1;
TagOptions[_a] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.TagOptions", version: "2.15.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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