"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RollbackEvent = exports.EcsDeploymentGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const ecs_deployment_config_1 = require("./ecs-deployment-config");
class EcsDeploymentGroup extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const { applicationName, deploymentGroupName, deploymentConfig, ecsServices, targetGroupNames, prodTrafficListener, testTrafficListener, terminationWaitTimeInMinutes = 60, autoRollbackOnEvents, } = props;
        if (terminationWaitTimeInMinutes > 2880) {
            throw new Error('Invalid TerminationWaitTimeInMinutes: The maximum setting is 2880 minutes (2 days).');
        }
        const codeDeployEcsRole = new aws_iam_1.Role(this, 'EcsCodeDeployRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AWSCodeDeployRoleForECS')],
        });
        this.application = new aws_codedeploy_1.EcsApplication(this, 'EcsApplication', {
            applicationName,
        });
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::EcsDeploymentGroup', {
            codeDirectory: path.join(__dirname, 'lambdas', 'ecs-deployment-group'),
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12_X,
            policyStatements: [
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['codeDeploy:CreateDeploymentGroup', 'codeDeploy:UpdateDeploymentGroup', 'codeDeploy:DeleteDeploymentGroup'],
                    Resource: '*',
                },
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['iam:PassRole'],
                    Resource: codeDeployEcsRole.roleArn,
                },
            ],
        });
        this.deploymentConfig = deploymentConfig || ecs_deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE;
        const ecsDeploymentGroup = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::EcsDeploymentGroup',
            properties: {
                ApplicationName: this.application.applicationName,
                DeploymentGroupName: deploymentGroupName,
                ServiceRoleArn: codeDeployEcsRole.roleArn,
                TargetGroupNames: targetGroupNames,
                EcsServices: ecsServices.map((service) => ({
                    ClusterName: service.clusterName,
                    ServiceName: service.serviceName,
                })),
                ProdTrafficListenerArn: prodTrafficListener.listenerArn,
                TestTrafficListenerArn: testTrafficListener.listenerArn,
                TerminationWaitTimeInMinutes: terminationWaitTimeInMinutes,
                AutoRollbackOnEvents: autoRollbackOnEvents,
                DeploymentConfigName: this.deploymentConfig.deploymentConfigName,
            },
        });
        this.deploymentGroupName = ecsDeploymentGroup.ref;
        this.deploymentGroupArn = this.arnForDeploymentGroup(this.application.applicationName, this.deploymentGroupName);
    }
    arnForDeploymentGroup(applicationName, deploymentGroupName) {
        return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentGroup[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentGroup", version: "1.40.0" };
var RollbackEvent;
(function (RollbackEvent) {
    RollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    RollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    RollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(RollbackEvent = exports.RollbackEvent || (exports.RollbackEvent = {}));
//# sourceMappingURL=data:application/json;base64,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