"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
const core_1 = require("@aws-cdk/core");
class EcsDeploymentConfig extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const cfnDeploymentConfig = new aws_codedeploy_1.CfnDeploymentConfig(this, 'EcsDeploymentConfiguration', {
            computePlatform: 'ECS',
            ...props,
        });
        this.deploymentConfigName = cfnDeploymentConfig.ref;
        this.deploymentConfigArn = arnForDeploymentConfig(this.deploymentConfigName);
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct.
     * @param _id the logical ID of this new Construct.
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentConfig[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentConfig", version: "1.40.0" };
EcsDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.ECSLinear10PercentEvery1Minutes');
EcsDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.ECSLinear10PercentEvery3Minutes');
EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.ECSCanary10Percent5Minutes');
EcsDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.ECSCanary10Percent15Minutes');
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: arnForDeploymentConfig(name),
    };
}
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
//# sourceMappingURL=data:application/json;base64,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