# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bap',
 'lunar',
 'lunar.config',
 'lunar.data',
 'lunar.data.batch',
 'lunar.data.batch.models',
 'lunar.data.data',
 'lunar.data.datasets',
 'lunar.data.datasets.models',
 'lunar.data.datasets.models.params',
 'lunar.data.query',
 'lunar.ml',
 'lunar.rec',
 'lunar.rec.channels',
 'lunar.rec.channels.models',
 'lunar.rec.experiments',
 'lunar.rec.experiments.models',
 'lunar.rec.recommendations',
 'lunar.rec.recommendations.models']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.1,<4.0.0',
 'boto3',
 'click>=8.1.2,<9.0.0',
 'cloudpickle>=2.1.0,<3.0.0',
 'pydantic>=1.8.2,<2.0.0',
 'requests>=2.27.1,<3.0.0']

extras_require = \
{'ml': ['scikit-learn>=1.1.1,<1.2.0',
        'catboost>=1.0.6,<1.1.0',
        'lightgbm>=3.3.2,<3.4.0',
        'xgboost>=1.6.1,<1.7.0']}

entry_points = \
{'console_scripts': ['lunar = lunar.cli:main']}

setup_kwargs = {
    'name': 'apollo-lunar',
    'version': '2022.11.14rc1',
    'description': 'A Python SDK/CLI for Lunar API',
    'long_description': '# lunar-sdk\n\n## Contents \n- [Description](#description)\n- [Installation](#installation)\n- [How to use](#how-to-use)\n  - [credentials](#credentials)\n  - [SDK](#sdk)\n  - [CLI](#cli)\n- [Development](#development)\n  - [Requirements for development](#requirements-for-development)\n  - [Python environment](#python-environment)\n  - [Documents generation](#documents-generation)\n\n\nSDK for lunar microservices\n\n## Description\n\nA Python based SDK & CLI for Lunar microservices\n\nThis python package includes\n- Functions for [lunar-rec](https://github.com/sktaiflow/lunar-rec)\n- CLI (Command Line Interface) named `lunar`\n\n## Installation\n\nBuild package and wheel files with `poetry`.\n\n```bash\n# installation\npoetry install\n\npoetry run lunar -h\n```\n\n## How to use\n\n### Credentials\n`lunar` uses a credentials file to setup a config(`env`, `apikey`) with a `init` file type.  \nThe path for credentials file and format must be as follow:\n\n```bash\n[Path]\n\n.lunar/credentials\n```\n\n```bash\n[default]\nenv=local\napikey=ABCDEFG123\n\n[dev]\nenv=dev\napikey=AERSDF123\n\n[stg]\nenv=stg\napikey=HIJKLMNO456\n\n[prd]\nenv=prd\napikey=PQRSTUV789\n```\nThe first [default] is used when SDK / CLI is run without a specified profile.\n\nTo specify a profile, use `AWS_PROFILE` to overrides the default profile for commands that run in that session. \n\n```bash\nexport AWS_PROFILE=stg\n```\n\n### SDK\n\n`lunar` package provides functions for using all lunar microservices.\nFor the detailed information related to each function, please refer to [Docs](https://sktaiflow.github.io/lunar-sdk/lunar/).\n\nHere is an example for CRUDing channels:\n\n```python\nimport lunar\n\n# Environment for Lunar-rec is automatically set with credential file\nclient = lunar.client("channel")\n\n# Get list of channels\nchannels = client.get_channels()\n\n# Get a channel\nchannel = client.get_channel(id="test_channel")\n\n# Create a channel\nchannel = client.create_channel(id="new_channel", experiment_id="new_experiment")\n\n# Update(or partial) a channel \nupdated_channel = client.update_channel(id="test_channel", experiment_id="a")\npartially_updated_channel = client.update_channel_partial(id="test_channel", experiment_id="ab")\n\n# Delete a channel\nclient.delete_channel(channel.id)\n```\n\nAll functions on the SDK also supports asyncio. If necessary, use an async version of each function.\n- Naming rule: Suffix with **_async**. (e.g. `list_channels()` → `list_channels_async()`)\n\n### CLI\n\n`lunar` also provides CLI (Command Line Interface) generated by [click](https://click.palletsprojects.com/) package.\n\n```zsh\npoetry run lunar -h\n```\n\nshould show something like the below:\n\n``` zsh\nUsage: lunar [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  -h, --help  Show this message and exit.\n\nCommands:\n  channel     Channels on lunar-rec\n  experiment  Experiments on lunar-rec\n  recommend   Recommendation on lunar-rec\n```\n\nEach option also has its own usage instruction.\n\n``` zsh\npoetry run lunar experiments -h\n\nUsage: lunar experiment [OPTIONS] {CREATE|LIST|READ|UPDATE|DELETE}\n\n  Experiments on lunar-rec\n\n  Send a request to Lunar Recommendation API (`/v1/experiemnts/`).\n\n  Return: dict or list(dict)\n\nOptions:\n  -i, --id TEXT                   Unique identifier of a channel\n  -b, --buckets <TEXT INTEGER>...\n                                  Bucket list\n  -s, --bucketing-seed TEXT       Random seed for bucketing\n  -p, --partial                   Partial update or not (default: False)\n  -h, --help                      Show this message and exit.\n```\n\n## Development\n\n### Requirements for development\n\n- Python 3.8\n- Poetry\n\nInstalling Python 3.8 with [pyenv](https://github.com/pyenv/pyenv) is recommended. Check [this](https://github.com/pyenv/pyenv#installation).\n\nFor zsh,\n\n```zsh\n# Install Xcode command line tools (Only if you don\'t have it already)\nxcode-select --install\n\n# Install pyenv and its dependencies\nbrew update\nbrew install pyenv openssl readline sqlite3 xz zlib\n\necho \'eval "$(pyenv init --path)"\' >> ~/.zshrc\neval \'"$(pyenv init -)"\' >> ~/.zshrc\n\n# Restart the terminal\n\n# Install Python 3.8\npyenv install 3.8.10\npyenv global 3.8.10\n\n# Restart the terminal\n\n# Check if the version is right\npython -V\n\n# Install Poetry\ncurl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python -\npoetry config virtualenvs.in-project true\n```\n\nshould work.\n\n### Python environment\n\n```zsh\npoetry install\n```\n\nIf you need additional deps,\n\n```zsh\n# For production\npoetry add package_name\n\n# For development only\npoetry add --dev package_name\n```\n\n### Documents generation\n\n```bash\nrm -rf docs\npdoc --html --config show_source_code=False -f -o ./docs lunar\n```\n',
    'author': 'Lunar module',
    'author_email': 'lunar@sktio.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.9',
}


setup(**setup_kwargs)
