"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Server = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process_1 = require("child_process");
const fs_1 = require("fs");
const http_1 = require("http");
const os_1 = require("os");
const path_1 = require("path");
class Server {
    constructor(props) {
        this.appCommand = props.appCommand;
        this.server = (0, http_1.createServer)((req, res) => this.handleRequest(req, res).catch(e => {
            console.error('server error: ', e);
            res.statusCode = 500;
            res.write(e.message);
            res.end();
        }));
        this.tmpdir = (0, fs_1.mkdtempSync)((0, path_1.join)((0, os_1.tmpdir)(), 'cdk8s-operator-'));
    }
    /**
     * Starts HTTP server.
     * @param port The port to listen to. If not specified, the `PORT` environment
     * variable will be used. If that's not specified an available port will be
     * auto-selected.
     */
    async listen(port) {
        const lport = port ?? process.env.PORT ?? 0;
        return new Promise((ok, ko) => {
            this.server.listen(lport, () => {
                const addr = this.server.address();
                if (typeof (addr) === 'string') {
                    throw new Error(`cannot determine port from server address ${addr}`);
                }
                return ok(addr?.port ?? Number(lport));
            });
            this.server.on('error', err => ko(err));
        });
    }
    /**
     * Stop server.
     */
    close() {
        this.server.close();
    }
    async handleRequest(req, res) {
        const inputfile = await this.writeInputFile(req);
        const child = (0, child_process_1.spawn)(this.appCommand, [inputfile], {
            stdio: ['ignore', 'pipe', 'pipe'],
            shell: true,
        });
        const stderr = new Array();
        res.setHeader('Content-Type', 'application/json');
        // stdout should go directly to the response
        child.stdout.on('data', chunk => {
            process.stderr.write('output: ' + chunk);
            res.write(chunk);
        });
        // for stderr: write to server terminal and only send back if we exited with a non-zero
        child.stderr.on('data', chunk => {
            process.stderr.write(chunk);
            stderr.push(chunk);
        });
        // will be caused by the async handler and 500 will be returned.
        child.on('error', err => {
            throw err;
        });
        child.on('exit', code => {
            if (code !== 0) {
                res.statusCode = 500;
                for (const c of stderr) {
                    res.write(c);
                }
                res.end();
            }
            // success
            return res.end();
        });
    }
    async writeInputFile(req) {
        return new Promise((ok, ko) => {
            const inputfile = (0, path_1.join)(this.tmpdir, `input-${Math.round(Math.random() * 999999)}.json`);
            const input = (0, fs_1.createWriteStream)(inputfile);
            req.pipe(input);
            input.on('close', () => {
                try {
                    const inputJson = JSON.parse((0, fs_1.readFileSync)(inputfile, 'utf-8'));
                    console.error(`input: ${JSON.stringify(inputJson)}`);
                    return ok(inputfile);
                }
                catch (e) {
                    return ko(new Error(`unable to parse request body as JSON: ${e}`));
                }
            });
            req.on('error', err => ko(err.message));
        });
    }
}
exports.Server = Server;
_a = JSII_RTTI_SYMBOL_1;
Server[_a] = { fqn: "cdk8s-operator.Server", version: "0.1.346" };
//# sourceMappingURL=data:application/json;base64,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