export interface ServerProps {
    /**
     * The command to execute in order to synthesize the CDK app.
     */
    readonly appCommand: string;
}
export declare class Server {
    private readonly server;
    private readonly appCommand;
    private readonly tmpdir;
    constructor(props: ServerProps);
    /**
     * Starts HTTP server.
     * @param port The port to listen to. If not specified, the `PORT` environment
     * variable will be used. If that's not specified an available port will be
     * auto-selected.
     */
    listen(port?: number): Promise<number>;
    /**
     * Stop server.
     */
    close(): void;
    private handleRequest;
    private writeInputFile;
}
