#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_afp_sports']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.5.152,<0.6.0',
 'collections-extended',
 'pandas>=1.2.3,<=1.3.5',
 'openpyxl==3.0.7',
 'log-with-context']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-mypy',
          'pytest-black',
          'flake8==3.9.2',
          'tox',
          'dirty-equals']}

entry_points = \
{'pyprocessors.plugins': ['afp_sports = '
                          'pyprocessors_afp_sports.afp_sports:AFPSportsProcessor']}

setup(name='pyprocessors-afp_sports',
      version='0.5.18',
      description='Sherpa Consolidation processor',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyprocessors_afp_sports/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
